/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.Image;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.RootCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Stack;

public class FindPtrCommand
extends Command {
    String pattern;

    public FindPtrCommand(Output out) {
        super(out, "findptr", "searches memory for the given pointer", "parameters: see parameters for \"find\" command\n\nthe findptr command searches for <pattern> as a pointer in the memory segment from <start_address> to <end_address> (both inclusive), and outputs the first <matches_to_display> matching addresses that start at the corresponding <memory_boundary>. It also display the next <bytes_to_print> bytes for the last match.");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        RootCommand rootCommand = (RootCommand)properties.get("RootCommandObject");
        if (null == rootCommand) {
            this.out.error("ERROR - No mapping found for RootCommand object");
            return;
        }
        String argsConcact = Utils.concatArgsFromStack(args);
        String[] params = argsConcact.split(",");
        if (!this.isParametersValid(params)) {
            return;
        }
        if (this.isLittleEndian()) {
            this.pattern = this.reorderBytes();
        }
        String parameters = this.getparameters(params);
        this.out.println("issuing: find " + parameters);
        Stack findCommandStack = Utils.constructStackFromString("find " + parameters);
        rootCommand.doCommand(findCommandStack, loadedImage, properties);
    }

    private String getparameters(String[] params) {
        String temp = "0x" + this.pattern;
        for (int i = 1; i < params.length; ++i) {
            temp = temp + "," + params[i];
        }
        return temp;
    }

    private String reorderBytes() {
        if (0 != this.pattern.length() % 2) {
            this.pattern = "0" + this.pattern;
        }
        String temp = "";
        for (int i = this.pattern.length() / 2 - 1; i >= 0; --i) {
            temp = temp + this.pattern.substring(i * 2, i * 2 + 2);
        }
        return temp;
    }

    private boolean isLittleEndian() {
        return true;
    }

    private boolean isParametersValid(String[] params) {
        if (6 != params.length) {
            this.out.error("insufficient number of parameters");
            return false;
        }
        this.pattern = params[0];
        if (this.pattern.equals("")) {
            this.out.error("missing pattern string");
            return false;
        }
        if (this.pattern.startsWith("0x")) {
            this.pattern = this.pattern.substring(2);
        }
        return true;
    }
}

