/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends Number
implements Serializable,
Comparable<BigDecimal> {
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final ThreadLocal thLocalToString = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new char[22];
        }
    };
    private static final long[] powersOfTenLL = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final BigInteger[] powersOfTenBI = new BigInteger[]{BigInteger.valueOf(1L), BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L), BigInteger.valueOf(10000000000L), BigInteger.valueOf(100000000000L), BigInteger.valueOf(1000000000000L), BigInteger.valueOf(10000000000000L), BigInteger.valueOf(100000000000000L), BigInteger.valueOf(1000000000000000L), BigInteger.valueOf(10000000000000000L), BigInteger.valueOf(100000000000000000L), BigInteger.valueOf(1000000000000000000L)};
    private static final char[] doubleDigitsTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] doubleDigitsOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static byte[] doubleDFPComboField = BigDecimal.comboinit();
    private static short[] DPD2BCD = BigDecimal.dpd2bcdinit();
    private static final long dfpZERO = 2465720795985346560L;
    private static final BigInteger MAXBYTE = BigInteger.valueOf(127L);
    private static final BigInteger MINBYTE = BigInteger.valueOf(-128L);
    private static final BigInteger MAXSHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MINSHORT = BigInteger.valueOf(-32768L);
    private static final BigInteger MAXINT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MININT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAXLONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MINLONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAXDFP64 = BigInteger.valueOf(9999999999999999L);
    private static final BigInteger MINDFP64 = BigInteger.valueOf(-9999999999999999L);
    public static final BigDecimal ZERO = new BigDecimal(0);
    public static final BigDecimal ONE = new BigDecimal(1);
    public static final BigDecimal TEN = new BigDecimal(10);
    private static BigDecimal[] CACHE1;
    private static BigDecimal[] CACHE2;
    private static String zeroDec;
    private static int hys_threshold;
    private static boolean hys_type;
    private static int hys_counter;
    private BigInteger bi;
    private transient int flags;
    private transient long laside;
    private transient int scale;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final ObjectStreamField[] serialPersistentFields;

    private BigDecimal() {
        this.flags = 0;
        this.scale = 0;
        this.bi = null;
        this.laside = 0L;
    }

    public BigDecimal(BigInteger bi) {
        this(bi, 0, MathContext.UNLIMITED);
    }

    public BigDecimal(BigInteger bi, int scale) {
        this(bi, scale, MathContext.UNLIMITED);
    }

    public BigDecimal(BigInteger bi, MathContext set) {
        this(bi, 0, set);
    }

    public BigDecimal(BigInteger bi, int scale, MathContext set) {
        this.bigIntegerConstructor(bi, scale, set);
    }

    public BigDecimal(char[] inchars) {
        this(inchars, 0, inchars.length, MathContext.UNLIMITED);
    }

    public BigDecimal(char[] inchars, int offset, int length) {
        this(inchars, offset, length, MathContext.UNLIMITED);
    }

    public BigDecimal(char[] inchars, MathContext set) {
        this(inchars, 0, inchars.length, set);
    }

    public BigDecimal(char[] inchars, int offset, int length, MathContext set) {
        this.charParser(inchars, offset, length, set);
    }

    public BigDecimal(double num) {
        this(num, MathContext.UNLIMITED);
    }

    public BigDecimal(double num, MathContext set) {
        int p = 1075;
        long signMask = Long.MIN_VALUE;
        long eMask = 0x7FF0000000000000L;
        long fMask = 0xFFFFFFFFFFFFFL;
        long inputNumberBits = Double.doubleToLongBits(num);
        long sign = (inputNumberBits & Long.MIN_VALUE) >> 63;
        long e = (inputNumberBits & 0x7FF0000000000000L) >> 52;
        long f = inputNumberBits & 0xFFFFFFFFFFFFFL;
        int pow = 0;
        sign = sign == 0L ? 1L : -1L;
        if (e == 2047L) {
            throw new NumberFormatException("Initializing with infinity, or NaN");
        }
        if (e == 0L) {
            if (f == 0L) {
                if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
                    this.constructDFPZero();
                    return;
                }
                this.laside = 0L;
                this.flags |= 1;
                this.flags |= 0x10;
                this.flags |= 0x80;
                return;
            }
            pow = (int)(e - 1075L + 1L);
        } else {
            f |= 0x10000000000000L;
            pow = (int)(e - 1075L);
        }
        while ((f & 1L) == 0L) {
            f >>= 1;
            ++pow;
        }
        BigInteger bi = null;
        long lon = sign * f;
        long multval = 1L;
        if (pow < 0 && pow > -27) {
            int n;
            int m;
            for (int i = pow; i < 0; ++i) {
                multval *= 5L;
            }
            long laside = lon;
            if (laside < 0L) {
                laside *= -1L;
            }
            if ((m = Long.numberOfLeadingZeros(laside) - 1) + (n = Long.numberOfLeadingZeros(multval) - 1) >= 63) {
                lon *= multval;
            } else {
                bi = BigInteger.valueOf(lon).multiply(BigInteger.valueOf(multval));
            }
        } else if (pow > 0 && pow < 63) {
            int n;
            int m;
            multval <<= pow;
            long laside = lon;
            if (laside < 0L) {
                laside *= -1L;
            }
            if ((m = Long.numberOfLeadingZeros(laside) - 1) + (n = Long.numberOfLeadingZeros(multval) - 1) >= 63) {
                lon *= multval;
            } else {
                bi = BigInteger.valueOf(lon).multiply(BigInteger.valueOf(multval));
            }
            pow = 0;
        } else if (pow != 0) {
            bi = BigInteger.valueOf(lon);
            if (pow < 0) {
                bi = bi.multiply(BigInteger.valueOf(5L).pow(-pow));
            } else if (pow > 0) {
                bi = bi.shiftLeft(pow);
                pow = 0;
            }
        }
        if (bi == null) {
            this.longConstructor(lon, -pow, set);
        } else {
            this.bigIntegerConstructor(bi, -pow, set);
        }
    }

    public BigDecimal(int num) {
        this(num, MathContext.UNLIMITED);
    }

    public BigDecimal(int num, MathContext set) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            if (num == 0) {
                this.constructDFPZero();
                return;
            }
            this.flags |= 8;
            this.flags |= 4;
            if (num < 0) {
                this.flags |= 0x60;
            } else if (num > 0) {
                this.flags |= 0x20;
            }
            int prec = set.getPrecision();
            int rm = set.getRoundingMode().ordinal();
            if (prec == 16 && rm == 6 && this.DFPIntConstructor(num, 64, 0, 0)) {
                this.flags |= 0x10;
                this.flags |= BigDecimal.numDigits(num) << 7;
                return;
            }
            if (prec == 0 || prec > 0 && rm == 7 || prec > 16) {
                if (this.DFPIntConstructor(num, 0, 0, 0)) {
                    if (prec > 0 && rm == 7) {
                        this.finish(prec, rm);
                    } else {
                        this.flags |= 0x10;
                        this.flags |= BigDecimal.numDigits(num) << 7;
                    }
                    return;
                }
            } else if (prec <= 16) {
                if (rm == 6) {
                    rm = 0;
                } else if (rm == 0) {
                    rm = 6;
                }
                if (this.DFPIntConstructor(num, 1, prec, rm)) {
                    this.flags &= 0xFFFFFFF7;
                    return;
                }
            }
        }
        this.flags |= 1;
        this.laside = num;
        this.flags |= 0x10;
        this.flags |= BigDecimal.numDigits(num) << 7;
        if (set != MathContext.UNLIMITED) {
            this.finish(set.getPrecision(), set.getRoundingMode().ordinal());
        }
    }

    public BigDecimal(long num) {
        this(num, MathContext.UNLIMITED);
    }

    public BigDecimal(long num, MathContext set) {
        this.longConstructor(num, 0, set);
    }

    public BigDecimal(String string) {
        this(string, MathContext.UNLIMITED);
    }

    public BigDecimal(String string, MathContext set) {
        this(string.toCharArray(), 0, string.length(), set);
    }

    private final void longConstructor(long num, int scale, MathContext set) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            if (num == 0L) {
                this.constructDFPZero();
                return;
            }
            if (num <= 9999999999999999L && num >= -9999999999999999L && -scale >= -398 && -scale < 369) {
                this.flags |= 4;
                if (num < 0L) {
                    this.flags |= 0x60;
                } else if (num > 0L) {
                    this.flags |= 0x20;
                }
                int prec = set.getPrecision();
                int rm = set.getRoundingMode().ordinal();
                if (prec == 16 && rm == 6 && this.DFPLongExpConstructor(num, -scale + 398, 64, 0, 0, false)) {
                    this.flags |= 0x10;
                    this.flags |= BigDecimal.numDigits(num) << 7;
                    this.flags |= 8;
                    this.scale = scale;
                    return;
                }
                if (prec == 0 || prec > 0 && rm == 7 || prec > 16) {
                    if (this.DFPLongExpConstructor(num, -scale + 398, 0, 0, 0, false)) {
                        if (prec > 0 && rm == 7) {
                            this.finish(prec, rm);
                        } else {
                            this.flags |= 8;
                            this.scale = scale;
                            this.flags |= 0x10;
                            this.flags |= BigDecimal.numDigits(num) << 7;
                        }
                        return;
                    }
                } else if (prec <= 16) {
                    if (rm == 6) {
                        rm = 0;
                    } else if (rm == 0) {
                        rm = 6;
                    }
                    if (this.DFPLongExpConstructor(num, -scale + 398, 1, prec, rm, false)) {
                        this.flags &= 0xFFFFFFF7;
                        return;
                    }
                }
            }
            this.flags |= 2;
            this.bi = BigInteger.valueOf(num);
            this.scale = scale;
        } else if (num != Long.MIN_VALUE) {
            this.laside = num;
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(num) << 7;
            this.flags |= 1;
            this.scale = scale;
        } else {
            this.flags |= 2;
            this.bi = BigInteger.valueOf(num);
            this.flags |= 0x10;
            this.flags |= 0x980;
            this.scale = scale;
        }
        if (set != MathContext.UNLIMITED) {
            this.finish(set.getPrecision(), set.getRoundingMode().ordinal());
        }
    }

    private final void charParser(char[] inchars, int offset, int length, MathContext set) {
        boolean DFPCrit;
        int initLength = length;
        boolean exotic = false;
        int numDigits = 0;
        int dotoff = -1;
        int last = -1;
        char si = '\u0000';
        int j = 0;
        char sj = '\u0000';
        int dvalue = 0;
        long interm_exp = 0L;
        long bcdVal = 0L;
        int newInd = 32;
        int newExp = 0;
        if (length <= 0) {
            this.bad(inchars);
        }
        if (offset < 0 || offset > inchars.length - 1) {
            this.bad(inchars);
        }
        if (length > inchars.length) {
            this.bad(inchars);
        }
        int i = offset;
        int $1 = length;
        while ($1 > 0) {
            si = inchars[i];
            if (si >= '0' && si <= '9') {
                last = i;
                bcdVal <<= 4;
                bcdVal |= (long)(si & 0xF);
                ++numDigits;
            } else if (si == '.') {
                if (dotoff >= 0) {
                    this.bad(inchars);
                }
                dotoff = i - offset;
            } else if (si == '-') {
                if ($1 != initLength) {
                    this.bad(inchars);
                }
                newInd = 96;
                ++offset;
                --length;
            } else if (si == '+') {
                if ($1 != initLength) {
                    this.bad(inchars);
                }
                ++offset;
                --length;
            } else {
                if (si == 'e' || si == 'E') {
                    int k = 0;
                    int elen = 0;
                    boolean eneg = false;
                    if (i - offset > length - 2) {
                        this.bad(inchars);
                    }
                    eneg = false;
                    if (inchars[i + 1] == '-') {
                        eneg = true;
                        k = i + 2;
                    } else {
                        k = inchars[i + 1] == '+' ? i + 2 : i + 1;
                    }
                    elen = length - (k - offset);
                    if (elen == 0) {
                        throw new NumberFormatException("Invalid exponent");
                    }
                    int $2 = elen;
                    j = k;
                    while ($2 > 0 && (sj = inchars[j]) == '0') {
                        --elen;
                        --$2;
                        ++j;
                    }
                    k = j;
                    if (elen > 10) {
                        throw new NumberFormatException("Invalid exponent");
                    }
                    char[] maxExp = new char[]{'2', '1', '4', '7', '4', '8', '3', '6', '4', '7'};
                    if (elen == 10) {
                        boolean equals = true;
                        for (int b = 0; b < 10 && inchars[k + b] >= maxExp[b]; ++b) {
                            if (inchars[k + b] <= maxExp[b]) continue;
                            equals = false;
                            break;
                        }
                        if (!equals) {
                            throw new NumberFormatException("Invalid scale, must be between 2147483647 and -2147483647");
                        }
                    }
                    $2 = elen;
                    while ($2 > 0) {
                        sj = inchars[j];
                        if (sj < '0') {
                            this.bad(inchars);
                        }
                        if (sj > '9') {
                            if (!Character.isDigit(sj)) {
                                this.bad(inchars);
                            }
                            if ((dvalue = Character.digit(sj, 10)) < 0) {
                                this.bad(inchars);
                            }
                        } else {
                            dvalue = sj - 48;
                        }
                        newExp = newExp * 10 + dvalue;
                        --$2;
                        ++j;
                    }
                    if (!eneg) break;
                    newExp = -newExp;
                    break;
                }
                if (!Character.isDigit(si)) {
                    this.bad(inchars);
                }
                exotic = true;
                last = i;
                ++numDigits;
            }
            --$1;
            ++i;
        }
        if (numDigits == 0) {
            this.bad(inchars);
        }
        if (dotoff >= 0) {
            interm_exp = (long)newExp + (long)dotoff - (long)numDigits;
            if (-interm_exp < Integer.MIN_VALUE || -interm_exp > Integer.MAX_VALUE) {
                throw new NumberFormatException("BigDecimal scale outside legal range: " + -interm_exp);
            }
            newExp = newExp + dotoff - numDigits;
        }
        int $3 = last - 1;
        for (i = offset; i <= $3; ++i) {
            si = inchars[i];
            if (si == '0') {
                ++offset;
                --dotoff;
                --numDigits;
                continue;
            }
            if (si == '.') {
                ++offset;
                --dotoff;
                continue;
            }
            if (si <= '9' || Character.digit(si, 10) != 0) break;
            ++offset;
            --dotoff;
            --numDigits;
        }
        boolean tryLL = true;
        boolean bl = DFPCrit = numDigits < 17 && newExp >= -398 && newExp < 369;
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && DFPCrit) {
            int sum;
            if ((hys_counter += 0xA & ~((((sum = hys_counter + 10) ^ 0xA) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                hys_type = false;
                hys_counter = 0;
            } else if (hys_counter > hys_threshold) {
                hys_type = true;
                hys_counter = 0;
            }
        }
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP() && DFPCrit) {
            int prec = set.getPrecision();
            int rm = set.getRoundingMode().ordinal();
            if (bcdVal == 0L && newExp == 0) {
                this.constructDFPZero();
                return;
            }
            this.flags |= 4;
            if (bcdVal != 0L) {
                this.flags |= newInd;
            }
            this.flags |= 8;
            this.scale = -newExp;
            if (prec == 16 && rm == 6) {
                if (newInd == 96) {
                    if (this.DFPLongExpConstructor(bcdVal, newExp + 398, 64, 0, 0, true)) {
                        if (newInd == 96) {
                            this.laside |= Long.MIN_VALUE;
                        }
                        this.flags |= 0x10;
                        this.flags |= numDigits << 7;
                        this.finish(prec, rm);
                        return;
                    }
                } else if (this.DFPLongExpConstructor(bcdVal, newExp + 398, 64, 0, 0, true)) {
                    this.flags |= 0x10;
                    this.flags |= numDigits << 7;
                    return;
                }
            }
            if (prec == 0 || prec > 0 && rm == 7 || prec > 16) {
                if (this.DFPLongExpConstructor(bcdVal, newExp + 398, 0, 0, 0, true)) {
                    if (newInd == 96) {
                        this.laside |= Long.MIN_VALUE;
                    }
                    if (prec > 0 && rm == 7) {
                        if (newInd == 96) {
                            this.laside |= Long.MIN_VALUE;
                        }
                        this.finish(prec, rm);
                    } else {
                        this.flags |= 0x10;
                        this.flags |= numDigits << 7;
                    }
                    return;
                }
            } else if (prec <= 16) {
                if (newInd == 96) {
                    if (this.DFPLongExpConstructor(bcdVal, newExp + 398, 0, 0, 0, true)) {
                        this.laside |= Long.MIN_VALUE;
                        this.finish(prec, rm);
                        return;
                    }
                } else {
                    if (rm == 6) {
                        rm = 0;
                    } else if (rm == 0) {
                        rm = 6;
                    }
                    if (this.DFPLongExpConstructor(bcdVal, newExp + 398, 1, prec, rm, true)) {
                        this.flags &= 0xFFFFFFF7;
                        return;
                    }
                }
            }
            tryLL = false;
        }
        char[] sb = new char[numDigits];
        j = offset;
        if (exotic) {
            i = 0;
            int $4 = numDigits;
            while ($4 > 0) {
                if (i == dotoff) {
                    ++j;
                }
                if ((sj = inchars[j]) <= '9') {
                    sb[i] = sj;
                } else {
                    dvalue = Character.digit(sj, 10);
                    if (dvalue < 0) {
                        this.bad(inchars);
                    }
                    sb[i] = (char)dvalue;
                }
                ++j;
                --$4;
                ++i;
            }
        } else {
            int $5 = numDigits;
            i = 0;
            while ($5 > 0) {
                if (i == dotoff) {
                    ++j;
                }
                sb[i] = inchars[j];
                ++j;
                --$5;
                ++i;
            }
        }
        if (sb[0] == '0') {
            newInd = 0;
        }
        this.charConstructor(sb, newExp, newInd, set, tryLL);
    }

    private final void charConstructor(char[] sb, int newExp, int newInd, MathContext set, boolean tryLL) {
        if (tryLL && sb.length < 19) {
            this.flags |= 1;
            this.laside = BigDecimal.toLongForm(sb);
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            if (newInd == 96) {
                this.laside *= -1L;
            }
            this.scale = -newExp;
        } else {
            this.flags |= 2;
            this.bi = newInd == 96 ? new BigInteger("-" + new String(sb)) : new BigInteger(new String(sb));
            this.scale = -newExp;
            if (sb.length <= 0x1FFFFFF) {
                this.flags |= 0x10;
                this.flags |= sb.length << 7;
            }
        }
        if (set != MathContext.UNLIMITED) {
            this.finish(set.getPrecision(), set.getRoundingMode().ordinal());
        }
    }

    private void bigIntegerConstructor(BigInteger bi, int scale, MathContext set) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            if (BigDecimal.precisionBI(bi) < 17 && -scale <= 369 && -scale >= -398) {
                long val = bi.longValue();
                if (val == 0L && scale == 0) {
                    this.constructDFPZero();
                    return;
                }
                int prec = set.getPrecision();
                int rm = set.getRoundingMode().ordinal();
                if (prec == 16 && rm == 6 && this.DFPLongExpConstructor(val, -scale + 398, 64, 0, 0, false)) {
                    this.flags |= 0x10;
                    this.flags |= BigDecimal.numDigits(val) << 7;
                    this.flags |= 4;
                    this.flags |= bi.signum() << 5 & 0x60;
                    this.flags |= 8;
                    this.scale = scale;
                    return;
                }
                if (prec == 0 || prec > 0 && rm == 7 || prec > 16) {
                    if (this.DFPLongExpConstructor(val, -scale + 398, 0, 0, 0, false)) {
                        this.flags |= 4;
                        this.flags |= bi.signum() << 5 & 0x60;
                        if (prec > 0 && rm == 7) {
                            this.finish(prec, rm);
                        } else {
                            this.flags |= 0x10;
                            this.flags |= BigDecimal.numDigits(val) << 7;
                            this.flags |= 8;
                            this.scale = scale;
                        }
                        return;
                    }
                } else if (prec <= 16) {
                    if (rm == 6) {
                        rm = 0;
                    } else if (rm == 0) {
                        rm = 6;
                    }
                    if (this.DFPLongExpConstructor(val, -scale + 398, 1, prec, rm, false)) {
                        this.flags |= 4;
                        this.flags |= bi.signum() << 5 & 0x60;
                        return;
                    }
                }
            }
            this.flags |= 2;
            this.bi = bi;
            this.scale = scale;
            if (set != MathContext.UNLIMITED) {
                this.finish(set.getPrecision(), set.getRoundingMode().ordinal());
            }
            return;
        }
        if (bi.bitLength() < 63) {
            this.flags |= 1;
            this.laside = bi.longValue();
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            this.scale = scale;
            if (set != MathContext.UNLIMITED) {
                this.finish(set.getPrecision(), set.getRoundingMode().ordinal());
            }
        } else {
            this.flags |= 2;
            this.bi = bi;
            this.scale = scale;
            if (set != MathContext.UNLIMITED) {
                this.finish(set.getPrecision(), set.getRoundingMode().ordinal());
            }
            return;
        }
    }

    private final void bad(char[] s) {
        throw new NumberFormatException("Not a valid char constructor input  " + String.valueOf(s));
    }

    public BigDecimal add(BigDecimal rhs) {
        BigDecimal res = null;
        BigDecimal lhsClone = this;
        BigDecimal rhsClone = rhs;
        if ((res = this.add2DFP(rhs, res)) != null) {
            return res;
        }
        lhsClone = this.possibleClone(this);
        rhsClone = this.possibleClone(rhs);
        if ((lhsClone.flags & rhsClone.flags & 1) == 1) {
            long sum;
            int lhsScale = lhsClone.scale;
            if (lhsClone.scale == rhsClone.scale && BigDecimal.overflowAdd(lhsClone.laside, rhsClone.laside, sum = lhsClone.laside + rhsClone.laside) == 0L) {
                res = new BigDecimal();
                res.laside = sum;
                res.scale = lhsScale;
                res.flags |= 1;
                res.flags &= 0xFFFFFFEF;
                return res;
            }
        }
        return lhsClone.longAdd(rhsClone, res, MathContext.UNLIMITED, false);
    }

    private BigDecimal possibleClone(BigDecimal bd) {
        if (BigDecimal.DFPHWAvailable() && (bd.flags & 3) == 0) {
            bd = BigDecimal.clone(bd);
            bd.DFPToBI();
        }
        return bd;
    }

    private void add2BI(long lhsLaside, long rhsLaside, int lhsScale, BigDecimal res) {
        BigInteger lhsBI = BigInteger.valueOf(lhsLaside);
        BigInteger rhsBI = BigInteger.valueOf(rhsLaside);
        res.bi = lhsBI.add(rhsBI);
        res.scale = lhsScale;
        res.flags |= 2;
        res.flags &= 0xFFFFFFEF;
    }

    private BigDecimal add2DFP(BigDecimal rhs, BigDecimal res) {
        if (BigDecimal.DFPHWAvailable() && ((this.flags | rhs.flags) & 3) == 0) {
            res = new BigDecimal();
            int resExp = -Math.max(this.scale(), rhs.scale());
            if (resExp >= -398 && resExp <= 369 && res.DFPScaledAdd(rhs.laside, this.laside, resExp + 398)) {
                if (res.isDFPZero()) {
                    res.laside &= Long.MAX_VALUE;
                }
                return res;
            }
        }
        return null;
    }

    public BigDecimal add(BigDecimal rhs, MathContext set) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && set.getPrecision() == 16 && set.getRoundingMode().ordinal() == 6) {
            int sum;
            if ((hys_counter += 0xA & ~((((sum = hys_counter + 10) ^ 0xA) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                hys_type = false;
                hys_counter = 0;
            } else if (hys_counter > hys_threshold) {
                hys_type = true;
                hys_counter = 0;
            }
        }
        BigDecimal res = null;
        BigDecimal lhsClone = this;
        BigDecimal rhsClone = rhs;
        boolean passed = false;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | rhs.flags) & 3) == 0) {
            int sum;
            int prec = set.getPrecision();
            int rm = set.getRoundingMode().ordinal();
            if (prec != 0 && set.getRoundingMode().ordinal() != 7) {
                boolean lZero = this.isDFPZero();
                boolean rZero = rhs.isDFPZero();
                if (lZero && rZero) {
                    res = BigDecimal.valueOf(0L, Math.max(this.scale(), rhs.scale()));
                    res = BigDecimal.clone(res);
                    if (set != MathContext.UNLIMITED) {
                        res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                    }
                    return res;
                }
                if (lZero) {
                    res = BigDecimal.clone(rhs);
                    if (this.scale() > rhs.scale() && set.getPrecision() - rhs.precision() > 0) {
                        res = res.setScale(Math.abs(-this.scale()), true);
                    }
                    if (set != MathContext.UNLIMITED) {
                        res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                    }
                    return res;
                }
                if (rZero) {
                    res = BigDecimal.clone(this);
                    if (rhs.scale() > this.scale() && set.getPrecision() - rhs.precision() > 0) {
                        res = res.setScale(Math.abs(-rhs.scale()), true);
                    }
                    if (set != MathContext.UNLIMITED) {
                        res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                    }
                    return res;
                }
            }
            res = new BigDecimal();
            if (prec == 16 && rm == 6) {
                if (res.DFPAdd(rhs.laside, this.laside, 64, 0, 0)) {
                    passed = true;
                }
            } else if (prec == 0) {
                int resExp = -Math.max(this.scale(), rhs.scale());
                if (resExp >= -398 && resExp <= 369 && res.DFPScaledAdd(rhs.laside, this.laside, resExp + 398)) {
                    passed = true;
                }
            } else if (prec > 0 && rm == 7) {
                if (res.DFPAdd(rhs.laside, this.laside, 0, 0, 0)) {
                    if (BigDecimal.DFPPerformHysteresis()) {
                        if ((hys_counter += 0xFFFFFFFD & ~((((sum = hys_counter - 3) ^ 0xFFFFFFFD) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                            hys_type = false;
                            hys_counter = 0;
                        } else if (hys_counter > hys_threshold) {
                            hys_type = true;
                            hys_counter = 0;
                        }
                    }
                    res.finish(prec, rm);
                    passed = true;
                }
            } else if (prec <= 16) {
                if (rm == 6) {
                    rm = 0;
                } else if (rm == 0) {
                    rm = 6;
                }
                if (res.DFPAdd(rhs.laside, this.laside, 1, prec, rm)) {
                    if (BigDecimal.DFPPerformHysteresis()) {
                        if ((hys_counter += 0xFFFFFFFD & ~((((sum = hys_counter - 3) ^ 0xFFFFFFFD) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                            hys_type = false;
                            hys_counter = 0;
                        } else if (hys_counter > hys_threshold) {
                            hys_type = true;
                            hys_counter = 0;
                        }
                    }
                    passed = true;
                }
            }
            if (passed) {
                if (res.isDFPZero()) {
                    res.laside &= Long.MAX_VALUE;
                }
                return res;
            }
        }
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            lhsClone = BigDecimal.clone(this);
            lhsClone.DFPToBI();
        }
        if (BigDecimal.DFPHWAvailable() && (rhs.flags & 3) == 0) {
            rhsClone = BigDecimal.clone(rhs);
            rhsClone.DFPToBI();
        }
        if (res == null) {
            res = new BigDecimal();
        }
        if ((lhsClone.flags & rhsClone.flags & 1) == 1) {
            int lhsScale = lhsClone.scale;
            int rhsScale = rhsClone.scale;
            if (lhsScale == rhsScale) {
                long lhsLaside = lhsClone.laside;
                long rhsLaside = rhsClone.laside;
                int tempFlags = 0;
                long sum = lhsLaside + rhsLaside;
                if (BigDecimal.overflowAdd(lhsLaside, rhsLaside, sum) == 0L) {
                    res.laside = sum;
                    res.scale = lhsScale;
                    tempFlags |= 1;
                } else {
                    BigInteger lhsBI = BigInteger.valueOf(lhsLaside);
                    BigInteger rhsBI = BigInteger.valueOf(rhsLaside);
                    res.bi = lhsBI.add(rhsBI);
                    res.scale = lhsScale;
                    tempFlags |= 2;
                }
                res.flags = tempFlags &= 0xFFFFFFEF;
                if (set != MathContext.UNLIMITED) {
                    res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                }
                BigDecimal.postSetScaleProcessing(res);
                return res;
            }
            res = lhsClone.longAdd(rhsClone, res, set, false);
        } else {
            res = lhsClone.longAdd(rhsClone, res, set, false);
        }
        BigDecimal.postSetScaleProcessing(res);
        return res;
    }

    private final BigDecimal longAdd(BigDecimal rhs, BigDecimal allocedRes, MathContext set, boolean onRhs) {
        allocedRes = new BigDecimal();
        if (!onRhs && (rhs.flags & this.flags & 1) == 1 && rhs.scale == this.scale) {
            BigDecimal res = allocedRes;
            BigInteger lhsBI = BigInteger.valueOf(this.laside);
            BigInteger rhsBI = BigInteger.valueOf(rhs.laside);
            res.bi = lhsBI.add(rhsBI);
            res.scale = this.scale;
            res.flags |= 2;
            res.flags &= 0xFFFFFFEF;
            return res;
        }
        BigDecimal res = rhs;
        BigDecimal lhs = this;
        int lhsScale = lhs.scale;
        int rhsScale = rhs.scale;
        int tempFlags = 0;
        boolean passed = false;
        if ((lhs.flags & rhs.flags & 1) == 1) {
            boolean rZero;
            boolean lZero;
            long rhsLaside;
            long lhsLaside;
            if (set.getPrecision() != 0) {
                long scaleDiff;
                int tempPrecision;
                int preferredScale;
                lhsLaside = lhs.laside;
                rhsLaside = rhs.laside;
                if (lhsScale != rhsScale && lhsLaside != 0L && rhsLaside != 0L) {
                    BigDecimal smallerScaleBD;
                    BigDecimal biggerScaleBD;
                    if ((long)lhsScale - (long)rhsScale < 0L) {
                        biggerScaleBD = lhs;
                        smallerScaleBD = rhs;
                    } else {
                        biggerScaleBD = rhs;
                        smallerScaleBD = lhs;
                    }
                    int tempPrecision2 = 0;
                    int tempFlags2 = biggerScaleBD.flags;
                    tempPrecision2 = (tempFlags2 & 0x10) != 0 ? (tempFlags2 & 0xFFFFFF80) >> 7 : BigDecimal.numDigits(biggerScaleBD.laside);
                    long ulp = (long)biggerScaleBD.scale - (long)tempPrecision2 + (long)set.getPrecision();
                    tempFlags2 = smallerScaleBD.flags;
                    tempPrecision2 = (tempFlags2 & 0x10) != 0 ? (tempFlags2 & 0xFFFFFF80) >> 7 : BigDecimal.numDigits(biggerScaleBD.laside);
                    long msDigR = (long)smallerScaleBD.scale - (long)tempPrecision2 + 1L;
                    if (msDigR > (long)biggerScaleBD.scale + 2L && msDigR > ulp + 2L) {
                        long tempLaside = smallerScaleBD.laside;
                        int smallerSignum = (int)(tempLaside >> 63) | (int)(-tempLaside >>> 63);
                        if (smallerScaleBD == rhs) {
                            rhs = new BigDecimal();
                            rhs.laside = smallerSignum;
                            rhs.scale = (int)(Math.max((long)biggerScaleBD.scale, ulp) + 3L);
                            rhs.flags |= 1;
                        } else {
                            lhs = new BigDecimal();
                            lhs.laside = smallerSignum;
                            lhs.scale = (int)(Math.max((long)biggerScaleBD.scale, ulp) + 3L);
                            lhs.flags |= 1;
                        }
                    }
                }
                lhsLaside = lhs.laside;
                rhsLaside = rhs.laside;
                lZero = lhsLaside == 0L;
                boolean bl = rZero = rhsLaside == 0L;
                if (lZero && rZero) {
                    if (!onRhs) {
                        BigDecimal.clone(allocedRes, rhs);
                        res = allocedRes;
                    }
                    res.laside = 0L;
                    res.scale = Math.max(lhs.scale, rhs.scale);
                    res.roundLL(set.getPrecision(), set.getRoundingMode().ordinal(), false);
                    return res;
                }
                if (lZero) {
                    if (!onRhs) {
                        BigDecimal.clone(allocedRes, rhs);
                        res = allocedRes;
                    }
                    res.roundLL(set.getPrecision(), set.getRoundingMode().ordinal(), false);
                    preferredScale = Math.max(lhs.scale, rhs.scale);
                    tempPrecision = 0;
                    int tempFlags2 = res.flags;
                    tempPrecision = (tempFlags2 & 0x10) != 0 ? (tempFlags2 & 0xFFFFFF80) >> 7 : BigDecimal.numDigits(res.laside);
                    int precisionDiff = set.getPrecision() - tempPrecision;
                    scaleDiff = preferredScale - res.scale;
                    res = (long)precisionDiff >= scaleDiff ? res.setScale(preferredScale, true) : res.setScale(res.scale() + precisionDiff, true);
                    return res;
                }
                if (rZero) {
                    BigDecimal.clone(allocedRes, lhs);
                    res = allocedRes;
                    res.roundLL(set.getPrecision(), set.getRoundingMode().ordinal(), false);
                    preferredScale = Math.max(lhs.scale, rhs.scale);
                    tempPrecision = 0;
                    int tempFlags2 = res.flags;
                    tempPrecision = (tempFlags2 & 0x10) != 0 ? (tempFlags2 & 0xFFFFFF80) >> 7 : BigDecimal.numDigits(res.laside);
                    int precisionDiff = set.getPrecision() - tempPrecision;
                    scaleDiff = preferredScale - res.scale;
                    res = (long)precisionDiff >= scaleDiff ? res.setScale(preferredScale, true) : res.setScale(res.scale() + precisionDiff, true);
                    return res;
                }
            }
            lhsLaside = lhs.laside;
            rhsLaside = rhs.laside;
            lhsScale = lhs.scale;
            rhsScale = rhs.scale;
            lZero = lhsLaside == 0L;
            boolean bl = rZero = rhsLaside == 0L;
            if (!passed) {
                long pad;
                if (!onRhs) {
                    res = allocedRes;
                }
                tempFlags = res.flags;
                if (lhsScale > rhsScale) {
                    long diff = (long)(-rhsScale) + (long)lhsScale;
                    pad = BigDecimal.powerOfTenLL(diff);
                    if (pad != -1L) {
                        long sum;
                        int n;
                        int m;
                        long tempRhsLaside = rhsLaside;
                        if (tempRhsLaside < 0L) {
                            tempRhsLaside *= -1L;
                        }
                        if ((m = Long.numberOfLeadingZeros(tempRhsLaside) - 1) + (n = Long.numberOfLeadingZeros(pad) - 1) >= 63 && BigDecimal.overflowAdd(lhsLaside, rhsLaside *= pad, sum = lhsLaside + rhsLaside) == 0L) {
                            res.laside = sum;
                            res.scale = lhsScale;
                            tempFlags &= 0xFFFFFFFC;
                            tempFlags |= 1;
                            passed = true;
                        }
                    } else {
                        BigInteger lhsBI = BigInteger.valueOf(lhsLaside);
                        BigInteger rhsBI = BigInteger.valueOf(rhsLaside);
                        if (!rZero) {
                            if (diff > Integer.MAX_VALUE) {
                                throw new ArithmeticException("Scale overflow");
                            }
                            rhsBI = rhsBI.multiply(BigDecimal.powerOfTenBI(diff));
                        }
                        res.bi = lhsBI.add(rhsBI);
                        res.scale = lhsScale;
                        tempFlags &= 0xFFFFFFFC;
                        tempFlags |= 2;
                        passed = true;
                    }
                } else {
                    long diff = (long)(-lhsScale) + (long)rhsScale;
                    pad = BigDecimal.powerOfTenLL(diff);
                    if (pad != -1L) {
                        long sum;
                        int n;
                        int m;
                        long tempLhsLaside = lhsLaside;
                        if (tempLhsLaside < 0L) {
                            tempLhsLaside *= -1L;
                        }
                        if ((m = Long.numberOfLeadingZeros(tempLhsLaside) - 1) + (n = Long.numberOfLeadingZeros(pad) - 1) >= 63 && BigDecimal.overflowAdd(lhsLaside *= pad, rhsLaside, sum = lhsLaside + rhsLaside) == 0L) {
                            res.laside = sum;
                            res.scale = rhsScale;
                            tempFlags &= 0xFFFFFFFC;
                            tempFlags |= 1;
                            passed = true;
                        }
                    } else {
                        BigInteger lhsBI = BigInteger.valueOf(lhsLaside);
                        BigInteger rhsBI = BigInteger.valueOf(rhsLaside);
                        if (!lZero) {
                            if (diff > Integer.MAX_VALUE) {
                                throw new ArithmeticException("Scale overflow");
                            }
                            lhsBI = lhsBI.multiply(BigDecimal.powerOfTenBI(diff));
                        }
                        res.bi = lhsBI.add(rhsBI);
                        res.scale = rhsScale;
                        tempFlags &= 0xFFFFFFFC;
                        tempFlags |= 2;
                        passed = true;
                    }
                }
            }
            res.flags = tempFlags;
        }
        res.flags &= 0xFFFFFFEF;
        if (passed) {
            if (set != MathContext.UNLIMITED) {
                res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
            }
            return res;
        }
        return this.slAdd(rhs, allocedRes, set, onRhs);
    }

    private BigDecimal slAdd(BigDecimal rhs, BigDecimal allocedRes, MathContext set, boolean onRhs) {
        boolean rZero;
        boolean lZero;
        BigDecimal res = rhs;
        BigDecimal lhs = this;
        boolean passed = false;
        BigInteger lhsBI = null;
        BigInteger rhsBI = null;
        int lhsScale = lhs.scale;
        int rhsScale = rhs.scale;
        int tempFlags = 0;
        if (set.getPrecision() != 0) {
            long scaleDiff;
            if (lhsScale != rhsScale && lhs.signum() != 0 && rhs.signum() != 0) {
                BigDecimal smallerScaleBD;
                BigDecimal biggerScaleBD;
                if ((long)lhsScale - (long)rhsScale < 0L) {
                    biggerScaleBD = lhs;
                    smallerScaleBD = rhs;
                } else {
                    biggerScaleBD = rhs;
                    smallerScaleBD = lhs;
                }
                long ulp = (long)biggerScaleBD.scale - (long)biggerScaleBD.precision() + (long)set.getPrecision();
                long msDigR = (long)smallerScaleBD.scale - (long)smallerScaleBD.precision() + 1L;
                if (msDigR > (long)biggerScaleBD.scale + 2L && msDigR > ulp + 2L) {
                    int smallerSignum = smallerScaleBD.signum();
                    if (smallerScaleBD == rhs) {
                        rhs = new BigDecimal();
                        rhs.bi = BigInteger.valueOf(smallerSignum);
                        rhs.scale = (int)(Math.max((long)biggerScaleBD.scale, ulp) + 3L);
                        rhs.flags |= 2;
                    } else {
                        lhs = new BigDecimal();
                        lhs.bi = BigInteger.valueOf(smallerSignum);
                        lhs.scale = Math.max(biggerScaleBD.scale, (int)ulp) + 3;
                        lhs.flags |= 2;
                    }
                }
            }
            lZero = lhs.signum() == 0;
            boolean bl = rZero = rhs.signum() == 0;
            if (lZero && rZero) {
                if (!onRhs) {
                    BigDecimal.clone(allocedRes, rhs);
                    res = allocedRes;
                }
                res.laside = 0L;
                res.scale = Math.max(lhsScale, rhsScale);
                res.roundBI(set.getPrecision(), set.getRoundingMode().ordinal(), false);
                return res;
            }
            if (lZero) {
                if (!onRhs) {
                    BigDecimal.clone(allocedRes, rhs);
                    res = allocedRes;
                }
                if ((res.flags & 1) == 1) {
                    res.roundLL(set.getPrecision(), set.getRoundingMode().ordinal(), false);
                } else {
                    res.roundBI(set.getPrecision(), set.getRoundingMode().ordinal(), false);
                }
                int preferredScale = Math.max(lhsScale, rhsScale);
                int precisionDiff = set.getPrecision() - res.precision();
                scaleDiff = preferredScale - res.scale;
                res = (long)precisionDiff >= scaleDiff ? res.setScale(preferredScale, true) : res.setScale(res.scale() + precisionDiff, true);
                return res;
            }
            if (rZero) {
                BigDecimal.clone(allocedRes, lhs);
                res = allocedRes;
                if ((res.flags & 1) == 1) {
                    res.roundLL(set.getPrecision(), set.getRoundingMode().ordinal(), false);
                } else {
                    res.roundBI(set.getPrecision(), set.getRoundingMode().ordinal(), false);
                }
                int preferredScale = Math.max(lhsScale, rhsScale);
                int precisionDiff = set.getPrecision() - res.precision();
                scaleDiff = preferredScale - res.scale;
                res = (long)precisionDiff >= scaleDiff ? res.setScale(preferredScale, true) : res.setScale(res.scale() + precisionDiff, true);
                return res;
            }
        }
        lhsBI = lhs.bi;
        rhsBI = rhs.bi;
        if ((lhs.flags & 3) != 2) {
            lhsBI = BigInteger.valueOf(lhs.laside);
        }
        if ((rhs.flags & 3) != 2) {
            rhsBI = BigInteger.valueOf(rhs.laside);
        }
        lhsScale = lhs.scale;
        rhsScale = rhs.scale;
        lZero = lhsBI.signum() == 0;
        boolean bl = rZero = rhsBI.signum() == 0;
        if (!passed) {
            long diff;
            if (!onRhs) {
                res = allocedRes;
            }
            tempFlags = res.flags;
            if (lhsScale == rhsScale) {
                res.bi = lhsBI.add(rhsBI);
                res.scale = lhs.scale;
                tempFlags &= 0xFFFFFFFC;
                tempFlags |= 2;
            } else if (lhsScale > rhsScale) {
                if (!rZero) {
                    diff = -((long)rhsScale) + (long)lhsScale;
                    if (diff > Integer.MAX_VALUE) {
                        throw new ArithmeticException("Scale overflow");
                    }
                    rhsBI = rhsBI.multiply(BigDecimal.powerOfTenBI(diff));
                }
                res.bi = lhsBI.add(rhsBI);
                res.scale = lhsScale;
                tempFlags &= 0xFFFFFFFC;
                tempFlags |= 2;
            } else {
                if (!lZero) {
                    diff = -((long)lhsScale) + (long)rhsScale;
                    if (diff > Integer.MAX_VALUE) {
                        throw new ArithmeticException("Scale overflow");
                    }
                    lhsBI = lhsBI.multiply(BigDecimal.powerOfTenBI(diff));
                }
                res.bi = lhsBI.add(rhsBI);
                res.scale = rhsScale;
                tempFlags &= 0xFFFFFFFC;
                tempFlags |= 2;
            }
            res.flags = tempFlags;
        }
        res.flags &= 0xFFFFFFEF;
        if (set != MathContext.UNLIMITED) {
            res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
        }
        return res;
    }

    public BigDecimal subtract(BigDecimal rhs) {
        BigDecimal res = new BigDecimal();
        BigDecimal lhsClone = this;
        BigDecimal rhsClone = rhs;
        if (this.subtract2DFP(rhs, res) != null) {
            return res;
        }
        lhsClone = this.possibleClone(this);
        rhsClone = this.possibleClone(rhs);
        return lhsClone.subtract(rhsClone, res, MathContext.UNLIMITED);
    }

    private BigDecimal subtract2DFP(BigDecimal rhs, BigDecimal res) {
        int resExp;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | rhs.flags) & 3) == 0 && (resExp = -Math.max(this.scale(), rhs.scale())) >= -398 && resExp <= 369 && res.DFPScaledSubtract(rhs.laside, this.laside, resExp + 398)) {
            if (res.isDFPZero()) {
                res.laside &= Long.MAX_VALUE;
            }
            return res;
        }
        return null;
    }

    public BigDecimal subtract(BigDecimal rhs, MathContext set) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && set.getPrecision() == 16 && set.getRoundingMode().ordinal() == 6) {
            int sum;
            if ((hys_counter += 0xA & ~((((sum = hys_counter + 10) ^ 0xA) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                hys_type = false;
                hys_counter = 0;
            } else if (hys_counter > hys_threshold) {
                hys_type = true;
                hys_counter = 0;
            }
        }
        BigDecimal res = null;
        BigDecimal lhsClone = this;
        BigDecimal rhsClone = rhs;
        boolean passed = false;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | rhs.flags) & 3) == 0) {
            int sum;
            int prec = set.getPrecision();
            int rm = set.getRoundingMode().ordinal();
            if (prec != 0 && set.getRoundingMode().ordinal() != 7) {
                boolean lZero = this.isDFPZero();
                boolean rZero = rhs.isDFPZero();
                if (lZero && rZero) {
                    res = BigDecimal.valueOf(0L, Math.max(this.scale(), rhs.scale()));
                    res = BigDecimal.clone(res);
                    if (set != MathContext.UNLIMITED) {
                        res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                    }
                    return res;
                }
                if (lZero) {
                    res = rhs.negate();
                    if (this.scale() > rhs.scale() && set.getPrecision() - rhs.precision() > 0) {
                        res = res.setScale(Math.abs(-this.scale()), true);
                    }
                    if (set != MathContext.UNLIMITED) {
                        res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                    }
                    return res;
                }
                if (rZero) {
                    res = BigDecimal.clone(this);
                    if (rhs.scale() > this.scale() && set.getPrecision() - rhs.precision() > 0) {
                        res = res.setScale(Math.abs(-rhs.scale()), true);
                    }
                    if (set != MathContext.UNLIMITED) {
                        res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                    }
                    return res;
                }
            }
            res = new BigDecimal();
            if (prec == 16 && rm == 6) {
                if (res.DFPSubtract(rhs.laside, this.laside, 64, 0, 0)) {
                    passed = true;
                }
            } else if (prec == 0) {
                int resExp = -Math.max(this.scale(), rhs.scale());
                if (resExp >= -398 && resExp <= 369 && res.DFPScaledSubtract(rhs.laside, this.laside, resExp + 398)) {
                    passed = true;
                }
            } else if (prec > 0 && rm == 7) {
                if (res.DFPSubtract(rhs.laside, this.laside, 0, 0, 0)) {
                    if (BigDecimal.DFPPerformHysteresis()) {
                        if ((hys_counter += 0xFFFFFFFD & ~((((sum = hys_counter - 3) ^ 0xFFFFFFFD) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                            hys_type = false;
                            hys_counter = 0;
                        } else if (hys_counter > hys_threshold) {
                            hys_type = true;
                            hys_counter = 0;
                        }
                    }
                    res.finish(prec, rm);
                    passed = true;
                }
            } else if (prec <= 16) {
                if (rm == 6) {
                    rm = 0;
                } else if (rm == 0) {
                    rm = 6;
                }
                if (res.DFPSubtract(rhs.laside, this.laside, 1, prec, rm)) {
                    if (BigDecimal.DFPPerformHysteresis()) {
                        if ((hys_counter += 0xFFFFFFFD & ~((((sum = hys_counter - 3) ^ 0xFFFFFFFD) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                            hys_type = false;
                            hys_counter = 0;
                        } else if (hys_counter > hys_threshold) {
                            hys_type = true;
                            hys_counter = 0;
                        }
                    }
                    passed = true;
                }
            }
            if (passed) {
                if (res.isDFPZero()) {
                    res.laside &= Long.MAX_VALUE;
                }
                return res;
            }
        }
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            lhsClone = BigDecimal.clone(this);
            lhsClone.DFPToBI();
        }
        if (BigDecimal.DFPHWAvailable() && (rhs.flags & 3) == 0) {
            rhsClone = BigDecimal.clone(rhs);
            rhsClone.DFPToBI();
        }
        if (res == null) {
            res = new BigDecimal();
        }
        res = lhsClone.subtract(rhsClone, res, set);
        BigDecimal.postSetScaleProcessing(res);
        return res;
    }

    private final BigDecimal subtract(BigDecimal rhs, BigDecimal allocedRes, MathContext set) {
        BigDecimal newrhs = BigDecimal.clone(rhs);
        if ((rhs.flags & 1) == 1) {
            newrhs.laside *= -1L;
        } else {
            newrhs.bi = newrhs.bi.negate();
        }
        newrhs.flags &= 0xFFFFFFFB;
        return this.longAdd(newrhs, allocedRes, set, true);
    }

    public BigDecimal multiply(BigDecimal rhs) {
        if ((this.flags & rhs.flags & 1) == 1) {
            int n;
            int m;
            BigDecimal res = new BigDecimal();
            long interm_scale = 0L;
            int tempFlags = this.flags;
            interm_scale = (long)this.scale() + (long)rhs.scale();
            if (interm_scale < Integer.MIN_VALUE || interm_scale > Integer.MAX_VALUE) {
                if (this.signum() == 0) {
                    interm_scale = interm_scale > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                } else {
                    throw new ArithmeticException("BigDecimal scale outside legal range: " + interm_scale);
                }
            }
            res.scale = (int)interm_scale;
            long lhsLaside = this.laside;
            long rhsLaside = rhs.laside;
            if (lhsLaside < 0L) {
                lhsLaside *= -1L;
            }
            if (rhsLaside < 0L) {
                rhsLaside *= -1L;
            }
            if ((m = Long.numberOfLeadingZeros(lhsLaside) - 1) + (n = Long.numberOfLeadingZeros(rhsLaside) - 1) >= 63) {
                long result;
                res.laside = result = this.laside * rhs.laside;
                tempFlags &= 0xFFFFFFFC;
                tempFlags |= 1;
                res.flags = tempFlags &= 0xFFFFFFEF;
                return res;
            }
        }
        return this.multiply2(rhs);
    }

    private BigDecimal multiply2(BigDecimal rhs) {
        int resExp;
        BigDecimal res = new BigDecimal();
        BigDecimal lhsClone = null;
        BigDecimal rhsClone = null;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | rhs.flags) & 3) == 0 && (resExp = -(this.scale() + rhs.scale())) >= -398 && resExp <= 369 && res.DFPScaledMultiply(rhs.laside, this.laside, resExp + 398)) {
            if (res.isDFPZero()) {
                res.laside &= Long.MAX_VALUE;
            }
            return res;
        }
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            lhsClone = BigDecimal.clone(this);
            lhsClone.DFPToBI();
        }
        if (BigDecimal.DFPHWAvailable() && (rhs.flags & 3) == 0) {
            rhsClone = BigDecimal.clone(rhs);
            rhsClone.DFPToBI();
        } else {
            rhsClone = rhs;
        }
        if (lhsClone != null) {
            lhsClone.longMultiply(rhsClone, res, MathContext.UNLIMITED, false);
        } else {
            this.longMultiply(rhsClone, res, MathContext.UNLIMITED, false);
        }
        return res;
    }

    public BigDecimal multiply(BigDecimal rhs, MathContext set) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && set.getPrecision() == 16 && set.getRoundingMode().ordinal() == 6) {
            int sum;
            if ((hys_counter += 0xA & ~((((sum = hys_counter + 10) ^ 0xA) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                hys_type = false;
                hys_counter = 0;
            } else if (hys_counter > hys_threshold) {
                hys_type = true;
                hys_counter = 0;
            }
        }
        BigDecimal res = new BigDecimal();
        BigDecimal lhsClone = this;
        BigDecimal rhsClone = rhs;
        boolean passed = false;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | rhs.flags) & 3) == 0) {
            int prec = set.getPrecision();
            int rm = set.getRoundingMode().ordinal();
            if (prec == 16 && rm == 6) {
                if (res.DFPMultiply(rhs.laside, this.laside, 64, 0, 0)) {
                    passed = true;
                }
            } else if (prec == 0) {
                int resExp = -(this.scale() + rhs.scale());
                if (resExp >= -398 && resExp <= 369 && res.DFPScaledMultiply(rhs.laside, this.laside, resExp + 398)) {
                    passed = true;
                }
            } else if (prec > 0 && rm == 7) {
                if (res.DFPMultiply(rhs.laside, this.laside, 0, 0, 0)) {
                    res.finish(prec, rm);
                    passed = true;
                }
            } else if (prec <= 16) {
                if (rm == 6) {
                    rm = 0;
                } else if (rm == 0) {
                    rm = 6;
                }
                if (res.DFPMultiply(rhs.laside, this.laside, 1, prec, rm)) {
                    passed = true;
                }
            }
            if (passed) {
                if (res.isDFPZero()) {
                    res.laside &= Long.MAX_VALUE;
                }
                return res;
            }
        }
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            lhsClone = BigDecimal.clone(this);
            lhsClone.DFPToBI();
        }
        if (BigDecimal.DFPHWAvailable() && (rhs.flags & 3) == 0) {
            rhsClone = BigDecimal.clone(rhs);
            rhsClone.DFPToBI();
        }
        lhsClone.longMultiply(rhsClone, res, set, false);
        return res;
    }

    private final void longMultiply(BigDecimal rhs, BigDecimal allocedRes, MathContext set, boolean onLhs) {
        long interm_scale = 0L;
        boolean passed = false;
        int tempFlags = onLhs ? this.flags : allocedRes.flags;
        tempFlags &= 0xFFFFFFEF;
        interm_scale = (long)this.scale() + (long)rhs.scale();
        if (interm_scale < Integer.MIN_VALUE || interm_scale > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                interm_scale = interm_scale > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + interm_scale);
            }
        }
        if (onLhs) {
            this.scale = (int)interm_scale;
        } else {
            allocedRes.scale = (int)interm_scale;
        }
        if ((this.flags & rhs.flags & 1) == 1) {
            int n;
            int m;
            long lhsLaside = this.laside;
            long rhsLaside = rhs.laside;
            if (lhsLaside < 0L) {
                lhsLaside *= -1L;
            }
            if (rhsLaside < 0L) {
                rhsLaside *= -1L;
            }
            if ((m = Long.numberOfLeadingZeros(lhsLaside) - 1) + (n = Long.numberOfLeadingZeros(rhsLaside) - 1) >= 63) {
                long result = this.laside * rhs.laside;
                if (onLhs) {
                    this.laside = result;
                } else {
                    allocedRes.laside = result;
                }
                tempFlags &= 0xFFFFFFFC;
                tempFlags |= 1;
                passed = true;
            } else {
                BigInteger lhsBI = BigInteger.valueOf(this.laside);
                BigInteger rhsBI = BigInteger.valueOf(rhs.laside);
                if (onLhs) {
                    this.bi = rhsBI.multiply(lhsBI);
                } else {
                    allocedRes.bi = rhsBI.multiply(lhsBI);
                }
                tempFlags &= 0xFFFFFFFC;
                tempFlags |= 2;
                passed = true;
            }
            if (onLhs) {
                this.flags = tempFlags;
            } else {
                allocedRes.flags = tempFlags;
            }
        }
        if (passed) {
            if (set != MathContext.UNLIMITED) {
                if (onLhs) {
                    this.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                } else {
                    allocedRes.finish(set.getPrecision(), set.getRoundingMode().ordinal());
                }
            }
        } else if (onLhs) {
            this.slMultiply(rhs, this, set, onLhs);
        } else {
            this.slMultiply(rhs, allocedRes, set, onLhs);
        }
        if (onLhs) {
            BigDecimal.postSetScaleProcessing(this);
        } else {
            BigDecimal.postSetScaleProcessing(allocedRes);
        }
    }

    private final void slMultiply(BigDecimal rhs, BigDecimal res, MathContext set, boolean onLhs) {
        BigDecimal lhsClone = null;
        if (onLhs) {
            lhsClone = BigDecimal.clone(this);
        }
        BigInteger lhsBI = onLhs ? lhsClone.bi : this.bi;
        BigInteger rhsBI = rhs.bi;
        lhsBI = this.bi;
        rhsBI = rhs.bi;
        if (onLhs) {
            if ((lhsClone.flags & 3) != 2) {
                lhsBI = BigInteger.valueOf(lhsClone.laside);
            }
        } else if ((this.flags & 3) != 2) {
            lhsBI = BigInteger.valueOf(this.laside);
        }
        if ((rhs.flags & 3) != 2) {
            rhsBI = BigInteger.valueOf(rhs.laside);
        }
        int tempFlags = res.flags;
        tempFlags &= 0xFFFFFFFC;
        tempFlags |= 2;
        res.bi = lhsBI.multiply(rhsBI);
        res.flags = tempFlags &= 0xFFFFFFEF;
        if (set != MathContext.UNLIMITED) {
            res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
        }
    }

    public BigDecimal divide(BigDecimal rhs, int rm) {
        return this.divide(rhs, this.scale(), rm);
    }

    public BigDecimal divide(BigDecimal rhs, RoundingMode rm) {
        return this.divide(rhs, this.scale(), rm.ordinal());
    }

    public BigDecimal divide(BigDecimal rhs, int scale, RoundingMode rm) {
        return this.divide(rhs, scale, rm.ordinal());
    }

    public BigDecimal divide(BigDecimal rhs, int scale, int rm) {
        RoundingMode.valueOf(rm);
        BigDecimal res = new BigDecimal();
        BigDecimal lhsClone = this;
        BigDecimal rhsClone = rhs;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            lhsClone = BigDecimal.clone(this);
            lhsClone.DFPToBI();
        }
        if (BigDecimal.DFPHWAvailable() && (rhs.flags & 3) == 0) {
            rhsClone = BigDecimal.clone(rhs);
            rhsClone.DFPToBI();
        }
        lhsClone.divide(rhsClone, res, scale, rm);
        return res;
    }

    private final void divide(BigDecimal rhs, BigDecimal allocedRes, int scale, int rm) {
        BigDecimal res = null;
        BigDecimal lhsClone = null;
        BigDecimal rhsClone = null;
        if ((this.flags & rhs.flags & 1) == 1) {
            res = this.longScaledDivide(rhs, allocedRes, scale, rm);
        }
        if (res == null) {
            lhsClone = BigDecimal.clone(this);
            rhsClone = BigDecimal.clone(rhs);
            lhsClone.LLToBI();
            rhsClone.LLToBI();
            lhsClone.slScaledDivide(rhsClone, allocedRes, rm, scale);
        }
    }

    public BigDecimal divide(BigDecimal rhs) {
        BigDecimal lhs = this;
        BigDecimal res = new BigDecimal();
        BigDecimal lhsClone = lhs;
        BigDecimal rhsClone = rhs;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | rhs.flags) & 3) == 0) {
            if (rhs.isDFPZero()) {
                throw new ArithmeticException("Divide by zero.");
            }
            int desiredPrecision = (int)Math.min((double)lhs.precision() + Math.ceil(10 * rhs.precision() / 3), 2.147483647E9);
            boolean passed = false;
            int ret = res.DFPDivide(rhs.laside, this.laside, true, 0, 0, 0);
            if (ret == 1) {
                if (res.precision() > desiredPrecision) {
                    throw new ArithmeticException("Non-terminating decimal expansion");
                }
                passed = true;
            }
            if (passed) {
                if (res.isDFPZero()) {
                    res.laside &= Long.MAX_VALUE;
                }
                return res;
            }
        }
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            lhsClone = BigDecimal.clone(this);
            lhsClone.DFPToBI();
        }
        if (BigDecimal.DFPHWAvailable() && (rhs.flags & 3) == 0) {
            rhsClone = BigDecimal.clone(rhs);
            rhsClone.DFPToBI();
        }
        lhsClone.divide(rhsClone, res, MathContext.UNLIMITED);
        return res;
    }

    public BigDecimal divide(BigDecimal rhs, MathContext set) {
        BigDecimal lhs = this;
        BigDecimal res = new BigDecimal();
        BigDecimal thisClone = lhs;
        BigDecimal rhsClone = rhs;
        int prec = set.getPrecision();
        if (prec == 0) {
            return lhs.divide(rhs);
        }
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && set.getPrecision() == 16 && set.getRoundingMode().ordinal() == 6) {
            int sum;
            if ((hys_counter += 0xA & ~((((sum = hys_counter + 10) ^ 0xA) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                hys_type = false;
                hys_counter = 0;
            } else if (hys_counter > hys_threshold) {
                hys_type = true;
                hys_counter = 0;
            }
        }
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            thisClone = BigDecimal.clone(this);
            rhsClone = BigDecimal.clone(rhs);
            BigDecimal.postSetScaleProcessing(thisClone);
            BigDecimal.postSetScaleProcessing(rhsClone);
        }
        if (BigDecimal.DFPHWAvailable() && ((thisClone.flags | rhsClone.flags) & 3) == 0) {
            if (rhsClone.isDFPZero()) {
                throw new ArithmeticException("Divide by zero.");
            }
            int rm = set.getRoundingMode().ordinal();
            boolean passed = false;
            if (prec == 16 && rm == 6) {
                int ret = res.DFPDivide(rhsClone.laside, thisClone.laside, false, 64, 0, 0);
                if (ret == 1) {
                    passed = true;
                }
            } else if (prec <= 16) {
                if (rm == 6) {
                    rm = 0;
                } else if (rm == 0) {
                    rm = 6;
                }
                int ret = res.DFPDivide(rhsClone.laside, thisClone.laside, true, 1, prec, rm);
                if (ret == 0 && rm == 7) {
                    throw new ArithmeticException("Inexact result required rounding");
                }
                if (ret == 1) {
                    if (BigDecimal.DFPPerformHysteresis()) {
                        int sum;
                        if ((hys_counter += 0xA & ~((((sum = hys_counter + 10) ^ 0xA) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                            hys_type = false;
                            hys_counter = 0;
                        } else if (hys_counter > hys_threshold) {
                            hys_type = true;
                            hys_counter = 0;
                        }
                    }
                    passed = true;
                }
                if (rm == 6) {
                    rm = 0;
                } else if (rm == 0) {
                    rm = 6;
                }
            }
            if (passed) {
                if (res.isDFPZero()) {
                    res.laside &= Long.MAX_VALUE;
                }
                return res;
            }
        }
        if (BigDecimal.DFPHWAvailable() && (thisClone.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToBI();
        }
        if (BigDecimal.DFPHWAvailable() && (rhsClone.flags & 3) == 0) {
            rhsClone = BigDecimal.clone(rhs);
            rhsClone.DFPToBI();
        }
        thisClone.divide(rhsClone, res, set);
        BigDecimal.postSetScaleProcessing(res);
        return res;
    }

    private final void divide(BigDecimal rhs, BigDecimal allocedRes, MathContext set) {
        BigDecimal res = null;
        BigDecimal lhsClone = null;
        BigDecimal rhsClone = null;
        if ((this.flags & rhs.flags & 1) == 1) {
            res = this.longPrecisionDivide(rhs, allocedRes, set);
        }
        if (res == null) {
            lhsClone = BigDecimal.clone(this);
            rhsClone = BigDecimal.clone(rhs);
            lhsClone.LLToBI();
            rhsClone.LLToBI();
            lhsClone.slPrecisionDivide(rhsClone, allocedRes, set);
        }
    }

    public BigDecimal remainder(BigDecimal rhs) {
        BigDecimal first = this.divideToIntegralValue(rhs);
        BigDecimal second = first.multiply(rhs);
        BigDecimal third = this.subtract(second);
        return third;
    }

    public BigDecimal remainder(BigDecimal rhs, MathContext set) {
        BigDecimal first = this.divideToIntegralValue(rhs, set);
        BigDecimal second = first.multiply(rhs);
        BigDecimal third = this.subtract(second);
        return third;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal rhs) {
        BigDecimal[] ret;
        ret = new BigDecimal[]{this.divideToIntegralValue(rhs), this.subtract(ret[0].multiply(rhs))};
        return ret;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal rhs, MathContext set) {
        BigDecimal[] ret;
        ret = new BigDecimal[]{this.divideToIntegralValue(rhs, set), this.subtract(ret[0].multiply(rhs))};
        return ret;
    }

    public BigDecimal divideToIntegralValue(BigDecimal rhs) {
        BigDecimal absRHS;
        if (rhs.signum() == 0) {
            throw new ArithmeticException("Dividing by 0");
        }
        int desiredScale = (int)Math.max(Math.min((long)this.scale() - (long)rhs.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        BigDecimal absLHS = this.abs();
        if (absLHS.compareTo(absRHS = rhs.abs()) < 0) {
            return BigDecimal.valueOf(0L, desiredScale);
        }
        int numDigitsL = this.precision();
        int numDigitsR = rhs.precision();
        long desiredPrecision = (long)Math.min((double)numDigitsL + Math.ceil(10.0 * (double)numDigitsR / 3.0), 2.147483647E9);
        if ((desiredPrecision += Math.min(Math.abs((long)this.scale() - (long)rhs.scale()) + 2L + desiredPrecision, Integer.MAX_VALUE)) > Integer.MAX_VALUE) {
            throw new ArithmeticException("Scale overflow");
        }
        MathContext mc = new MathContext((int)desiredPrecision, RoundingMode.DOWN);
        BigDecimal res = this.divide(rhs, mc);
        int resScale = res.scale();
        if (resScale > 0) {
            res = res.setScale(0, RoundingMode.DOWN);
        }
        if (desiredScale > 0) {
            res = res.setScale(desiredScale);
        } else {
            int scaleDiff = Math.abs(desiredScale - res.scale());
            if (scaleDiff != 0) {
                if ((res.flags & 3) == 0) {
                    res.DFPToLL();
                }
                if ((res.flags & 1) == 1) {
                    long temp = res.laside;
                    int tempSc = res.scale;
                    while (temp % 10L == 0L && scaleDiff > 0) {
                        temp /= 10L;
                        --tempSc;
                        --scaleDiff;
                    }
                    res.laside = temp;
                    res.scale = tempSc;
                } else {
                    BigInteger temp = res.bi;
                    int tempSc = res.scale;
                    while (temp.mod(BigInteger.TEN).equals(BigInteger.ZERO) && scaleDiff > 0) {
                        temp = temp.divide(BigInteger.TEN);
                        --tempSc;
                        --scaleDiff;
                    }
                    res.bi = temp;
                    res.scale = tempSc;
                }
                res.flags &= 0xFFFFFFEF;
            }
        }
        return res;
    }

    public BigDecimal divideToIntegralValue(BigDecimal rhs, MathContext set) {
        BigDecimal absRHS;
        if (set.getPrecision() == 0) {
            return this.divideToIntegralValue(rhs);
        }
        int desiredScale = (int)Math.max(Math.min((long)this.scale() - (long)rhs.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        BigDecimal absLHS = this.abs();
        if (absLHS.compareTo(absRHS = rhs.abs()) < 0) {
            return BigDecimal.valueOf(0L, desiredScale);
        }
        MathContext mc = new MathContext(set.getPrecision(), RoundingMode.DOWN);
        BigDecimal res = this.divide(rhs, mc);
        int resScale = res.scale();
        if (resScale > 0) {
            res = res.setScale(0, RoundingMode.DOWN);
        }
        if (desiredScale > 0 && set.getPrecision() == 0) {
            res = res.setScale(desiredScale);
        } else if (desiredScale >= 0) {
            int diffOfPrecision = set.getPrecision() - res.precision();
            if (diffOfPrecision > 0) {
                res = res.setScale(Math.min(diffOfPrecision, desiredScale));
            }
        } else {
            int scaleDiff = Math.abs(desiredScale - res.scale());
            if (scaleDiff != 0) {
                if ((res.flags & 3) == 0) {
                    res.DFPToLL();
                }
                if ((res.flags & 1) == 1) {
                    long temp = res.laside;
                    int tempSc = res.scale;
                    while (temp % 10L == 0L && scaleDiff > 0) {
                        temp /= 10L;
                        --tempSc;
                        --scaleDiff;
                    }
                    res.laside = temp;
                    res.scale = tempSc;
                } else {
                    BigInteger temp = res.bi;
                    int tempSc = res.scale;
                    while (temp.mod(BigInteger.TEN).equals(BigInteger.ZERO) && scaleDiff > 0) {
                        temp = temp.divide(BigInteger.TEN);
                        --tempSc;
                        --scaleDiff;
                    }
                    res.bi = temp;
                    res.scale = tempSc;
                }
                res.flags &= 0xFFFFFFEF;
            }
        }
        BigDecimal rem = this.subtract(rhs.multiply(res));
        if (rem.abs().compareTo(absRHS) >= 0) {
            throw new ArithmeticException("Integral division is inexact");
        }
        if (set.getPrecision() > 0 && res.precision() > set.getPrecision()) {
            throw new ArithmeticException("Requires more than prec digits");
        }
        return res;
    }

    private final BigDecimal longPrecisionDivide(BigDecimal rhs, BigDecimal allocedRes, MathContext set) {
        long quotient;
        long remainder;
        BigDecimal res = null;
        long scaleL = this.scale;
        long scaleR = rhs.scale;
        long origScaleL = scaleL;
        long origScaleR = scaleR;
        int tempInd = this.signum() * rhs.signum();
        long newL = this.laside;
        long newR = rhs.laside;
        if (newL < 0L) {
            newL *= -1L;
        }
        if (newR < 0L) {
            newR *= -1L;
        }
        long numDigitsL = this.precision();
        long numDigitsR = rhs.precision();
        long digitDiff = 0L;
        long pow = 0L;
        boolean checkForNTE = false;
        int desiredPrecision = set.getPrecision();
        boolean closerScale = true;
        long preferredScale = 0L;
        if (rhs.laside == 0L) {
            if (this.laside == 0L) {
                throw new ArithmeticException("Division is undefined");
            }
            throw new ArithmeticException("Dividing by 0");
        }
        if (desiredPrecision == 0) {
            preferredScale = (int)Math.max(Math.min((long)this.scale() - (long)rhs.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
            desiredPrecision = (int)Math.min((double)numDigitsL + Math.ceil(10.0 * (double)numDigitsR / 3.0), 2.147483647E9);
            checkForNTE = true;
        } else {
            preferredScale = origScaleL - origScaleR;
        }
        if (this.laside == 0L) {
            BigDecimal.clone(allocedRes, this);
            allocedRes.scale = (int)Math.max(Math.min(preferredScale, Integer.MAX_VALUE), Integer.MIN_VALUE);
            return allocedRes;
        }
        if (numDigitsL > numDigitsR) {
            digitDiff = numDigitsL - numDigitsR;
            pow = BigDecimal.powerOfTenLL(digitDiff);
            if (pow == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(newR, pow)) {
                return null;
            }
            newR *= pow;
            scaleR += digitDiff;
        } else if (numDigitsL < numDigitsR) {
            digitDiff = numDigitsR - numDigitsL;
            pow = BigDecimal.powerOfTenLL(digitDiff);
            if (pow == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(newL, pow)) {
                return null;
            }
            newL *= pow;
            scaleL += digitDiff;
        }
        if (newL > newR) {
            if (BigDecimal.overflowMultiply(newR, 10L)) {
                return null;
            }
            newR *= 10L;
            ++scaleR;
        }
        if ((pow = BigDecimal.powerOfTenLL(desiredPrecision)) == -1L) {
            return null;
        }
        if (BigDecimal.overflowMultiply(newL, pow)) {
            return null;
        }
        if ((remainder = (newL *= pow) - (quotient = newL / newR) * newR) != 0L) {
            closerScale = false;
        }
        if (checkForNTE && remainder != 0L) {
            throw new ArithmeticException("Non-terminating decimal expansion.");
        }
        if (desiredPrecision != 0 && set.getRoundingMode().ordinal() == 7 && remainder != 0L) {
            throw new ArithmeticException("Inexact result requires rounding.");
        }
        long tempQuotient = quotient;
        long tempRemainder = remainder;
        long newnewR = newR;
        if (tempQuotient < 0L) {
            tempQuotient *= -1L;
        }
        if (tempRemainder < 0L) {
            tempRemainder *= -1L;
        }
        if (newR < 0L) {
            newnewR *= -1L;
        }
        int numDigits = BigDecimal.numDigits(tempQuotient);
        boolean roundEffect = false;
        long roundedQuotient = BigDecimal.roundPostLLDivision(tempQuotient, tempInd, newnewR, tempRemainder, set.getRoundingMode().ordinal());
        long scale = scaleL - scaleR + (long)desiredPrecision;
        if (roundedQuotient != tempQuotient && roundedQuotient % 10L == 0L && tempQuotient % 10L != 0L) {
            roundEffect = true;
        }
        if (roundedQuotient == -1L) {
            return null;
        }
        int numDigitsAgain = BigDecimal.numDigits(roundedQuotient);
        if (numDigits < numDigitsAgain && numDigitsAgain > desiredPrecision) {
            roundedQuotient /= 10L;
            --scale;
        }
        long scaleDiff = scale - preferredScale;
        if (checkForNTE && scale < preferredScale) {
            scaleDiff = preferredScale - scale;
            pow = BigDecimal.powerOfTenLL(scaleDiff);
            if (pow == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(roundedQuotient, pow)) {
                return null;
            }
            scale += scaleDiff;
            roundedQuotient *= pow;
        }
        if (scale > preferredScale && !roundEffect && closerScale) {
            while (roundedQuotient % 10L == 0L && scaleDiff > 0L) {
                roundedQuotient /= 10L;
                --scale;
                --scaleDiff;
            }
            if (roundedQuotient == 0L && scaleDiff > 0L) {
                scale -= scaleDiff;
            }
        }
        if (scale < Integer.MIN_VALUE || scale > Integer.MAX_VALUE) {
            throw new ArithmeticException("BigDecimal scale outside legal range: " + scale);
        }
        if (tempInd == -1) {
            roundedQuotient *= -1L;
        }
        res = allocedRes;
        res.laside = roundedQuotient;
        res.scale = (int)scale;
        res.flags &= 0xFFFFFFFC;
        res.flags |= 1;
        res.flags &= 0x7F;
        res.flags |= BigDecimal.numDigits(res.laside) << 7;
        return res;
    }

    private final BigDecimal longScaledDivide(BigDecimal rhs, BigDecimal allocedRes, int desiredScale, int rm) {
        long roundedQuotient;
        BigDecimal res = null;
        if (rhs.laside == 0L) {
            if (this.laside == 0L) {
                throw new ArithmeticException("Division is undefined");
            }
            throw new ArithmeticException("Dividing by 0");
        }
        if (this.laside == 0L) {
            res = allocedRes;
            res.laside = 0L;
            res.scale = desiredScale;
            res.flags &= 0xFFFFFFFC;
            res.flags |= 1;
            res.flags &= 0x7F;
            res.flags |= 0x80;
        }
        int tempInd = this.signum() * rhs.signum();
        long lhsL = this.laside;
        long rhsL = rhs.laside;
        if (lhsL < 0L) {
            lhsL *= -1L;
        }
        if (rhsL < 0L) {
            rhsL *= -1L;
        }
        long naturalScale = (long)this.scale - (long)rhs.scale;
        long pow = 0L;
        long scaleDiff = 0L;
        long newL = lhsL;
        long newR = rhsL;
        if (naturalScale < (long)desiredScale) {
            scaleDiff = (long)desiredScale - naturalScale;
            pow = BigDecimal.powerOfTenLL(scaleDiff);
            if (pow == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(newL, pow)) {
                return null;
            }
            newL *= pow;
        } else if (naturalScale > (long)desiredScale) {
            scaleDiff = naturalScale - (long)desiredScale;
            pow = BigDecimal.powerOfTenLL(scaleDiff);
            if (pow == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(newR, pow)) {
                return null;
            }
            newR *= pow;
        }
        long quotient = newL / newR;
        long remainder = newL - quotient * newR;
        long tempQuotient = quotient;
        long tempRemainder = remainder;
        long newnewR = newR;
        if (tempQuotient < 0L) {
            tempQuotient *= -1L;
        }
        if (tempRemainder < 0L) {
            tempRemainder *= -1L;
        }
        if (newR < 0L) {
            newnewR *= -1L;
        }
        if ((roundedQuotient = BigDecimal.roundPostLLDivision(tempQuotient, tempInd, newnewR, tempRemainder, rm)) == -1L) {
            return null;
        }
        if (tempInd == -1) {
            roundedQuotient *= -1L;
        }
        res = allocedRes;
        res.laside = roundedQuotient;
        res.scale = desiredScale;
        res.flags &= 0xFFFFFFFC;
        res.flags |= 1;
        res.flags &= 0x7F;
        res.flags |= BigDecimal.numDigits(res.laside) << 7;
        return res;
    }

    private final BigDecimal slPrecisionDivide(BigDecimal rhs, BigDecimal allocedRes, MathContext set) {
        int numDigitsAgain;
        BigDecimal res = null;
        long scaleL = this.scale;
        long scaleR = rhs.scale;
        long origScaleL = scaleL;
        long origScaleR = scaleR;
        int tempInd = rhs.signum() * this.signum();
        int numDigitsL = this.precision();
        int numDigitsR = rhs.precision();
        long digitDiff = 0L;
        boolean checkForNTE = false;
        int desiredPrecision = set.getPrecision();
        boolean closerScale = true;
        long preferredScale = 0L;
        if (rhs.bi.signum() == 0) {
            if (this.bi.signum() == 0) {
                throw new ArithmeticException("Division is undefined");
            }
            throw new ArithmeticException("Dividing by 0");
        }
        if (desiredPrecision == 0) {
            preferredScale = (int)Math.max(Math.min((long)this.scale() - (long)rhs.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
            desiredPrecision = (int)Math.min((double)numDigitsL + Math.ceil(10.0 * (double)numDigitsR / 3.0), 2.147483647E9);
            checkForNTE = true;
        } else {
            preferredScale = origScaleL - origScaleR;
        }
        if ((long)this.bi.signum() == 0L) {
            BigDecimal.clone(allocedRes, this);
            allocedRes.scale = (int)Math.max(Math.min(preferredScale, Integer.MAX_VALUE), Integer.MIN_VALUE);
            return allocedRes;
        }
        BigInteger newLBI = this.bi.abs();
        BigInteger newRBI = rhs.bi.abs();
        if (numDigitsL > numDigitsR) {
            digitDiff = numDigitsL - numDigitsR;
            if (digitDiff >= Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            newRBI = newRBI.multiply(BigDecimal.powerOfTenBI(digitDiff));
            scaleR += digitDiff;
        } else if (numDigitsL < numDigitsR) {
            digitDiff = numDigitsR - numDigitsL;
            if (digitDiff >= Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            newLBI = newLBI.multiply(BigDecimal.powerOfTenBI(digitDiff));
            scaleL += digitDiff;
        }
        if (newLBI.compareTo(newRBI) > 0) {
            newRBI = newRBI.multiply(BigInteger.TEN);
            ++scaleR;
        }
        if (desiredPrecision >= Integer.MAX_VALUE) {
            throw new ArithmeticException("Scale overflow");
        }
        BigInteger[] quotRem = (newLBI = newLBI.multiply(BigDecimal.powerOfTenBI(desiredPrecision))).divideAndRemainder(newRBI);
        if (quotRem[1].signum() != 0) {
            closerScale = false;
        }
        if (checkForNTE && quotRem[1].signum() != 0) {
            throw new ArithmeticException("Non-terminating decimal expansion.");
        }
        if (desiredPrecision != 0 && set.getRoundingMode().ordinal() == 7 && quotRem[1].signum() != 0) {
            throw new ArithmeticException("Inexact result requires rounding.");
        }
        int numDigits = BigDecimal.precisionBI(quotRem[0]);
        boolean roundEffect = false;
        BigInteger roundedQuotient = BigDecimal.roundPostSlowDivision(quotRem[0], tempInd, newRBI, quotRem[1], set.getRoundingMode().ordinal());
        long scale = scaleL - scaleR + (long)desiredPrecision;
        if (!roundedQuotient.equals(quotRem[0]) && roundedQuotient.mod(BigInteger.TEN).equals(BigInteger.ZERO) && !quotRem[1].mod(BigInteger.TEN).equals(BigInteger.ZERO)) {
            roundEffect = true;
        }
        if (numDigits < (numDigitsAgain = BigDecimal.precisionBI(roundedQuotient)) && numDigitsAgain > desiredPrecision) {
            roundedQuotient = roundedQuotient.divide(BigInteger.TEN);
            --scale;
        }
        long scaleDiff = scale - preferredScale;
        if (checkForNTE && scale < preferredScale) {
            scaleDiff = preferredScale - scale;
            if (scaleDiff >= Integer.MAX_VALUE || scale > Integer.MAX_VALUE || scale < Integer.MIN_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            roundedQuotient = roundedQuotient.multiply(BigDecimal.powerOfTenBI(scaleDiff));
            scale += scaleDiff;
        }
        if (scale > preferredScale && !roundEffect && closerScale) {
            while (roundedQuotient.mod(BigInteger.TEN).equals(BigInteger.ZERO) && scaleDiff > 0L) {
                roundedQuotient = roundedQuotient.divide(BigInteger.TEN);
                --scale;
                --scaleDiff;
            }
            if (roundedQuotient.equals(BigInteger.ZERO) && scaleDiff > 0L) {
                scale -= scaleDiff;
            }
        }
        if (scale < Integer.MIN_VALUE || scale > Integer.MAX_VALUE) {
            throw new ArithmeticException("BigDecimal scale outside legal range: " + scale);
        }
        if (tempInd == -1) {
            roundedQuotient = roundedQuotient.negate();
        }
        res = allocedRes;
        res.bi = roundedQuotient;
        res.scale = (int)scale;
        res.flags &= 0xFFFFFFFC;
        res.flags |= 2;
        res.flags |= 4;
        res.flags &= 0xFFFFFF9F;
        res.flags |= tempInd << 5 & 0x60;
        BigDecimal.postSetScaleProcessing(res);
        return res;
    }

    private final void slScaledDivide(BigDecimal rhs, BigDecimal allocedRes, int rm, int desiredScale) {
        BigDecimal res = null;
        if (rhs.bi.signum() == 0) {
            if (this.bi.signum() == 0) {
                throw new ArithmeticException("Division is undefined");
            }
            throw new ArithmeticException("Dividing by 0");
        }
        if ((long)this.bi.signum() == 0L) {
            res = allocedRes;
            res.bi = BigInteger.ZERO;
            res.scale = desiredScale;
            res.flags &= 0xFFFFFFFC;
            res.flags |= 2;
            res.flags |= 4;
            res.flags &= 0xFFFFFF9F;
            return;
        }
        int tempInd = this.bi.signum() * rhs.bi.signum();
        BigInteger lhsBI = this.bi.abs();
        BigInteger rhsBI = rhs.bi.abs();
        long naturalScale = (long)this.scale - (long)rhs.scale;
        long scaleDiff = 0L;
        BigInteger newLBI = lhsBI;
        BigInteger newRBI = rhsBI;
        long rhsCheck = (long)rhs.scale + (long)desiredScale;
        long thisCheck = (long)this.scale - (long)desiredScale;
        if (naturalScale < (long)desiredScale) {
            scaleDiff = (long)desiredScale - naturalScale;
            if (scaleDiff > Integer.MAX_VALUE || rhsCheck > Integer.MAX_VALUE || thisCheck > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            if (rhsCheck < Integer.MIN_VALUE) {
                throw new ArithmeticException("Scale underflow");
            }
            newLBI = newLBI.multiply(BigDecimal.powerOfTenBI(scaleDiff));
        } else if (naturalScale > (long)desiredScale) {
            scaleDiff = naturalScale - (long)desiredScale;
            if (scaleDiff > Integer.MAX_VALUE || thisCheck > Integer.MAX_VALUE || rhsCheck > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            if ((long)this.scale - (long)desiredScale < Integer.MIN_VALUE || rhsCheck < Integer.MIN_VALUE) {
                throw new ArithmeticException("Scale underflow");
            }
            newRBI = newRBI.multiply(BigDecimal.powerOfTenBI(scaleDiff));
        }
        BigInteger[] quotRem = newLBI.divideAndRemainder(newRBI);
        BigInteger roundedQuotient = BigDecimal.roundPostSlowDivision(quotRem[0], tempInd, newRBI, quotRem[1], rm);
        if (tempInd == -1) {
            roundedQuotient = roundedQuotient.negate();
        }
        res = allocedRes;
        res.bi = roundedQuotient;
        res.scale = desiredScale;
        res.flags &= 0xFFFFFFFC;
        res.flags |= 2;
        res.flags |= 4;
        res.flags &= 0xFFFFFF9F;
        res.flags |= tempInd << 5 & 0x60;
        BigDecimal.postSetScaleProcessing(res);
    }

    public BigDecimal abs() {
        return this.abs(MathContext.UNLIMITED);
    }

    public BigDecimal abs(MathContext set) {
        if (this.signum() < 0) {
            return this.negate(set);
        }
        return this.plus(set);
    }

    public BigDecimal max(BigDecimal rhs) {
        int res = this.compareTo(rhs);
        if (res > 0) {
            return this.plus();
        }
        if (res == 0) {
            return this;
        }
        return rhs.plus();
    }

    public BigDecimal min(BigDecimal rhs) {
        int res = this.compareTo(rhs);
        if (res < 0) {
            return this.plus();
        }
        if (res == 0) {
            return this;
        }
        return rhs.plus();
    }

    public BigDecimal negate() {
        return this.negate(MathContext.UNLIMITED);
    }

    public BigDecimal negate(MathContext set) {
        BigDecimal res = BigDecimal.clone(this);
        if (BigDecimal.DFPHWAvailable() && (res.flags & 3) == 0) {
            int signum = this.signum();
            res.flags |= 4;
            if (signum == -1) {
                res.laside &= Long.MAX_VALUE;
                res.flags &= 0xFFFFFF9F;
                res.flags |= 0x20;
            } else if (signum == 1) {
                res.laside |= (res.laside |= Long.MIN_VALUE);
                res.flags &= 0xFFFFFF9F;
                res.flags |= 0x60;
            }
            if (res.bi != null) {
                res.bi = res.bi.negate();
            }
        } else if ((this.flags & 3) == 2) {
            res.bi = this.bi.negate();
        } else {
            res.laside *= -1L;
            if (res.bi != null) {
                res.bi = res.bi.negate();
            }
        }
        if (set != MathContext.UNLIMITED) {
            res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
        }
        return res;
    }

    public BigDecimal plus() {
        return this.plus(MathContext.UNLIMITED);
    }

    public BigDecimal plus(MathContext set) {
        if (set == MathContext.UNLIMITED) {
            return this;
        }
        BigDecimal res = BigDecimal.clone(this);
        if (set != MathContext.UNLIMITED) {
            res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
        }
        return res;
    }

    public byte byteValueExact() {
        long tenPow;
        long actualNumDigits;
        int numDigits = 3;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
        }
        if ((actualNumDigits = (long)thisClone.precision() - (long)thisClone.scale) < 0L || actualNumDigits > 3L) {
            throw new ArithmeticException("Conversion overflow: " + thisClone);
        }
        if ((thisClone.flags & 1) == 1 ? thisClone.scale > 0 && ((tenPow = BigDecimal.powerOfTenLL(thisClone.scale)) != -1L ? thisClone.laside % tenPow != 0L : thisClone.laside != 0L) : thisClone.scale > 0 && thisClone.bi.remainder(tenPow = BigDecimal.powerOfTenBI(thisClone.scale)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + thisClone);
        }
        BigInteger num = thisClone.toBigInteger();
        if (num.compareTo(MAXBYTE) > 0 || num.compareTo(MINBYTE) < 0) {
            throw new ArithmeticException("Conversion overflow: " + thisClone);
        }
        return num.byteValue();
    }

    public short shortValueExact() {
        long tenPow;
        long actualNumDigits;
        int numDigits = 5;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
        }
        if ((actualNumDigits = (long)thisClone.precision() - (long)thisClone.scale) < 0L || actualNumDigits > 5L) {
            throw new ArithmeticException("Conversion overflow: " + thisClone);
        }
        if ((thisClone.flags & 1) == 1 ? thisClone.scale > 0 && ((tenPow = BigDecimal.powerOfTenLL(thisClone.scale)) != -1L ? thisClone.laside % tenPow != 0L : thisClone.laside != 0L) : thisClone.scale > 0 && thisClone.bi.remainder(tenPow = BigDecimal.powerOfTenBI(thisClone.scale)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + thisClone);
        }
        BigInteger num = thisClone.toBigInteger();
        if (num.compareTo(MAXSHORT) > 0 || num.compareTo(MINSHORT) < 0) {
            throw new ArithmeticException("Conversion overflow: " + thisClone);
        }
        return num.shortValue();
    }

    public int intValueExact() {
        long tenPow;
        long actualNumDigits;
        int numDigits = 10;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
        }
        if ((actualNumDigits = (long)thisClone.precision() - (long)thisClone.scale) < 0L || actualNumDigits > 10L) {
            throw new ArithmeticException("Conversion overflow: " + thisClone);
        }
        if ((thisClone.flags & 1) == 1 ? thisClone.scale > 0 && ((tenPow = BigDecimal.powerOfTenLL(thisClone.scale)) != -1L ? thisClone.laside % tenPow != 0L : thisClone.laside != 0L) : thisClone.scale > 0 && thisClone.bi.remainder(tenPow = BigDecimal.powerOfTenBI(thisClone.scale)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + thisClone);
        }
        BigInteger num = thisClone.toBigInteger();
        if (num.compareTo(MAXINT) > 0 || num.compareTo(MININT) < 0) {
            throw new ArithmeticException("Conversion overflow: " + thisClone);
        }
        return num.intValue();
    }

    public long longValueExact() {
        long tenPow;
        long actualNumDigits;
        int numDigits = 19;
        if (this.signum() == 0) {
            return 0L;
        }
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
        }
        if ((actualNumDigits = (long)thisClone.precision() - (long)thisClone.scale) < 0L || actualNumDigits > 19L) {
            throw new ArithmeticException("Conversion overflow: " + thisClone);
        }
        if ((thisClone.flags & 1) == 1 ? thisClone.scale > 0 && ((tenPow = BigDecimal.powerOfTenLL(thisClone.scale)) != -1L ? thisClone.laside % tenPow != 0L : thisClone.laside != 0L) : thisClone.scale > 0 && thisClone.bi.remainder(tenPow = BigDecimal.powerOfTenBI(thisClone.scale)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + thisClone);
        }
        BigInteger num = thisClone.toBigInteger();
        if (num.compareTo(MAXLONG) > 0 || num.compareTo(MINLONG) < 0) {
            throw new ArithmeticException("Conversion overflow: " + thisClone);
        }
        return num.longValue();
    }

    public BigInteger toBigIntegerExact() {
        BigInteger biTenPow;
        BigInteger bi;
        long tenPow;
        if (this.signum() == 0) {
            return BigInteger.valueOf(0L);
        }
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
        }
        if ((thisClone.flags & 1) == 1 ? thisClone.scale > 0 && ((tenPow = BigDecimal.powerOfTenLL(thisClone.scale)) != -1L ? thisClone.laside % tenPow != 0L : (bi = BigInteger.valueOf(thisClone.laside)).remainder(biTenPow = BigDecimal.powerOfTenBI(thisClone.scale)).compareTo(BigInteger.ZERO) != 0) : thisClone.scale > 0 && thisClone.bi.remainder(tenPow = BigDecimal.powerOfTenBI(thisClone.scale)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + thisClone);
        }
        thisClone = thisClone.setScale(0);
        if ((thisClone.flags & 3) == 1) {
            return BigInteger.valueOf(thisClone.laside);
        }
        return thisClone.bi;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    @Override
    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    @Override
    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public BigInteger toBigInteger() {
        BigDecimal temp = this.setScale(0, RoundingMode.DOWN);
        if (temp == this) {
            temp = BigDecimal.clone(this);
        }
        if (BigDecimal.DFPHWAvailable() && (temp.flags & 3) == 0) {
            temp.DFPToLL();
        }
        if ((temp.flags & 1) == 1) {
            return BigInteger.valueOf(temp.laside);
        }
        return temp.bi;
    }

    @Override
    public int compareTo(BigDecimal rhs) {
        if ((this.flags & rhs.flags & 1) == 1) {
            long lhsLaside = this.laside;
            long rhsLaside = rhs.laside;
            int lhsScale = this.scale;
            int rhsScale = rhs.scale;
            if (lhsScale == rhsScale) {
                long temp = lhsLaside - rhsLaside;
                return (int)(temp >> 63) | (int)(-temp >>> 63);
            }
        }
        return this.compareTo2(rhs);
    }

    private int compareTo2(BigDecimal rhs) {
        int ret = 0;
        BigDecimal thisClone = this;
        BigDecimal rhsClone = rhs;
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            thisClone = BigDecimal.clone(this);
            rhsClone = BigDecimal.clone(rhs);
            BigDecimal.postSetScaleProcessing(thisClone);
            BigDecimal.postSetScaleProcessing(rhsClone);
        }
        if (BigDecimal.DFPHWAvailable() && ((thisClone.flags | rhsClone.flags) & 3) == 0) {
            int res = BigDecimal.DFPCompareTo(thisClone.laside, rhsClone.laside);
            if (res != -2) {
                return res;
            }
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
            rhsClone = BigDecimal.clone(rhs);
            rhsClone.DFPToLL();
            ret = BigDecimal.longCompareTo(thisClone, rhsClone);
            return ret;
        }
        if ((thisClone.flags & rhsClone.flags & 1) == 1) {
            long lhsLaside = thisClone.laside;
            long rhsLaside = rhsClone.laside;
            int lhsScale = thisClone.scale;
            int rhsScale = rhsClone.scale;
            if (lhsScale == rhsScale) {
                long temp = lhsLaside - rhsLaside;
                ret = (int)(temp >> 63) | (int)(-temp >>> 63);
                return ret;
            }
            int lhsSignum = (int)(lhsLaside >> 63) | (int)(-lhsLaside >>> 63);
            int rhsSignum = (int)(rhsLaside >> 63) | (int)(-rhsLaside >>> 63);
            int signumDiff = lhsSignum - rhsSignum;
            if (signumDiff != 0) {
                ret = signumDiff > 0 ? 1 : -1;
                return ret;
            }
            int tempLHSFlags = thisClone.flags;
            int tempRHSFlags = rhsClone.flags;
            int lhsNumWholeDigits = -lhsScale;
            int rhsNumWholeDigits = -rhsScale;
            int prec = 0;
            if ((tempLHSFlags & 0x10) != 0) {
                lhsNumWholeDigits += (tempLHSFlags & 0xFFFFFF80) >> 7;
            } else {
                prec = BigDecimal.numDigits(lhsLaside);
                lhsNumWholeDigits += prec;
                tempLHSFlags |= 0x10;
                tempLHSFlags &= 0x7F;
                thisClone.flags = tempLHSFlags |= prec << 7;
            }
            if ((tempRHSFlags & 0x10) != 0) {
                rhsNumWholeDigits += (tempRHSFlags & 0xFFFFFF80) >> 7;
            } else {
                prec = BigDecimal.numDigits(rhsLaside);
                rhsNumWholeDigits += prec;
                tempRHSFlags |= 0x10;
                tempRHSFlags &= 0x7F;
                rhsClone.flags = tempRHSFlags |= prec << 7;
            }
            if (lhsNumWholeDigits < rhsNumWholeDigits) {
                ret = -lhsSignum;
                return ret;
            }
            if (lhsNumWholeDigits > rhsNumWholeDigits) {
                ret = lhsSignum;
                return ret;
            }
            long scaleDiff = 0L;
            BigInteger lhsBI = null;
            BigInteger rhsBI = null;
            if (lhsScale < rhsScale) {
                scaleDiff = (long)rhsScale - (long)lhsScale;
                long pad = BigDecimal.powerOfTenLL(scaleDiff);
                if (pad != -1L) {
                    int n;
                    int m;
                    long tempLaside = lhsLaside;
                    if (tempLaside < 0L) {
                        tempLaside *= -1L;
                    }
                    if ((m = Long.numberOfLeadingZeros(tempLaside) - 1) + (n = Long.numberOfLeadingZeros(pad) - 1) >= 63) {
                        long temp = (lhsLaside *= pad) - rhsLaside;
                        ret = (int)(temp >> 63) | (int)(-temp >>> 63);
                        return ret;
                    }
                }
                lhsBI = BigInteger.valueOf(lhsLaside);
                rhsBI = BigInteger.valueOf(rhsLaside);
                if (scaleDiff > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Scale overflow");
                }
                lhsBI = lhsBI.multiply(BigDecimal.powerOfTenBI(scaleDiff));
                ret = lhsBI.compareTo(rhsBI);
                return ret;
            }
            if (lhsScale > rhsScale) {
                scaleDiff = lhsScale - rhsScale;
                long pad = BigDecimal.powerOfTenLL(scaleDiff);
                if (pad != -1L) {
                    int n;
                    int m;
                    long tempLaside = rhsLaside;
                    if (tempLaside < 0L) {
                        tempLaside *= -1L;
                    }
                    if ((m = Long.numberOfLeadingZeros(tempLaside) - 1) + (n = Long.numberOfLeadingZeros(pad) - 1) >= 63) {
                        long temp = lhsLaside - (rhsLaside *= pad);
                        ret = (int)(temp >> 63) | (int)(-temp >>> 63);
                        return ret;
                    }
                }
                lhsBI = BigInteger.valueOf(lhsLaside);
                rhsBI = BigInteger.valueOf(rhsLaside);
                if (scaleDiff > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Scale overflow");
                }
                rhsBI = rhsBI.multiply(BigDecimal.powerOfTenBI(scaleDiff));
                ret = lhsBI.compareTo(rhsBI);
                return ret;
            }
            long temp = lhsLaside - rhsLaside;
            ret = (int)(temp >> 63) | (int)(-temp >>> 63);
            return ret;
        }
        thisClone = BigDecimal.clone(this);
        rhsClone = BigDecimal.clone(rhs);
        if (BigDecimal.DFPHWAvailable() && (thisClone.flags & 3) == 0) {
            thisClone.DFPToLL();
        }
        if (BigDecimal.DFPHWAvailable() && (rhsClone.flags & 3) == 0) {
            rhsClone.DFPToLL();
        }
        if ((thisClone.flags & rhsClone.flags & 1) == 1) {
            ret = BigDecimal.longCompareTo(thisClone, rhsClone);
            return ret;
        }
        if ((thisClone.flags & 3) == 1) {
            thisClone.LLToBI();
        }
        if ((rhsClone.flags & 3) == 1) {
            rhsClone.LLToBI();
        }
        ret = BigDecimal.slCompareTo(thisClone, rhsClone);
        return ret;
    }

    private static final int longCompareTo(BigDecimal lhs, BigDecimal rhs) {
        long lhsLaside = lhs.laside;
        int lhsSignum = (int)(lhsLaside >> 63) | (int)(-lhsLaside >>> 63);
        long rhsLaside = rhs.laside;
        int rhsSignum = (int)(rhsLaside >> 63) | (int)(-rhsLaside >>> 63);
        int signumDiff = lhsSignum - rhsSignum;
        if (signumDiff != 0) {
            return signumDiff > 0 ? 1 : -1;
        }
        int lhsScale = lhs.scale;
        int rhsScale = rhs.scale;
        int tempLHSFlags = lhs.flags;
        int tempRHSFlags = rhs.flags;
        int lhsNumWholeDigits = -lhsScale;
        int rhsNumWholeDigits = -rhsScale;
        int prec = 0;
        if ((tempLHSFlags & 0x10) != 0) {
            lhsNumWholeDigits += (tempLHSFlags & 0xFFFFFF80) >> 7;
        } else {
            prec = BigDecimal.numDigits(lhsLaside);
            lhsNumWholeDigits += prec;
            tempLHSFlags |= 0x10;
            tempLHSFlags &= 0x7F;
            lhs.flags = tempLHSFlags |= prec << 7;
        }
        if ((tempRHSFlags & 0x10) != 0) {
            rhsNumWholeDigits += (tempRHSFlags & 0xFFFFFF80) >> 7;
        } else {
            prec = BigDecimal.numDigits(rhsLaside);
            rhsNumWholeDigits += prec;
            tempRHSFlags |= 0x10;
            tempRHSFlags &= 0x7F;
            rhs.flags = tempRHSFlags |= prec << 7;
        }
        if (lhsNumWholeDigits < rhsNumWholeDigits) {
            return -lhsSignum;
        }
        if (lhsNumWholeDigits > rhsNumWholeDigits) {
            return lhsSignum;
        }
        int scaleDiff = 0;
        BigInteger lhsBI = null;
        BigInteger rhsBI = null;
        if (lhsScale < rhsScale) {
            scaleDiff = rhsScale - lhsScale;
            long pad = BigDecimal.powerOfTenLL(scaleDiff);
            if (pad != -1L) {
                int n;
                int m;
                long tempLaside = lhsLaside;
                if (tempLaside < 0L) {
                    tempLaside *= -1L;
                }
                if ((m = Long.numberOfLeadingZeros(tempLaside) - 1) + (n = Long.numberOfLeadingZeros(pad) - 1) >= 63) {
                    long temp = (lhsLaside *= pad) - rhsLaside;
                    return (int)(temp >> 63) | (int)(-temp >>> 63);
                }
            }
            lhsBI = BigInteger.valueOf(lhsLaside);
            rhsBI = BigInteger.valueOf(rhsLaside);
            if (scaleDiff > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            lhsBI = lhsBI.multiply(BigDecimal.powerOfTenBI(scaleDiff));
            return lhsBI.compareTo(rhsBI);
        }
        if (lhsScale > rhsScale) {
            scaleDiff = lhsScale - rhsScale;
            long pad = BigDecimal.powerOfTenLL(scaleDiff);
            if (pad != -1L) {
                int n;
                int m;
                long tempLaside = rhsLaside;
                if (tempLaside < 0L) {
                    tempLaside *= -1L;
                }
                if ((m = Long.numberOfLeadingZeros(tempLaside) - 1) + (n = Long.numberOfLeadingZeros(pad) - 1) >= 63) {
                    long temp = lhsLaside - (rhsLaside *= pad);
                    return (int)(temp >> 63) | (int)(-temp >>> 63);
                }
            }
            lhsBI = BigInteger.valueOf(lhsLaside);
            rhsBI = BigInteger.valueOf(rhsLaside);
            if (scaleDiff > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            rhsBI = rhsBI.multiply(BigDecimal.powerOfTenBI(scaleDiff));
            return lhsBI.compareTo(rhsBI);
        }
        long temp = lhsLaside - rhsLaside;
        return (int)(temp >> 63) | (int)(-temp >>> 63);
    }

    private static final int slCompareTo(BigDecimal lhs, BigDecimal rhs) {
        int rhsNumWholeDigits;
        int rhsSignum;
        int lhsSignum = lhs.bi.signum();
        int signumDiff = lhsSignum - (rhsSignum = rhs.bi.signum());
        if (signumDiff != 0) {
            return signumDiff > 0 ? 1 : -1;
        }
        BigInteger lhsBI = lhs.bi;
        BigInteger rhsBI = rhs.bi;
        int lhsScale = lhs.scale;
        int rhsScale = rhs.scale;
        int lhsNumWholeDigits = lhs.precision() - lhsScale;
        if (lhsNumWholeDigits < (rhsNumWholeDigits = rhs.precision() - rhsScale)) {
            return -lhsSignum;
        }
        if (lhsNumWholeDigits > rhsNumWholeDigits) {
            return lhsSignum;
        }
        int scaleDiff = 0;
        if (lhsScale < rhsScale) {
            scaleDiff = rhsScale - lhsScale;
            if (scaleDiff > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            lhsBI = lhsBI.multiply(BigDecimal.powerOfTenBI(scaleDiff));
            return lhsBI.compareTo(rhsBI);
        }
        if (lhsScale > rhsScale) {
            scaleDiff = lhsScale - rhsScale;
            if (scaleDiff > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            rhsBI = rhsBI.multiply(BigDecimal.powerOfTenBI(scaleDiff));
            return lhsBI.compareTo(rhsBI);
        }
        BigInteger temp = lhsBI.subtract(rhsBI);
        return temp.signum();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BigDecimal)) {
            return false;
        }
        BigDecimal rhs = (BigDecimal)obj;
        if (this == rhs) {
            return true;
        }
        if ((this.flags & rhs.flags & 1) == 1) {
            return this.laside == rhs.laside && this.scale == rhs.scale;
        }
        return this.unscaledValue().equals(rhs.unscaledValue()) && this.scale() == rhs.scale();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int precision() {
        int tempFlags = this.flags;
        if ((tempFlags & 0x10) != 0) {
            return (tempFlags & 0xFFFFFF80) >> 7;
        }
        if (BigDecimal.DFPHWAvailable() && (tempFlags & 3) == 0) {
            tempFlags |= 0x10;
            tempFlags &= 0x7F;
            int sig = BigDecimal.DFPSignificance(this.laside);
            if (sig < 0) {
                long digits = BigDecimal.DFPBCDDigits(this.laside);
                if (digits == 10L) {
                    digits = BigDecimal.extractDFPDigitsBCD(this.laside);
                }
                int nlz = Long.numberOfLeadingZeros(digits);
                nlz >>= 2;
                if ((nlz = 16 - nlz) == 0) {
                    ++nlz;
                }
                this.flags = tempFlags |= nlz << 7;
                return nlz;
            }
            if (sig == 0) {
                ++sig;
            }
            this.flags = tempFlags |= sig << 7;
            return sig;
        }
        if ((this.flags & 3) == 2) {
            int prec = BigDecimal.precisionBI(this.bi);
            if (prec <= 0x1FFFFFF) {
                tempFlags |= 0x10;
                tempFlags &= 0x7F;
                tempFlags |= prec << 7;
            }
            this.flags = tempFlags;
            return prec;
        }
        int prec = BigDecimal.numDigits(this.laside);
        tempFlags |= 0x10;
        tempFlags &= 0x7F;
        this.flags = tempFlags |= prec << 7;
        return prec;
    }

    private static final int precisionBI(BigInteger bi) {
        int prec = 0;
        while (bi.mag.length > 1) {
            bi = bi.divide(BigDecimal.powerOfTenBI(9L));
            prec += 9;
        }
        if (bi.mag.length == 1) {
            prec += BigDecimal.numDigitsBI(bi.mag[0]);
        } else if (bi.mag.length == 0) {
            ++prec;
        }
        return prec;
    }

    public int scale() {
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            if ((this.flags & 8) != 0) {
                return this.scale;
            }
            this.flags |= 8;
            int newExp = BigDecimal.DFPExponent(this.laside);
            this.scale = newExp == 1000 ? -BigDecimal.extractDFPExponent(this.laside) - 398 : -(newExp - 398);
        }
        return this.scale;
    }

    public int signum() {
        int tempFlags = this.flags;
        if (BigDecimal.DFPHWAvailable() && (tempFlags & 3) == 0) {
            if ((tempFlags & 4) != 0) {
                return (tempFlags & 0x60) << 25 >> 30;
            }
            tempFlags |= 4;
            if ((this.laside & Long.MIN_VALUE) == Long.MIN_VALUE) {
                this.flags = tempFlags |= 0x60;
                return -1;
            }
            long mask = BigDecimal.DFPBCDDigits(this.laside);
            if (mask == 10L) {
                if (this.isDFPZero()) {
                    this.flags = tempFlags &= 0xFFFFFF9F;
                    return 0;
                }
                tempFlags &= 0xFFFFFF9F;
                this.flags = tempFlags |= 0x20;
                return 1;
            }
            if (mask != 0L) {
                tempFlags &= 0xFFFFFF9F;
                this.flags = tempFlags |= 0x20;
                return 1;
            }
            this.flags = tempFlags &= 0xFFFFFF9F;
            return 0;
        }
        if ((tempFlags & 3) == 1) {
            long laside = this.laside;
            return (int)(laside >> 63) | (int)(-laside >>> 63);
        }
        return this.bi.signum();
    }

    public BigDecimal ulp() {
        BigDecimal res = new BigDecimal();
        res.laside = 1L;
        res.flags |= 1;
        res.flags |= 0x10;
        res.flags |= 0x80;
        res.scale = this.scale();
        return res;
    }

    public BigInteger unscaledValue() {
        if (this.bi != null) {
            return this.bi;
        }
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            long lVal = BigDecimal.DFPUnscaledValue(this.laside);
            if (lVal != Long.MAX_VALUE) {
                this.bi = BigInteger.valueOf(lVal);
                return this.bi;
            }
            lVal = BigDecimal.DFPBCDDigits(this.laside);
            if (lVal == 10L) {
                lVal = BigDecimal.extractDFPDigitsBCD(this.laside);
            }
            if (lVal == 0L) {
                this.bi = BigInteger.ZERO;
                return this.bi;
            }
            long val = 0L;
            int i = 0;
            while (lVal != 0L) {
                val += (lVal & 0xFL) * BigDecimal.powerOfTenLL(i++);
                lVal >>>= 4;
            }
            this.bi = BigInteger.valueOf((long)this.signum() * val);
            return this.bi;
        }
        if ((this.flags & 3) == 1) {
            this.bi = BigInteger.valueOf(this.laside);
            return this.bi;
        }
        return this.bi;
    }

    public BigDecimal pow(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative power: " + n);
        }
        return this.pow(n, MathContext.UNLIMITED);
    }

    public BigDecimal pow(int n, MathContext set) {
        int minPow = -999999999;
        int maxPow = 999999999;
        int workDigits = 0;
        BigDecimal lhs = this;
        BigDecimal res = null;
        int tempN = n;
        boolean seenbit = false;
        int i = 0;
        if (n > maxPow || n < minPow) {
            throw new ArithmeticException("Too large a power: " + n);
        }
        if (set.getPrecision() == 0 && n < 0) {
            throw new ArithmeticException("Negative power " + n);
        }
        if (set.getPrecision() > 0 && BigDecimal.numDigits(n) > set.getPrecision()) {
            throw new ArithmeticException("Too many digits: " + n);
        }
        if (n == 0) {
            return ONE;
        }
        if ((lhs.flags & 2) == 2 || (lhs.flags & 1) == 1) {
            if (lhs.signum() == 0) {
                if (n >= 0) {
                    BigDecimal ret = BigDecimal.clone(this);
                    long newScale = (long)ret.scale * (long)n;
                    ret.scale = newScale < Integer.MIN_VALUE ? Integer.MIN_VALUE : (newScale > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)newScale);
                    return ret;
                }
                throw new ArithmeticException("Dividing by 0");
            }
        } else if (lhs.signum() == 0) {
            if (n >= 0) {
                BigDecimal ret = BigDecimal.clone(this);
                ret.DFPToLL();
                long newScale = (long)ret.scale * (long)n;
                ret.scale = newScale < Integer.MIN_VALUE ? Integer.MIN_VALUE : (newScale > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)newScale);
                return ret;
            }
            new ArithmeticException("Dividing by 0");
        }
        if (set.getPrecision() > 0) {
            workDigits = set.getPrecision() + BigDecimal.numDigits(n) + 1;
        }
        MathContext workingSet = new MathContext(workDigits, set.getRoundingMode());
        res = new BigDecimal();
        res.bi = BigInteger.ONE;
        res.flags |= 0x10;
        res.flags |= 0x80;
        res.flags |= 2;
        BigDecimal lhsClone = BigDecimal.clone(lhs);
        if (BigDecimal.DFPHWAvailable() && (lhs.flags & 3) == 0) {
            lhsClone.DFPToBI();
        }
        if (tempN < 0) {
            tempN = -tempN;
        }
        seenbit = false;
        i = 1;
        while (true) {
            if ((tempN += tempN) < 0) {
                seenbit = true;
                res.longMultiply(lhsClone, null, workingSet, true);
                if (BigDecimal.DFPHWAvailable() && (lhsClone.flags & 3) == 0) {
                    lhsClone.DFPToBI();
                }
                if (BigDecimal.DFPHWAvailable() && (res.flags & 3) == 0) {
                    res.DFPToBI();
                }
            }
            if (i == 31) break;
            if (seenbit) {
                res.longMultiply(res, null, workingSet, true);
                if (BigDecimal.DFPHWAvailable() && (res.flags & 3) == 0) {
                    res.DFPToBI();
                }
            }
            i = (short)(i + 1);
        }
        if (n < 0) {
            res = ONE.divide(res, workingSet);
        }
        if (set != MathContext.UNLIMITED) {
            res.finish(set.getPrecision(), set.getRoundingMode().ordinal());
        }
        return res;
    }

    public BigDecimal movePointLeft(int n) {
        long interm_scale = 0L;
        BigDecimal res = BigDecimal.clone(this);
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            res.DFPToBI();
        }
        if ((interm_scale = (long)res.scale() + (long)n) < Integer.MIN_VALUE || interm_scale > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                interm_scale = interm_scale > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + interm_scale);
            }
        }
        res.scale = (int)interm_scale;
        if (interm_scale < 0L) {
            return res.setScale(0, true);
        }
        return res;
    }

    public BigDecimal movePointRight(int n) {
        int signum = 0;
        BigDecimal res = BigDecimal.clone(this);
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            res.DFPToBI();
        }
        long interm_scale = (long)res.scale() - (long)n;
        signum = (this.flags & 3) == 1 ? (int)(res.laside >> 63) | (int)(-res.laside >>> 63) : res.bi.signum();
        if (interm_scale < Integer.MIN_VALUE || interm_scale > Integer.MAX_VALUE) {
            if (signum == 0) {
                interm_scale = interm_scale > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + interm_scale);
            }
        }
        res.scale = (int)interm_scale;
        if (interm_scale < 0L) {
            return res.setScale(0, true);
        }
        return res;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        long interm_scale;
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToBI();
        }
        if ((interm_scale = (long)thisClone.scale - (long)n) < Integer.MIN_VALUE || interm_scale > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                interm_scale = interm_scale > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + interm_scale);
            }
        }
        BigDecimal res = BigDecimal.clone(thisClone);
        res.scale = (int)interm_scale;
        return res;
    }

    public BigDecimal setScale(int scale) {
        return this.setScale(scale, false);
    }

    private BigDecimal setScale(int scale, boolean onThis) {
        BigDecimal res = this;
        boolean cloned = false;
        int ourscale = this.scale();
        if (ourscale == scale) {
            return res;
        }
        if (!onThis) {
            res = new BigDecimal();
            cloned = true;
        }
        int ret = 0;
        boolean tryBI = false;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            if (-scale >= -398 && -scale <= 369) {
                ret = res.DFPSetScale(this.laside, -scale + 398, false, 0, true);
                if (ret == 1) {
                    if (BigDecimal.DFPPerformHysteresis()) {
                        int sum;
                        if ((hys_counter += 5 & ~((((sum = hys_counter + 5) ^ 5) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                            hys_type = false;
                            hys_counter = 0;
                        } else if (hys_counter > hys_threshold) {
                            hys_type = true;
                            hys_counter = 0;
                        }
                    }
                    if (res.isDFPZero()) {
                        res.laside &= Long.MAX_VALUE;
                        res.flags |= 4;
                        res.flags &= 0xFFFFFF9F;
                    } else {
                        res.flags |= 4;
                        res.flags |= this.signum() << 5 & 0x60;
                    }
                    res.flags |= 8;
                    res.scale = scale;
                    res.flags &= 0xFFFFFFEF;
                    return res;
                }
                if (ret == 0) {
                    throw new ArithmeticException("Requires rounding: " + scale);
                }
                tryBI = true;
            }
            tryBI = true;
        }
        if (tryBI || (this.flags & 3) == 2) {
            if (!cloned) {
                res = new BigDecimal();
            }
            BigDecimal.clone(res, this);
            if ((res.flags & 3) == 0) {
                res.DFPToBI();
            }
            if (res.bi.signum() == 0) {
                res.scale = scale;
                res.flags &= 0xFFFFFFEF;
                return res;
            }
            int tempFlags = res.flags;
            if (ourscale < scale) {
                long padding = (long)scale - (long)ourscale;
                if (padding > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Scale overflow");
                }
                res.bi = res.bi.multiply(BigDecimal.powerOfTenBI(padding));
                res.scale = scale;
                res.flags = tempFlags &= 0xFFFFFFEF;
                return res;
            }
            long chopoff = (long)ourscale - (long)scale;
            if (chopoff > (long)res.precision()) {
                throw new ArithmeticException("Requires rounding: " + scale);
            }
            chopoff = Math.min((long)this.precision(), chopoff);
            BigInteger[] divRem = null;
            if (chopoff > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            divRem = res.bi.divideAndRemainder(BigDecimal.powerOfTenBI(chopoff));
            if (divRem[1].signum() != 0) {
                throw new ArithmeticException("Requires rounding: " + scale);
            }
            res.bi = divRem[0];
            res.scale = scale;
            res.flags = tempFlags &= 0xFFFFFFEF;
            return res;
        }
        if (!cloned) {
            res = new BigDecimal();
        }
        BigDecimal.clone(res, this);
        int tempFlags = res.flags;
        int signum = (int)(res.laside >> 63) | (int)(-res.laside >>> 63);
        if (signum == 0) {
            res.flags &= 0xFFFFFFEF;
            res.scale = scale;
            return res;
        }
        if (ourscale < scale) {
            int n;
            int m;
            long padding = 0L;
            padding = (long)scale - (long)ourscale;
            if (padding > 18L) {
                res.LLToBI();
                if (padding > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Scale overflow");
                }
                res.bi = res.bi.multiply(BigDecimal.powerOfTenBI(padding));
                res.scale = scale;
                tempFlags = res.flags;
                res.flags = tempFlags &= 0xFFFFFFEF;
                return res;
            }
            long multiple = powersOfTenLL[(int)padding];
            long resLaside = res.laside;
            if (resLaside < 0L) {
                resLaside *= -1L;
            }
            if ((m = Long.numberOfLeadingZeros(resLaside) - 1) + (n = Long.numberOfLeadingZeros(multiple) - 1) >= 63) {
                res.laside *= multiple;
                res.scale = scale;
                res.flags = tempFlags &= 0xFFFFFFEF;
                res.bi = null;
                return res;
            }
            res.LLToBI();
            if (padding > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            res.bi = res.bi.multiply(BigDecimal.powerOfTenBI(padding));
            res.scale = scale;
            tempFlags = res.flags;
            res.flags = tempFlags &= 0xFFFFFFEF;
            return res;
        }
        long chopoff = (long)ourscale - (long)scale;
        int precision = 0;
        if ((tempFlags & 0x10) != 0) {
            precision = (tempFlags & 0xFFFFFF80) >> 7;
        } else {
            precision = BigDecimal.numDigits(res.laside);
            tempFlags |= 0x10;
            tempFlags &= 0x7F;
            res.flags = tempFlags |= precision << 7;
        }
        if (chopoff > (long)precision) {
            throw new ArithmeticException("Requires rounding: " + scale);
        }
        if (chopoff > 18L) {
            if (res.laside != 0L) {
                throw new ArithmeticException("Requires rounding: " + scale);
            }
            res.laside = 0L;
            res.scale = scale;
            res.flags = tempFlags &= 0xFFFFFFEF;
            return res;
        }
        long rem = res.laside % powersOfTenLL[(int)chopoff];
        if (rem != 0L) {
            throw new ArithmeticException("Requires rounding: " + scale);
        }
        res.laside /= powersOfTenLL[(int)chopoff];
        res.scale = scale;
        res.flags = tempFlags &= 0xFFFFFFEF;
        res.bi = null;
        return res;
    }

    public BigDecimal setScale(int scale, RoundingMode round) {
        return this.setScale(scale, round.ordinal());
    }

    public BigDecimal setScale(int scale, int rm) {
        if (rm < 0 || rm > 7) {
            throw new IllegalArgumentException("Illegal rounding mode");
        }
        long ourscale = this.scale;
        if (ourscale == (long)scale) {
            return this;
        }
        BigDecimal res = new BigDecimal();
        if (!BigDecimal.DFPHWAvailable() || (this.flags & 3) != 0) {
            BigDecimal.clone(res, this);
            if ((this.flags & 3) != 2) {
                res.bi = null;
            }
            if (res.signum() == 0) {
                res.scale = scale;
                res.flags &= 0xFFFFFFEF;
                return res;
            }
            boolean isBI = false;
            if ((this.flags & 3) == 2) {
                isBI = true;
            }
            if (ourscale > (long)scale) {
                res = res.divide(ONE, scale, rm);
                res.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(res);
                return res;
            }
            if (!isBI) {
                long padding = (long)scale - ourscale;
                if (padding > 18L) {
                    res.LLToBI();
                    if (padding > Integer.MAX_VALUE) {
                        throw new ArithmeticException("Scale overflow");
                    }
                    res.bi = res.bi.multiply(BigDecimal.powerOfTenBI(padding));
                    res.scale = scale;
                } else {
                    int n;
                    int m;
                    long multiple = powersOfTenLL[(int)padding];
                    long resLaside = res.laside;
                    if (resLaside < 0L) {
                        resLaside *= -1L;
                    }
                    if ((m = Long.numberOfLeadingZeros(resLaside) - 1) + (n = Long.numberOfLeadingZeros(multiple) - 1) >= 63) {
                        res.laside *= multiple;
                        res.scale = scale;
                        res.bi = null;
                    } else {
                        res.LLToBI();
                        if (padding > Integer.MAX_VALUE) {
                            throw new ArithmeticException("Scale overflow");
                        }
                        res.bi = res.bi.multiply(BigDecimal.powerOfTenBI(padding));
                        res.scale = scale;
                    }
                }
                res.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(res);
                return res;
            }
        }
        return this.setScale2(scale, rm, ourscale, res);
    }

    private BigDecimal setScale2(int scale, int rm, long ourscale, BigDecimal allocatedRes) {
        BigDecimal res = allocatedRes;
        boolean passed = false;
        int ret = 0;
        boolean tryBI = false;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            if (-scale >= -398 && -scale <= 369) {
                int sum;
                if (rm == 7) {
                    ret = res.DFPSetScale(this.laside, -scale + 398, false, 0, true);
                    if (ret == 1) {
                        if (BigDecimal.DFPPerformHysteresis()) {
                            if ((hys_counter += 5 & ~((((sum = hys_counter + 5) ^ 5) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                                hys_type = false;
                                hys_counter = 0;
                            } else if (hys_counter > hys_threshold) {
                                hys_type = true;
                                hys_counter = 0;
                            }
                        }
                        if (res.isDFPZero()) {
                            res.laside &= Long.MAX_VALUE;
                            res.flags |= 4;
                            res.flags &= 0xFFFFFF9F;
                        } else {
                            res.flags |= 4;
                            res.flags |= this.signum() << 5 & 0x60;
                        }
                        res.flags |= 8;
                        res.scale = scale;
                        passed = true;
                    }
                } else {
                    if (rm == 6) {
                        rm = 0;
                    } else if (rm == 0) {
                        rm = 6;
                    }
                    ret = res.DFPSetScale(this.laside, -scale + 398, true, rm, false);
                    if (ret == 1) {
                        if (BigDecimal.DFPPerformHysteresis()) {
                            if ((hys_counter += 5 & ~((((sum = hys_counter + 5) ^ 5) & (sum ^ hys_counter)) >>> 31)) < -hys_threshold) {
                                hys_type = false;
                                hys_counter = 0;
                            } else if (hys_counter > hys_threshold) {
                                hys_type = true;
                                hys_counter = 0;
                            }
                        }
                        if (res.isDFPZero()) {
                            res.laside &= Long.MAX_VALUE;
                            res.flags |= 4;
                            res.flags &= 0xFFFFFF9F;
                        } else {
                            res.flags |= 4;
                            res.flags |= this.signum() << 5 & 0x60;
                        }
                        res.flags |= 8;
                        res.scale = scale;
                        passed = true;
                    }
                }
            }
            if (!passed) {
                tryBI = true;
            }
        }
        if (tryBI || (this.flags & 3) == 2) {
            BigDecimal.clone(res, this);
            if (tryBI) {
                res.DFPToBI();
            }
            res.flags &= 0xFFFFFFEF;
            if (res.bi.signum() == 0) {
                res.scale = scale;
                res.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(res);
                return res;
            }
            if (!tryBI) {
                long padding = (long)scale - ourscale;
                if (padding > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Scale overflow");
                }
                res.bi = res.bi.multiply(BigDecimal.powerOfTenBI(padding));
                res.scale = scale;
                res.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(res);
                return res;
            }
            if (ourscale > (long)scale) {
                res = res.divide(ONE, scale, rm);
                res.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(res);
                return res;
            }
            long padding = (long)scale - ourscale;
            if (padding > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale overflow");
            }
            res.bi = res.bi.multiply(BigDecimal.powerOfTenBI(padding));
            res.scale = scale;
            res.flags &= 0xFFFFFFEF;
            BigDecimal.postSetScaleProcessing(res);
            return res;
        }
        if ((this.flags & 3) == 1) {
            BigDecimal.clone(res, this);
            int signum = (int)(res.laside >> 63) | (int)(-res.laside >>> 63);
            if (signum == 0) {
                res.scale = scale;
                res.flags &= 0xFFFFFFEF;
            }
            BigDecimal.postSetScaleProcessing(res);
            return res;
        }
        return res;
    }

    private static final void postSetScaleProcessing(BigDecimal res) {
        if ((!BigDecimal.DFPHWAvailable() || BigDecimal.DFPHWAvailable() && !BigDecimal.DFPUseDFP()) && (res.flags & 3) == 2 && res.bi.bitLength() < 63) {
            res.BIToLL();
        }
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            if ((res.flags & 3) == 2 && res.bi.compareTo(MAXDFP64) <= 0 && res.bi.compareTo(MINDFP64) >= 0 && res.scale > -369 && res.scale < 398) {
                long lint = res.bi.longValue();
                if (res.DFPLongExpConstructor(lint, -res.scale + 398, 0, 0, 0, false)) {
                    res.flags &= 0xFFFFFFFC;
                    res.flags |= 8;
                    res.flags |= 4;
                    res.flags &= 0xFFFFFF9F;
                    res.flags = res.bi.signum() < 0 ? (res.flags |= 0x60) : (res.bi.signum() > 0 ? (res.flags |= 0x20) : (res.flags &= 0xFFFFFF9F));
                    res.bi = null;
                }
            } else if ((res.flags & 3) == 1 && res.laside <= 9999999999999999L && res.laside >= -9999999999999999L && res.scale > -369 && res.scale < 398) {
                int signum = res.signum();
                if (res.DFPLongExpConstructor(res.laside, -res.scale + 398, 0, 0, 0, false)) {
                    res.flags &= 0xFFFFFFFC;
                    res.flags |= 8;
                    res.flags |= 4;
                    res.flags &= 0xFFFFFF9F;
                    res.flags = signum < 0 ? (res.flags |= 0x60) : (signum > 0 ? (res.flags |= 0x20) : (res.flags &= 0xFFFFFF9F));
                }
            }
        }
    }

    public BigDecimal stripTrailingZeros() {
        BigDecimal res;
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
            res = thisClone;
        } else {
            res = BigDecimal.clone(thisClone);
        }
        if (res.signum() == 0) {
            return res;
        }
        res.flags &= 0xFFFFFFEF;
        if ((thisClone.flags & 3) == 1) {
            int scaleDecr = 0;
            long temp = res.laside;
            if (temp < 0L) {
                temp *= -1L;
            }
            if (temp < Integer.MAX_VALUE) {
                int intTmp = (int)temp;
                byte rem = 0;
                while ((rem = (byte)(intTmp - ((BigDecimal.uDivideByTen(intTmp) << 1) + (BigDecimal.uDivideByTen(intTmp) << 3)))) == 0) {
                    intTmp = BigDecimal.uDivideByTen(intTmp);
                    ++scaleDecr;
                }
                res.laside = res.laside < 0L ? (long)(-intTmp) : (long)intTmp;
            } else {
                byte rem = 0;
                while ((rem = (byte)(temp - ((temp / 10L << 1) + (temp / 10L << 3)))) == 0) {
                    temp /= 10L;
                    ++scaleDecr;
                }
                res.laside = res.laside < 0L ? -temp : temp;
            }
            res.scale -= scaleDecr;
            return res;
        }
        int scaleDecr = 0;
        BigInteger temp = res.bi;
        BigInteger rem = BigInteger.ZERO;
        BigInteger tmpVal = BigInteger.ONE;
        while ((rem = (tmpVal = temp).remainder(BigInteger.TEN)).signum() == 0) {
            ++scaleDecr;
            temp = temp.divide(BigInteger.TEN);
        }
        res.bi = temp;
        res.scale -= scaleDecr;
        return res;
    }

    public String toString() {
        int precision;
        long actualExp;
        if ((this.flags & 1) == 1 && BigDecimal.longTest1(actualExp = (long)(-this.scale), precision = this.precision())) {
            long sign = this.laside >> 63 | -this.laside >>> 63;
            int length = 1 + precision;
            if (BigDecimal.longTest2(actualExp, precision)) {
                return this.longString1(length, (int)sign);
            }
            if (sign == 0L && actualExp == -2L) {
                return zeroDec;
            }
            int numZeros = -((int)actualExp) - precision;
            return this.longString2(length += 1 + numZeros, precision, (int)sign);
        }
        return this.toString2();
    }

    private static boolean longTest1(long actualExp, int precision) {
        return actualExp < 0L && actualExp >= (long)(-5 - precision);
    }

    private static boolean longTest2(long actualExp, int precision) {
        return actualExp > (long)(-precision) && actualExp >= -19L;
    }

    private String longString1(int length, int sign) {
        long laside = this.laside;
        long actualExp = -this.scale;
        if (sign == -1) {
            ++length;
        }
        char[] charArray = new char[length];
        byte rem = 0;
        int start = 0;
        laside = Math.abs(laside);
        if (sign == -1) {
            charArray[start++] = 45;
        }
        int charLoc = length - 1;
        if (laside <= Integer.MAX_VALUE) {
            if (actualExp == -2L) {
                int intVal;
                int intTmpVal = intVal = (int)laside;
                rem = (byte)(intTmpVal - (((intVal /= 100) << 6) + (intVal << 5) + (intVal << 2)));
                char onesDig = doubleDigitsOnes[rem];
                char tensDig = doubleDigitsTens[rem];
                charArray[charLoc--] = onesDig;
                charArray[charLoc--] = tensDig;
                charArray[charLoc--] = 46;
                while (intVal != 0) {
                    intTmpVal = intVal;
                    rem = (byte)(intTmpVal - (((intVal /= 100) << 6) + (intVal << 5) + (intVal << 2)));
                    onesDig = doubleDigitsOnes[rem];
                    tensDig = doubleDigitsTens[rem];
                    charArray[charLoc--] = onesDig;
                    if (charLoc >= start) {
                        charArray[charLoc--] = tensDig;
                        continue;
                    }
                    break;
                }
            } else {
                int decimalPointLoc = (int)((long)length - -actualExp - 1L);
                int intVal = (int)laside;
                while (intVal != 0) {
                    int intTmpVal = intVal;
                    rem = (byte)(intTmpVal - (((intVal /= 100) << 6) + (intVal << 5) + (intVal << 2)));
                    char onesDig = doubleDigitsOnes[rem];
                    char tensDig = doubleDigitsTens[rem];
                    if (charLoc == decimalPointLoc) {
                        charArray[charLoc--] = 46;
                    }
                    charArray[charLoc--] = onesDig;
                    if (charLoc == decimalPointLoc) {
                        charArray[charLoc--] = 46;
                    }
                    if (charLoc >= start) {
                        charArray[charLoc--] = tensDig;
                        continue;
                    }
                    break;
                }
            }
        } else {
            char tensDig;
            char onesDig;
            int decimalPointLoc = (int)((long)length - -actualExp - 1L);
            while (laside > Integer.MAX_VALUE) {
                long tmpVal = laside;
                rem = (byte)(tmpVal - (((laside /= 100L) << 6) + (laside << 5) + (laside << 2)));
                onesDig = doubleDigitsOnes[rem];
                tensDig = doubleDigitsTens[rem];
                if (charLoc == decimalPointLoc) {
                    charArray[charLoc--] = 46;
                }
                charArray[charLoc--] = onesDig;
                if (charLoc == decimalPointLoc) {
                    charArray[charLoc--] = 46;
                }
                charArray[charLoc--] = tensDig;
            }
            int intVal = (int)laside;
            while (intVal != 0) {
                int intTmpVal = intVal;
                rem = (byte)(intTmpVal - (((intVal /= 100) << 6) + (intVal << 5) + (intVal << 2)));
                onesDig = doubleDigitsOnes[rem];
                tensDig = doubleDigitsTens[rem];
                if (charLoc == decimalPointLoc) {
                    charArray[charLoc--] = 46;
                }
                charArray[charLoc--] = onesDig;
                if (charLoc == decimalPointLoc) {
                    charArray[charLoc--] = 46;
                }
                if (charLoc >= start) {
                    charArray[charLoc--] = tensDig;
                    continue;
                }
                break;
            }
        }
        return new String(charArray, 0, length);
    }

    private String longString2(int length, int numLasideDigits, int sign) {
        char[] charArray;
        block9: {
            long laside = this.laside;
            long actualExp = -this.scale;
            int start = 0;
            long tmpVal = 0L;
            byte rem = 0;
            if (sign == -1) {
                ++length;
            }
            charArray = new char[length];
            Arrays.fill(charArray, 0, length, '0');
            if (sign == -1) {
                charArray[start++] = 45;
            }
            int n = ++start;
            ++start;
            charArray[n] = 46;
            start = (int)((long)start + (-actualExp - (long)numLasideDigits));
            if (sign == 0) break block9;
            laside = Math.abs(laside);
            int charLoc = length - 1;
            if (laside <= Integer.MAX_VALUE) {
                int intVal = (int)laside;
                while (intVal != 0) {
                    int intTmpVal = intVal;
                    rem = (byte)(intTmpVal - (((intVal /= 100) << 6) + (intVal << 5) + (intVal << 2)));
                    char onesDig = doubleDigitsOnes[rem];
                    char tensDig = doubleDigitsTens[rem];
                    charArray[charLoc--] = onesDig;
                    if (charLoc >= start) {
                        charArray[charLoc--] = tensDig;
                        continue;
                    }
                    break;
                }
            } else {
                char tensDig;
                char onesDig;
                while (laside > Integer.MAX_VALUE) {
                    tmpVal = laside;
                    rem = (byte)(tmpVal - (((laside /= 100L) << 6) + (laside << 5) + (laside << 2)));
                    onesDig = doubleDigitsOnes[rem];
                    tensDig = doubleDigitsTens[rem];
                    charArray[charLoc--] = onesDig;
                    charArray[charLoc--] = tensDig;
                }
                int intVal = (int)laside;
                while (intVal != 0) {
                    int intTmpVal = intVal;
                    rem = (byte)(intTmpVal - (((intVal /= 100) << 6) + (intVal << 5) + (intVal << 2)));
                    onesDig = doubleDigitsOnes[rem];
                    tensDig = doubleDigitsTens[rem];
                    charArray[charLoc--] = onesDig;
                    if (charLoc >= start) {
                        charArray[charLoc--] = tensDig;
                        continue;
                    }
                    break;
                }
            }
        }
        return new String(charArray, 0, length);
    }

    private String toString2() {
        long actualExp = 0L;
        int tempFlags = this.flags;
        int precision = 0;
        if ((tempFlags & 1) == 1) {
            actualExp = -this.scale;
            long laside = this.laside;
            if ((tempFlags & 0x10) != 0) {
                precision = (tempFlags & 0xFFFFFF80) >> 7;
            } else {
                precision = BigDecimal.numDigits(laside);
                tempFlags |= 0x10;
                tempFlags &= 0x7F;
                this.flags = tempFlags |= precision << 7;
            }
            if (actualExp < 0L && actualExp >= (long)(-5 - precision)) {
                if (actualExp > (long)(-precision) && actualExp >= -19L) {
                    char tensDig;
                    char onesDig;
                    int sign = (int)(laside >> 63) | (int)(-laside >>> 63);
                    int length = 1 + precision;
                    int start = 0;
                    laside = Math.abs(laside);
                    if (sign == -1) {
                        ++length;
                    }
                    if (actualExp == Integer.MIN_VALUE) {
                        actualExp = -actualExp;
                    }
                    char[] str = length <= 22 ? (char[])thLocalToString.get() : new char[length];
                    if (sign == -1) {
                        str[start++] = 45;
                    }
                    int decimalPointLoc = (int)((long)length - -actualExp - 1L);
                    byte rem = 0;
                    int charLoc = length - 1;
                    while (laside > Integer.MAX_VALUE) {
                        long tmpVal = laside;
                        rem = (byte)(tmpVal - (((laside /= 100L) << 6) + (laside << 5) + (laside << 2)));
                        onesDig = doubleDigitsOnes[rem];
                        tensDig = doubleDigitsTens[rem];
                        if (charLoc == decimalPointLoc) {
                            str[charLoc--] = 46;
                        }
                        str[charLoc--] = onesDig;
                        if (charLoc == decimalPointLoc) {
                            str[charLoc--] = 46;
                        }
                        str[charLoc--] = tensDig;
                    }
                    int intVal = (int)laside;
                    while (intVal != 0) {
                        int intTmpVal = intVal;
                        rem = (byte)(intTmpVal - (((intVal /= 100) << 6) + (intVal << 5) + (intVal << 2)));
                        onesDig = doubleDigitsOnes[rem];
                        tensDig = doubleDigitsTens[rem];
                        if (charLoc == decimalPointLoc) {
                            str[charLoc--] = 46;
                        }
                        str[charLoc--] = onesDig;
                        if (charLoc == decimalPointLoc) {
                            str[charLoc--] = 46;
                        }
                        if (charLoc < start) break;
                        str[charLoc--] = tensDig;
                    }
                    return new String(str, 0, length);
                }
                if (actualExp != 0L) {
                    // empty if block
                }
            }
        }
        actualExp = -((long)this.scale());
        if ((tempFlags & 1) == 1) {
            if ((tempFlags & 0x10) != 0) {
                precision = (tempFlags & 0xFFFFFF80) >> 7;
            } else {
                precision = BigDecimal.numDigits(this.laside);
                tempFlags |= 0x10;
                tempFlags &= 0x7F;
                this.flags = tempFlags |= precision << 7;
            }
        } else {
            precision = this.precision();
        }
        if (-actualExp >= 0L && actualExp >= (long)(-5 - precision)) {
            if (-actualExp == 0L) {
                if (BigDecimal.DFPHWAvailable() && (tempFlags & 3) == 0) {
                    long lVal = BigDecimal.DFPUnscaledValue(this.laside);
                    if (lVal == Long.MAX_VALUE) {
                        lVal = BigDecimal.DFPBCDDigits(this.laside);
                        if (lVal == 10L) {
                            lVal = BigDecimal.extractDFPDigitsBCD(this.laside);
                        }
                        long val = 0L;
                        int i = 0;
                        while (lVal != 0L) {
                            val += (lVal & 0xFL) * BigDecimal.powerOfTenLL(i++);
                            lVal >>>= 4;
                        }
                        return Long.toString(val * (long)this.signum());
                    }
                    return Long.toString(lVal);
                }
                if ((tempFlags & 1) == 1) {
                    return Long.toString(this.laside);
                }
                return this.bi.toString();
            }
            int sign = 0;
            if (BigDecimal.DFPHWAvailable() && (tempFlags & 3) == 0) {
                sign = this.signum();
                if (-actualExp < (long)precision) {
                    int length = 1 + precision;
                    if (sign == -1) {
                        ++length;
                    }
                    return new String(this.prePaddedStringDFP(sign, precision), 0, length);
                }
                int length = 2 - (int)actualExp;
                if (sign == -1) {
                    ++length;
                }
                return new String(this.prePaddedStringDFP(sign, precision), 0, length);
            }
            if ((tempFlags & 1) == 1) {
                sign = (int)(this.laside >> 63) | (int)(-this.laside >>> 63);
                int length = 2 - (int)actualExp;
                if (sign == -1) {
                    ++length;
                }
                return new String(this.prePaddedString(sign, precision), 0, length);
            }
            sign = this.bi.signum();
            if (-actualExp < (long)precision) {
                int length = 1 + precision;
                if (sign == -1) {
                    ++length;
                }
                return new String(this.prePaddedString(sign, precision), 0, length);
            }
            int length = 2 - (int)actualExp;
            if (sign == -1) {
                ++length;
            }
            return new String(this.prePaddedString(sign, precision), 0, length);
        }
        long adjExp = actualExp + (long)precision - 1L;
        int length = 0;
        if (this.signum() == -1) {
            ++length;
        }
        ++length;
        if (precision > 1) {
            ++length;
            length += precision - 1;
        }
        ++length;
        if (actualExp != 0L) {
            ++length;
        }
        int expPrecision = BigDecimal.numDigits(adjExp);
        length += expPrecision;
        if ((tempFlags & 3) == 0) {
            return new String(this.toStringExpDFP(length), 0, length);
        }
        if ((tempFlags & 1) == 1) {
            return new String(this.toStringExpLL(length), 0, length);
        }
        return new String(this.toStringExpBI(length), 0, length);
    }

    private final char[] toStringExpDFP(int length) {
        int i;
        long actualExp = -((long)this.scale());
        int precision = this.precision();
        long bcd = BigDecimal.DFPBCDDigits(this.laside);
        if (bcd == 10L) {
            bcd = BigDecimal.extractDFPDigitsBCD(this.laside);
        }
        long adjExp = actualExp + (long)precision - 1L;
        int expPrecision = BigDecimal.numDigits(adjExp);
        int index = 0;
        char[] str = length <= 22 ? (char[])thLocalToString.get() : new char[length];
        if (this.signum() == -1) {
            str[index++] = 45;
        }
        str[index++] = (char)(BigDecimal.digitAtBCD(bcd, precision, 0) | 0x30);
        if (precision > 1) {
            str[index++] = 46;
            for (i = 0; i < precision - 1; ++i) {
                str[index++] = (char)(BigDecimal.digitAtBCD(bcd, precision, i + 1) | 0x30);
            }
        }
        str[index++] = 69;
        if (actualExp > 0L) {
            str[index++] = 43;
        } else if (actualExp < 0L) {
            str[index++] = 45;
        }
        for (i = 0; i < expPrecision; ++i) {
            str[index++] = (char)(BigDecimal.digitAt(adjExp, expPrecision, i) | 0x30);
        }
        return str;
    }

    private final char[] toStringExpLL(int length) {
        int i;
        long actualExp = -((long)this.scale());
        int precision = this.precision();
        long adjExp = actualExp + (long)precision - 1L;
        int expPrecision = BigDecimal.numDigits(adjExp);
        int index = 0;
        char[] str = length <= 22 ? (char[])thLocalToString.get() : new char[length];
        if (this.signum() == -1) {
            str[index++] = 45;
        }
        str[index++] = (char)(BigDecimal.digitAt(this.laside, precision, 0) | 0x30);
        if (precision > 1) {
            str[index++] = 46;
            for (i = 0; i < precision - 1; ++i) {
                str[index++] = (char)(BigDecimal.digitAt(this.laside, precision, i + 1) | 0x30);
            }
        }
        str[index++] = 69;
        if (actualExp > 0L) {
            str[index++] = 43;
        } else if (actualExp < 0L) {
            str[index++] = 45;
        }
        for (i = 0; i < expPrecision; ++i) {
            str[index++] = (char)(BigDecimal.digitAt(adjExp, expPrecision, i) | 0x30);
        }
        return str;
    }

    private final char[] toStringExpBI(int length) {
        int i;
        long actualExp = -((long)this.scale());
        int precision = this.precision();
        long adjExp = actualExp + (long)precision - 1L;
        int expPrecision = BigDecimal.numDigits(adjExp);
        int index = 0;
        char[] str = length <= 22 ? (char[])thLocalToString.get() : new char[length];
        String strBI = this.bi.toString();
        int start = 0;
        if (this.bi.signum() == -1) {
            str[index++] = 45;
        }
        if (this.bi.signum() >= 0) {
            str[index++] = strBI.charAt(0);
            start = 0;
        } else {
            str[index++] = strBI.charAt(1);
            start = 1;
        }
        if (precision > 1) {
            str[index++] = 46;
            if (this.bi.signum() < 0) {
                ++precision;
            }
            for (i = start; i < precision - 1; ++i) {
                str[index++] = strBI.charAt(i + 1);
            }
        }
        str[index++] = 69;
        if (actualExp > 0L) {
            str[index++] = 43;
        } else if (actualExp < 0L) {
            str[index++] = 45;
        }
        for (i = 0; i < expPrecision; ++i) {
            str[index++] = (char)(BigDecimal.digitAt(adjExp, expPrecision, i) | 0x30);
        }
        return str;
    }

    public String toEngineeringString() {
        boolean isZero;
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
        }
        int tempFlags = thisClone.flags;
        long actualExp = -((long)thisClone.scale);
        if (actualExp == Integer.MIN_VALUE) {
            actualExp = -actualExp;
        }
        int precision = thisClone.precision();
        byte sign = (byte)this.signum();
        if (-actualExp >= 0L && actualExp >= (long)(-5 - precision)) {
            if (-actualExp == 0L) {
                if ((tempFlags & 1) == 1) {
                    return Long.toString(thisClone.laside);
                }
                return thisClone.bi.toString();
            }
            if (-actualExp < (long)precision) {
                if ((tempFlags & 1) == 1) {
                    long length = 1 + precision;
                    if (sign == -1) {
                        ++length;
                    }
                    return new String(thisClone.prePaddedString(sign, precision), 0, (int)length);
                }
                long length = 1 + precision;
                if (sign == -1) {
                    ++length;
                }
                return new String(thisClone.prePaddedString(sign, precision), 0, (int)length);
            }
            long numZeros = -actualExp - (long)precision;
            if ((tempFlags & 1) == 1) {
                long length = 2L + numZeros + (long)precision;
                if (sign == -1) {
                    ++length;
                }
                return new String(thisClone.prePaddedString(sign, precision), 0, (int)length);
            }
            long length = 2L + numZeros + (long)precision;
            if (sign == -1) {
                ++length;
            }
            return new String(thisClone.prePaddedString(sign, precision), 0, (int)length);
        }
        long euse = actualExp + (long)thisClone.precision() - 1L;
        int sigDigs = (int)euse % 3;
        boolean bl = isZero = this.signum() == 0;
        if (isZero) {
            int rem = sigDigs;
            if (rem != 0) {
                if (rem < 0) {
                    sigDigs = -rem + 1;
                    euse += (long)(-rem);
                } else {
                    sigDigs = 1 + (3 - rem);
                    euse += (long)(3 - rem);
                }
                StringBuilder sb = new StringBuilder();
                sb.append('0');
                if (sigDigs > 1) {
                    sb.append('.');
                }
                for (int j = sigDigs - 1; j > 0; --j) {
                    sb.append('0');
                }
                if (euse < 0L) {
                    sb.append('E');
                    sb.append('-');
                    sb.append(-euse);
                } else if (euse > 0L) {
                    sb.append('E');
                    sb.append('+');
                    sb.append(euse);
                }
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            if (euse < 0L) {
                sb.append('0');
                sb.append('E');
                sb.append('-');
                sb.append(-euse);
                return sb.toString();
            }
            if (euse > 0L) {
                sb.append('0');
                sb.append('E');
                sb.append('+');
                sb.append(euse);
                return sb.toString();
            }
            return "0";
        }
        if (sigDigs < 0) {
            sigDigs = 3 + sigDigs;
        }
        euse -= (long)sigDigs;
        ++sigDigs;
        int length = precision;
        char[] cmant = length <= 22 ? (char[])thLocalToString.get() : new char[length];
        if ((tempFlags & 1) == 1) {
            int j;
            long temp = thisClone.laside;
            if (temp < 0L) {
                temp *= -1L;
            }
            byte rem = 0;
            int numDigits = precision;
            if (temp <= Integer.MAX_VALUE) {
                int tmpVal = 0;
                int intTmp = (int)temp;
                for (j = numDigits - 1; j >= 0; --j) {
                    tmpVal = intTmp;
                    intTmp = BigDecimal.uDivideByTen(intTmp);
                    rem = (byte)(tmpVal - ((intTmp << 3) + (intTmp << 1)));
                    cmant[j] = (char)(rem | 0x30);
                }
            } else {
                long tmpVal = 0L;
                for (j = numDigits - 1; j >= 0; --j) {
                    tmpVal = temp;
                    rem = (byte)(tmpVal - (((temp /= 10L) << 3) + (temp << 1)));
                    cmant[j] = (char)(rem | 0x30);
                }
            }
        } else {
            int j = 0;
            String strBI = thisClone.bi.abs().toString();
            for (j = 0; j < strBI.length(); ++j) {
                cmant[j] = (char)(strBI.charAt(j) | 0x30);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (this.signum() == -1) {
            sb.append('-');
        }
        if (sigDigs >= length) {
            sb.append(cmant, 0, length);
            for (int x = sigDigs - length; x > 0; --x) {
                sb.append('0');
            }
        } else {
            sb.append(cmant, 0, sigDigs).append('.').append(cmant, sigDigs, length - sigDigs);
        }
        if (euse < 0L) {
            sb.append('E');
            sb.append('-');
            sb.append(-euse);
        } else if (euse > 0L) {
            sb.append('E');
            sb.append('+');
            sb.append(euse);
        }
        return sb.toString();
    }

    public String toPlainString() {
        String toPlStr;
        BigDecimal thisClone = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            thisClone = BigDecimal.clone(this);
            thisClone.DFPToLL();
        }
        byte sign = (byte)this.signum();
        if (thisClone.scale < 0) {
            thisClone = thisClone.setScale(0);
        }
        int tempFlags = thisClone.flags;
        if (thisClone.scale == 0) {
            toPlStr = (tempFlags & 1) == 1 ? Long.toString(thisClone.laside) : thisClone.bi.toString();
        } else {
            int precision = thisClone.precision();
            long actualExp = -((long)thisClone.scale);
            if (actualExp == Integer.MIN_VALUE) {
                actualExp = -actualExp;
            }
            if (-actualExp < (long)precision) {
                if ((tempFlags & 1) == 1) {
                    long length = 1 + precision;
                    if (sign == -1) {
                        ++length;
                    }
                    toPlStr = new String(thisClone.prePaddedString(sign, precision), 0, (int)length);
                } else {
                    long length = 1 + precision;
                    if (sign == -1) {
                        ++length;
                    }
                    toPlStr = new String(thisClone.prePaddedString(sign, precision), 0, (int)length);
                }
            } else {
                long numZeros = -actualExp - (long)precision;
                if ((tempFlags & 1) == 1) {
                    long length = 2L + numZeros + (long)precision;
                    if (sign == -1) {
                        ++length;
                    }
                    toPlStr = new String(thisClone.prePaddedString(sign, precision), 0, (int)length);
                } else {
                    long length = 2L + numZeros + (long)precision;
                    if (sign == -1) {
                        ++length;
                    }
                    toPlStr = new String(thisClone.prePaddedString(sign, precision), 0, (int)length);
                }
            }
        }
        return toPlStr;
    }

    private final char[] prePaddedStringDFP(int sign, int precision) {
        char[] str;
        long unscaledValue;
        int actualExp = -this.scale();
        int signLen = 0;
        if (sign == -1) {
            signLen = 1;
        }
        if ((unscaledValue = BigDecimal.DFPBCDDigits(this.laside)) == 10L) {
            unscaledValue = BigDecimal.extractDFPDigitsBCD(this.laside);
        }
        if (-actualExp < precision) {
            int i = 0;
            int length = signLen + 1 + precision;
            str = length <= 22 ? (char[])thLocalToString.get() : new char[length];
            int start = 0;
            int decimalPointLoc = length - -actualExp - 1;
            if (signLen != 0) {
                str[start++] = 45;
            }
            int curBCD = 0;
            for (i = length - 1; i > decimalPointLoc; --i) {
                curBCD = (int)(unscaledValue & 0xFL);
                unscaledValue >>>= 4;
                str[i] = (char)(curBCD | 0x30);
            }
            str[i--] = 46;
            while (i >= start) {
                curBCD = (int)(unscaledValue & 0xFL);
                unscaledValue >>>= 4;
                str[i] = (char)(curBCD | 0x30);
                --i;
            }
        } else {
            int numZeros = -actualExp - precision;
            int length = signLen + 1 + 1 + numZeros + precision;
            str = length <= 22 ? (char[])thLocalToString.get() : new char[length];
            int start = 0;
            int i = 0;
            Arrays.fill(str, 0, length, '0');
            if (signLen != 0) {
                str[start++] = 45;
            }
            int n = ++start;
            ++start;
            str[n] = 46;
            start += -actualExp - precision;
            int curBCD = 0;
            for (i = length - 1; i >= start; --i) {
                curBCD = (int)(unscaledValue & 0xFL);
                unscaledValue >>>= 4;
                str[i] = (char)(curBCD | 0x30);
            }
        }
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final char[] prePaddedString(int sign, int precision) {
        char[] str;
        int signLen = 0;
        if (sign == -1) {
            signLen = 1;
        }
        long actualExp = -((long)this.scale);
        int tempFlags = this.flags;
        if (-actualExp < (long)precision) {
            if ((tempFlags & 3) == 1) {
                long length = signLen + 1 + precision;
                str = length <= 22L ? (char[])thLocalToString.get() : new char[(int)length];
                int start = 0;
                int decimalPointLoc = (int)(length - -actualExp - 1L);
                if (signLen != 0) {
                    str[start++] = 45;
                }
                long val = this.laside;
                val = Math.abs(val);
                byte rem = 0;
                int i = 0;
                if (val <= Integer.MAX_VALUE) {
                    int tmpVal = 0;
                    int intTmp = (int)val;
                    for (i = (int)(length - 1L); i > decimalPointLoc; --i) {
                        tmpVal = intTmp;
                        intTmp = BigDecimal.uDivideByTen(intTmp);
                        rem = (byte)(tmpVal - ((intTmp << 3) + (intTmp << 1)));
                        str[i] = (char)(rem | 0x30);
                    }
                    str[i--] = 46;
                    while (i >= start) {
                        tmpVal = intTmp;
                        intTmp = BigDecimal.uDivideByTen(intTmp);
                        rem = (byte)(tmpVal - ((intTmp << 3) + (intTmp << 1)));
                        str[i] = (char)(rem | 0x30);
                        --i;
                    }
                    return str;
                } else {
                    long tmpVal = 0L;
                    for (i = (int)(length - 1L); i > decimalPointLoc; --i) {
                        tmpVal = val;
                        rem = (byte)(tmpVal - (((val /= 10L) << 3) + (val << 1)));
                        str[i] = (char)(rem | 0x30);
                    }
                    str[i--] = 46;
                    while (i >= start) {
                        tmpVal = val;
                        rem = (byte)(tmpVal - (((val /= 10L) << 3) + (val << 1)));
                        str[i] = (char)(rem | 0x30);
                        --i;
                    }
                }
                return str;
            } else {
                long length;
                String strBI = this.bi.toString();
                int numDigits = strBI.length();
                if (sign == -1) {
                    --numDigits;
                }
                str = (length = (long)(signLen + 1 + numDigits)) <= 22L ? (char[])thLocalToString.get() : new char[(int)length];
                int start = 0;
                int decimalPointLoc = (int)(length - -actualExp - 1L);
                if (signLen != 0) {
                    str[start++] = 45;
                }
                int i = 0;
                int j = strBI.length() - 1;
                for (i = (int)(length - 1L); i > decimalPointLoc; --i) {
                    str[i] = (char)(strBI.charAt(j--) | 0x30);
                }
                str[i--] = 46;
                while (i >= start) {
                    str[i] = (char)(strBI.charAt(j--) | 0x30);
                    --i;
                }
            }
            return str;
        } else {
            long numZeros = -actualExp - (long)precision;
            int i = 0;
            if ((tempFlags & 3) == 1) {
                char tensDig;
                char onesDig;
                int numLasideDigits = precision;
                long length = (long)(signLen + 1 + 1) + numZeros + (long)numLasideDigits;
                str = length <= 22L ? (char[])thLocalToString.get() : new char[(int)length];
                int start = 0;
                long tmpVal = 0L;
                byte rem = 0;
                Arrays.fill(str, 0, (int)length, '0');
                if (signLen != 0) {
                    str[start++] = 45;
                }
                int n = ++start;
                ++start;
                str[n] = 46;
                start = (int)((long)start + (-actualExp - (long)numLasideDigits));
                if (sign == 0) return str;
                long val = this.laside;
                if (val < 0L) {
                    val *= -1L;
                }
                int charLoc = (int)(length - 1L);
                while (val > Integer.MAX_VALUE) {
                    tmpVal = val;
                    rem = (byte)(tmpVal - (((val /= 100L) << 6) + (val << 5) + (val << 2)));
                    onesDig = doubleDigitsOnes[rem];
                    tensDig = doubleDigitsTens[rem];
                    str[charLoc--] = onesDig;
                    str[charLoc--] = tensDig;
                }
                int intVal = (int)val;
                while (intVal != 0) {
                    int intTmpVal = intVal;
                    rem = (byte)(intTmpVal - (((intVal /= 100) << 6) + (intVal << 5) + (intVal << 2)));
                    onesDig = doubleDigitsOnes[rem];
                    tensDig = doubleDigitsTens[rem];
                    str[charLoc--] = onesDig;
                    if (charLoc < start) return str;
                    str[charLoc--] = tensDig;
                }
                return str;
            } else {
                long length;
                String strBI = this.bi.toString();
                int numDigits = strBI.length();
                if (sign == -1) {
                    --numDigits;
                }
                str = (length = (long)(signLen + 1 + 1) + numZeros + (long)numDigits) <= 22L ? (char[])thLocalToString.get() : new char[(int)length];
                int start = 0;
                Arrays.fill(str, 0, (int)length, '0');
                if (signLen != 0) {
                    str[start++] = 45;
                }
                int n = ++start;
                ++start;
                str[n] = 46;
                start = (int)((long)start + (-actualExp - (long)numDigits));
                if (sign == 0) return str;
                int charLoc = (int)(length - 1L);
                i = strBI.length() - 1;
                while (charLoc >= start) {
                    str[charLoc--] = strBI.charAt(i--);
                }
            }
        }
        return str;
    }

    public static BigDecimal valueOf(double dub) {
        return new BigDecimal(new Double(dub).toString());
    }

    public static BigDecimal valueOf(long lint) {
        return BigDecimal.valueOf(lint, 0);
    }

    public static BigDecimal valueOf(long lint, int scale) {
        BigDecimal res;
        if (scale == 0) {
            if (lint == 0L) {
                return ZERO;
            }
            if (lint == 1L) {
                return ONE;
            }
            if (lint == 10L) {
                return TEN;
            }
        }
        if (scale < 3 && lint >= 0L && lint < (long)CACHE1.length) {
            switch (scale) {
                case 2: {
                    return CACHE2[(int)lint];
                }
                case 1: {
                    return CACHE1[(int)lint];
                }
            }
        }
        if (BigDecimal.valueOf2DFP(lint, scale, res = new BigDecimal()) != null) {
            return res;
        }
        BigDecimal.valueOf2BI(lint, res);
        res.scale = scale;
        return res;
    }

    private static void valueOf2BI(long lint, BigDecimal res) {
        if (lint != Long.MIN_VALUE) {
            res.flags |= 1;
            res.laside = lint;
        } else {
            res.flags |= 2;
            res.bi = BigInteger.valueOf(Long.MIN_VALUE);
        }
    }

    private static BigDecimal valueOf2DFP(long lint, int scale, BigDecimal res) {
        int tempFlags = 0;
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            if (lint == 0L && scale == 0) {
                res.constructDFPZero();
                return res;
            }
            if (lint <= 9999999999999999L && lint >= -9999999999999999L && -scale >= -398 && -scale <= 369 && res.DFPLongExpConstructor(lint, -scale + 398, 0, 0, 0, false)) {
                tempFlags |= 8;
                res.scale = scale;
                tempFlags |= 4;
                if (lint < 0L) {
                    tempFlags |= 0x60;
                } else if (lint > 0L) {
                    tempFlags |= 0x20;
                }
                res.flags = tempFlags;
                return res;
            }
        }
        return null;
    }

    private static final void clone(BigDecimal copy, BigDecimal dec) {
        copy.flags = dec.flags;
        copy.scale = dec.scale;
        copy.laside = dec.laside;
        copy.bi = dec.bi;
    }

    private static final BigDecimal clone(BigDecimal dec) {
        BigDecimal copy = new BigDecimal();
        copy.flags = dec.flags;
        copy.scale = dec.scale;
        copy.laside = dec.laside;
        copy.bi = dec.bi;
        return copy;
    }

    public BigDecimal round(MathContext set) {
        BigDecimal res = BigDecimal.clone(this);
        if (set.getPrecision() > 0) {
            if (BigDecimal.DFPHWAvailable() && (res.flags & 3) == 0) {
                res.roundDFP(set.getPrecision(), set.getRoundingMode().ordinal());
            } else if ((res.flags & 2) == 2) {
                res.roundBI(set.getPrecision(), set.getRoundingMode().ordinal(), false);
            } else {
                res.roundLL(set.getPrecision(), set.getRoundingMode().ordinal(), false);
            }
        }
        return res;
    }

    private final void roundDFP(int prec, int rm) {
        if (this.precision() > prec) {
            long bcd = BigDecimal.DFPBCDDigits(this.laside);
            if (bcd == 10L) {
                bcd = BigDecimal.extractDFPDigitsBCD(this.laside);
            }
            if (rm == 7 && !BigDecimal.allzeroBCD(bcd, this.precision() - prec)) {
                throw new ArithmeticException("Rounding mode unnecessary, but rounding changes value");
            }
            if (rm == 6) {
                rm = 0;
            } else if (rm == 0) {
                rm = 6;
            }
            if (!this.DFPRound(this.laside, prec, rm)) {
                this.DFPToLL();
                if (rm == 6) {
                    rm = 0;
                } else if (rm == 0) {
                    rm = 6;
                }
                this.roundLL(prec, rm, false);
            } else {
                this.flags |= 0x10;
                this.flags &= 0x7F;
                this.flags |= prec << 7;
                this.flags &= 0xFFFFFFF7;
            }
            if ((this.flags & 3) == 0 && this.isDFPZero()) {
                this.laside &= Long.MAX_VALUE;
            }
        }
    }

    private final void roundBI(long len, int mode, boolean ignoreExact) {
        long interm_exp = 0L;
        long adjust = (long)this.precision() - len;
        if (adjust <= 0L) {
            return;
        }
        if (!ignoreExact && len == 0L) {
            return;
        }
        interm_exp = -((long)this.scale) + adjust;
        int sign = this.bi.signum();
        BigInteger oldBI = this.bi;
        BigInteger rem = null;
        BigInteger rest = null;
        int first = 0;
        if (len > 0L) {
            BigInteger[] quotRemAdjust = null;
            quotRemAdjust = oldBI.divideAndRemainder(BigDecimal.powerOfTenBI(adjust));
            this.bi = quotRemAdjust[0];
            rem = quotRemAdjust[1];
            first = quotRemAdjust[1].divide(BigDecimal.powerOfTenBI(adjust - 1L)).byteValue();
            rest = quotRemAdjust[1].remainder(BigDecimal.powerOfTenBI(adjust - 1L));
        } else {
            this.bi = BigInteger.ZERO;
            if (len == 0L) {
                rem = oldBI.remainder(BigDecimal.powerOfTenBI(adjust));
                first = rem.divide(BigDecimal.powerOfTenBI(adjust - 1L)).byteValue();
                rest = rem.remainder(BigDecimal.powerOfTenBI(adjust - 1L));
            } else {
                rem = oldBI;
                first = 0;
                rest = oldBI;
            }
        }
        if (sign == -1) {
            first = (byte)(first * -1);
        }
        if (rest.signum() < 0) {
            rest = rest.abs();
        }
        this.flags &= 0xFFFFFFEF;
        int increment = 0;
        if (mode == 4) {
            if (first >= 5) {
                increment = sign;
            } else if (first == 5 && rest.signum() > 0) {
                increment = sign;
            }
        } else if (mode == 0) {
            if (rem.signum() != 0) {
                increment = sign;
            }
        } else if (mode != 1) {
            if (mode == 2) {
                if (sign == 1 && (first != 0 || rest.signum() != 0)) {
                    increment = sign;
                }
            } else if (mode == 3) {
                if (sign == -1 && (first != 0 || rest.signum() != 0)) {
                    increment = sign;
                }
            } else if (mode == 5) {
                if (first > 5) {
                    increment = sign;
                } else if (first == 5 && rest.signum() > 0) {
                    increment = sign;
                }
            } else if (mode == 6) {
                if (first > 5) {
                    increment = sign;
                } else if (first == 5) {
                    if (rest.signum() != 0) {
                        increment = sign;
                    } else if (this.bi.abs().remainder(BigInteger.TEN).byteValue() % 2 == 1) {
                        increment = sign;
                    }
                }
            } else if (mode == 7) {
                if (first != 0 || rest.signum() != 0) {
                    throw new ArithmeticException("Rounding necessary");
                }
            } else {
                throw new IllegalArgumentException("Bad round value: " + mode);
            }
        }
        if (increment != 0) {
            if (sign == 0) {
                if (-interm_exp < Integer.MIN_VALUE || -interm_exp > Integer.MAX_VALUE) {
                    throw new ArithmeticException("BigDecimal scale outside legal range: " + -interm_exp);
                }
                this.bi = BigInteger.ONE;
                this.flags |= 4;
                this.flags &= 0x7F;
                this.flags |= 0x80;
                this.scale = (int)(-interm_exp);
            } else {
                BigInteger newBI = increment == 1 ? this.bi.add(BigInteger.ONE) : this.bi.subtract(BigInteger.ONE);
                int leng = BigDecimal.precisionBI(newBI);
                if (this.precision() < leng) {
                    this.flags &= 0xFFFFFFEF;
                    ++interm_exp;
                    newBI = newBI.divide(BigInteger.TEN);
                }
                this.bi = newBI;
                if (-interm_exp < Integer.MIN_VALUE || -interm_exp > Integer.MAX_VALUE) {
                    throw new ArithmeticException("BigDecimal scale outside legal range: " + -interm_exp);
                }
                this.scale = (int)(-interm_exp);
            }
        } else {
            if (-interm_exp < Integer.MIN_VALUE || -interm_exp > Integer.MAX_VALUE) {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + -interm_exp);
            }
            this.scale = (int)(-interm_exp);
        }
        if (this.bi.bitLength() < 63) {
            this.BIToLL();
        }
    }

    private final void roundLL(long len, int rm, boolean ignoreExact) {
        byte first = 0;
        long rest = 0L;
        int increment = 0;
        long newlaside = 0L;
        long interm_exp = 0L;
        boolean fallBackToBI = false;
        int precision = 0;
        int tempFlags = this.flags;
        if ((tempFlags & 0x10) != 0) {
            precision = (tempFlags & 0xFFFFFF80) >> 7;
        } else {
            precision = BigDecimal.numDigits(this.laside);
            tempFlags |= 0x10;
            tempFlags &= 0x7F;
            this.flags = tempFlags |= precision << 7;
        }
        long adjust = (long)precision - len;
        if (adjust <= 0L) {
            return;
        }
        if (!ignoreExact && len == 0L) {
            return;
        }
        interm_exp = -((long)this.scale) + adjust;
        long oldlaside = this.laside;
        int sign = (int)(oldlaside >> 63) | (int)(-oldlaside >>> 63);
        if (sign == -1) {
            oldlaside *= -1L;
        }
        if (len > 0L) {
            first = (byte)BigDecimal.digitAt(oldlaside, precision, (int)len);
            rest = oldlaside % BigDecimal.powerOfTenLL(adjust - 1L);
            this.laside = oldlaside / BigDecimal.powerOfTenLL(adjust);
            this.flags &= 0x7F;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
        } else {
            this.laside = 0L;
            if (len == 0L) {
                first = (byte)BigDecimal.digitAt(oldlaside, precision, 0);
                rest = oldlaside % BigDecimal.powerOfTenLL(adjust - 1L);
            } else {
                first = 0;
                rest = oldlaside;
            }
            this.flags &= 0x7F;
            this.flags |= 0x80;
        }
        this.flags &= 0xFFFFFFEF;
        if (rm == 4) {
            if (first >= 5) {
                increment = sign;
            } else if (first == 5 && rest != 0L) {
                increment = sign;
            }
        } else if (rm == 5) {
            if (first > 5) {
                increment = sign;
            } else if (first == 5 && rest != 0L) {
                increment = sign;
            }
        } else if (rm == 6) {
            if (first > 5) {
                increment = sign;
            } else if (first == 5) {
                if (rest != 0L) {
                    increment = sign;
                } else if (BigDecimal.digitAt(this.laside, BigDecimal.numDigits(this.laside), BigDecimal.numDigits(this.laside) - 1) % 2 == 1) {
                    increment = sign;
                }
            }
        } else if (rm != 1) {
            if (rm == 0) {
                if (first != 0 || rest != 0L) {
                    increment = sign;
                }
            } else if (rm == 2) {
                if (sign == 1 && (first != 0 || rest != 0L)) {
                    increment = sign;
                }
            } else if (rm == 3) {
                if (sign == -1 && (first != 0 || rest != 0L)) {
                    increment = sign;
                }
            } else if (rm == 7) {
                if (first != 0 || rest != 0L) {
                    throw new ArithmeticException("Rounding necessary");
                }
            } else {
                throw new IllegalArgumentException("Bad round value: " + rm);
            }
        }
        if (increment != 0) {
            if (sign == 0) {
                this.laside = 1L;
                this.flags &= 0x7F;
                this.flags |= 0x80;
            } else {
                long sum;
                if (sign == -1) {
                    increment *= -1;
                }
                if (BigDecimal.overflowAdd(this.laside, increment, sum = this.laside + (long)increment) == 0L) {
                    newlaside = sum;
                } else {
                    fallBackToBI = true;
                }
                if (fallBackToBI) {
                    this.laside = oldlaside;
                    this.LLToBI();
                    this.roundBI(len, rm, ignoreExact);
                    return;
                }
                if (BigDecimal.numDigits(newlaside) > this.precision()) {
                    ++interm_exp;
                    this.laside = Math.abs(newlaside) > Integer.MAX_VALUE ? newlaside / 10L : (long)((int)newlaside / 10);
                } else {
                    this.laside = newlaside;
                }
            }
        }
        if (-interm_exp < Integer.MIN_VALUE || -interm_exp > Integer.MAX_VALUE) {
            throw new ArithmeticException("BigDecimal scale outside legal range: " + -interm_exp);
        }
        this.scale = (int)(-interm_exp);
        this.flags &= 0x7F;
        this.flags |= BigDecimal.numDigits(this.laside) << 7;
        if (sign == -1) {
            this.laside *= -1L;
        }
    }

    private static final long roundPostLLDivision(long quotient, int quotInd, long divisor, long remainder, int rm) {
        if (rm == 4) {
            if (remainder < 0x3FFFFFFFFFFFFFFFL) {
                if (2L * remainder >= divisor) {
                    long sum = quotient + 1L;
                    if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                        return -1L;
                    }
                    quotient = sum;
                }
            } else {
                long sum = quotient + 1L;
                if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                    return -1L;
                }
                quotient = sum;
            }
        } else if (rm == 0) {
            if (remainder > 0L) {
                long sum = quotient + 1L;
                if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                    return -1L;
                }
                quotient = sum;
            }
        } else if (rm != 1) {
            if (rm == 2) {
                if (remainder > 0L && quotInd == 1) {
                    long sum = quotient + 1L;
                    if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                        return -1L;
                    }
                    quotient = sum;
                }
            } else if (rm == 3) {
                if (remainder > 0L && quotInd == -1) {
                    long sum = quotient + 1L;
                    if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                        return -1L;
                    }
                    quotient = sum;
                }
            } else if (rm == 5) {
                if (remainder < 0x3FFFFFFFFFFFFFFFL) {
                    if (2L * remainder > divisor) {
                        long sum = quotient + 1L;
                        if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                            return -1L;
                        }
                        quotient = sum;
                    }
                } else {
                    long sum = quotient + 1L;
                    if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                        return -1L;
                    }
                    quotient = sum;
                }
            } else if (rm == 6) {
                if (remainder < 0x3FFFFFFFFFFFFFFFL) {
                    if (2L * remainder > divisor) {
                        long sum = quotient + 1L;
                        if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                            return -1L;
                        }
                        quotient = sum;
                    } else if (2L * remainder >= divisor && quotient % 10L % 2L == 1L) {
                        long sum = quotient + 1L;
                        if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                            return -1L;
                        }
                        quotient = sum;
                    }
                } else {
                    long sum = quotient + 1L;
                    if (BigDecimal.overflowAdd(quotient, 1L, sum) == 1L) {
                        return -1L;
                    }
                    quotient = sum;
                }
            } else if (rm == 7 && remainder != 0L) {
                throw new ArithmeticException("Rounding unnecessary for inexact result");
            }
        }
        return quotient;
    }

    private static final BigInteger roundPostSlowDivision(BigInteger quotient, int quotInd, BigInteger divisor, BigInteger remainder, int rm) {
        if (rm == 4) {
            if (remainder.shiftLeft(1).compareTo(divisor) >= 0) {
                quotient = quotient.add(BigInteger.ONE);
            }
        } else if (rm == 0) {
            if (remainder.signum() > 0) {
                quotient = quotient.add(BigInteger.ONE);
            }
        } else if (rm != 1) {
            if (rm == 2) {
                if (remainder.signum() > 0 && quotInd == 1) {
                    quotient = quotient.add(BigInteger.ONE);
                }
            } else if (rm == 3) {
                if (remainder.signum() > 0 && quotInd == -1) {
                    quotient = quotient.add(BigInteger.ONE);
                }
            } else if (rm == 5) {
                if (remainder.shiftLeft(1).compareTo(divisor) > 0) {
                    quotient = quotient.add(BigInteger.ONE);
                }
            } else if (rm == 6) {
                if (remainder.shiftLeft(1).compareTo(divisor) > 0) {
                    quotient = quotient.add(BigInteger.ONE);
                } else if (remainder.shiftLeft(1).compareTo(divisor) >= 0 && quotient.mod(BigInteger.TEN).mod(new BigInteger("2")).compareTo(BigInteger.ONE) == 0) {
                    quotient = quotient.add(BigInteger.ONE);
                }
            } else if (rm == 7 && remainder.signum() != 0) {
                throw new ArithmeticException("Rounding unnecessary for inexact result");
            }
        }
        return quotient;
    }

    private static final boolean allzeroBCD(long num, int numDigsToCheck) {
        long mask = -1L;
        return ((mask >>>= (64 - numDigsToCheck) * 4) & num) == 0L;
    }

    private final void finish(int prec, int rm) {
        if (prec > 0 && this.precision() > prec) {
            if ((this.flags & 3) == 0) {
                this.roundDFP(prec, rm);
            } else if ((this.flags & 3) == 2) {
                this.roundBI(prec, rm, false);
            } else {
                this.roundLL(prec, rm, false);
            }
        }
    }

    private static final BigInteger powerOfTenBI(long i) {
        if (i > -1L && i <= 18L) {
            return powersOfTenBI[(int)i];
        }
        char[] ten = new char[(int)i + 1];
        Arrays.fill(ten, '0');
        ten[0] = 49;
        return new BigInteger(ten);
    }

    private static final long powerOfTenLL(long i) {
        if (i > -1L && i <= 18L) {
            return powersOfTenLL[(int)i];
        }
        return -1L;
    }

    private static final long toLongForm(char[] num) {
        long laside = 0L;
        for (int i = 0; i < num.length; ++i) {
            laside *= 10L;
            laside += (long)(num[i] - 48);
        }
        return laside;
    }

    private final void BIToLL() {
        this.flags &= 0xFFFFFFFC;
        this.flags |= 1;
        this.laside = this.bi.longValue();
        this.bi = null;
    }

    private final void LLToBI() {
        if ((this.flags & 3) == 1) {
            this.bi = BigInteger.valueOf(this.laside);
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
        }
    }

    private final void DFPToLL() {
        if (this.laside == 2465720795985346560L) {
            this.flags &= 0xFFFFFFFC;
            this.flags |= 1;
            this.scale = 0;
            this.laside = 0L;
            this.flags |= 0x10;
            this.flags |= 0x80;
        } else {
            int signum = this.signum();
            this.scale = this.scale();
            int prec = this.precision();
            this.flags &= 0xFFFFFFEF;
            this.flags |= 0x10;
            this.flags |= prec << 7;
            long lVal = BigDecimal.DFPUnscaledValue(this.laside);
            if (lVal == Long.MAX_VALUE) {
                lVal = BigDecimal.DFPBCDDigits(this.laside);
                if (lVal == 10L) {
                    lVal = BigDecimal.extractDFPDigitsBCD(this.laside);
                }
                long val = 0L;
                int i = 0;
                while (lVal != 0L) {
                    val += (lVal & 0xFL) * BigDecimal.powerOfTenLL(i++);
                    lVal >>>= 4;
                }
                this.laside = val * (long)signum;
            } else {
                this.laside = lVal;
            }
            this.flags &= 0xFFFFFFFC;
            this.flags |= 1;
        }
    }

    private final void DFPToBI() {
        if (this.laside == 2465720795985346560L) {
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
            this.scale = 0;
            this.bi = BigInteger.ZERO;
            this.flags |= 0x10;
            this.flags |= 0x80;
        } else {
            this.scale = this.scale();
            this.bi = this.unscaledValue();
            int prec = this.precision();
            this.flags |= 0x10;
            this.flags |= prec << 7;
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
        }
    }

    private static final int numDigitsBI(int in) {
        if (in < 0) {
            return 10;
        }
        if (in < 1000000000) {
            if (in < 100000000) {
                if (in < 10000) {
                    if (in < 100) {
                        if (in < 10) {
                            return 1;
                        }
                        return 2;
                    }
                    if (in < 1000) {
                        return 3;
                    }
                    return 4;
                }
                if (in < 1000000) {
                    if (in < 100000) {
                        return 5;
                    }
                    return 6;
                }
                if (in < 10000000) {
                    return 7;
                }
                return 8;
            }
            return 9;
        }
        return 10;
    }

    private static final int numDigits(long lon) {
        if ((lon = Math.abs(lon)) < 1000000000L) {
            if (lon < 100000000L) {
                if (lon < 10000L) {
                    if (lon < 100L) {
                        if (lon < 10L) {
                            return 1;
                        }
                        return 2;
                    }
                    if (lon < 1000L) {
                        return 3;
                    }
                    return 4;
                }
                if (lon < 1000000L) {
                    if (lon < 100000L) {
                        return 5;
                    }
                    return 6;
                }
                if (lon < 10000000L) {
                    return 7;
                }
                return 8;
            }
            return 9;
        }
        if (lon < 10000000000L) {
            return 10;
        }
        if (lon < 100000000000000L) {
            if (lon < 1000000000000L) {
                if (lon < 100000000000L) {
                    return 11;
                }
                return 12;
            }
            if (lon < 10000000000000L) {
                return 13;
            }
            return 14;
        }
        if (lon < 10000000000000000L) {
            if (lon < 1000000000000000L) {
                return 15;
            }
            return 16;
        }
        if (lon < 100000000000000000L) {
            return 17;
        }
        if (lon < 1000000000000000000L) {
            return 18;
        }
        return 19;
    }

    private static final int digitAt(long lon, int numdigits, int loc) {
        lon = Math.abs(lon);
        if (loc > numdigits - 1) {
            return -1;
        }
        if (loc < 0) {
            return -1;
        }
        int indexFromRight = numdigits - loc - 1;
        if (lon <= Integer.MAX_VALUE) {
            int temp = (int)lon;
            switch (indexFromRight) {
                case 0: {
                    break;
                }
                case 1: {
                    temp /= 10;
                    break;
                }
                case 2: {
                    temp /= 100;
                    break;
                }
                case 3: {
                    temp /= 1000;
                    break;
                }
                case 4: {
                    temp /= 10000;
                    break;
                }
                case 5: {
                    temp /= 100000;
                    break;
                }
                case 6: {
                    temp /= 1000000;
                    break;
                }
                case 7: {
                    temp /= 10000000;
                    break;
                }
                case 8: {
                    temp /= 100000000;
                    break;
                }
                case 9: {
                    temp /= 1000000000;
                    break;
                }
                case 10: {
                    temp = (int)((long)temp / 10000000000L);
                    break;
                }
                case 11: {
                    temp = (int)((long)temp / 100000000000L);
                    break;
                }
                case 12: {
                    temp = (int)((long)temp / 1000000000000L);
                    break;
                }
                case 13: {
                    temp = (int)((long)temp / 10000000000000L);
                    break;
                }
                case 14: {
                    temp = (int)((long)temp / 100000000000000L);
                    break;
                }
                case 15: {
                    temp = (int)((long)temp / 1000000000000000L);
                    break;
                }
                case 16: {
                    temp = (int)((long)temp / 10000000000000000L);
                    break;
                }
                case 17: {
                    temp = (int)((long)temp / 100000000000000000L);
                    break;
                }
                case 18: {
                    temp = (int)((long)temp / 1000000000000000000L);
                }
            }
            if (temp <= Integer.MAX_VALUE) {
                int intTmp;
                int tmpVal = intTmp = temp;
                intTmp = BigDecimal.uDivideByTen(intTmp);
                return tmpVal - ((intTmp << 3) + (intTmp << 1));
            }
            long tmpVal = temp;
            return (int)(tmpVal - (long)(((temp /= 10) << 3) + (temp << 1)));
        }
        long temp = lon;
        switch (indexFromRight) {
            case 0: {
                break;
            }
            case 1: {
                temp /= 10L;
                break;
            }
            case 2: {
                temp /= 100L;
                break;
            }
            case 3: {
                temp /= 1000L;
                break;
            }
            case 4: {
                temp /= 10000L;
                break;
            }
            case 5: {
                temp /= 100000L;
                break;
            }
            case 6: {
                temp /= 1000000L;
                break;
            }
            case 7: {
                temp /= 10000000L;
                break;
            }
            case 8: {
                temp /= 100000000L;
                break;
            }
            case 9: {
                temp /= 1000000000L;
                break;
            }
            case 10: {
                temp /= 10000000000L;
                break;
            }
            case 11: {
                temp /= 100000000000L;
                break;
            }
            case 12: {
                temp /= 1000000000000L;
                break;
            }
            case 13: {
                temp /= 10000000000000L;
                break;
            }
            case 14: {
                temp /= 100000000000000L;
                break;
            }
            case 15: {
                temp /= 1000000000000000L;
                break;
            }
            case 16: {
                temp /= 10000000000000000L;
                break;
            }
            case 17: {
                temp /= 100000000000000000L;
                break;
            }
            case 18: {
                temp /= 1000000000000000000L;
            }
        }
        if (temp <= Integer.MAX_VALUE) {
            int intTmp;
            int tmpVal = intTmp = (int)temp;
            intTmp = BigDecimal.uDivideByTen(intTmp);
            return tmpVal - ((intTmp << 3) + (intTmp << 1));
        }
        long tmpVal = temp;
        return (int)(tmpVal - (((temp /= 10L) << 3) + (temp << 1)));
    }

    private static final int digitAtBCD(long bcd, int numDigits, int indexFromLeft) {
        int indexFromRight = numDigits - indexFromLeft - 1;
        switch (indexFromRight) {
            case 0: {
                return (int)(bcd & 0xFL);
            }
            case 1: {
                return (int)((bcd & 0xF0L) >>> 4);
            }
            case 2: {
                return (int)((bcd & 0xF00L) >>> 8);
            }
            case 3: {
                return (int)((bcd & 0xF000L) >>> 12);
            }
            case 4: {
                return (int)((bcd & 0xF0000L) >>> 16);
            }
            case 5: {
                return (int)((bcd & 0xF00000L) >>> 20);
            }
            case 6: {
                return (int)((bcd & 0xF000000L) >>> 24);
            }
            case 7: {
                return (int)((bcd & 0xF0000000L) >>> 28);
            }
            case 8: {
                return (int)((bcd & 0xF00000000L) >>> 32);
            }
            case 9: {
                return (int)((bcd & 0xF000000000L) >>> 36);
            }
            case 10: {
                return (int)((bcd & 0xF0000000000L) >>> 40);
            }
            case 11: {
                return (int)((bcd & 0xF00000000000L) >> 44);
            }
            case 12: {
                return (int)((bcd & 0xF000000000000L) >>> 48);
            }
            case 13: {
                return (int)((bcd & 0xF0000000000000L) >>> 52);
            }
            case 14: {
                return (int)((bcd & 0xF00000000000000L) >>> 56);
            }
            case 15: {
                return (int)((bcd & 0xF000000000000000L) >>> 60);
            }
        }
        return 0;
    }

    private static final long overflowAdd(long lhs, long rhs, long sum) {
        return ((sum ^ lhs) & (sum ^ rhs)) >>> 63;
    }

    private static final boolean overflowMultiply(long lhs, long rhs) {
        if (lhs < 0L) {
            lhs *= -1L;
        }
        if (rhs < 0L) {
            rhs *= -1L;
        }
        if (lhs == 0L || rhs == 0L) {
            return false;
        }
        if (lhs == 1L || rhs == 1L) {
            return false;
        }
        int m = 0;
        int n = 0;
        m = Long.numberOfLeadingZeros(lhs) - 1;
        return m + (n = Long.numberOfLeadingZeros(rhs) - 1) < 63;
    }

    private static final int uDivideByTen(int x) {
        int q = (x >> 1) + (x >> 2);
        q += q >> 4;
        q += q >> 8;
        q += q >> 16;
        return q + ((x -= (q >>= 3) * 10) + 6 >> 4);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("scale", this.scale);
        fields.put("intVal", this.unscaledValue());
        out.writeFields();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        BigInteger bi = (BigInteger)fields.get("intVal", null);
        int scale = fields.get("scale", 0);
        if (bi == null) {
            throw new IOException("Referenced field was null");
        }
        this.bigIntegerConstructor(bi, scale, MathContext.UNLIMITED);
    }

    private static final byte[] comboinit() {
        byte[] comboCode = new byte[]{0, 4, 8, 12, 16, 20, 24, 28, 1, 5, 9, 13, 17, 21, 25, 29, 2, 6, 10, 14, 18, 22, 26, 30, 32, 36, 33, 37, 34, 38};
        return comboCode;
    }

    private static final short[] dpd2bcdinit() {
        short[] dpd2bcd = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 128, 129, 2048, 2049, 2176, 2177, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 144, 145, 2064, 2065, 2192, 2193, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 130, 131, 2080, 2081, 2056, 2057, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 146, 147, 2096, 2097, 2072, 2073, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 132, 133, 2112, 2113, 136, 137, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 148, 149, 2128, 2129, 152, 153, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 134, 135, 2144, 2145, 2184, 2185, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 150, 151, 2160, 2161, 2200, 2201, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 384, 385, 2304, 2305, 2432, 2433, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 400, 401, 2320, 2321, 2448, 2449, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 386, 387, 2336, 2337, 2312, 2313, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 402, 403, 2352, 2353, 2328, 2329, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 388, 389, 2368, 2369, 392, 393, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 404, 405, 2384, 2385, 408, 409, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 390, 391, 2400, 2401, 2440, 2441, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 406, 407, 2416, 2417, 2456, 2457, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 640, 641, 2050, 2051, 2178, 2179, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 656, 657, 2066, 2067, 2194, 2195, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 642, 643, 2082, 2083, 2088, 2089, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 658, 659, 2098, 2099, 2104, 2105, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 644, 645, 2114, 2115, 648, 649, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 660, 661, 2130, 2131, 664, 665, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 646, 647, 2146, 2147, 2184, 2185, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 662, 663, 2162, 2163, 2200, 2201, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 896, 897, 2306, 2307, 2434, 2435, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 912, 913, 2322, 2323, 2450, 2451, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 898, 899, 2338, 2339, 2344, 2345, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 914, 915, 2354, 2355, 2360, 2361, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 900, 901, 2370, 2371, 904, 905, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 916, 917, 2386, 2387, 920, 921, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 902, 903, 2402, 2403, 2440, 2441, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 918, 919, 2418, 2419, 2456, 2457, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1152, 1153, 2052, 2053, 2180, 2181, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1168, 1169, 2068, 2069, 2196, 2197, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1154, 1155, 2084, 2085, 2120, 2121, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1170, 1171, 2100, 2101, 2136, 2137, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1156, 1157, 2116, 2117, 1160, 1161, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1172, 1173, 2132, 2133, 1176, 1177, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1158, 1159, 2148, 2149, 2184, 2185, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1174, 1175, 2164, 2165, 2200, 2201, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1408, 1409, 2308, 2309, 2436, 2437, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1305, 1424, 1425, 2324, 2325, 2452, 2453, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1410, 1411, 2340, 2341, 2376, 2377, 1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1426, 1427, 2356, 2357, 2392, 2393, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1412, 1413, 2372, 2373, 1416, 1417, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1428, 1429, 2388, 2389, 1432, 1433, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1414, 1415, 2404, 2405, 2440, 2441, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1430, 1431, 2420, 2421, 2456, 2457, 1536, 1537, 1538, 1539, 1540, 1541, 1542, 1543, 1544, 1545, 1664, 1665, 2054, 2055, 2182, 2183, 1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1680, 1681, 2070, 2071, 2198, 2199, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1666, 1667, 2086, 2087, 2152, 2153, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1682, 1683, 2102, 2103, 2168, 2169, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1668, 1669, 2118, 2119, 1672, 1673, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624, 1625, 1684, 1685, 2134, 2135, 1688, 1689, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 1670, 1671, 2150, 2151, 2184, 2185, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1686, 1687, 2166, 2167, 2200, 2201, 1792, 1793, 1794, 1795, 1796, 1797, 1798, 1799, 1800, 1801, 1920, 1921, 2310, 2311, 2438, 2439, 1808, 1809, 1810, 1811, 1812, 1813, 1814, 1815, 1816, 1817, 1936, 1937, 2326, 2327, 2454, 2455, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 1833, 1922, 1923, 2342, 2343, 2408, 2409, 1840, 1841, 1842, 1843, 1844, 1845, 1846, 1847, 1848, 1849, 1938, 1939, 2358, 2359, 2424, 2425, 1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 1865, 1924, 1925, 2374, 2375, 1928, 1929, 1872, 1873, 1874, 1875, 1876, 1877, 1878, 1879, 1880, 1881, 1940, 1941, 2390, 2391, 1944, 1945, 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 1897, 1926, 1927, 2406, 2407, 2440, 2441, 1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911, 1912, 1913, 1942, 1943, 2422, 2423, 2456, 2457};
        return dpd2bcd;
    }

    private static final long extractDFPDigitsBCD(long dfpNum) {
        int combo = 0;
        if (dfpNum == 2465720795985346560L) {
            return 0L;
        }
        combo = (int)(dfpNum >>> 58);
        combo &= 0x1F;
        long ccf = dfpNum & 0x3FFFFFFFFFFFFL;
        long ccBCD = 0L;
        long bcd = 0L;
        for (int i = 0; i < 5; ++i) {
            bcd = DPD2BCD[(int)((ccf & 0x3FF0000000000L) >>> 40)];
            ccBCD <<= 12;
            ccBCD |= bcd;
            ccf <<= 10;
        }
        return ccBCD |= (long)(doubleDFPComboField[combo] >>> 2) << 60;
    }

    private static final int extractDFPExponent(long dfpNum) {
        byte combo = 0;
        combo = (byte)(dfpNum >>> 58);
        short bxf = (short)(dfpNum >>> 50);
        bxf = (short)(bxf & 0xFF);
        byte exp2Digits = (byte)(doubleDFPComboField[combo] & 3);
        short unbExp = exp2Digits;
        unbExp = (short)(unbExp << 8);
        unbExp = (short)(unbExp | bxf);
        return unbExp;
    }

    private final void constructDFPZero() {
        this.laside = 2465720795985346560L;
        this.flags |= 4;
        this.flags |= 0x10;
        this.flags |= 0x80;
        this.flags |= 8;
    }

    private final boolean isDFPZero() {
        if (this.laside == 2465720795985346560L) {
            return true;
        }
        return (this.laside & 0x3FFFFFFFFFFFFL) == 0L && (this.laside >>> 58 & 7L) == 0L;
    }

    private static final boolean DFPHWAvailable() {
        return false;
    }

    private static final boolean DFPPerformHysteresis() {
        return false;
    }

    private static final boolean DFPUseDFP() {
        return hys_type;
    }

    private final boolean DFPIntConstructor(int val, int rndFlag, int prec, int rm) {
        return false;
    }

    private final boolean DFPLongConstructor(long val, int rndFlag, int prec, int rm) {
        return false;
    }

    private final boolean DFPLongExpConstructor(long val, int biasedExp, int rndFlag, int prec, int rm, boolean bcd) {
        return false;
    }

    private final boolean DFPScaledAdd(long lhsDFP, long rhsDFP, int biasedExp) {
        return false;
    }

    private final boolean DFPAdd(long lhsDFP, long rhsDFP, int rndFlag, int precision, int rm) {
        return false;
    }

    private final boolean DFPScaledSubtract(long lhsDFP, long rhsDFP, int biasedExp) {
        return false;
    }

    private final boolean DFPSubtract(long lhsDFP, long rhsDFP, int rndFlag, int precision, int rm) {
        return false;
    }

    private final boolean DFPScaledMultiply(long lhsDFP, long rhsDFP, int biasedExp) {
        return false;
    }

    private final boolean DFPMultiply(long lhsDFP, long rhsDFP, int rndFlag, int precision, int rm) {
        return false;
    }

    private final int DFPScaledDivide(long lhsDFP, long rhsDFP, int scale, int rndFlg, int rm) {
        return -1;
    }

    private final int DFPDivide(long lhsDFP, long rhsDFP, boolean checkForInexact, int rndFlag, int prec, int rm) {
        return -1;
    }

    private final boolean DFPRound(long dfpSrc, int precision, int rm) {
        return false;
    }

    private static final int DFPCompareTo(long lhsDFP, long rhsDFP) {
        return -2;
    }

    private static final long DFPBCDDigits(long dfp) {
        return 10L;
    }

    private static final int DFPSignificance(long dfp) {
        return -1;
    }

    private static final int DFPExponent(long dfp) {
        return 1000;
    }

    private final int DFPSetScale(long srcDFP, int biasedExp, boolean round, int rm, boolean checkInexact) {
        return -1;
    }

    private static final long DFPUnscaledValue(long srcDFP) {
        return Long.MAX_VALUE;
    }

    private final long getLaside() {
        return this.laside;
    }

    private static BigDecimal slowSMSS(BigDecimal valueOfObject, BigDecimal subtractObject, BigDecimal multiplyObject) {
        return multiplyObject.multiply(valueOfObject.subtract(subtractObject).setScale(2, 4));
    }

    private static boolean noLLOverflow(long temp) {
        return false;
    }

    private static BigDecimal SMSS(BigDecimal valueOfObject, BigDecimal subtractObject, BigDecimal multiplyObject, int subtractArgScale, int multiplyArgScale) {
        long temp3;
        long temp2;
        long powerOfTen;
        long temp1;
        if (multiplyObject != null && multiplyObject.getClass() == BigDecimal.class && subtractObject.scale == subtractArgScale && multiplyObject.scale == multiplyArgScale && (subtractObject.flags & multiplyObject.flags & 1) == 1 && BigDecimal.noLLOverflow(temp1 = (powerOfTen = (long)Math.pow(10.0, subtractArgScale)) - subtractObject.getLaside()) && BigDecimal.noLLOverflow(temp2 = multiplyObject.getLaside() * temp1) && BigDecimal.noLLOverflow(temp3 = temp2 + powerOfTen / 2L)) {
            return BigDecimal.valueOf(temp3 / powerOfTen, 2);
        }
        return BigDecimal.slowSMSS(valueOfObject, subtractObject, multiplyObject);
    }

    private static BigDecimal slowAAMSS(BigDecimal valueOfObject, BigDecimal add1Object, BigDecimal add2Object, BigDecimal multiplyObject) {
        return multiplyObject.multiply(valueOfObject.add(add1Object).add(add2Object)).setScale(2, 4);
    }

    private static BigDecimal AAMSS(BigDecimal valueOfObject, BigDecimal add1Object, BigDecimal add2Object, BigDecimal multiplyObject, int add1ArgScale, int add2ArgScale, int multiplyArgScale) {
        long temp4;
        long temp3;
        long temp2;
        long powerOfTen;
        long temp1;
        if (multiplyObject != null && multiplyObject.getClass() == BigDecimal.class && add1Object.scale == add1ArgScale && add2Object.scale == add2ArgScale && multiplyObject.scale == multiplyArgScale && (add1Object.flags & add2Object.flags & multiplyObject.flags & 1) == 1 && BigDecimal.noLLOverflow(temp1 = (powerOfTen = (long)Math.pow(10.0, add1ArgScale)) + add1Object.getLaside()) && BigDecimal.noLLOverflow(temp2 = temp1 + add2Object.getLaside()) && BigDecimal.noLLOverflow(temp3 = temp2 * multiplyObject.getLaside()) && BigDecimal.noLLOverflow(temp4 = temp3 + powerOfTen / 2L)) {
            return BigDecimal.valueOf(temp4 / powerOfTen, 2);
        }
        return BigDecimal.slowAAMSS(valueOfObject, add1Object, add2Object, multiplyObject);
    }

    private static BigDecimal slowMSS(BigDecimal valueOfObject, BigDecimal multiplyObject) {
        return valueOfObject.multiply(multiplyObject).setScale(2, 4);
    }

    private static BigDecimal MSS(BigDecimal valueOfObject, BigDecimal multiplyObject, int multiplyArgScale) {
        long temp1;
        if (multiplyObject.scale == multiplyArgScale && (valueOfObject.flags & multiplyObject.flags & 1) == 1 && BigDecimal.noLLOverflow(temp1 = valueOfObject.getLaside() * multiplyObject.getLaside())) {
            return BigDecimal.valueOf(temp1, 2);
        }
        return BigDecimal.slowMSS(valueOfObject, multiplyObject);
    }

    static {
        zeroDec = "0.00";
        hys_threshold = 1000;
        hys_type = false;
        hys_counter = 0;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("scale", Integer.TYPE), new ObjectStreamField("intVal", BigInteger.class)};
        CACHE1 = new BigDecimal[11];
        CACHE2 = new BigDecimal[11];
        for (int i = 0; i < CACHE1.length; ++i) {
            BigDecimal.CACHE1[i] = new BigDecimal();
            BigDecimal.CACHE1[i].flags |= 1;
            BigDecimal.CACHE1[i].laside = i;
            BigDecimal.CACHE1[i].scale = 1;
            BigDecimal.CACHE2[i] = new BigDecimal();
            BigDecimal.CACHE2[i].flags |= 1;
            BigDecimal.CACHE2[i].laside = i;
            BigDecimal.CACHE2[i].scale = 2;
        }
    }
}

