/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarRunner {
    public static void main(String[] args) throws Exception {
        Manifest manifest = JarRunner.getManifest(args[0]);
        if (null == manifest) {
            System.err.println(Msg.getString("K0222", args[0]));
            return;
        }
        String mainClass = JarRunner.mainClassName(manifest);
        if (mainClass == null) {
            System.err.println(Msg.getString("K01c6", args[0]));
            return;
        }
        Class<?> runnable = Class.forName(mainClass, true, ClassLoader.getSystemClassLoader());
        Class[] mainParams = new Class[]{args.getClass()};
        Method mainMethod = runnable.getMethod("main", mainParams);
        Object[] params = new Object[1];
        String[] margs = new String[args.length - 1];
        System.arraycopy((Object)args, 1, (Object)margs, 0, args.length - 1);
        params[0] = margs;
        mainMethod.invoke(null, params);
    }

    private static String mainClassName(Manifest manifest) throws IOException {
        Attributes mainAttrib = manifest.getMainAttributes();
        String name = mainAttrib.getValue(Attributes.Name.MAIN_CLASS);
        if (name != null) {
            name = name.replace('/', '.');
        }
        return name;
    }

    private static Manifest getManifest(String jarFileName) throws IOException {
        JarFile jar = new JarFile(jarFileName);
        return jar.getManifest();
    }
}

