/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedAbstractHelper;
import com.ibm.oti.shared.SharedDataHelper;
import java.nio.ByteBuffer;

public class SharedDataHelperImpl
extends SharedAbstractHelper
implements SharedDataHelper {
    SharedDataHelperImpl(ClassLoader loader, int id, boolean canFind, boolean canStore) {
        this.initialize(loader, id, canFind, canStore);
    }

    private native ByteBuffer findSharedDataImpl(int var1, String var2);

    private native ByteBuffer storeSharedDataImpl(ClassLoader var1, int var2, String var3, ByteBuffer var4);

    public ByteBuffer findSharedData(String token) {
        if (!this.canFind) {
            return null;
        }
        if (!this.checkReadPermission()) {
            this.printVerboseError("Read permission denied. Returning null.");
            return null;
        }
        if (token == null) {
            this.printVerboseError("Cannot call findSharedData with null token. Returning null.");
            return null;
        }
        return this.findSharedDataImpl(this.id, token);
    }

    public ByteBuffer storeSharedData(String token, ByteBuffer data) {
        if (!this.canStore) {
            return null;
        }
        if (!this.checkWritePermission()) {
            this.printVerboseError("Write permission denied. Returning null.");
            return null;
        }
        if (token == null) {
            this.printVerboseError("Cannot call storeSharedData with null token. Returning null.");
            return null;
        }
        if (data != null && !data.isDirect()) {
            this.printVerboseError("Cannot call storeSharedData with a non-direct ByteBuffer. Returning null.");
            return null;
        }
        return this.storeSharedDataImpl(this.getClassLoader(), this.id, token, data);
    }

    String getHelperType() {
        return "SharedDataHelper";
    }
}

