/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;

public class StartupSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private long options_offset;
    private long options_end;
    private TraceFile traceFile;
    private String[] startupOptions;

    public StartupSection(TraceFile traceFile, int start) throws IOException {
        this.traceFile = traceFile;
        traceFile.seek(start);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.options_offset = traceFile.getFilePointer();
        this.options_end = start + this.length;
        Util.Debug.println("StartupSection: eyecatcher:        " + this.eyecatcher_string);
        Util.Debug.println("StartupSection: length:            " + this.length);
        Util.Debug.println("StartupSection: version:           " + this.version);
        Util.Debug.println("StartupSection: modification:      " + this.modification);
        this.startupOptions = this.readOptions(traceFile, this.options_offset);
    }

    private String[] readOptions(TraceFile traceFile, long options_offset) throws IOException {
        String[] opts = null;
        Vector<String> optsVector = new Vector<String>();
        traceFile.seek(options_offset);
        byte[] optionsBuffer = new byte[(int)(this.options_end - options_offset)];
        Util.Debug.println("StartupSection: options_offset:        " + options_offset);
        Util.Debug.println("StartupSection: options_end:           " + this.options_end);
        int i = 0;
        traceFile.read(optionsBuffer);
        for (i = 0; i < optionsBuffer.length; ++i) {
            StringBuffer buf = new StringBuffer();
            while (optionsBuffer[i] != 0) {
                buf.append((char)optionsBuffer[i]);
                ++i;
            }
            if (buf.length() == 0) break;
            String newOpt = buf.toString();
            optsVector.add(newOpt);
        }
        opts = new String[optsVector.size()];
        for (i = 0; i < optsVector.size(); ++i) {
            opts[i] = (String)optsVector.elementAt(i);
        }
        return opts;
    }

    protected void summary(BufferedWriter out) throws IOException {
        out.write("JVM Start-up Params :");
        out.newLine();
        for (int i = 0; i < this.startupOptions.length; ++i) {
            out.write(this.startupOptions[i]);
            out.newLine();
        }
        out.newLine();
    }

    protected String[] getStartUpOptions() {
        return this.startupOptions;
    }
}

