/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class StdChannel
extends Channel {
    private int stdType = -1;
    static final int STDIN = 0;
    static final int STDOUT = 1;
    static final int STDERR = 2;

    StdChannel() {
    }

    StdChannel(String stdName) {
        if (stdName.equals("stdin")) {
            this.open(0);
        } else if (stdName.equals("stdout")) {
            this.open(1);
        } else if (stdName.equals("stderr")) {
            this.open(2);
        } else {
            throw new TclRuntimeError("Error: unexpected type for StdChannel");
        }
    }

    StdChannel(int type) {
        this.open(type);
    }

    String open(int type) {
        switch (type) {
            case 0: {
                this.mode = 1;
                this.setBuffering(1);
                this.setChanName("stdin");
                break;
            }
            case 1: {
                this.mode = 2;
                this.setBuffering(1);
                this.setChanName("stdout");
                break;
            }
            case 2: {
                this.mode = 2;
                this.setBuffering(2);
                this.setChanName("stderr");
                break;
            }
            default: {
                throw new RuntimeException("type does not match one of STDIN, STDOUT, or STDERR");
            }
        }
        this.stdType = type;
        return this.getChanName();
    }

    void write(Interp interp, TclObject outData) throws IOException, TclException {
        this.checkWrite(interp);
        if (this.stdType == 2) {
            System.err.print(outData.toString());
        } else {
            String s = outData.toString();
            System.out.print(s);
            if (this.buffering == 2 || this.buffering == 1 && s.endsWith("\n")) {
                System.out.flush();
            }
        }
    }

    void close() throws IOException {
        super.close();
        if (this.stdType == 1) {
            System.out.flush();
        }
    }

    String getChanType() {
        return "tty";
    }

    protected InputStream getInputStream() throws IOException {
        return System.in;
    }

    protected OutputStream getOutputStream() throws IOException {
        throw new RuntimeException("should never be called");
    }
}

