/*
 * Decompiled with CFR 0.152.
 */
package sunlabs.brazil.util.regexp;

import sunlabs.brazil.util.regexp.Regsub;

public class Regexp {
    static final int NSUBEXP = 100;
    static final char END = '\u0000';
    static final char BOL = '\u0001';
    static final char EOL = '\u0002';
    static final char ANY = '\u0003';
    static final char ANYOF = '\u0004';
    static final char ANYBUT = '\u0005';
    static final char BRANCH = '\u0006';
    static final char BACK = '\u0007';
    static final char EXACTLY = '\b';
    static final char NOTHING = '\t';
    static final char STAR = '\n';
    static final char PLUS = '\u000b';
    static final char OPEN = '\u0014';
    static final char CLOSE = 'x';
    static final String[] opnames = new String[]{"END", "BOL", "EOL", "ANY", "ANYOF", "ANYBUT", "BRANCH", "BACK", "EXACTLY", "NOTHING", "STAR", "PLUS"};
    char[] program;
    boolean ignoreCase;
    int npar;
    boolean anchored;
    int startChar;
    String must;

    public static void main(String[] args) throws Exception {
        if (args.length == 2 && args[0].equals("compile")) {
            System.out.println(new Regexp(args[1]));
        } else if (args.length == 3 && args[0].equals("match")) {
            Regexp r = new Regexp(args[1]);
            String[] substrs = new String[r.subspecs()];
            boolean match = r.match(args[2], substrs);
            System.out.println("match:\t" + match);
            for (int i = 0; i < substrs.length; ++i) {
                System.out.println(i + 1 + ":\t" + substrs[i]);
            }
        } else if (args.length == 4 && args[0].equals("sub")) {
            Regexp r = new Regexp(args[1]);
            System.out.println(r.subAll(args[2], args[3]));
        } else {
            System.out.println("usage:");
            System.out.println("\tRegexp match <pattern> <string>");
            System.out.println("\tRegexp sub <pattern> <string> <subspec>");
            System.out.println("\tRegexp compile <pattern>");
        }
    }

    public Regexp(String pat) throws IllegalArgumentException {
        this.compile(pat);
    }

    public Regexp(String pat, boolean ignoreCase) throws IllegalArgumentException {
        this.ignoreCase = ignoreCase;
        if (ignoreCase) {
            pat = pat.toLowerCase();
        }
        this.compile(pat);
    }

    public int subspecs() {
        return this.npar;
    }

    public String match(String str) {
        Match m = this.exec(str, 0, 0);
        if (m == null) {
            return null;
        }
        return str.substring(m.indices[0], m.indices[1]);
    }

    public boolean match(String str, String[] substrs) {
        Match m = this.exec(str, 0, 0);
        if (m == null) {
            return false;
        }
        if (substrs != null) {
            int i;
            int max = Math.min(substrs.length, this.npar);
            int j = 0;
            for (i = 0; i < max; ++i) {
                int start = m.indices[j++];
                int end = m.indices[j++];
                substrs[i] = start < 0 ? null : str.substring(start, end);
            }
            while (i < substrs.length) {
                substrs[i] = null;
                ++i;
            }
        }
        return true;
    }

    public boolean match(String str, int[] indices) {
        Match m = this.exec(str, 0, 0);
        if (m == null) {
            return false;
        }
        if (indices != null) {
            int max = Math.min(indices.length, this.npar * 2);
            System.arraycopy(m.indices, 0, indices, 0, max);
            for (int i = max; i < indices.length; ++i) {
                indices[i] = -1;
            }
        }
        return true;
    }

    public String sub(String str, String subspec) {
        Regsub rs = new Regsub(this, str);
        if (rs.nextMatch()) {
            StringBuffer sb = new StringBuffer(rs.skipped());
            Regexp.applySubspec(rs, subspec, sb);
            sb.append(rs.rest());
            return sb.toString();
        }
        return null;
    }

    public String subAll(String str, String subspec) {
        return this.sub(str, new SubspecFilter(subspec, true));
    }

    public static void applySubspec(Regsub rs, String subspec, StringBuffer sb) {
        try {
            int len = subspec.length();
            block6: for (int i = 0; i < len; ++i) {
                char ch = subspec.charAt(i);
                switch (ch) {
                    case '&': {
                        sb.append(rs.matched());
                        continue block6;
                    }
                    case '\\': {
                        ch = subspec.charAt(++i);
                        if (ch >= '0' && ch <= '9') {
                            String match = rs.submatch(ch - 48);
                            if (match == null) continue block6;
                            sb.append(match);
                            continue block6;
                        }
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public String sub(String str, Filter rf) {
        Regsub rs = new Regsub(this, str);
        if (!rs.nextMatch()) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        do {
            sb.append(rs.skipped());
        } while (rf.filter(rs, sb) && rs.nextMatch());
        sb.append(rs.rest());
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# subs:  " + this.npar + "\n");
        sb.append("anchor:  " + this.anchored + "\n");
        sb.append("start:   " + (char)this.startChar + "\n");
        sb.append("must:    " + this.must + "\n");
        int i = 0;
        while (i < this.program.length) {
            sb.append(i + ":\t");
            char op = this.program[i];
            if (op >= 'x') {
                sb.append("CLOSE" + (op - 120));
            } else if (op >= '\u0014') {
                sb.append("OPEN" + (op - 20));
            } else {
                sb.append(opnames[op]);
            }
            char offset = this.program[i + 1];
            if (offset == '\u0000') {
                sb.append('\t');
            } else if (op == '\u0007') {
                sb.append("\t-" + offset + "," + (i - offset));
            } else {
                sb.append("\t+" + offset + "," + (i + offset));
            }
            if (op == '\u0004' || op == '\u0005' || op == '\b') {
                sb.append("\t'");
                sb.append(this.program, i + 3, (int)this.program[i + 2]);
                sb.append("'");
                i += 3 + this.program[i + 2];
            } else {
                i += 2;
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private void compile(String exp) throws IllegalArgumentException {
        Compiler rcstate = new Compiler();
        rcstate.parse = exp.toCharArray();
        rcstate.off = 0;
        rcstate.npar = 1;
        rcstate.code = new StringBuffer();
        rcstate.reg(false);
        this.program = rcstate.code.toString().toCharArray();
        this.npar = rcstate.npar;
        this.startChar = -1;
        if (this.program[rcstate.regnext(0)] == '\u0000') {
            if (this.program[2] == '\u0001') {
                this.anchored = true;
            } else if (this.program[2] == '\b') {
                this.startChar = this.program[5];
            }
        }
    }

    Match exec(String str, int start, int off) {
        if (this.ignoreCase) {
            str = str.toLowerCase();
        }
        Match match = new Match();
        match.program = this.program;
        match.str = str;
        match.bol = start;
        match.length = str.length();
        match.indices = new int[this.npar * 2];
        if (this.anchored) {
            if (match.regtry(off)) {
                return match;
            }
        } else if (this.startChar >= 0) {
            while (off < match.length && (off = str.indexOf(this.startChar, off)) >= 0) {
                if (match.regtry(off)) {
                    return match;
                }
                ++off;
            }
        } else {
            do {
                if (!match.regtry(off)) continue;
                return match;
            } while (off++ < match.length);
        }
        return null;
    }

    static class Match {
        char[] program;
        String str;
        int bol;
        int input;
        int length;
        int[] indices;

        Match() {
        }

        boolean regtry(int off) {
            this.input = off;
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = -1;
            }
            if (this.regmatch(0)) {
                this.indices[0] = off;
                this.indices[1] = this.input;
                return true;
            }
            return false;
        }

        boolean regmatch(int scan) {
            while (true) {
                int next = this.regnext(scan);
                char op = this.program[scan];
                switch (op) {
                    case '\u0001': {
                        if (this.input == this.bol) break;
                        return false;
                    }
                    case '\u0002': {
                        if (this.input == this.length) break;
                        return false;
                    }
                    case '\u0003': {
                        if (this.input >= this.length) {
                            return false;
                        }
                        ++this.input;
                        break;
                    }
                    case '\b': {
                        if (this.compare(scan)) break;
                        return false;
                    }
                    case '\u0004': {
                        if (this.input >= this.length) {
                            return false;
                        }
                        if (!this.present(scan)) {
                            return false;
                        }
                        ++this.input;
                        break;
                    }
                    case '\u0005': {
                        if (this.input >= this.length) {
                            return false;
                        }
                        if (this.present(scan)) {
                            return false;
                        }
                        ++this.input;
                        break;
                    }
                    case '\u0007': 
                    case '\t': {
                        break;
                    }
                    case '\u0006': {
                        if (this.program[next] != '\u0006') {
                            next = scan + 2;
                            break;
                        }
                        do {
                            int n = this.input;
                            if (this.regmatch(scan + 2)) {
                                return true;
                            }
                            this.input = n;
                        } while ((scan = this.regnext(scan)) >= 0 && this.program[scan] == '\u0006');
                        return false;
                    }
                    case '\n': 
                    case '\u000b': {
                        char c;
                        int n = -1;
                        if (this.program[next] == '\b') {
                            c = this.program[next + 3];
                        }
                        int min = op == '\n' ? 0 : 1;
                        int save = this.input;
                        int no = this.regrepeat(scan + 2);
                        while (no >= min) {
                            if ((c < '\u0000' || this.input < this.length && this.str.charAt(this.input) == c) && this.regmatch(next)) {
                                return true;
                            }
                            this.input = save + --no;
                        }
                        return false;
                    }
                    case '\u0000': {
                        return true;
                    }
                    default: {
                        if (op >= 'x') {
                            int n = op - 120;
                            int save = this.input;
                            if (this.regmatch(next)) {
                                if (this.indices[n * 2 + 1] <= 0) {
                                    this.indices[n * 2 + 1] = save;
                                }
                                return true;
                            }
                        } else if (op >= '\u0014') {
                            int n = op - 20;
                            int save = this.input;
                            if (this.regmatch(next)) {
                                if (this.indices[n * 2] <= 0) {
                                    this.indices[n * 2] = save;
                                }
                                return true;
                            }
                        }
                        return false;
                    }
                }
                scan = next;
            }
        }

        boolean compare(int scan) {
            char count = this.program[scan + 2];
            if (this.input + count > this.length) {
                return false;
            }
            int start = scan + 3;
            int end = start + count;
            for (int i = start; i < end; ++i) {
                if (this.str.charAt(this.input++) == this.program[i]) continue;
                return false;
            }
            return true;
        }

        boolean present(int scan) {
            char ch = this.str.charAt(this.input);
            char count = this.program[scan + 2];
            int start = scan + 3;
            int end = start + count;
            for (int i = start; i < end; ++i) {
                if (this.program[i] != ch) continue;
                return true;
            }
            return false;
        }

        int regrepeat(int scan) {
            char op = this.program[scan];
            int count = 0;
            switch (op) {
                case '\u0003': {
                    count = this.length - this.input;
                    this.input = this.length;
                    break;
                }
                case '\b': {
                    char ch = this.program[scan + 3];
                    while (this.input < this.length && this.str.charAt(this.input) == ch) {
                        ++this.input;
                        ++count;
                    }
                    break;
                }
                case '\u0004': {
                    while (this.input < this.length && this.present(scan)) {
                        ++this.input;
                        ++count;
                    }
                    break;
                }
                case '\u0005': {
                    while (this.input < this.length && !this.present(scan)) {
                        ++this.input;
                        ++count;
                    }
                    break;
                }
            }
            return count;
        }

        int regnext(int scan) {
            char offset = this.program[scan + 1];
            if (this.program[scan] == '\u0007') {
                return scan - offset;
            }
            return scan + offset;
        }
    }

    static class Compiler {
        char[] parse;
        int off;
        int npar;
        StringBuffer code;
        int flagp;
        static final String META = "^$.[()|?+*\\";
        static final String MULT = "*+?";
        static final int WORST = 0;
        static final int HASWIDTH = 1;
        static final int SIMPLE = 2;
        static final int SPSTART = 4;

        Compiler() {
        }

        int reg(boolean paren) throws IllegalArgumentException {
            int netFlags = 1;
            int parno = 0;
            int ret = -1;
            if (paren) {
                parno = this.npar++;
                if (this.npar >= 100) {
                    throw new IllegalArgumentException("too many ()");
                }
                ret = this.regnode((char)(20 + parno));
            }
            int br = this.regbranch();
            if (ret >= 0) {
                this.regtail(ret, br);
            } else {
                ret = br;
            }
            if ((this.flagp & 1) == 0) {
                netFlags &= 0xFFFFFFFE;
            }
            netFlags |= this.flagp & 4;
            while (this.off < this.parse.length && this.parse[this.off] == '|') {
                ++this.off;
                br = this.regbranch();
                this.regtail(ret, br);
                if ((this.flagp & 1) == 0) {
                    netFlags &= 0xFFFFFFFE;
                }
                netFlags |= this.flagp & 4;
            }
            int ender = this.regnode(paren ? (char)(120 + parno) : (char)'\u0000');
            this.regtail(ret, ender);
            br = ret;
            while (br >= 0) {
                this.regoptail(br, ender);
                br = this.regnext(br);
            }
            if (paren && (this.off >= this.parse.length || this.parse[this.off++] != ')')) {
                throw new IllegalArgumentException("missing )");
            }
            if (!paren && this.off < this.parse.length) {
                throw new IllegalArgumentException("unexpected )");
            }
            this.flagp = netFlags;
            return ret;
        }

        int regbranch() throws IllegalArgumentException {
            int netFlags = 0;
            int ret = this.regnode('\u0006');
            int chain = -1;
            while (this.off < this.parse.length && this.parse[this.off] != '|' && this.parse[this.off] != ')') {
                int latest = this.regpiece();
                netFlags |= this.flagp & 1;
                if (chain < 0) {
                    netFlags |= this.flagp & 4;
                } else {
                    this.regtail(chain, latest);
                }
                chain = latest;
            }
            if (chain < 0) {
                this.regnode('\t');
            }
            this.flagp = netFlags;
            return ret;
        }

        int regpiece() throws IllegalArgumentException {
            int netFlags;
            int ret = this.regatom();
            if (this.off >= this.parse.length || !Compiler.isMult(this.parse[this.off])) {
                return ret;
            }
            char op = this.parse[this.off];
            if ((this.flagp & 1) == 0 && op != '?') {
                throw new IllegalArgumentException("*+ operand could be empty");
            }
            int n = netFlags = op != '+' ? 4 : 1;
            if (op == '*' && (this.flagp & 2) != 0) {
                this.reginsert('\n', ret);
            } else if (op == '*') {
                this.reginsert('\u0006', ret);
                this.regoptail(ret, this.regnode('\u0007'));
                this.regoptail(ret, ret);
                this.regtail(ret, this.regnode('\u0006'));
                this.regtail(ret, this.regnode('\t'));
            } else if (op == '+' && (this.flagp & 2) != 0) {
                this.reginsert('\u000b', ret);
            } else if (op == '+') {
                int next = this.regnode('\u0006');
                this.regtail(ret, next);
                this.regtail(this.regnode('\u0007'), ret);
                this.regtail(next, this.regnode('\u0006'));
                this.regtail(ret, this.regnode('\t'));
            } else if (op == '?') {
                this.reginsert('\u0006', ret);
                this.regtail(ret, this.regnode('\u0006'));
                int next = this.regnode('\t');
                this.regtail(ret, next);
                this.regoptail(ret, next);
            }
            ++this.off;
            if (this.off < this.parse.length && Compiler.isMult(this.parse[this.off])) {
                throw new IllegalArgumentException("nested *?+");
            }
            this.flagp = netFlags;
            return ret;
        }

        int regatom() throws IllegalArgumentException {
            int ret;
            int netFlags = 0;
            switch (this.parse[this.off++]) {
                case '^': {
                    ret = this.regnode('\u0001');
                    break;
                }
                case '$': {
                    ret = this.regnode('\u0002');
                    break;
                }
                case '.': {
                    ret = this.regnode('\u0003');
                    netFlags |= 3;
                    break;
                }
                case '[': {
                    try {
                        if (this.parse[this.off] == '^') {
                            ret = this.regnode('\u0005');
                            ++this.off;
                        } else {
                            ret = this.regnode('\u0004');
                        }
                        int pos = this.reglen();
                        this.regc('\u0000');
                        if (this.parse[this.off] == ']' || this.parse[this.off] == '-') {
                            this.regc(this.parse[this.off++]);
                        }
                        while (this.parse[this.off] != ']') {
                            if (this.parse[this.off] == '-') {
                                char end;
                                ++this.off;
                                if (this.parse[this.off] == ']') {
                                    this.regc('-');
                                    continue;
                                }
                                char start = this.parse[this.off - 2];
                                if (start > (end = this.parse[this.off++])) {
                                    throw new IllegalArgumentException("invalid [] range");
                                }
                                for (int i = start + '\u0001'; i <= end; ++i) {
                                    this.regc((char)i);
                                }
                                continue;
                            }
                            this.regc(this.parse[this.off++]);
                        }
                        this.regset(pos, (char)(this.reglen() - pos - 1));
                        ++this.off;
                        netFlags |= 3;
                        break;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("missing ]");
                    }
                }
                case '(': {
                    ret = this.reg(true);
                    netFlags |= this.flagp & 5;
                    break;
                }
                case ')': 
                case '|': {
                    throw new IllegalArgumentException("internal urp");
                }
                case '*': 
                case '+': 
                case '?': {
                    throw new IllegalArgumentException("?+* follows nothing");
                }
                case '\\': {
                    if (this.off >= this.parse.length) {
                        throw new IllegalArgumentException("trailing \\");
                    }
                    ret = this.regnode('\b');
                    this.regc('\u0001');
                    this.regc(this.parse[this.off++]);
                    netFlags |= 3;
                    break;
                }
                default: {
                    int end;
                    --this.off;
                    for (end = this.off; end < this.parse.length && META.indexOf(this.parse[end]) < 0; ++end) {
                    }
                    if (end > this.off + 1 && end < this.parse.length && Compiler.isMult(this.parse[end])) {
                        --end;
                    }
                    netFlags |= 1;
                    if (end == this.off + 1) {
                        netFlags |= 2;
                    }
                    ret = this.regnode('\b');
                    this.regc((char)(end - this.off));
                    while (this.off < end) {
                        this.regc(this.parse[this.off]);
                        ++this.off;
                    }
                    break block1;
                }
            }
            this.flagp = netFlags;
            return ret;
        }

        int regnode(char op) {
            int ret = this.code.length();
            this.code.append(op);
            this.code.append('\u0000');
            return ret;
        }

        void regc(char b) {
            this.code.append(b);
        }

        int reglen() {
            return this.code.length();
        }

        void regset(int pos, char ch) {
            this.code.setCharAt(pos, ch);
        }

        void reginsert(char op, int pos) {
            char[] tmp = new char[]{op, '\u0000'};
            this.code.insert(pos, tmp);
        }

        void regtail(int pos, int val) {
            int tmp;
            int scan = pos;
            while ((tmp = this.regnext(scan)) >= 0) {
                scan = tmp;
            }
            int offset = this.code.charAt(scan) == '\u0007' ? scan - val : val - scan;
            this.code.setCharAt(scan + 1, (char)offset);
        }

        void regoptail(int pos, int val) {
            if (pos < 0 || this.code.charAt(pos) != '\u0006') {
                return;
            }
            this.regtail(pos + 2, val);
        }

        int regnext(int pos) {
            char offset = this.code.charAt(pos + 1);
            if (offset == '\u0000') {
                return -1;
            }
            if (this.code.charAt(pos) == '\u0007') {
                return pos - offset;
            }
            return pos + offset;
        }

        static boolean isMult(char ch) {
            return ch == '*' || ch == '+' || ch == '?';
        }
    }

    private static class SubspecFilter
    implements Filter {
        String subspec;
        boolean all;

        public SubspecFilter(String subspec, boolean all) {
            this.subspec = subspec;
            this.all = all;
        }

        public boolean filter(Regsub rs, StringBuffer sb) {
            Regexp.applySubspec(rs, this.subspec, sb);
            return this.all;
        }
    }

    public static interface Filter {
        public boolean filter(Regsub var1, StringBuffer var2);
    }
}

