/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.xml;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.xml.J2EEXMLResourceHandler;
import org.eclipse.jst.j2ee.internal.xml.XMLParseResourceHandler;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GeneralXmlDocumentReader {
    protected InputSource inputSource;
    protected EntityResolver entityResolver;
    protected ErrorHandler errorHandler;
    protected boolean doValidate = false;
    protected boolean doAllowJavaEncodings = false;

    public GeneralXmlDocumentReader() {
    }

    public GeneralXmlDocumentReader(InputSource source) {
        this.setInputSource(source);
    }

    public GeneralXmlDocumentReader(InputSource source, EntityResolver resolver, ErrorHandler handler) {
        this.setInputSource(source);
        this.setEntityResolver(resolver);
        this.setErrorHandler(handler);
    }

    protected EntityResolver createDefaultEntityResolver() {
        return null;
    }

    protected ErrorHandler createDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void warning(SAXParseException exception) throws SAXException {
                Logger.getLogger().logWarning(exception);
            }
        };
    }

    protected DocumentBuilder createNewDOMParser() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.setFeatures(dbf);
            return dbf.newDocumentBuilder();
        }
        catch (Exception ie) {
            this.handleException(J2EEXMLResourceHandler.getString(XMLParseResourceHandler.failed_instantiating_EXC_, new Object[]{"Failed to instantiate parser"}), ie);
            return null;
        }
    }

    public boolean doAllowJavaEncodings() {
        return this.doAllowJavaEncodings;
    }

    public boolean doValidate() {
        return this.doValidate;
    }

    public ClassLoader getClassLoader() {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public Document getDocument() {
        return this.parseDocument();
    }

    protected Document getDocument(DocumentBuilder domParser) {
        return domParser.newDocument();
    }

    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = this.createDefaultEntityResolver();
        }
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = this.createDefaultErrorHandler();
        }
        return this.errorHandler;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    protected void handleException(String aMessage, Throwable anException) {
        if (anException instanceof InvocationTargetException) {
            InvocationTargetException invocationEx = (InvocationTargetException)anException;
            if (invocationEx.getTargetException() != null) {
                this.handleException(aMessage, invocationEx.getTargetException());
            }
        } else {
            this.primHandleException(aMessage, anException);
        }
    }

    protected Document parse(DocumentBuilder domParser, InputSource is) {
        try {
            return domParser.parse(is);
        }
        catch (SAXException ex) {
            this.handleException(J2EEXMLResourceHandler.getString(XMLParseResourceHandler.failed_instantiating_EXC_, new Object[]{"SAX Parser error"}), ex);
        }
        catch (IOException ex) {
            this.handleException(J2EEXMLResourceHandler.getString(XMLParseResourceHandler.failed_instantiating_EXC_, new Object[]{"IO Exception on input stream"}), ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseDocument() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DocumentBuilder parser2 = this.createNewDOMParser();
            this.setEntityResolver(parser2);
            this.setErrorHandler(parser2);
            Document document = this.parse(parser2, this.getInputSource());
            return document;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    protected void primHandleException(String aMessage, Throwable anException) {
        Logger.getLogger().logError(anException);
        throw new RuntimeException(aMessage);
    }

    public void setAllowJavaEncodings(boolean newAllowJavaEncodings) {
        this.doAllowJavaEncodings = newAllowJavaEncodings;
    }

    protected void setEntityResolver(DocumentBuilder domParser) {
        if (this.getEntityResolver() != null) {
            domParser.setEntityResolver(this.getEntityResolver());
        }
    }

    public void setEntityResolver(EntityResolver newEntityResolver) {
        this.entityResolver = newEntityResolver;
    }

    protected void setErrorHandler(DocumentBuilder domParser) {
        if (this.getErrorHandler() != null) {
            domParser.setErrorHandler(this.getErrorHandler());
        }
    }

    public void setErrorHandler(ErrorHandler newErrorHandler) {
        this.errorHandler = newErrorHandler;
    }

    protected void setFeatures(DocumentBuilderFactory domParser) {
        try {
            domParser.setValidating(this.doValidate());
            domParser.setAttribute("http://apache.org/xml/features/allow-java-encodings", new Boolean(this.doAllowJavaEncodings()));
            domParser.setExpandEntityReferences(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setInputSource(InputSource newInputSource) {
        this.inputSource = newInputSource;
    }

    public void setValidate(boolean newValidate) {
        this.doValidate = newValidate;
    }
}

