/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestOperation;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.operations.UpdateJavaBuildPathOperation;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JARDependencyOperation
extends AbstractDataModelOperation
implements JARDependencyDataModelProperties {
    static /* synthetic */ Class class$0;

    public JARDependencyOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    private void saveModel(ClasspathModel model, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        if (!model.isDirty()) {
            return;
        }
        this.validateEdit(model);
        monitor.beginTask("", 2);
        UpdateManifestOperation mfOperation = this.createManifestOperation(model);
        this.createBuildPathOperation(model);
        try {
            mfOperation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1), null);
        }
        catch (Exception e) {
            Logger.getLogger().logError(e);
        }
    }

    protected void validateEdit(ClasspathModel aModel) throws CoreException {
        Set affectedFiles = aModel.getAffectedFiles();
        IFile[] files = affectedFiles.toArray(new IFile[affectedFiles.size()]);
        IStatus result = J2EEPlugin.getWorkspace().validateEdit(files, null);
        if (!result.isOK()) {
            throw new CoreException(result);
        }
    }

    protected UpdateJavaBuildPathOperation createBuildPathOperation(ClasspathModel aModel) {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)aModel.getProject());
        return new UpdateJavaBuildPathOperation(javaProject, aModel.getClassPathSelection());
    }

    private UpdateManifestOperation createManifestOperation(ClasspathModel aModel) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel(clazz);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", aModel.getProject().getName());
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", UpdateManifestDataModelProvider.convertClasspathStringToList(aModel.getClassPathSelection().toString()));
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", J2EEProjectUtilities.getManifestFile(aModel.getProject()));
        return new UpdateManifestOperation(updateManifestDataModel);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        IProject proj = ProjectUtilities.getProject(this.model.getStringProperty("UpdateManifestDataModel.PROJECT_NAME"));
        IProject earProject = ProjectUtilities.getProject(this.model.getStringProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME"));
        ClasspathModel clpModel = new ClasspathModel(null);
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
        if (!earComponent.exists()) {
            return OK_STATUS;
        }
        clpModel.setSelectedEARComponent(earComponent);
        clpModel.setProject(proj);
        try {
            int jarManipulationType = this.model.getIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE");
            switch (jarManipulationType) {
                case 0: {
                    List jarList = (List)this.model.getNestedModel("AbstractJARDependencyDataModel.NESTED_MODEL_UPDATE_MAINFEST").getProperty("UpdateManifestDataModel.CLASSPATH_LIST");
                    if (!jarList.isEmpty()) {
                        int i = 0;
                        while (i < jarList.size()) {
                            String jarName = (String)jarList.get(i);
                            clpModel.selectDependencyIfNecessary(jarName);
                            ++i;
                        }
                        break;
                    } else {
                        IProject refproj = ProjectUtilities.getProject(this.model.getStringProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME"));
                        clpModel.selectDependencyIfNecessary(refproj);
                        break;
                    }
                }
                case 1: {
                    List jarList = (List)this.model.getNestedModel("AbstractJARDependencyDataModel.NESTED_MODEL_UPDATE_MAINFEST").getProperty("UpdateManifestDataModel.CLASSPATH_LIST");
                    int i = 0;
                    while (i < jarList.size()) {
                        String jarName = (String)jarList.get(i);
                        clpModel.removeDependency(jarName);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    IProject refproj = ProjectUtilities.getProject(this.model.getStringProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME"));
                    IProject oppositeProject = ProjectUtilities.getProject(this.model.getStringProperty("AbstractJARDependencyDataModel.OPPOSITE_PROJECT_NAME"));
                    clpModel.getClassPathSelection().invertClientJARSelection(refproj, oppositeProject);
                    break;
                }
            }
            if (clpModel.isDirty()) {
                try {
                    this.saveModel(clpModel, monitor);
                }
                catch (InvocationTargetException e) {
                    Logger.getLogger().logError(e);
                }
                catch (InterruptedException e) {
                    Logger.getLogger().logError(e);
                }
                catch (CoreException e) {
                    Logger.getLogger().logError(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            if (clpModel != null) {
                clpModel.dispose();
            }
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_20 = null;
            if (clpModel != null) {
                clpModel.dispose();
            }
            if (monitor == null) return OK_STATUS;
        }
        monitor.done();
        return OK_STATUS;
    }
}

