/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEEObjectImpl;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.ejb.internal.util.MethodElementHelper;

public class MethodElementImpl
extends J2EEEObjectImpl
implements MethodElement {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String PARMS_EDEFAULT = null;
    protected String parms = PARMS_EDEFAULT;
    protected static final MethodElementKind TYPE_EDEFAULT = MethodElementKind.UNSPECIFIED_LITERAL;
    protected MethodElementKind type = TYPE_EDEFAULT;
    protected boolean typeESet = false;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected EnterpriseBean enterpriseBean = null;
    protected EList descriptions = null;

    protected EClass eStaticClass() {
        return EjbPackage.Literals.METHOD_ELEMENT;
    }

    public void addMethodParams(String param) {
        String oldParms = this.getParms();
        if (oldParms == null) {
            this.setParms(param);
        } else {
            this.setParms(oldParms.concat(" ").concat(param));
        }
    }

    public void applyZeroParams() {
        this.setParms("");
    }

    public boolean equalSignature(MethodElement anotherMethodElement) {
        boolean equal = this.getName().equals(anotherMethodElement.getName());
        if (equal && (equal = this.parmsEqual(anotherMethodElement))) {
            equal = this.getType() == null ? anotherMethodElement.getType() == null : this.getType().equals(anotherMethodElement.getType());
        }
        return equal;
    }

    public List getMethodParams() {
        StringTokenizer tok = this.getMethodParamsTokenizer();
        ArrayList<String> v = new ArrayList<String>();
        ArrayList<String> paramsList = new ArrayList<String>();
        String current = null;
        if (tok != null) {
            while (current != null || tok.hasMoreTokens()) {
                String peek = null;
                if (current == null) {
                    current = tok.nextToken();
                }
                if (tok.hasMoreTokens() && (peek = tok.nextToken()).startsWith("[")) {
                    current = current + peek;
                    peek = null;
                }
                v.add(current);
                if (peek != null) {
                    current = peek;
                    continue;
                }
                current = null;
            }
        }
        for (int i = 0; i < v.size(); ++i) {
            tok = new StringTokenizer((String)v.get(i), ",");
            if (tok == null) continue;
            while (tok.hasMoreTokens()) {
                paramsList.add(tok.nextToken());
            }
        }
        return paramsList;
    }

    private StringTokenizer getMethodParamsTokenizer() {
        String aParms = this.getParms();
        if (aParms == null || aParms.length() == 0) {
            return null;
        }
        return new StringTokenizer(this.getParms());
    }

    public Method[] getMethods() {
        EnterpriseBean ejb = this.getEnterpriseBean();
        if (ejb == null) {
            return new Method[0];
        }
        List result = null;
        switch (this.getType().getValue()) {
            case 2: {
                result = this.getMethods(ejb.getHomeInterface());
                break;
            }
            case 1: {
                result = this.getMethods(ejb.getRemoteInterface());
                break;
            }
            case 4: {
                result = this.getMethods(ejb.getLocalHomeInterface());
                break;
            }
            case 3: {
                result = this.getMethods(ejb.getLocalInterface());
                break;
            }
            case 5: {
                if (ejb.isSession()) {
                    result = this.getMethods(((Session)ejb).getServiceEndpoint());
                    break;
                }
            }
            case 0: {
                if (ejb.isMessageDriven()) {
                    result = this.getMethods(ejb.getEjbClass());
                    break;
                }
                result = new ArrayList();
                result.addAll(this.getMethods(ejb.getHomeInterface()));
                result.addAll(this.getMethods(ejb.getRemoteInterface()));
                result.addAll(this.getMethods(ejb.getLocalHomeInterface()));
                result.addAll(this.getMethods(ejb.getLocalInterface()));
            }
        }
        return result.toArray(new Method[result.size()]);
    }

    private List getMethods(JavaClass javaClass) {
        if (javaClass == null) {
            return Collections.EMPTY_LIST;
        }
        List<Method> result = null;
        String methodName = this.getName().trim();
        if (this.name.equals("*")) {
            result = javaClass.getPublicMethodsExtended();
        } else if (this.hasMethodParams()) {
            result = new ArrayList();
            Method method2 = javaClass.getPublicMethodExtended(this.name, this.getMethodParams());
            if (method2 != null) {
                result.add(method2);
            }
        } else {
            result = javaClass.getPublicMethodsExtendedNamed(methodName);
        }
        return result;
    }

    public MethodElement getMostSpecific(MethodElement aMethodElement, JavaClass aClass) {
        if (aMethodElement == null) {
            return this;
        }
        if (aMethodElement.isDefault() && !this.isDefault()) {
            return this;
        }
        if (!aMethodElement.isDefault() && this.isDefault()) {
            return aMethodElement;
        }
        if (aMethodElement.hasMethodParams() && !this.hasMethodParams()) {
            return aMethodElement;
        }
        if (!aMethodElement.hasMethodParams() && this.hasMethodParams()) {
            return this;
        }
        if (this.isUnspecified() && !aMethodElement.isUnspecified()) {
            return aMethodElement;
        }
        return this;
    }

    public static MethodElement getMostSpecificMethodElement(List methodElements, Method aMethod) {
        MethodElement specificME = null;
        if (aMethod != null) {
            for (MethodElement me : methodElements) {
                if (!me.represents(aMethod)) continue;
                if (me.uniquelyIdentifies(aMethod)) {
                    return me;
                }
                if (specificME == null) {
                    specificME = me;
                    continue;
                }
                specificME = specificME.getMostSpecific(me, aMethod.getJavaClass());
            }
        }
        return specificME;
    }

    protected String getParmsString() {
        String parmString = this.getParms();
        if (parmString == null) {
            parmString = "";
        }
        return parmString;
    }

    public static String[] getPossibleTypeNames() {
        EjbPackage pack = EjbFactoryImpl.getPackage();
        EList literals = pack.getMethodElementKind().getELiterals();
        String[] names = new String[literals.size()];
        for (int i = 0; i < literals.size(); ++i) {
            names[i] = literals.get(i).toString();
        }
        return names;
    }

    public String getSignature() {
        if (this.isDefault()) {
            return this.getName();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        if (this.hasMethodParams()) {
            buf.append("(");
            StringTokenizer tok = this.getMethodParamsTokenizer();
            if (tok != null) {
                while (tok.hasMoreTokens()) {
                    buf.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    buf.append(",");
                }
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public JavaClass getTypeJavaClass() {
        if (this.isHome()) {
            return this.getEnterpriseBean().getHomeInterface();
        }
        if (this.isRemote()) {
            return this.getEnterpriseBean().getRemoteInterface();
        }
        if (this.isLocalHome()) {
            return this.getEnterpriseBean().getLocalHomeInterface();
        }
        if (this.isLocal()) {
            return this.getEnterpriseBean().getLocalInterface();
        }
        if (this.isUnspecified() && this.getEnterpriseBean().isMessageDriven()) {
            return this.getEnterpriseBean().getEjbClass();
        }
        return null;
    }

    public boolean hasMethodParams() {
        return this.getParms() != null;
    }

    public void initializeFromSignature(String aSignature) {
        this.parseSignature(aSignature);
    }

    public boolean isDefault() {
        return "*".equals(this.getName());
    }

    public boolean isEquivalent(MethodElement anotherMethodElement) {
        boolean equal = this.equalSignature(anotherMethodElement);
        if (equal) {
            equal = this.getEnterpriseBean() == anotherMethodElement.getEnterpriseBean();
        }
        return equal;
    }

    public boolean isHome() {
        return this.getType().getValue() == 2;
    }

    public boolean isRemote() {
        return this.getType().getValue() == 1;
    }

    public boolean isUnspecified() {
        return this.getType().getValue() == 0;
    }

    public boolean isLocalHome() {
        return this.getType().getValue() == 4;
    }

    public boolean isLocal() {
        return this.getType().getValue() == 3;
    }

    public boolean isValid() {
        return this.getMethods().length > 0;
    }

    public boolean matchesParams(Method aMethod) {
        if (aMethod == null) {
            return false;
        }
        List params = this.getMethodParams();
        JavaParameter[] methodParams = aMethod.listParametersWithoutReturn();
        if (params.size() != methodParams.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            String parameterType = ((JavaHelpers)methodParams[i].getEType()).getQualifiedName();
            if (params.get(i).equals(parameterType)) continue;
            return false;
        }
        return true;
    }

    public boolean nameAndParamsEquals(Method aMethod) {
        if (aMethod != null && this.getName().equals(aMethod.getName())) {
            if (this.hasMethodParams()) {
                return this.matchesParams(aMethod);
            }
            return false;
        }
        return false;
    }

    protected boolean parmsEqual(MethodElement me) {
        if (me == null) {
            return false;
        }
        List myParms = this.getMethodParams();
        List otherParms = me.getMethodParams();
        if (myParms.size() != otherParms.size()) {
            return false;
        }
        for (int i = 0; i < myParms.size(); ++i) {
            if (myParms.get(i).equals(otherParms.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void parseSignature(String aSignature) {
        int index = aSignature.indexOf("(");
        int endIndex = aSignature.indexOf(")");
        if (endIndex < 0) {
            endIndex = aSignature.length() - 1;
        }
        if (index < 0) {
            this.setName(aSignature);
            this.setParms(null);
        } else {
            String sigName = aSignature.substring(0, index);
            this.setName(sigName);
            String sigParms = aSignature.substring(index + 1, endIndex);
            if (sigParms.length() > 0) {
                char commaChar = ",".charAt(0);
                char[] sigParmsChars = sigParms.toCharArray();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < sigParmsChars.length; ++i) {
                    if (sigParmsChars[i] != commaChar) {
                        buf.append(sigParmsChars[i]);
                        continue;
                    }
                    this.addMethodParams(buf.toString());
                    buf = new StringBuffer();
                }
                this.addMethodParams(buf.toString());
            } else {
                this.applyZeroParams();
            }
        }
    }

    public void removeMethodParams(String param) {
        String myParams = this.getParms();
        if (myParams == null || myParams.length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(myParams);
        StringBuffer newParms = new StringBuffer();
        while (tok.hasMoreElements()) {
            String token = tok.nextToken();
            if (token.equals(param)) continue;
            newParms.append(token);
            newParms.append(" ");
        }
        this.setParms(newParms.toString().trim());
    }

    public boolean represents(Method aMethod) {
        if (aMethod != null && (this.isUnspecified() || this.typeClassImplementsInterface(aMethod.getJavaClass()))) {
            if (this.isDefault()) {
                return true;
            }
            if (this.getName().equals(aMethod.getName())) {
                if (this.hasMethodParams()) {
                    return this.matchesParams(aMethod);
                }
                return true;
            }
        }
        return false;
    }

    public void setIdToReadableString() {
        String aParms = this.getParms() == null ? "" : "_" + this.getParms().replace(' ', '_');
        String prefix = "";
        switch (MethodElementHelper.getContainedType(this)) {
            case 1: {
                prefix = ((XMIResource)this.eContainer.eResource()).getID(this.eContainer);
                break;
            }
            case 2: {
                prefix = ((XMIResource)this.eContainer.eResource()).getID(this.eContainer);
            }
        }
        ((XMIResource)this.eResource()).setID(this, prefix + "_" + this.getEnterpriseBean().getName() + "_" + this.getName() + aParms);
    }

    protected boolean typeClassImplementsInterface(JavaClass anInterface) {
        if (this.getTypeJavaClass() == null || anInterface == null) {
            return false;
        }
        return this.getTypeJavaClass().implementsInterface(anInterface);
    }

    public boolean uniquelyIdentifies(Method aMethod) {
        if (aMethod != null && this.getTypeJavaClass() != null && this.typeClassImplementsInterface(aMethod.getJavaClass()) && this.getName().equals(aMethod.getName())) {
            if (this.hasMethodParams()) {
                return this.matchesParams(aMethod);
            }
            return aMethod.listParametersWithoutReturn().length == 0;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    public String getParms() {
        return this.parms;
    }

    public void setParms(String newParms) {
        String oldParms = this.parms;
        this.parms = newParms;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldParms, (Object)this.parms));
        }
    }

    public MethodElementKind getType() {
        return this.type;
    }

    public void setType(MethodElementKind newType) {
        MethodElementKind oldType = this.type;
        this.type = newType == null ? TYPE_EDEFAULT : newType;
        boolean oldTypeESet = this.typeESet;
        this.typeESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldType, (Object)this.type, !oldTypeESet));
        }
    }

    public void unsetType() {
        MethodElementKind oldType = this.type;
        boolean oldTypeESet = this.typeESet;
        this.type = TYPE_EDEFAULT;
        this.typeESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 2, (Object)oldType, (Object)TYPE_EDEFAULT, oldTypeESet));
        }
    }

    public boolean isSetType() {
        return this.typeESet;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDescription, (Object)this.description));
        }
    }

    public EnterpriseBean getEnterpriseBean() {
        if (this.enterpriseBean != null && this.enterpriseBean.eIsProxy()) {
            InternalEObject oldEnterpriseBean = (InternalEObject)((Object)this.enterpriseBean);
            this.enterpriseBean = (EnterpriseBean)this.eResolveProxy(oldEnterpriseBean);
            if (this.enterpriseBean != oldEnterpriseBean && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldEnterpriseBean, (Object)this.enterpriseBean));
            }
        }
        return this.enterpriseBean;
    }

    public EnterpriseBean basicGetEnterpriseBean() {
        return this.enterpriseBean;
    }

    public void setEnterpriseBean(EnterpriseBean newEnterpriseBean) {
        EnterpriseBean oldEnterpriseBean = this.enterpriseBean;
        this.enterpriseBean = newEnterpriseBean;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldEnterpriseBean, (Object)this.enterpriseBean));
        }
    }

    public EList getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new EObjectContainmentEList(Description.class, this, 5);
        }
        return this.descriptions;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getDescriptions()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getParms();
            }
            case 2: {
                return this.getType();
            }
            case 3: {
                return this.getDescription();
            }
            case 4: {
                if (resolve) {
                    return this.getEnterpriseBean();
                }
                return this.basicGetEnterpriseBean();
            }
            case 5: {
                return this.getDescriptions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setParms((String)newValue);
                return;
            }
            case 2: {
                this.setType((MethodElementKind)newValue);
                return;
            }
            case 3: {
                this.setDescription((String)newValue);
                return;
            }
            case 4: {
                this.setEnterpriseBean((EnterpriseBean)newValue);
                return;
            }
            case 5: {
                this.getDescriptions().clear();
                this.getDescriptions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setParms(PARMS_EDEFAULT);
                return;
            }
            case 2: {
                this.unsetType();
                return;
            }
            case 3: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 4: {
                this.setEnterpriseBean(null);
                return;
            }
            case 5: {
                this.getDescriptions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return PARMS_EDEFAULT == null ? this.parms != null : !PARMS_EDEFAULT.equals(this.parms);
            }
            case 2: {
                return this.isSetType();
            }
            case 3: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 4: {
                return this.enterpriseBean != null;
            }
            case 5: {
                return this.descriptions != null && !this.descriptions.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", parms: ");
        result.append(this.parms);
        result.append(", type: ");
        if (this.typeESet) {
            result.append(this.type);
        } else {
            result.append("<unset>");
        }
        result.append(", description: ");
        result.append(this.description);
        result.append(')');
        return result.toString();
    }
}

