/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.j2ee.common.CompatibilityDescriptionGroup;
import org.eclipse.jst.j2ee.commonarchivecore.internal.AnnotationsProcessor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.BindingType;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsProcessorException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ExportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.AnnotationsProcessorFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.MergeDataImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public abstract class ModuleFileImpl
extends ArchiveImpl
implements ModuleFile {
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected ImportStrategy importStrategy;
    protected ExportStrategy exportStrategy;
    private static final String className = ModuleFileImpl.class.getName();
    private static AnnotationsProcessor annotationsProcessor = null;
    private boolean _generatedDD = false;
    private Object _ammStore = null;
    private int moduleVersion = -1;

    protected void checkAddValid(String aUri) throws DuplicateObjectException {
        String methodName = "checkAddValid";
        super.checkAddValid(aUri);
        if (File.separatorChar == '\\') {
            aUri = aUri.replace('\\', '/');
        }
        if (aUri.equals(this.getDeploymentDescriptorUri())) {
            logger.logp(Level.FINER, className, methodName, "Warning: Adding file for descriptor [ {0} ]", aUri);
        } else {
            String useMergedDD = this.getMergedDeploymentDescriptorUri();
            if (useMergedDD != null && aUri.equals(useMergedDD)) {
                logger.logp(Level.FINER, className, methodName, "Warning: Adding file for merged descriptor [ {0} ]", aUri);
            }
        }
    }

    public String getMergedDeploymentDescriptorUri() {
        return null;
    }

    protected Resource removeResource(String uriText) {
        String methodName = "removeResource";
        logger.logp(Level.FINER, className, methodName, "ENTER - resource [ {0} ]", uriText);
        URI uri = URI.createURI(uriText);
        ResourceSet resourceSet = this.getResourceSet();
        EList resources = resourceSet.getResources();
        Iterator useResources = resources.iterator();
        Resource selectedResource = null;
        while (selectedResource == null && useResources.hasNext()) {
            Resource nextResource = (Resource)useResources.next();
            URI nextResourceURI = nextResource.getURI();
            if (nextResourceURI == null || !nextResourceURI.equals(uri)) continue;
            selectedResource = nextResource;
        }
        if (selectedResource != null) {
            logger.logp(Level.FINER, className, methodName, "Resource detected");
            resources.remove(selectedResource);
            if (resourceSet instanceof ResourceSetImpl) {
                Map resourceMap = ((ResourceSetImpl)resourceSet).getURIResourceMap();
                if (resourceMap != null) {
                    Resource mappedResource = (Resource)resourceMap.remove(uri);
                    if (mappedResource != null) {
                        logger.logp(Level.FINER, className, methodName, "Mapped resource detected and removed");
                    } else {
                        logger.logp(Level.FINER, className, methodName, "No mapped resource detected");
                    }
                } else {
                    logger.logp(Level.FINER, className, methodName, "No resource mapping is active");
                }
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "Resource not detected");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
        return selectedResource;
    }

    protected boolean discard(Object object) {
        return object != null;
    }

    protected abstract String getDDObjectId();

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.MODULE_FILE;
    }

    protected boolean canLazyInitialize() {
        return this.getImportStrategy() != null;
    }

    public Resource getDeploymentDescriptorResource() throws FileNotFoundException, ResourceLoadException {
        return this.getMofResource(this.getDeploymentDescriptorUri());
    }

    protected void cleanupOnClose() {
    }

    public void close() {
        super.close();
    }

    public EARFile getEARFile() {
        String methodName = "getEARFile";
        logger.entering(className, methodName, this.getURI());
        Container aContainer = this.getContainer();
        if (aContainer == null || !aContainer.isEARFile()) {
            logger.logp(Level.FINER, className, methodName, "Container is [ {0} ]", aContainer);
            if (aContainer != null) {
                logger.logp(Level.FINER, className, methodName, "Container is an instance of [ {0} ]", aContainer.getClass());
            }
            logger.logp(Level.FINER, className, methodName, "Container is not an EAR file.");
            aContainer = this.getLoadingContainer();
            if (aContainer == null || !aContainer.isEARFile()) {
                logger.logp(Level.FINER, className, methodName, "Loading Container is [ {0} ]", aContainer);
                if (aContainer != null) {
                    logger.logp(Level.FINER, className, methodName, "Loading Container is an instance of [ {0} ]", aContainer.getClass());
                }
                logger.logp(Level.FINER, className, methodName, "RETURN Cannot find EAR file container.");
                return null;
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", aContainer);
        return (EARFile)aContainer;
    }

    protected void processMergeException(Exception e) {
        String exceptionClassName;
        String methodName = "processMergeException";
        String NOSUCHCLASS = "class com.ibm.wsspi.amm.exception.NoSuchClassException";
        String GETCLASSNAME = "getClassName";
        if (e instanceof AnnotationsProcessorException) {
            e = ((AnnotationsProcessorException)e).getNestedException();
        }
        if (!(exceptionClassName = e.getClass().toString()).equals(NOSUCHCLASS)) {
            logger.logp(Level.SEVERE, className, methodName, "Annotations scanning of archive [ {0} ] completed with errors.", this.getURI());
            logger.logp(Level.SEVERE, className, methodName, "Annotations error:", e);
            return;
        }
        String classNotFound = null;
        Class<?> noSuchClass = e.getClass();
        try {
            Method meth = noSuchClass.getMethod(GETCLASSNAME, new Class[0]);
            Object retobj = meth.invoke((Object)e, new Object[0]);
            classNotFound = (String)retobj;
        }
        catch (Exception unexpected) {
            logger.logp(Level.SEVERE, className, methodName, "Annotations scanning of archive [ {0} ] completed with errors.", this.getURI());
            logger.logp(Level.SEVERE, className, methodName, "Annotations error:", e);
            return;
        }
        this.processNoSuchClassException(classNotFound);
    }

    protected void processNoSuchClassException(String classname) {
        String methodName = "processNoSuchClassException";
        boolean foundClass = false;
        logger.logp(Level.SEVERE, className, methodName, "Annotations scanning of archive [ {0} ] completed with errors.  Could not find class [ {1} ].", new Object[]{this.getURI(), classname});
        String classnameURI = classname.replace('.', '/') + ".class";
        EARFile ear = this.getEARFile();
        if (ear != null) {
            if (this.getEARFile().containsFile(classnameURI)) {
                logger.logp(Level.SEVERE, className, methodName, "Class [ {0} ] has been found in archive [ {1} ].", new Object[]{classnameURI, ear.getURI()});
                foundClass = true;
            }
            if (this.lookForClassInChildArchives(classnameURI, ear)) {
                foundClass = true;
            }
        }
        if (foundClass) {
            logger.logp(Level.SEVERE, className, methodName, "There may be manifest or classpath issues with archive [ {0} ].", this.getURI());
        }
    }

    private boolean lookForClassInChildArchives(String classnameURI, Archive parentArchive) {
        String methodName = "lookForClassInChildArchives";
        boolean foundClass = false;
        List children = parentArchive.getArchiveFiles();
        String parentArchiveURI = parentArchive.getURI();
        if (children != null) {
            for (Archive childArchive : children) {
                String swizzledName;
                String childArchiveURI = childArchive.getURI();
                if (childArchive.containsFile(classnameURI)) {
                    logger.logp(Level.SEVERE, className, methodName, "Class [ {0} ] has been found in [ {1} ] in child archive [ {2} ].", new Object[]{classnameURI, parentArchiveURI, childArchiveURI});
                    foundClass = true;
                }
                if (childArchive.isWARFile() && childArchive.containsFile(swizzledName = ArchiveUtil.concatUri("WEB-INF/classes/", classnameURI, '/'))) {
                    logger.logp(Level.SEVERE, className, methodName, "Class [ {0} ] has been found in [ {1} ] in child archive [ {2} ].", new Object[]{swizzledName, parentArchiveURI, childArchiveURI});
                    foundClass = true;
                }
                if (!this.lookForClassInChildArchives(classnameURI, childArchive)) continue;
                foundClass = true;
            }
        }
        return foundClass;
    }

    public ExportStrategy getExportStrategy() {
        return this.exportStrategy;
    }

    public ImportStrategy getImportStrategy() {
        return this.importStrategy;
    }

    public String getSpecVersion() {
        float ver = this.getSpecVersionID();
        Float specVersion = new Float(ver / 10.0f);
        return specVersion.toString();
    }

    public int getSpecVersionID() {
        try {
            return ((XMLResource)this.getDeploymentDescriptorResource()).getModuleVersionID();
        }
        catch (FileNotFoundException fileNotFoundE) {
            return this.getNoDescriptorVersionID();
        }
        catch (ResourceLoadException resourceLoadE) {
            return this.getNoDescriptorVersionID();
        }
        catch (Exception e) {
            throw new ArchiveRuntimeException(e);
        }
    }

    public boolean isModuleFile() {
        return true;
    }

    public abstract EObject makeDeploymentDescriptor(XMLResource var1);

    public Resource makeDeploymentDescriptorResource() {
        XMLResource resource = null;
        try {
            resource = (XMLResource)this.makeMofResource(this.getDeploymentDescriptorUri());
        }
        catch (DuplicateObjectException ex) {
            try {
                return this.getDeploymentDescriptorResource();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.makeDeploymentDescriptor(resource);
        return resource;
    }

    public void save(SaveStrategy aSaveStrategy) throws SaveFailureException {
        String methodName = "save";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this.getURI());
        this.setSaveStrategy(aSaveStrategy);
        if (this.getExportStrategy() != null) {
            this.getExportStrategy().preSave(aSaveStrategy);
        }
        this.preSave(aSaveStrategy);
        super.save(aSaveStrategy);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void setExportStrategy(ExportStrategy newExportStrategy) {
        this.exportStrategy = newExportStrategy;
        if (newExportStrategy != null) {
            newExportStrategy.setArchive(this);
        }
    }

    public void setImportStrategy(ImportStrategy newImportStrategy) {
        this.importStrategy = newImportStrategy;
        if (newImportStrategy != null) {
            newImportStrategy.setArchive(this);
        }
    }

    public void setJ2EEVersion(int versionID) {
        try {
            ((XMLResource)this.getDeploymentDescriptorResource()).setVersionID(versionID);
        }
        catch (ResourceLoadException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new ArchiveRuntimeException(e);
        }
    }

    protected AnnotationsProcessor getAnnotationsProcessor() {
        String methodName = "getAnnotationsProcessor";
        logger.entering(className, methodName);
        if (annotationsProcessor == null) {
            annotationsProcessor = AnnotationsProcessorFactoryImpl.getInstance().create();
        }
        logger.exiting(className, methodName);
        return annotationsProcessor;
    }

    protected MergeData createMergeData(EObject deploymentDescriptor) {
        String methodName = "createMergeData";
        MergeDataImpl mergeData = new MergeDataImpl(this, deploymentDescriptor);
        logger.logp(Level.FINER, className, methodName, "mergeData={0}", mergeData);
        return mergeData;
    }

    protected EObject copyDeploymentDescriptor(EObject dd) {
        EObject newDD;
        String methodName = "copyDeploymentDescriptor";
        logger.entering(className, methodName);
        logger.logp(Level.FINER, className, methodName, "Attempting to copy deployment descriptor.");
        try {
            newDD = (EObject)((CompatibilityDescriptionGroup)dd).clone();
        }
        catch (CloneNotSupportedException e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.WARNING, className, methodName, "Clone failure; answering original DD");
            return dd;
        }
        this.updateCopiedDDResource(dd, newDD);
        logger.logp(Level.FINER, className, methodName, "Copy complete - new Deployment Descriptor: {0}", newDD);
        return newDD;
    }

    private void updateCopiedDDResource(EObject oldDD, EObject newDD) {
        Resource oldResource = oldDD.eResource();
        ResourceSet resourceSet = oldResource.getResourceSet();
        URI originalUri = oldResource.getURI();
        String uriPath = originalUri.path();
        int extensionLocation = uriPath.length() - 4;
        URI mergedURI = URI.createURI(uriPath.substring(0, extensionLocation) + "_merged" + uriPath.substring(extensionLocation));
        Resource newResource = resourceSet.createResource(originalUri);
        newResource.setURI(mergedURI);
        newResource.getContents().add(newDD);
        XMLResource newXMLResource = (XMLResource)newResource;
        newXMLResource.setID(newDD, this.getDDObjectId());
        int oldVersionID = ((XMLResource)oldResource).getVersionID();
        newXMLResource.setVersionID(oldVersionID);
    }

    public boolean isGeneratedDD() {
        return this._generatedDD;
    }

    public void setGeneratedDD(boolean generatedDD) {
        this._generatedDD = generatedDD;
    }

    public boolean isModuleVersionSet() {
        return this.moduleVersion != -1;
    }

    public int getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(int version) {
        this.moduleVersion = version;
    }

    public void setAMMStore(Object o) {
        this._ammStore = o;
    }

    public Object getAMMStore() {
        return this._ammStore;
    }

    public BindingType getBindingType(String bindingName) {
        return null;
    }

    public boolean requiresIterationOnSave() {
        return false;
    }

    public void preSave(SaveStrategy aStrategy) throws SaveFailureException {
        String methodName = "preSave";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void setModified(String resourcePath) throws SaveFailureException {
        String logText;
        FileNotFoundException fileException;
        ResourceLoadException loadException;
        Resource resource;
        String methodName = "setModified";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ]", new Object[]{this.getURI(), resourcePath});
        try {
            resource = !this.containsFile(resourcePath) ? null : this.getMofResource(resourcePath);
            loadException = null;
            fileException = null;
        }
        catch (ResourceLoadException e) {
            resource = null;
            loadException = e;
            fileException = null;
        }
        catch (FileNotFoundException e) {
            resource = null;
            loadException = null;
            fileException = e;
        }
        if (loadException != null) {
            SaveFailureException sfe = new SaveFailureException("Failed to mark [ " + resourcePath + " ] in [ " + this.getURI() + " ]", loadException);
            logger.throwing(className, methodName, loadException);
            logger.throwing(className, methodName, sfe);
            String logText2 = "RETURN - Load Failure: " + sfe.getMessage() + " - " + loadException.getMessage() + ": Skipping mark as modified";
            logger.logp(Level.FINER, className, methodName, logText2);
            throw sfe;
        }
        if (fileException != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.throwing(className, methodName, fileException);
            }
            logText = "RETURN - Resource not present: Skipping mark as modified";
            logger.logp(Level.FINER, className, methodName, logText);
        } else {
            if (resource != null) {
                if (!resource.isModified()) {
                    resource.setModified(true);
                    logText = "RETURN - Resource present and not modified: Setting modified";
                } else {
                    logText = "RETURN - Resource present and not modified: Skipping mark as modified";
                }
            } else {
                logText = "RETURN - Resource not present and not modified: Skipping mark as modified";
            }
            logger.logp(Level.FINER, className, methodName, logText);
        }
    }
}

