/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ApplicationClientFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBJarFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl;

public class MergeDataImpl
implements MergeData {
    private ModuleFile moduleFile;
    private EObject deploymentDescriptor;
    private EObject altDeploymentDescriptor;

    public MergeDataImpl(ModuleFile moduleFile, EObject deploymentDescriptor) throws AnnotationsException {
        if (moduleFile == null) {
            throw new AnnotationsException("The ModuleFile parameter for MergeData can not be null.");
        }
        if (deploymentDescriptor == null) {
            throw new AnnotationsException("The EObject parameter for MergeData for the deployment descriptor can not be null.");
        }
        this.moduleFile = moduleFile;
        this.deploymentDescriptor = deploymentDescriptor;
    }

    public MergeDataImpl(ModuleFile moduleFile, EObject deploymentDescriptor, EObject altDeploymentDescriptor) throws AnnotationsException {
        this(moduleFile, MergeDataImpl.determineDeploymentDescriptor(moduleFile, deploymentDescriptor));
        this.altDeploymentDescriptor = altDeploymentDescriptor;
    }

    public EObject getAltDeploymentDescriptor() {
        return this.altDeploymentDescriptor;
    }

    public ModuleFile getModuleFile() {
        return this.moduleFile;
    }

    public EObject getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    private static EObject determineDeploymentDescriptor(ModuleFile moduleFile, EObject deploymentDescriptor) {
        EObject tempDescriptor = deploymentDescriptor;
        if (deploymentDescriptor == null && moduleFile != null) {
            if (moduleFile.isWARFile()) {
                tempDescriptor = ((WARFileImpl)moduleFile).getDeploymentDescriptorGen();
            } else if (moduleFile.isEJBJarFile()) {
                tempDescriptor = ((EJBJarFileImpl)moduleFile).getDeploymentDescriptorGen();
            } else if (moduleFile.isApplicationClientFile()) {
                tempDescriptor = ((ApplicationClientFileImpl)moduleFile).getDeploymentDescriptorGen();
            } else if (moduleFile.isRARFile()) {
                tempDescriptor = ((RARFileImpl)moduleFile).getDeploymentDescriptor(false);
            }
        }
        return tempDescriptor;
    }
}

