/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.model.translator.application.ApplicationTranslator;
import org.eclipse.wst.common.internal.emf.resource.J2EESchemaUtility;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class ApplicationResourceImpl
extends XMLResourceImpl
implements ApplicationResource {
    public static final String CLASS_NAME = ApplicationResourceImpl.class.getName();

    public ApplicationResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public ApplicationResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public Application getApplication() {
        return (Application)this.getRootObject();
    }

    public Translator getRootTranslator() {
        return ApplicationTranslator.INSTANCE;
    }

    public int getType() {
        return 2;
    }

    public String getDoctype() {
        int j2eeVersionId = this.getJ2EEVersionID();
        if (j2eeVersionId == 12) {
            return "application";
        }
        if (j2eeVersionId == 13) {
            return "application";
        }
        return null;
    }

    public int getJ2EEVersionID() {
        return this.getModuleVersionID();
    }

    protected int getDefaultVersionID() {
        return this.getDefaultModuleVersionID();
    }

    protected int getDefaultModuleVersionID() {
        return 50;
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
    }

    public String getJ2EE_Alt_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/application_1.2.dtd";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/application_1_3.dtd";
    }

    public String getJ2EE_Alt_1_3_SystemID() {
        return "http://java.sun.com/dtd/application_1.3.dtd";
    }

    public void setModuleVersionID(int moduleVersionId) {
        this.primSetVersionID(moduleVersionId);
        if (moduleVersionId == 50) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 14) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 13) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
        } else if (moduleVersionId == 12) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
        } else {
            this.primSetDoctypeValues(null, null);
            this.unrecognizedModuleVersionID(CLASS_NAME, "setModuleVersionID", moduleVersionId);
        }
        this.syncVersionOfRootObject();
    }

    public void setJ2EEVersionID(int j2eeVersionId) {
        this.primSetVersionID(j2eeVersionId);
        if (j2eeVersionId == 50) {
            this.primSetDoctypeValues(null, null);
        } else if (j2eeVersionId == 14) {
            this.primSetDoctypeValues(null, null);
        } else if (j2eeVersionId == 13) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
        } else if (j2eeVersionId == 12) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
        } else {
            this.primSetDoctypeValues(null, null);
            this.unrecognizedJ2EEVersionID(CLASS_NAME, "setJ2EEVersionID", j2eeVersionId);
        }
        this.syncVersionOfRootObject();
    }

    protected void syncVersionOfRootObject() {
        Application app = this.getApplication();
        if (app == null) {
            return;
        }
        String version = app.getVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            app.setVersion(newVersion);
        }
    }

    protected byte[] getElementBytes() {
        return J2EESchemaUtility.APP_BYTES;
    }

    protected byte[] getVersionBytes() {
        return J2EESchemaUtility.VERSION_1_4_BYTES;
    }

    protected byte[] getSchemaLocationBytes() {
        return J2EESchemaUtility.APP_1_4_BYTES;
    }

    public int lookupModuleVersionId(String schemaName) {
        if (schemaName == null) {
            return -1;
        }
        if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd")) {
            return 14;
        }
        if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd")) {
            return 50;
        }
        return -1;
    }

    public int lookupModuleVersionId(String publicId, String systemId) {
        if (publicId == null || systemId == null) {
            return -1;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN") && (systemId.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd") || systemId.equals("http://java.sun.com/j2ee/dtds/application_1.2.dtd"))) {
            return 12;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN") && (systemId.equals("http://java.sun.com/dtd/application_1_3.dtd") || systemId.equals("http://java.sun.com/dtd/application_1.3.dtd"))) {
            return 13;
        }
        return -1;
    }

    public int parseModuleVersionId(String versionString) {
        if (versionString == null) {
            return -1;
        }
        if (versionString.equals("1.2")) {
            return 12;
        }
        if (versionString.equals("1.3")) {
            return 13;
        }
        if (versionString.equals("1.4")) {
            return 14;
        }
        if (versionString.equals("5")) {
            return 50;
        }
        return -1;
    }
}

