/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util;

import com.ibm.icu.text.UTF16;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CharacterUtil {
    private static Method METHOD_JAVA_IDENTIFIER_START;
    private static Method METHOD_JAVA_IDENTIFIER_PART;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Character");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            METHOD_JAVA_IDENTIFIER_START = clazz.getMethod("isJavaIdentifierStart", Integer.TYPE);
        }
        catch (SecurityException securityException) {
            METHOD_JAVA_IDENTIFIER_START = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            METHOD_JAVA_IDENTIFIER_START = null;
        }
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Character");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            METHOD_JAVA_IDENTIFIER_PART = clazz.getMethod("isJavaIdentifierPart", Integer.TYPE);
        }
        catch (SecurityException securityException) {
            METHOD_JAVA_IDENTIFIER_PART = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            METHOD_JAVA_IDENTIFIER_PART = null;
        }
    }

    private CharacterUtil() {
    }

    public static boolean isJavaIdentifierStart(int intChar) {
        if (METHOD_JAVA_IDENTIFIER_START != null) {
            try {
                return (Boolean)METHOD_JAVA_IDENTIFIER_START.invoke(null, new Integer(intChar));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return Character.isJavaIdentifierStart((char)intChar);
    }

    public static boolean isJavaIdentifierPart(int intChar) {
        if (METHOD_JAVA_IDENTIFIER_PART != null) {
            try {
                return (Boolean)METHOD_JAVA_IDENTIFIER_PART.invoke(null, new Integer(intChar));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return Character.isJavaIdentifierPart((char)intChar);
    }

    public static abstract class AbstractCharIterator {
        protected final CharSequence charSeq;
        private int pos = 0;
        private int lastCharIndex = 0;

        public AbstractCharIterator(CharSequence charSeq) {
            this.charSeq = charSeq;
        }

        public void setIndex(int index) {
            this.pos = index;
        }

        public boolean hasNext() {
            return this.pos < this.charSeq.length();
        }

        public boolean hasPrevious() {
            return this.pos > 0;
        }

        public int next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            int next = this.utfCharAt(this.pos);
            this.lastCharIndex = this.pos;
            this.pos += UTF16.getCharCount(next);
            return next;
        }

        protected abstract int utfCharAt(int var1);

        public int previous() {
            if (!this.hasPrevious()) {
                throw new IllegalStateException();
            }
            int next = UTF16.isTrailSurrogate(this.charSeq.charAt(--this.pos)) ? (this.pos > 0 ? this.utfCharAt(--this.pos) : this.charSeq.charAt(this.pos)) : this.charSeq.charAt(this.pos);
            this.lastCharIndex = this.pos;
            return next;
        }

        public int getPosition() {
            return this.lastCharIndex;
        }
    }

    public static class StringIterator
    extends AbstractCharIterator {
        public StringIterator(String str) {
            super(str);
        }

        protected int utfCharAt(int pos) {
            return UTF16.charAt((String)this.charSeq, pos);
        }
    }

    public static class StringBufferIterator
    extends AbstractCharIterator {
        public StringBufferIterator(StringBuffer strBuffer) {
            super(strBuffer);
        }

        protected int utfCharAt(int pos) {
            return UTF16.charAt((StringBuffer)this.charSeq, pos);
        }
    }
}

