/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLJavaMappingRegistry {
    private Hashtable sReg = new Hashtable();
    private Hashtable dsReg = new Hashtable();
    private Hashtable xml2JavaReg = new Hashtable();
    private Hashtable java2XMLReg = new Hashtable();
    private String defaultEncodingStyle = null;

    public void setDefaultEncodingStyle(String defEncStyle) {
        this.defaultEncodingStyle = defEncStyle;
    }

    public void mapTypes(String encodingStyleURI, QName elementType, Class javaType, Serializer s, Deserializer ds) {
        String java2XMLKey = XMLJavaMappingRegistry.getKey(javaType, encodingStyleURI);
        String xml2JavaKey = XMLJavaMappingRegistry.getKey(elementType, encodingStyleURI);
        if (s != null) {
            this.sReg.put(java2XMLKey, s);
        }
        if (ds != null) {
            this.dsReg.put(xml2JavaKey, ds);
        }
        if (elementType != null && javaType != null) {
            this.java2XMLReg.put(java2XMLKey, elementType);
            this.xml2JavaReg.put(xml2JavaKey, javaType);
        }
    }

    protected Serializer querySerializer_(Class javaType, String encodingStyleURI) {
        String java2XMLKey;
        Serializer s;
        if (encodingStyleURI == null) {
            encodingStyleURI = this.defaultEncodingStyle;
        }
        if ((s = (Serializer)this.sReg.get(java2XMLKey = XMLJavaMappingRegistry.getKey(javaType, encodingStyleURI))) != null) {
            return s;
        }
        java2XMLKey = XMLJavaMappingRegistry.getKey(null, encodingStyleURI);
        return (Serializer)this.sReg.get(java2XMLKey);
    }

    public Serializer querySerializer(Class javaType, String encodingStyleURI) throws IllegalArgumentException {
        Serializer s = this.querySerializer_(javaType, encodingStyleURI);
        if (s != null) {
            return s;
        }
        throw new IllegalArgumentException("No Serializer found to serialize a '" + XMLJavaMappingRegistry.getClassName(javaType) + "' using encoding style '" + encodingStyleURI + "'.");
    }

    protected Deserializer queryDeserializer_(QName elementType, String encodingStyleURI) {
        String xml2JavaKey;
        Deserializer ds;
        if (encodingStyleURI == null) {
            encodingStyleURI = this.defaultEncodingStyle;
        }
        if ((ds = (Deserializer)this.dsReg.get(xml2JavaKey = XMLJavaMappingRegistry.getKey(elementType, encodingStyleURI))) != null) {
            return ds;
        }
        xml2JavaKey = XMLJavaMappingRegistry.getKey(null, encodingStyleURI);
        return (Deserializer)this.dsReg.get(xml2JavaKey);
    }

    public Deserializer queryDeserializer(QName elementType, String encodingStyleURI) throws IllegalArgumentException {
        Deserializer ds = this.queryDeserializer_(elementType, encodingStyleURI);
        if (ds != null) {
            return ds;
        }
        throw new IllegalArgumentException("No Deserializer found to deserialize a '" + elementType + "' using encoding style '" + encodingStyleURI + "'.");
    }

    protected QName queryElementType_(Class javaType, String encodingStyleURI) {
        if (encodingStyleURI == null) {
            encodingStyleURI = this.defaultEncodingStyle;
        }
        String java2XMLkey = XMLJavaMappingRegistry.getKey(javaType, encodingStyleURI);
        return (QName)this.java2XMLReg.get(java2XMLkey);
    }

    public QName queryElementType(Class javaType, String encodingStyleURI) throws IllegalArgumentException {
        QName elementType = this.queryElementType_(javaType, encodingStyleURI);
        if (elementType != null) {
            return elementType;
        }
        throw new IllegalArgumentException("No mapping found for '" + XMLJavaMappingRegistry.getClassName(javaType) + "' using encoding style '" + encodingStyleURI + "'.");
    }

    protected Class queryJavaType_(QName elementType, String encodingStyleURI) {
        if (encodingStyleURI == null) {
            encodingStyleURI = this.defaultEncodingStyle;
        }
        String xml2JavaKey = XMLJavaMappingRegistry.getKey(elementType, encodingStyleURI);
        return (Class)this.xml2JavaReg.get(xml2JavaKey);
    }

    public Class queryJavaType(QName elementType, String encodingStyleURI) throws IllegalArgumentException {
        Class javaType = this.queryJavaType_(elementType, encodingStyleURI);
        if (javaType != null) {
            return javaType;
        }
        throw new IllegalArgumentException("No mapping found for '" + elementType + "' using encoding style '" + encodingStyleURI + "'.");
    }

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, SOAPContext ctx) throws IllegalArgumentException, IOException {
        Serializer s = this.querySerializer(javaType, inScopeEncStyle);
        s.marshall(inScopeEncStyle, javaType, src, context, sink, nsStack, this, ctx);
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, SOAPContext ctx) throws IllegalArgumentException {
        Deserializer ds = null;
        try {
            ds = this.queryDeserializer(elementType, inScopeEncStyle);
        }
        catch (IllegalArgumentException iae) {
            String href = ((Element)src).getAttribute("href");
            if (href != null && !href.equals("")) {
                ds = SOAPMappingRegistry.partSer;
            }
            throw iae;
        }
        return ds.unmarshall(inScopeEncStyle, elementType, src, this, ctx);
    }

    private static String getKey(Object type, String encodingStyleURI) {
        return type + " + " + encodingStyleURI;
    }

    protected static String getClassName(Class javaType) {
        return javaType != null ? StringUtils.getClassName(javaType) : "null";
    }
}

