/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.Serializable;
import org.w3c.dom.Node;

public class QName
implements Serializable {
    private String namespaceURI;
    private String localPart;

    public QName() {
    }

    public QName(Node node) throws IllegalArgumentException {
        String namespaceURI = node.getNamespaceURI();
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Can't create QName: NamespaceURI must not be null.");
        }
        String localPart = node.getLocalName();
        if (localPart == null) {
            throw new IllegalArgumentException("Can't create QName: LocalName must not be null.");
        }
        this.setNamespaceURI(namespaceURI);
        this.setLocalPart(localPart);
    }

    public QName(String namespaceURI, String localPart) {
        this.setNamespaceURI(namespaceURI);
        this.setLocalPart(localPart);
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = (namespaceURI == null ? "" : namespaceURI).intern();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setLocalPart(String localPart) {
        this.localPart = (localPart == null ? "" : localPart).intern();
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public int hashCode() {
        String hash1 = this.namespaceURI.hashCode() + "";
        String hash2 = this.localPart.hashCode() + "";
        String hash3 = hash1 + '_' + hash2;
        return hash3.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.namespaceURI == ((QName)obj).getNamespaceURI() && this.localPart == ((QName)obj).getLocalPart();
    }

    public boolean matches(Node node) {
        try {
            return node != null && this.equals(new QName(node));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String toString() {
        return this.namespaceURI + ':' + this.localPart;
    }
}

