/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.soap.util.net.Relay;

public class TcpTunnelGui
extends Frame {
    int listenPort;
    String tunnelHost;
    int tunnelPort;
    TextArea listenText;
    TextArea tunnelText;
    Label status;
    Relay inRelay;
    Relay outRelay;

    public TcpTunnelGui(int listenPort, String tunnelHost, int tunnelPort) {
        this.listenPort = listenPort;
        this.tunnelHost = tunnelHost;
        this.tunnelPort = tunnelPort;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setTitle("TCP Tunnel/Monitor: Tunneling localhost:" + listenPort + " to " + tunnelHost + ":" + tunnelPort);
        Panel p = new Panel();
        p.setLayout(new BorderLayout());
        Label l1 = new Label("From localhost:" + listenPort, 1);
        p.add("West", l1);
        Label l2 = new Label("From " + tunnelHost + ":" + tunnelPort, 1);
        p.add("East", l2);
        this.add("North", p);
        p = new Panel();
        p.setLayout(new GridLayout(-1, 2));
        this.listenText = new TextArea();
        p.add(this.listenText);
        this.tunnelText = new TextArea();
        p.add(this.tunnelText);
        this.add("Center", p);
        Panel p2 = new Panel();
        p2.setLayout(new BorderLayout());
        p = new Panel();
        Button b = new Button("Clear");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TcpTunnelGui.this.listenText.setText("");
                TcpTunnelGui.this.tunnelText.setText("");
            }
        });
        p.add(b);
        p2.add("Center", p);
        this.status = new Label();
        p2.add("South", this.status);
        this.add("South", p2);
        this.pack();
        this.show();
        Font f = l1.getFont();
        l1.setFont(new Font(f.getName(), 1, f.getSize()));
        l2.setFont(new Font(f.getName(), 1, f.getSize()));
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public String getTunnelHost() {
        return this.tunnelHost;
    }

    public int getTunnelPort() {
        return this.tunnelPort;
    }

    public TextArea getListenText() {
        return this.listenText;
    }

    public TextArea getTunnelText() {
        return this.tunnelText;
    }

    public Label getStatus() {
        return this.status;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: java TcpTunnelGui listenport tunnelhost tunnelport");
            System.exit(1);
        }
        int listenPort = Integer.parseInt(args[0]);
        String tunnelHost = args[1];
        int tunnelPort = Integer.parseInt(args[2]);
        final TcpTunnelGui ttg = new TcpTunnelGui(listenPort, tunnelHost, tunnelPort);
        Thread server = new Thread(){

            public void run() {
                ServerSocket ss = null;
                Label status = ttg.getStatus();
                try {
                    ss = new ServerSocket(ttg.getListenPort());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                while (true) {
                    try {
                        while (true) {
                            status.setText("Listening for connections on port " + ttg.getListenPort() + " ...");
                            Socket sc = ss.accept();
                            Socket st = new Socket(ttg.getTunnelHost(), ttg.getTunnelPort());
                            status.setText("Tunnelling port " + ttg.getListenPort() + " to port " + ttg.getTunnelPort() + " on host " + ttg.getTunnelHost() + " ...");
                            new Relay(sc.getInputStream(), st.getOutputStream(), ttg.getListenText()).start();
                            new Relay(st.getInputStream(), sc.getOutputStream(), ttg.getTunnelText()).start();
                        }
                    }
                    catch (Exception ee) {
                        status.setText("Ouch! [See console for details]: " + ee.getMessage());
                        ee.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        server.start();
    }
}

