/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.soap.util.net.SSLUtils;

class HttpClientConnectionPool {
    private static HttpClientConnectionPool _singleton;
    private static boolean traceEnabled;
    private int _maxClientsCachedPerURL = 5;
    private HashMap _clients = new HashMap();

    public static synchronized HttpClientConnectionPool getInstance() {
        if (_singleton == null) {
            if (traceEnabled) {
                System.out.println(" ** xxx creating singleton SOAP connection pool ..");
            }
            _singleton = new HttpClientConnectionPool();
        }
        return _singleton;
    }

    private HttpClientConnectionPool() {
        try {
            String max = System.getProperty("com.ibm.ws.management.connector.soap.maxClientsCachedPerURL");
            if (max != null && !max.trim().equals("")) {
                if (traceEnabled) {
                    System.out.println("** xxx sys prop maxClientsCachedPerURL " + max);
                }
                this._maxClientsCachedPerURL = new Integer(max);
                if (this._maxClientsCachedPerURL < 1) {
                    this._maxClientsCachedPerURL = 5;
                    if (traceEnabled) {
                        System.out.println("** xxx maxClientsCachedPerURL reset to " + this._maxClientsCachedPerURL);
                    }
                }
            }
        }
        catch (Throwable th) {
            System.out.println("** xxx Exception in reading system prop for maxClientsCachedPerURL: " + th + ".  Resetting it to " + this._maxClientsCachedPerURL);
        }
    }

    public synchronized HttpClient getHttpClient(String url) {
        ArrayList clients = (ArrayList)this._clients.get(url.trim());
        if (clients == null) {
            clients = new ArrayList();
            this._clients.put(url, clients);
        }
        if (clients.size() > 0) {
            return (HttpClient)clients.remove(0);
        }
        if (traceEnabled) {
            System.out.println("** xxxx creating a new client for " + url);
        }
        HttpClient httpClient = new HttpClient();
        return httpClient;
    }

    public synchronized void releaseHttpClient(String url, HttpClient httpClient) {
        ArrayList<HttpClient> clients = (ArrayList<HttpClient>)this._clients.get(url.trim());
        if (clients == null) {
            clients = new ArrayList<HttpClient>();
            this._clients.put(url, clients);
        }
        if (clients.size() > this._maxClientsCachedPerURL) {
            if (traceEnabled) {
                System.out.println("** xxx Max httpclients already cached for " + url + ". Hence discarding " + httpClient);
            }
        } else {
            clients.add(httpClient);
        }
    }

    static {
        traceEnabled = SSLUtils.traceEnabled;
    }
}

