/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.net.HttpClientConnectionPool;
import org.apache.soap.util.net.SSLUtils;

public class HTTPUtils {
    private static final String HTTP_VERSION = "1.0";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    public static final int DEFAULT_OUTPUT_BUFFER_SIZE = 512;
    public static boolean traceEnabled = SSLUtils.traceEnabled;
    public static boolean nonProxyTraceEnabled = false;

    public static boolean shouldUseProxy(String host, String nonProxyHosts) {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy > Entry");
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy: host=" + host + " nonProxyHosts=" + nonProxyHosts);
        }
        if (nonProxyHosts == null || host == null) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns true < Exit");
            }
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (!HTTPUtils.match(pattern, host, false, nonProxyTraceEnabled)) continue;
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns false < Exit");
            }
            return false;
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns true < Exit");
        }
        return true;
    }

    private static Socket buildSocket(URL url, int targetPort, String httpProxyHost, int httpProxyPort, String httpProxyUserName, String httpProxyPassword, Boolean tcpNoDelay) throws Exception {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.buildSocket > Entry");
            System.out.println("org.apache.soap.util.net.buildSocket: url=" + url + " targetPort=" + targetPort + " httpProxyHost=" + httpProxyHost + " httpProxyPort=" + httpProxyPort + " httpProxyUserName=" + httpProxyUserName + " httpProxyPassword=***** tcpNoDelay=" + tcpNoDelay);
        }
        Socket s = null;
        String host = null;
        int port = targetPort;
        host = url.getHost();
        if (url.getProtocol().equalsIgnoreCase("HTTPS")) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.buildSocket: protocol is HTTPS");
            }
            Class<?> SSLUtilsClass = Class.forName("org.apache.soap.util.net.SSLUtils");
            Class[] paramTypes = new Class[]{String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, String.class};
            Method buildSSLSocket = SSLUtilsClass.getMethod("buildSSLSocket", paramTypes);
            Object[] params = new Object[]{host, new Integer(port), httpProxyHost, new Integer(httpProxyPort), httpProxyUserName, httpProxyPassword};
            s = (Socket)buildSSLSocket.invoke(null, params);
        } else {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.buildSocket: protocol is HTTP");
            }
            if (httpProxyHost != null && HTTPUtils.shouldUseProxy(host, System.getProperty("http.nonProxyHosts"))) {
                host = httpProxyHost;
                port = httpProxyPort;
            }
            s = new Socket(host, port);
        }
        if (tcpNoDelay != null && s != null) {
            s.setTcpNoDelay(tcpNoDelay);
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.buildSocket < Exit");
        }
        return s;
    }

    private static int getPort(URL url) throws IOException {
        int port;
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.getPort > Entry");
            System.out.println("org.apache.soap.util.net.getPort: url=" + url);
        }
        if ((port = url.getPort()) < 0) {
            port = url.getProtocol().equalsIgnoreCase("HTTPS") ? 443 : 80;
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.getPort returns " + port + " < Exit");
        }
        return port;
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort) throws IllegalArgumentException, IOException, SOAPException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort)> Entry");
        }
        TransportMessage response = HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, null, null, 512, null);
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort)< Exit");
        }
        return response;
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, int outputBufferSize) throws IllegalArgumentException, IOException, SOAPException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize) > Entry");
        }
        TransportMessage response = HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, null, null, outputBufferSize, null);
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize)< Exit");
        }
        return response;
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, String httpProxyUserName, String httpProxyPassword, int outputBufferSize, Boolean tcpNoDelay) throws IllegalArgumentException, IOException, SOAPException {
        TransportMessage response;
        int offset;
        String URI2;
        Socket s;
        int port;
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)> Entry");
            System.out.println("org.apache.soap.util.net.post: url=" + url + " timeout=" + timeout + " httpProxyHost=" + httpProxyHost + " httpProxyPort=" + httpProxyPort + " outputBufferSize=" + outputBufferSize + " tcpNoDelay=" + tcpNoDelay);
        }
        OutputStream outStream = null;
        InputStream inStream = null;
        Object in = null;
        try {
            port = HTTPUtils.getPort(url);
            s = HTTPUtils.buildSocket(url, port, httpProxyHost, httpProxyPort, httpProxyUserName, httpProxyPassword, tcpNoDelay);
            if (url.getProtocol().equalsIgnoreCase("HTTPS")) {
                if (traceEnabled) {
                    System.out.println("org.apache.soap.util.net.post: protocol is HTTPS, Ignore proxy from now on. Buildsocket takes handles it");
                }
                httpProxyHost = null;
            }
            if (timeout > 0) {
                s.setSoTimeout(timeout);
            }
            outStream = s.getOutputStream();
            inStream = s.getInputStream();
        }
        catch (Exception e) {
            Throwable t = e;
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + e.toString());
                if (t != e) {
                    System.out.println("org.apache.soap.util.net.post: Target exception " + t.toString());
                }
                e.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            IllegalArgumentException iae = new IllegalArgumentException("Error opening socket: " + t);
            iae.initCause(t);
            throw iae;
        }
        String string = URI2 = httpProxyHost == null ? url.getFile() : url.toString();
        if (URI2.length() == 0) {
            URI2 = "/";
        }
        StringBuffer headerbuf = new StringBuffer();
        headerbuf.append("POST").append(' ').append(URI2).append(" HTTP/").append(HTTP_VERSION).append("\r\n").append("Host").append(": ").append(url.getHost()).append(':').append(port).append("\r\n").append("Content-Type").append(": ").append(request.getContentType()).append("\r\n").append("Content-Length").append(": ").append(request.getContentLength()).append("\r\n");
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            headerbuf.append(key).append(": ").append(request.getHeader((String)key)).append("\r\n");
        }
        headerbuf.append("\r\n");
        BufferedOutputStream bOutStream = new BufferedOutputStream(outStream, outputBufferSize);
        bOutStream.write(headerbuf.toString().getBytes("iso-8859-1"));
        request.writeTo(bOutStream);
        bOutStream.flush();
        outStream.flush();
        BufferedInputStream bInStream = new BufferedInputStream(inStream);
        int statusCode = 0;
        String statusString = null;
        StringBuffer linebuf = new StringBuffer();
        int b = 0;
        while (b != 10 && b != -1) {
            b = bInStream.read();
            if (b == 10 || b == 13 || b == -1) continue;
            linebuf.append((char)b);
        }
        String line = linebuf.toString();
        try {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            statusCode = Integer.parseInt(st.nextToken());
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken());
                if (!st.hasMoreTokens()) continue;
                sb.append(" ");
            }
            statusString = sb.toString();
        }
        catch (Exception e2) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + e2.toString());
                e2.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            IllegalArgumentException iae = new IllegalArgumentException("Error parsing HTTP status line \"" + line + "\": " + e2);
            iae.initCause(e2);
            throw iae;
        }
        ByteArrayDataSource ds = new ByteArrayDataSource(bInStream, "iso-8859-1");
        byte[] bytes = ds.toByteArray();
        Hashtable<String, String> respHeaders = new Hashtable<String, String>();
        int respContentLength = -1;
        String respContentType = null;
        StringBuffer namebuf = new StringBuffer();
        StringBuffer valuebuf = new StringBuffer();
        boolean parsingName = true;
        for (offset = 0; offset < bytes.length; ++offset) {
            if (bytes[offset] == 10) {
                if (namebuf.length() == 0) break;
                String name = namebuf.toString();
                int valueLen = valuebuf.length();
                if (valueLen > 0 && valuebuf.charAt(valueLen - 1) == ';') {
                    valuebuf.deleteCharAt(valueLen - 1);
                }
                String value = valuebuf.toString();
                if (name.equalsIgnoreCase("Content-Length")) {
                    respContentLength = Integer.parseInt(value.trim());
                } else if (name.equalsIgnoreCase("Content-Type")) {
                    respContentType = value;
                } else {
                    String previousValue = respHeaders.put(name, value);
                    if (previousValue != null && (name.equalsIgnoreCase("Set-Cookie") || name.equalsIgnoreCase("Set-Cookie2"))) {
                        respHeaders.put(name, previousValue + "," + value);
                    }
                }
                namebuf = new StringBuffer();
                valuebuf = new StringBuffer();
                parsingName = true;
                continue;
            }
            if (bytes[offset] == 13) continue;
            if (parsingName) {
                if (bytes[offset] == 58) {
                    parsingName = false;
                    if (offset == bytes.length - 1 || bytes[offset + 1] != 32) continue;
                    ++offset;
                    continue;
                }
                namebuf.append((char)bytes[offset]);
                continue;
            }
            valuebuf.append((char)bytes[offset]);
        }
        InputStream is = ds.getInputStream();
        is.skip(offset + 1);
        if (respContentLength < 0) {
            respContentLength = ds.getSize() - offset - 1;
        }
        try {
            SOAPContext ctx = new SOAPContext();
            response = new TransportMessage(is, respContentLength, respContentType, ctx, respHeaders);
            response.read();
        }
        catch (MessagingException me) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + me.toString());
                me.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            throw new IllegalArgumentException("Error parsing response: " + me);
        }
        is.close();
        bOutStream.close();
        outStream.close();
        bInStream.close();
        inStream.close();
        s.close();
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)< Exit");
        }
        return response;
    }

    public static TransportMessage postKeepAlive(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, String httpProxyUserName, String httpProxyPassword, int outputBufferSize, Boolean tcpNoDelay) throws IllegalArgumentException, IOException, SOAPException {
        TransportMessage transportMessage;
        HttpClient httpClient;
        block27: {
            BufferedInputStream bin;
            block28: {
                if (traceEnabled) {
                    System.out.println("org.apache.soap.util.net.postKeepAlive (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)> Entry");
                    System.out.println("org.apache.soap.util.net.post.postKeepAlive: url=" + url + " timeout=" + timeout + " httpProxyHost=" + httpProxyHost + " httpProxyPort=" + httpProxyPort + " outputBufferSize=" + outputBufferSize + " tcpNoDelay=" + tcpNoDelay);
                }
                bin = null;
                httpClient = null;
                HttpMethodRetryHandler myretryhandler = new HttpMethodRetryHandler(){

                    public boolean retryMethod(HttpMethod method2, IOException exception, int executionCount) {
                        if (executionCount >= 1) {
                            return false;
                        }
                        if (exception instanceof NoHttpResponseException) {
                            return false;
                        }
                        if (!method2.isRequestSent()) {
                            return false;
                        }
                        return false;
                    }
                };
                try {
                    if (traceEnabled) {
                        System.out.println("**************** new code ***********");
                    }
                    PostMethod post = new PostMethod(url.toString());
                    post.getParams().setVersion(HttpVersion.HTTP_1_1);
                    post.getParams().setParameter("http.method.retry-handler", myretryhandler);
                    if (traceEnabled) {
                        System.out.println("Request Protocol = " + post.getParams().getVersion().toString());
                    }
                    Enumeration e = request.getHeaderNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String value = request.getHeader(key);
                        post.addRequestHeader(key, value);
                        if (!traceEnabled) continue;
                        System.out.println("Adding header = " + key + ", " + value);
                    }
                    ByteArrayRequestEntity bae = new ByteArrayRequestEntity(request.getBytes(), request.getContentType());
                    post.getParams().setSoTimeout(timeout);
                    if (traceEnabled) {
                        System.out.println("Soap request content type: " + bae.getContentType());
                        System.out.println("Soap request content length: " + bae.getContentLength());
                    }
                    post.setRequestEntity(bae);
                    httpClient = HttpClientConnectionPool.getInstance().getHttpClient(url.toString());
                    int status = httpClient.executeMethod(post);
                    if (traceEnabled) {
                        System.out.println("Status is  " + status);
                    }
                    Header[] headers = post.getResponseHeaders();
                    Hashtable<String, String> respHeaders = new Hashtable<String, String>();
                    for (int i = 0; i < headers.length; ++i) {
                        if (traceEnabled) {
                            System.out.println("Response header: " + headers[i].getName() + " = " + headers[i].getValue());
                        }
                        respHeaders.put(headers[i].getName(), headers[i].getValue());
                    }
                    if (traceEnabled) {
                        System.out.println("Response status line == " + post.getStatusLine());
                    }
                    String contentType = (String)respHeaders.get("Content-Type");
                    if (traceEnabled) {
                        System.out.println("Response content type = " + contentType);
                    }
                    if (contentType == null) {
                        contentType = request.getContentType();
                    }
                    SOAPContext ctx = new SOAPContext();
                    if (traceEnabled) {
                        System.out.println("Response details = " + post.getResponseContentLength() + ", " + post.getResponseCharSet());
                    }
                    bin = new BufferedInputStream(post.getResponseBodyAsStream());
                    TransportMessage retVal = new TransportMessage(bin, (int)post.getResponseContentLength(), contentType, ctx, respHeaders);
                    String r = retVal.read();
                    if (traceEnabled) {
                        System.out.println("Response is: " + r);
                    }
                    transportMessage = retVal;
                    if (bin == null) break block27;
                    if (!traceEnabled) break block28;
                    System.out.println("Closing input stream - release connection ");
                }
                catch (Throwable th) {
                    try {
                        if (traceEnabled) {
                            System.out.println("Exception from new code(post): " + th);
                        }
                        IllegalArgumentException iae = new IllegalArgumentException("Error making SOAP call: " + th);
                        if (th instanceof ConnectException) {
                            ConnectException conEx = (ConnectException)th;
                            if (traceEnabled) {
                                System.out.println(".............. cause " + conEx.getCause());
                            }
                            if (conEx.getCause() != null) {
                                iae.initCause(conEx.getCause());
                            }
                        }
                        throw iae;
                    }
                    catch (Throwable throwable) {
                        if (bin != null) {
                            if (traceEnabled) {
                                System.out.println("Closing input stream - release connection ");
                            }
                            bin.close();
                        }
                        if (httpClient != null) {
                            if (traceEnabled) {
                                System.out.println("releasing client to pool " + httpClient);
                            }
                            HttpClientConnectionPool.getInstance().releaseHttpClient(url.toString(), httpClient);
                        }
                        throw throwable;
                    }
                }
            }
            bin.close();
        }
        if (httpClient != null) {
            if (traceEnabled) {
                System.out.println("releasing client to pool " + httpClient);
            }
            HttpClientConnectionPool.getInstance().releaseHttpClient(url.toString(), httpClient);
        }
        return transportMessage;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive, boolean traceMatch) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: pattern=" + pattern + " str=" + str + " isCaseSensitive=" + isCaseSensitive);
        }
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Pattern and string are not the same size");
                }
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (isCaseSensitive && ch2 != strArr[i]) {
                    if (traceMatch) {
                        System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch");
                    }
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch");
                }
                return false;
            }
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true.  Pattern matches.");
            }
            return true;
        }
        if (patIdxEnd == 0) {
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true.  Pattern contains only star.");
            }
            return true;
        }
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing chars before first star");
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch with chars before first star.");
                }
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch with chars before first star.");
                }
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (1).");
                }
                return false;
            }
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (1).");
            }
            return true;
        }
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing chars after last star");
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch with chars after last star.");
                }
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch with chars after last star.");
                }
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (2).");
                }
                return false;
            }
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (2).");
            }
            return true;
        }
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing between stars");
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j])) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false");
                }
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (3).");
            }
            return false;
        }
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (3).");
        }
        return true;
    }

    static {
        String propName = "org.apache.soap.nonProxy.debug";
        try {
            String envString = System.getProperty(propName);
            boolean envValue = SSLUtils.isTrueExplicitly(envString);
            if (envValue) {
                nonProxyTraceEnabled = true;
            }
            if (nonProxyTraceEnabled) {
                String strSetting = envValue ? "enabled" : "disabled";
                System.out.println(propName + " is " + strSetting);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

