/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.mime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import org.apache.soap.util.mime.MimeUtils;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;

    public ByteArrayDataSource(File f, String type) throws IOException {
        this(new FileInputStream(f), type);
        if (this.type == null) {
            this.type = FileTypeMap.getDefaultFileTypeMap().getContentType(f);
        }
    }

    public ByteArrayDataSource(InputStream is, String type) throws IOException {
        int len;
        this.type = type;
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = is.read(buf)) >= 0) {
            os2.write(buf, 0, len);
        }
        this.data = os2.toByteArray();
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.type = type;
        this.data = data;
    }

    public ByteArrayDataSource(String data, String type) {
        this.type = type;
        try {
            this.data = data.getBytes(MimeUtils.getEncoding(type, "iso-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("No data.");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("getOutputStream() not supported.");
    }

    public String getContentType() {
        return this.type;
    }

    public void setContentType(String type) {
        this.type = type;
    }

    public String getName() {
        return "";
    }

    public void writeTo(OutputStream os2) throws IOException {
        os2.write(this.data);
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public int getSize() {
        if (this.data == null) {
            return -1;
        }
        return this.data.length;
    }

    public String getText() {
        try {
            return new String(this.data, MimeUtils.getEncoding(this.type, "iso-8859-1"));
        }
        catch (UnsupportedEncodingException uex) {
            try {
                return new String(this.data, "iso-8859-1");
            }
            catch (UnsupportedEncodingException uex1) {
                return null;
            }
        }
    }
}

