/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.mail.MessagingException;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.transport.http.Cookie;
import org.apache.soap.util.PropUtils;
import org.apache.soap.util.net.HTTPUtils;

public class SOAPHTTPConnection
implements SOAPTransport {
    private BufferedReader responseReader;
    private Hashtable responseHeaders;
    private SOAPContext responseSOAPContext;
    private String httpProxyHost;
    private int httpProxyPort = 80;
    private int timeout;
    private String userName;
    private String password;
    private String proxyUserName;
    private String proxyPassword;
    private boolean maintainSession = true;
    private Cookie[] cookies;
    private Cookie[] cookies2;
    private int outputBufferSize = 512;
    private Boolean tcpNoDelay = defaultTcpNoDelay;
    private static Boolean defaultTcpNoDelay;
    private static final String NO_DELAY = "tcp.no.delay";
    private boolean keepAlive = false;

    public void setProxyHost(String host) {
        this.httpProxyHost = host;
    }

    public void setProxyPort(int port) {
        this.httpProxyPort = port;
    }

    public String getProxyHost() {
        return this.httpProxyHost;
    }

    public int getProxyPort() {
        return this.httpProxyPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProxyUserName(String userName) {
        this.proxyUserName = userName;
    }

    public void setProxyPassword(String password) {
        this.proxyPassword = password;
    }

    private static String encodeAuth(String userName, String password) throws SOAPException {
        try {
            return Base64.encode((userName + ":" + password).getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
        if (!maintainSession) {
            this.cookies = null;
            this.cookies2 = null;
        }
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public Cookie[] getCookies2() {
        return this.cookies2;
    }

    public void setCookies2(Cookie[] cookies2) {
        this.cookies2 = cookies2;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setOutputBufferSize(int sz) {
        this.outputBufferSize = sz;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean nodelay) {
        this.tcpNoDelay = nodelay;
    }

    public void setKeepAlive(boolean b) {
        this.keepAlive = b;
    }

    public void send(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        try {
            TransportMessage response;
            String payload = null;
            if (env != null) {
                StringWriter payloadSW = new StringWriter();
                env.marshall(payloadSW, smr, ctx);
                payload = payloadSW.toString();
            }
            if (headers == null) {
                headers = new Hashtable<String, String>();
            }
            if (this.maintainSession) {
                if (this.cookies2 != null) {
                    headers.put("Cookie2", Cookie.buildCookieValue(sendTo, this.cookies2));
                }
                if (this.cookies != null) {
                    headers.put("Cookie", Cookie.buildCookieValue(sendTo, this.cookies));
                }
            }
            headers.put("SOAPAction", action != null ? '\"' + action + '\"' : "");
            if (this.userName != null) {
                headers.put("Authorization", "Basic " + SOAPHTTPConnection.encodeAuth(this.userName, this.password));
            }
            if (this.proxyUserName != null) {
                headers.put("Proxy-Authorization", "Basic " + SOAPHTTPConnection.encodeAuth(this.proxyUserName, this.proxyPassword));
            }
            try {
                boolean proxyPresent;
                TransportMessage msg = new TransportMessage(payload, ctx, headers);
                msg.save();
                boolean bl = proxyPresent = this.httpProxyHost != null && !this.httpProxyHost.trim().equals("");
                response = !this.keepAlive || proxyPresent ? HTTPUtils.post(sendTo, msg, this.timeout, this.httpProxyHost, this.httpProxyPort, this.proxyUserName, this.proxyPassword, this.outputBufferSize, this.tcpNoDelay) : HTTPUtils.postKeepAlive(sendTo, msg, this.timeout, this.httpProxyHost, this.httpProxyPort, this.proxyUserName, this.proxyPassword, this.outputBufferSize, this.tcpNoDelay);
            }
            catch (MessagingException me) {
                throw new IOException("Failed to encode mime multipart: " + me);
            }
            catch (UnsupportedEncodingException uee) {
                throw new IOException("Failed to encode mime multipart: " + uee);
            }
            Reader envReader = response.getEnvelopeReader();
            this.responseReader = envReader != null ? new BufferedReader(envReader) : null;
            this.responseSOAPContext = response.getSOAPContext();
            this.responseHeaders = response.getHeaders();
            if (this.maintainSession) {
                Cookie[] hdrCookies;
                String hdr = SOAPHTTPConnection.getHeaderValue(this.responseHeaders, "Set-Cookie2");
                if (hdr != null) {
                    hdrCookies = Cookie.parseCookies(sendTo, hdr);
                    this.cookies2 = this.cookies2 != null ? Cookie.updateCookies(this.cookies2, hdrCookies) : hdrCookies;
                }
                if ((hdr = SOAPHTTPConnection.getHeaderValue(this.responseHeaders, "Set-Cookie")) != null) {
                    hdrCookies = Cookie.parseCookies(sendTo, hdr);
                    this.cookies = this.cookies != null ? Cookie.updateCookies(this.cookies, hdrCookies) : hdrCookies;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
        catch (MessagingException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
    }

    public BufferedReader receive() {
        return this.responseReader;
    }

    public Hashtable getHeaders() {
        return this.responseHeaders;
    }

    public SOAPContext getResponseSOAPContext() {
        return this.responseSOAPContext;
    }

    private static String getHeaderValue(Hashtable headers, String headerName) {
        Enumeration enum1 = headers.keys();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            if (!key.equalsIgnoreCase(headerName)) continue;
            return (String)headers.get(key);
        }
        return null;
    }

    static {
        PropUtils pu = new PropUtils();
        String noDelay = pu.getProperty(NO_DELAY);
        if (noDelay != null) {
            defaultTcpNoDelay = Boolean.valueOf(noDelay);
        }
    }
}

