/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TransportMessage
implements Serializable {
    protected String contentType = null;
    protected int offset = 0;
    protected byte[] bytes = null;
    protected String envelope = null;
    protected Hashtable headers = null;
    protected SOAPContext ctx = null;

    public TransportMessage() {
    }

    public TransportMessage(String envelope, SOAPContext ctx, Hashtable headers) throws IllegalArgumentException, MessagingException, IOException, SOAPException {
        this.envelope = envelope;
        this.ctx = ctx;
        this.headers = headers != null ? headers : new Hashtable();
    }

    public TransportMessage(InputStream is, int contentLength, String contentType, SOAPContext ctx, Hashtable headers) throws IllegalArgumentException, MessagingException, IOException, SOAPException {
        int offset;
        this.headers = headers != null ? headers : new Hashtable();
        this.ctx = ctx;
        this.contentType = contentType;
        if (contentLength < 0) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Content length must be specified.");
        }
        this.bytes = new byte[contentLength];
        int bytesRead = 0;
        for (offset = 0; offset < contentLength && bytesRead >= 0; offset += bytesRead) {
            bytesRead = is.read(this.bytes, offset, contentLength - offset);
        }
        if (offset < contentLength) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Premature end of stream. Data is truncated. Read " + offset + " bytes successfully, expected " + contentLength);
        }
    }

    public void editIncoming(EnvelopeEditor editor) throws SOAPException, IOException, MessagingException {
        this.editEnvelope(editor, true);
    }

    public void editOutgoing(EnvelopeEditor editor) throws SOAPException, IOException, MessagingException {
        this.editEnvelope(editor, false);
    }

    protected void editEnvelope(EnvelopeEditor editor, boolean isIncoming) throws SOAPException, IOException, MessagingException {
        if (editor != null) {
            if (this.getEnvelope() == null) {
                return;
            }
            StringWriter tout = new StringWriter();
            if (isIncoming) {
                editor.editIncoming(this.getEnvelopeReader(), tout);
            } else {
                editor.editOutgoing(this.getEnvelopeReader(), tout);
            }
            tout.flush();
            this.envelope = tout.toString();
        }
    }

    public String read() throws IllegalArgumentException, MessagingException, IOException, SOAPException {
        byte[] rootBytes;
        ContentType rootContentType;
        ByteArrayDataSource ds;
        ContentType cType = null;
        try {
            int pos = this.contentType.indexOf(";;");
            if (pos != -1) {
                this.contentType = this.contentType.substring(0, pos) + this.contentType.substring(pos + 1);
            }
            cType = new ContentType(this.contentType);
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (cType == null) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Missing content type.");
        }
        if (cType.match("multipart/*")) {
            ds = new ByteArrayDataSource(this.bytes, this.contentType);
            this.ctx.readMultipart(ds);
            MimeBodyPart rootPart = this.ctx.getRootPart();
            rootContentType = new ContentType(rootPart.getContentType());
            ByteArrayDataSource bads = new ByteArrayDataSource(rootPart.getInputStream(), null);
            rootBytes = bads.toByteArray();
        } else {
            rootBytes = this.bytes;
            rootContentType = cType;
            ds = new ByteArrayDataSource(this.bytes, this.contentType);
            DataHandler dh = new DataHandler(ds);
            MimeBodyPart rootPart = new MimeBodyPart();
            rootPart.setDataHandler(dh);
            this.ctx.addBodyPart(rootPart);
        }
        if (rootContentType.match("text/*")) {
            String charset = rootContentType.getParameter("charset");
            if (charset == null || charset.equals("")) {
                charset = "iso-8859-1";
            }
            this.envelope = new String(rootBytes, MimeUtility.javaCharset(charset));
        }
        return this.envelope;
    }

    public Envelope unmarshall(DocumentBuilder xdb) throws SOAPException {
        Document doc;
        try {
            doc = xdb.parse(new InputSource(this.getEnvelopeReader()));
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "parsing error: " + e);
        }
        if (doc == null) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "parsing error: received empty document");
        }
        return Envelope.unmarshall(doc.getDocumentElement());
    }

    public void save() throws IllegalArgumentException, MessagingException, IOException {
        MimeBodyPart rootPart;
        String rootContentType = null;
        if (this.ctx.isRootPartSet() && (rootPart = this.ctx.getRootPart()) != null) {
            rootContentType = rootPart.getHeader("Content-Type", null);
        }
        if (rootContentType == null) {
            rootContentType = "text/xml;charset=utf-8";
        }
        if (this.getEnvelope() != null) {
            this.ctx.setRootPart(this.envelope, rootContentType);
        }
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        this.ctx.writeTo(payload);
        this.bytes = payload.toByteArray();
        StringBuffer namebuf = new StringBuffer();
        StringBuffer valuebuf = new StringBuffer();
        boolean parsingName = true;
        this.offset = 0;
        while (this.offset < this.bytes.length) {
            if (this.bytes[this.offset] == 10) {
                if (this.bytes[this.offset + 1] == 32 || this.bytes[this.offset + 1] == 9) {
                    while (this.bytes[++this.offset + 1] == 32 || this.bytes[this.offset + 1] == 9) {
                    }
                } else {
                    if (namebuf.length() == 0) {
                        ++this.offset;
                        break;
                    }
                    String name = namebuf.toString();
                    if (name.equals("Content-Type")) {
                        this.contentType = valuebuf.toString();
                        if (this.ctx.getCount() > 1) {
                            String rootCID = this.ctx.getRootPart().getContentID();
                            rootCID = rootCID.substring(1, rootCID.length() - 1);
                            this.contentType = this.contentType + "; type=\"text/xml\"; start=\"" + rootCID + '\"';
                        }
                    }
                    namebuf = new StringBuffer();
                    valuebuf = new StringBuffer();
                    parsingName = true;
                }
            } else if (this.bytes[this.offset] != 13) {
                if (parsingName) {
                    if (this.bytes[this.offset] == 58) {
                        parsingName = false;
                        ++this.offset;
                    } else {
                        namebuf.append((char)this.bytes[this.offset]);
                    }
                } else {
                    valuebuf.append((char)this.bytes[this.offset]);
                }
            }
            ++this.offset;
        }
    }

    public SOAPContext getSOAPContext() {
        return this.ctx;
    }

    public String getEnvelope() throws MessagingException, IOException {
        MimeBodyPart rootPart;
        if (this.envelope == null && (rootPart = this.ctx.getRootPart()) != null && rootPart.isMimeType("text/*")) {
            ByteArrayDataSource ds = new ByteArrayDataSource(rootPart.getInputStream(), rootPart.getContentType());
            this.envelope = ds.getText();
        }
        return this.envelope;
    }

    public Reader getEnvelopeReader() throws MessagingException, IOException {
        if (this.getEnvelope() == null) {
            return null;
        }
        return new StringReader(this.envelope);
    }

    public void setEnvelope(String envelope) {
        this.envelope = envelope;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getContentLength() {
        return this.bytes.length - this.offset;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public void writeTo(OutputStream outStream) throws IOException {
        outStream.write(this.bytes, this.offset, this.bytes.length - this.offset);
        outStream.flush();
    }

    public void setBytes(byte[] data) {
        this.offset = 0;
        this.bytes = data;
    }

    public void readFully(InputStream is) throws IOException {
        this.offset = 0;
        ByteArrayDataSource bads = new ByteArrayDataSource(is, null);
        this.bytes = bads.toByteArray();
    }

    public byte[] getBytes() {
        if (this.offset != 0) {
            byte[] data = new byte[this.bytes.length - this.offset];
            System.arraycopy(this.bytes, this.offset, data, 0, data.length);
            this.bytes = data;
            this.offset = 0;
        }
        return this.bytes;
    }
}

