/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.mail.MessagingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.MethodUtils;

public class ServerHTTPUtils {
    private static final String SERVICE_MANAGER_ID = "serviceManager";
    private static final String SCRIPT_CLASS = "com.ibm.bsf.BSFManager";
    private static final String SCRIPT_INVOKER = "org.apache.soap.server.InvokeBSF";
    private static final String SERVLET_CLASSLOADER = "servletClassLoader";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceManager getServiceManagerFromContext(ServletContext context, String configFilename) {
        Object o;
        if (context != null) {
            ServletContext servletContext = context;
            synchronized (servletContext) {
                o = context.getAttribute(SERVICE_MANAGER_ID);
                if (o == null) {
                    o = new ServiceManager(context, configFilename);
                    context.setAttribute(SERVICE_MANAGER_ID, o);
                }
            }
        } else {
            o = new ServiceManager(null, configFilename);
        }
        return o;
    }

    public static ServiceManager getServiceManagerFromContext(ServletContext context) {
        return ServerHTTPUtils.getServiceManagerFromContext(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getServletClassLoaderFromContext(ServletContext context) {
        if (context != null) {
            Object o;
            ServletContext servletContext = context;
            synchronized (servletContext) {
                o = context.getAttribute(SERVLET_CLASSLOADER);
            }
            return (ClassLoader)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServletClassLoaderIntoContext(ServletContext context, ClassLoader cl) {
        ServletContext servletContext = context;
        synchronized (servletContext) {
            context.setAttribute(SERVLET_CLASSLOADER, cl);
        }
    }

    public static File getFileFromNameAndContext(String fileName, ServletContext context) {
        String realFileName;
        File file = new File(fileName);
        if (!file.isAbsolute() && context != null && (realFileName = context.getRealPath(fileName)) != null) {
            file = new File(realFileName);
        }
        return file;
    }

    public static Envelope readEnvelopeFromRequest(DocumentBuilder xdb, String contentType, int contentLength, InputStream requestStream, EnvelopeEditor editor, HttpServletResponse res, SOAPContext ctx) throws SOAPException, IOException {
        try {
            return ServerUtils.readEnvelopeFromInputStream(xdb, requestStream, contentLength, contentType, editor, ctx);
        }
        catch (IllegalArgumentException e) {
            String msg = e.getMessage();
            res.sendError(400, "Error unmarshalling envelope: " + msg);
            return null;
        }
        catch (MessagingException me) {
            res.sendError(400, "Error unmarshalling envelope: " + me);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getTargetObject(ServiceManager serviceManager, DeploymentDescriptor dd, String targetID, HttpServlet thisServlet, HttpSession session, SOAPContext ctxt, ServletContext context) throws SOAPException {
        int scope = dd.getScope();
        byte providerType = dd.getProviderType();
        Object targetObject = null;
        String className = providerType == 0 || providerType == 3 ? dd.getProviderClass() : SCRIPT_CLASS;
        Object scopeLock = null;
        if (scope == 0) {
            scopeLock = thisServlet;
        } else if (scope == 1) {
            scopeLock = session;
        } else if (scope == 2) {
            scopeLock = context;
        } else {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Service uses deprecated object scope 'page': inform provider of error");
        }
        boolean freshObject = false;
        if (targetID.equals("urn:xml-soap-service-management-service")) {
            targetObject = serviceManager;
        } else {
            if (scopeLock == null) {
                scopeLock = className;
            }
            Object object = scopeLock;
            synchronized (object) {
                targetObject = scopeLock == session ? session.getValue(targetID) : (scopeLock == context ? context.getAttribute(targetID) : null);
                if (targetObject == null) {
                    try {
                        Class c = ctxt.loadClass(className);
                        targetObject = dd.getIsStatic() ? c : c.newInstance();
                        freshObject = true;
                        if (scopeLock == session) {
                            session.putValue(targetID, targetObject);
                        } else if (scopeLock == context) {
                            context.setAttribute(targetID, targetObject);
                        }
                    }
                    catch (Exception e) {
                        String msg = providerType == 0 || providerType == 3 ? "Unable to resolve target object: " + e.getMessage() : "Unable to load BSF: script services not available without BSF: " + e.getMessage();
                        throw new SOAPException(Constants.FAULT_CODE_SERVER_BAD_TARGET_OBJECT_URI, msg, e);
                    }
                }
            }
        }
        if (providerType != 0 && providerType != 3 && freshObject) {
            Class bc = null;
            try {
                bc = ctxt.loadClass(SCRIPT_INVOKER);
            }
            catch (Exception e) {
                String msg = "Unable to load BSF invoker (org.apache.soap.server.InvokeBSF): script services not available without BSF: " + e.getMessage();
                throw new SOAPException(Constants.FAULT_CODE_SERVER, msg, e);
            }
            String script = dd.getScriptFilenameOrString();
            if (providerType == 1) {
                String fileName = context.getRealPath(script);
                try {
                    script = IOUtils.getStringFromReader(new FileReader(fileName));
                }
                catch (Exception e) {
                    String msg = "Unable to load script file (" + fileName + ")" + ": " + e.getMessage();
                    throw new SOAPException(Constants.FAULT_CODE_SERVER, msg, e);
                }
            }
            Class[] sig = new Class[]{DeploymentDescriptor.class, Object.class, String.class};
            try {
                Method m = MethodUtils.getMethod(bc, "init", sig, true);
                m.invoke(null, dd, targetObject, script);
            }
            catch (InvocationTargetException ite) {
                Throwable te = ite.getTargetException();
                if (te instanceof SOAPException) {
                    throw (SOAPException)te;
                }
                String msg = "Unable to invoke init method of script invoker: " + te;
                throw new SOAPException(Constants.FAULT_CODE_SERVER, msg, te);
            }
            catch (Exception e) {
                String msg = "Unable to invoke init method of script invoker: " + e;
                throw new SOAPException(Constants.FAULT_CODE_SERVER, msg, e);
            }
        }
        return targetObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPMappingRegistry getSMRFromContext(ServletContext context) {
        SOAPMappingRegistry smr = null;
        ServletContext servletContext = context;
        synchronized (servletContext) {
            smr = (SOAPMappingRegistry)context.getAttribute("__cached_servlet_SMR__");
            if (smr == null) {
                smr = new SOAPMappingRegistry();
                context.setAttribute("__cached_servlet_SMR__", smr);
            }
        }
        return smr;
    }
}

