/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.File;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.DefaultConfigManager;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.TypeMapping;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.ConfigManager;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServiceManager {
    protected String configFilename = "soap.xml";
    protected DeploymentDescriptor smsdd;
    protected ConfigManager configMgr = null;
    protected ServletContext context = null;
    protected DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
    protected boolean soapInterfaceEnabled = true;

    public ServiceManager(ServletContext context, String configFilename) {
        this.context = context;
        if (configFilename != null && !configFilename.equals("")) {
            this.configFilename = configFilename;
        }
        this.readConfigFile();
        if (this.soapInterfaceEnabled) {
            this.smsdd = new DeploymentDescriptor();
            this.smsdd.setID("urn:xml-soap-service-management-service");
            String[] svcs = new String[]{"deploy", "undeploy", "list", "query"};
            this.smsdd.setMethods(svcs);
            this.smsdd.setScope(2);
            this.smsdd.setProviderType((byte)0);
            this.smsdd.setProviderClass("org.apache.soap.server.ServiceManager");
            this.smsdd.setIsStatic(false);
            this.smsdd.setMappings(new TypeMapping[]{new TypeMapping("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "DeploymentDescriptor"), "org.apache.soap.server.DeploymentDescriptor", "org.apache.soap.encoding.soapenc.BeanSerializer", "org.apache.soap.encoding.soapenc.BeanSerializer"), new TypeMapping("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "TypeMapping"), "org.apache.soap.server.TypeMapping", "org.apache.soap.server.TypeMappingSerializer", "org.apache.soap.server.TypeMappingSerializer")});
        }
    }

    public void setConfigFilename(String configFilename) {
        if (configFilename == null || configFilename.equals("")) {
            return;
        }
        this.configFilename = configFilename;
        this.readConfigFile();
    }

    private void readConfigFile() {
        block12: {
            InputStreamReader reader = null;
            Document doc = null;
            Element elem = null;
            NodeList list = null;
            Hashtable<String, String> options = null;
            try {
                File configFile = ServerHTTPUtils.getFileFromNameAndContext(this.configFilename, this.context);
                doc = this.xdb.parse(new InputSource("file:///" + configFile.getAbsolutePath()));
                elem = doc.getDocumentElement();
                if (!"soapServer".equals(elem.getTagName())) {
                    throw new Exception("Root element must be 'soapServer'");
                }
                list = elem.getChildNodes();
                for (int i = 0; list != null && i < list.getLength(); ++i) {
                    int k;
                    String name = null;
                    Node n = list.item(i);
                    if (n.getNodeType() != 1) continue;
                    elem = (Element)n;
                    name = elem.getTagName();
                    if (name.equals("configManager")) {
                        String className = elem.getAttribute("value");
                        ClassLoader cl = null;
                        Class<?> c = null;
                        cl = ServerHTTPUtils.getServletClassLoaderFromContext(this.context);
                        c = cl == null ? Class.forName(className) : Class.forName(className, true, cl);
                        if (!ConfigManager.class.isAssignableFrom(c)) {
                            throw new IllegalArgumentException("Class '" + className + "' isn't a ConfigManager.");
                        }
                        this.configMgr = (ConfigManager)c.newInstance();
                        this.configMgr.setContext(this.context);
                        NodeList optList = elem.getElementsByTagName("option");
                        for (k = 0; optList != null && k < optList.getLength(); ++k) {
                            elem = (Element)optList.item(k);
                            name = elem.getAttribute("name");
                            String value = elem.getAttribute("value");
                            if (options == null) {
                                options = new Hashtable<String, String>();
                            }
                            if (name == null || value == null) continue;
                            options.put(name, value);
                        }
                        if (options == null) continue;
                        this.configMgr.setOptions(options);
                        continue;
                    }
                    if (!name.equals("serviceManager")) continue;
                    NodeList optList = elem.getElementsByTagName("option");
                    for (k = 0; optList != null && k < optList.getLength(); ++k) {
                        elem = (Element)optList.item(k);
                        name = elem.getAttribute("name");
                        String value = elem.getAttribute("value");
                        if (name == null || value == null || !name.equalsIgnoreCase("SOAPInterfaceEnabled") || !value.equalsIgnoreCase("false")) continue;
                        this.soapInterfaceEnabled = false;
                    }
                }
                reader.close();
            }
            catch (Throwable e) {
                if (reader == null) break block12;
                System.err.println("Error processing configuration file (" + this.configFilename + ")");
                System.err.println("Error was: " + e);
                System.err.println("Using DefaultConfigManager");
            }
        }
        if (this.configMgr == null) {
            this.configMgr = new DefaultConfigManager();
            this.configMgr.setContext(this.context);
        }
        try {
            this.configMgr.init();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
    }

    public void deploy(DeploymentDescriptor dd) throws SOAPException {
        String id = dd.getID();
        if (id.equals("urn:xml-soap-service-management-service")) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "service management service 'urn:xml-soap-service-management-service' cannot be user deployed");
        }
        this.configMgr.deploy(dd);
    }

    public DeploymentDescriptor undeploy(String id) throws SOAPException {
        return this.configMgr.undeploy(id);
    }

    public DeploymentDescriptor query(String id) throws SOAPException {
        if (id == null) {
            return null;
        }
        if (id.equals("urn:xml-soap-service-management-service")) {
            return this.smsdd;
        }
        DeploymentDescriptor dd = this.configMgr.query(id);
        if (dd != null) {
            return dd;
        }
        throw new SOAPException(Constants.FAULT_CODE_SERVER, "service '" + id + "' unknown");
    }

    public String[] list() throws SOAPException {
        return this.configMgr.list();
    }
}

