/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.Utils;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.StringUtils;
import org.w3c.dom.Element;

public class RPCRouter {
    public static Call extractCallFromEnvelope(ServiceManager serviceManager, Envelope callEnv, SOAPContext ctx) throws SOAPException {
        Header header;
        Vector bodyEntries = callEnv.getBody().getBodyEntries();
        Element mainEntry = (Element)bodyEntries.elementAt(0);
        String targetObjectURI = StringUtils.parseFullTargetObjectURI(mainEntry.getNamespaceURI());
        DeploymentDescriptor dd = serviceManager.query(targetObjectURI);
        if (dd == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER_BAD_TARGET_OBJECT_URI, "Unable to determine object id from call: is the method element namespaced?");
        }
        if (dd.getCheckMustUnderstands() && (header = callEnv.getHeader()) != null) {
            Utils.checkMustUnderstands(header);
        }
        return Call.extractFromEnvelope(callEnv, serviceManager, ctx);
    }

    public static boolean validCall(DeploymentDescriptor dd, Call call) {
        String callMethodName = call.getMethodName();
        String[] pubMethods = dd.getMethods();
        for (int i = 0; i < pubMethods.length; ++i) {
            if (!callMethodName.equals(pubMethods[i])) continue;
            return true;
        }
        return false;
    }

    public static Response invoke(DeploymentDescriptor dd, Call call, Object targetObject, SOAPContext reqCtx, SOAPContext resCtx) throws SOAPException {
        Bean result;
        String respEncStyle;
        block19: {
            byte providerType = dd.getProviderType();
            Vector params = call.getParams();
            respEncStyle = call.getEncodingStyleURI();
            Object[] args = null;
            Class[] argTypes = null;
            if (params != null) {
                int paramsCount = params.size();
                args = new Object[paramsCount];
                argTypes = new Class[paramsCount];
                for (int i = 0; i < paramsCount; ++i) {
                    Parameter param = (Parameter)params.elementAt(i);
                    args[i] = param.getValue();
                    argTypes[i] = param.getType();
                    if (respEncStyle != null) continue;
                    respEncStyle = param.getEncodingStyleURI();
                }
            }
            if (respEncStyle == null) {
                respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
            }
            result = null;
            try {
                if (providerType == 0 || providerType == 3) {
                    Method m = null;
                    try {
                        m = MethodUtils.getMethod(targetObject, call.getMethodName(), argTypes);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            int i;
                            int paramsCount = 0;
                            if (params != null) {
                                paramsCount = params.size();
                            }
                            Class[] tmpArgTypes = new Class[paramsCount + 1];
                            Object[] tmpArgs = new Object[paramsCount + 1];
                            for (i = 0; i < paramsCount; ++i) {
                                tmpArgTypes[i + 1] = argTypes[i];
                            }
                            argTypes = tmpArgTypes;
                            argTypes[0] = SOAPContext.class;
                            m = MethodUtils.getMethod(targetObject, call.getMethodName(), argTypes);
                            for (i = 0; i < paramsCount; ++i) {
                                tmpArgs[i + 1] = args[i];
                            }
                            tmpArgs[0] = reqCtx;
                            args = tmpArgs;
                        }
                        catch (NoSuchMethodException e2) {
                            throw e;
                        }
                        catch (Exception e2) {
                            throw e2;
                        }
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    result = new Bean(m.getReturnType(), m.invoke(targetObject, args));
                    break block19;
                }
                Class<?> bc = Class.forName("org.apache.soap.server.InvokeBSF");
                Class[] sig = new Class[]{DeploymentDescriptor.class, Object.class, String.class, Object[].class};
                Method m = MethodUtils.getMethod(bc, "service", sig, true);
                result = (Bean)m.invoke(null, dd, targetObject, call.getMethodName(), args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SOAPException) {
                    throw (SOAPException)t;
                }
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Exception from service object: " + t.getMessage(), t);
            }
            catch (ClassNotFoundException e) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to load BSF: script services unsupported without BSF", e);
            }
            catch (Throwable t) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Exception while handling service request: " + t.getMessage(), t);
            }
        }
        Parameter ret = null;
        if (result.type != Void.TYPE) {
            ret = new Parameter(RPCConstants.ELEM_RETURN, result.type, result.value, null);
        }
        return new Response(call.getTargetObjectURI(), call.getMethodName(), ret, null, null, respEncStyle, resCtx);
    }
}

