/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.util.MethodUtils;

public class MessageRouter {
    public static boolean validMessage(DeploymentDescriptor dd, String messageName) {
        String[] pubMessages = dd.getMethods();
        for (int i = 0; i < pubMessages.length; ++i) {
            if (!messageName.equals(pubMessages[i])) continue;
            return true;
        }
        return false;
    }

    public static void invoke(DeploymentDescriptor dd, Envelope env, Object targetObject, String messageName, SOAPContext reqCtx, SOAPContext resCtx) throws SOAPException {
        byte providerType = dd.getProviderType();
        try {
            Class[] argTypes = new Class[]{Envelope.class, SOAPContext.class, SOAPContext.class};
            Object[] args = new Object[]{env, reqCtx, resCtx};
            if (providerType == 0) {
                Method m = MethodUtils.getMethod(targetObject, messageName, argTypes);
                Object resObj = m.invoke(targetObject, args);
            } else {
                Class<?> bc = Class.forName("org.apache.soap.server.InvokeBSF");
                Class[] sig = new Class[]{DeploymentDescriptor.class, Object.class, String.class, Object[].class};
                Method m = MethodUtils.getMethod(bc, "service", sig, true);
                m.invoke(null, dd, targetObject, messageName, args);
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof SOAPException) {
                throw (SOAPException)t;
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Exception from service object: " + t.getMessage(), t);
        }
        catch (ClassNotFoundException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to load BSF: script services unsupported without BSF", e);
        }
        catch (Throwable t) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Exception while handling service request: " + t.getMessage(), t);
        }
    }
}

