/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.BaseConfigManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.ConfigManager;

public class DefaultConfigManager
extends BaseConfigManager
implements ConfigManager {
    protected String filename = "DeployedServices.ds";

    public void setOptions(Hashtable options) {
        if (options == null) {
            return;
        }
        String value = (String)options.get("filename");
        if (value != null && !"".equals(value)) {
            this.filename = value;
        }
    }

    public void loadRegistry() throws SOAPException {
        this.dds = null;
        try {
            File file = ServerHTTPUtils.getFileFromNameAndContext(this.filename, this.context);
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream is = new ObjectInputStream(fis);
            this.dds = (Hashtable)is.readObject();
            is.close();
            fis.close();
        }
        catch (Exception e) {
            this.dds = new Hashtable();
            System.err.println("SOAP Service Manager: Unable to read '" + this.filename + "': assuming fresh start");
        }
    }

    public void saveRegistry() throws SOAPException {
        try {
            File file = ServerHTTPUtils.getFileFromNameAndContext(this.filename, this.context);
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream os2 = new ObjectOutputStream(fos);
            os2.writeObject(this.dds);
            os2.close();
            fos.close();
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error saving services registry: " + e.getMessage());
        }
    }
}

