/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Call
extends RPCMessage {
    private DocumentBuilder xdb;
    private SOAPMappingRegistry smr = null;
    private SOAPTransport st = null;
    private int to = 0;
    boolean keepAlive = false;

    public Call() {
        this(null, null, null, null, null);
    }

    public Call(String targetObjectURI, String methodName, Vector params, Header header, String encodingStyleURI) {
        this(targetObjectURI, methodName, params, header, encodingStyleURI, new SOAPContext());
    }

    public Call(String targetObjectURI, String methodName, Vector params, Header header, String encodingStyleURI, SOAPContext ctx) {
        super(targetObjectURI, methodName, params, header, encodingStyleURI, ctx);
    }

    public void setSOAPMappingRegistry(SOAPMappingRegistry smr) {
        this.smr = smr;
    }

    public SOAPMappingRegistry getSOAPMappingRegistry() {
        if (this.smr == null) {
            this.smr = new SOAPMappingRegistry();
        }
        return this.smr;
    }

    public void setSOAPTransport(SOAPTransport st) {
        this.st = st;
    }

    public SOAPTransport getSOAPTransport() {
        return this.st;
    }

    public void setTimeout(int value) {
        this.to = value;
    }

    public int getTimeout() {
        return this.to;
    }

    public void setKeepAlive(boolean b) {
        this.keepAlive = b;
    }

    public void addBodyPart(MimeBodyPart part) throws MessagingException {
        this.ctx.addBodyPart(part);
    }

    public void removeBodyPart(MimeBodyPart part) throws MessagingException {
        this.ctx.removeBodyPart(part);
    }

    public Envelope buildEnvelope() {
        return super.buildEnvelope(false);
    }

    public static Call extractFromEnvelope(Envelope env, ServiceManager svcMgr, SOAPContext ctx) throws IllegalArgumentException {
        return (Call)RPCMessage.extractFromEnvelope(env, svcMgr, false, null, ctx);
    }

    public static String getEnvelopeString(SOAPTransport st) throws SOAPException, MessagingException, IOException {
        SOAPContext respCtx = st.getResponseSOAPContext();
        BufferedReader in = null;
        String payloadStr = null;
        MimeBodyPart rootPart = respCtx.getRootPart();
        if (rootPart.isMimeType("text/*")) {
            in = st.receive();
            payloadStr = IOUtils.getStringFromReader(in);
        }
        if (!rootPart.isMimeType("text/xml")) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Unsupported response content type \"" + rootPart.getContentType() + "\", must be: \"" + "text/xml" + "\"." + (payloadStr == null ? "" : " Response was:\n" + payloadStr));
        }
        return payloadStr;
    }

    public Response invoke(URL url, String SOAPActionURI) throws SOAPException {
        if (SOAPActionURI == null) {
            SOAPActionURI = "";
        }
        if (this.smr == null) {
            this.smr = new SOAPMappingRegistry();
        }
        if (this.xdb == null) {
            this.xdb = XMLParserUtils.getXMLDocBuilder();
        }
        try {
            Envelope callEnv = this.buildEnvelope();
            if (this.st == null) {
                this.st = new SOAPHTTPConnection();
            }
            if (this.to != 0 && this.st instanceof SOAPHTTPConnection) {
                ((SOAPHTTPConnection)this.st).setTimeout(this.to);
            }
            if (this.st instanceof SOAPHTTPConnection) {
                ((SOAPHTTPConnection)this.st).setKeepAlive(this.keepAlive);
            }
            this.st.send(url, SOAPActionURI, null, callEnv, this.smr, this.ctx);
            SOAPContext respCtx = this.st.getResponseSOAPContext();
            String payloadStr = Call.getEnvelopeString(this.st);
            Document respDoc = this.xdb.parse(new InputSource(new StringReader(payloadStr)));
            Element payload = null;
            if (respDoc == null) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + payloadStr);
            }
            payload = respDoc.getDocumentElement();
            Envelope respEnv = Envelope.unmarshall(payload, respCtx);
            Response resp = Response.extractFromEnvelope(respEnv, this.smr, respCtx);
            String fullTargetObjectURI = resp.getFullTargetObjectURI();
            if (fullTargetObjectURI != null) {
                this.setTargetObjectURI(fullTargetObjectURI);
            }
            return resp;
        }
        catch (MessagingException me) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, me.getMessage(), me);
        }
        catch (IllegalArgumentException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, e.getMessage(), e);
        }
    }
}

