/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers.com;

import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.providers.com.Log;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.MessageRouter;
import org.apache.soap.util.Provider;

public class RPCProvider
implements Provider {
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String methodName;
    private String targetObjectURI;
    private HttpServlet servlet;
    private HttpSession session;
    private byte[] vp = null;
    private String progid = null;
    private ServletContext sc = null;
    private String threadingModel = null;
    private static boolean initLog = false;
    static SOAPException dllLoadException = null;
    static final String libName = "COMProvider";
    static final String pname = "org.apache.soap.providers.com";
    static final String cname = "org.apache.soap.providers.com.RPCProvider";
    private static final int sizeOfVariant = 16;

    public void locate(DeploymentDescriptor dd, Envelope env, Call call, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        HttpServlet servlet = (HttpServlet)reqContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession session = (HttpSession)reqContext.getProperty(Constants.BAG_HTTPSESSION);
        if (!initLog) {
            Log.init(servlet);
            RPCProvider.initlog(Log.getLevel());
            initLog = true;
        }
        Log.msg(256, "msg.comprovider.inlocate", this.getClass().getName(), targetObjectURI, methodName);
        if (null != dllLoadException) {
            Log.msg(1, "msg.comprovider.dllfail", dllLoadException);
            throw dllLoadException;
        }
        if (!MessageRouter.validMessage(dd, methodName)) {
            String msg = Log.msg(1, "msg.comprovider.badMethod", targetObjectURI, methodName);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, msg);
        }
        Vector parms = call.getParams();
        int noParms = 0;
        if (parms != null) {
            this.vp = new byte[16 * parms.size()];
            noParms = parms.size();
        }
        for (int i = 0; i < noParms; ++i) {
            Log.msg(4096, "msg.comprovider.info.parms", new Integer(i), parms.elementAt(i).getClass().getName(), parms.elementAt(i).toString());
            this.objectToVariant(((Parameter)parms.elementAt(noParms - i - 1)).getValue(), this.vp, i * 16);
        }
        Hashtable props = dd.getProps();
        this.progid = (String)props.get("progid");
        if (null == this.progid) {
            this.progid = targetObjectURI.startsWith("urn:") ? targetObjectURI.substring(4) : targetObjectURI;
        }
        this.threadingModel = (String)props.get("threadmodel");
        if (null == this.threadingModel) {
            this.threadingModel = "MULTITHREADED";
        }
        Log.msg(4096, "msg.comprovider.info.cominf", this.progid, this.threadingModel);
        this.dd = dd;
        this.envelope = env;
        this.call = call;
        this.methodName = methodName;
        this.targetObjectURI = targetObjectURI;
        this.servlet = servlet;
        this.session = session;
    }

    public void invoke(SOAPContext reqContext, SOAPContext resContext) throws SOAPException {
        if (null != dllLoadException) {
            Log.msg(1, "msg.comprovider.dllfail", dllLoadException);
            throw dllLoadException;
        }
        if (null == this.progid) {
            String msg = Log.msg(1, "msg.comprovider.error.nullprog", this.methodName, this.targetObjectURI);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, msg);
        }
        if (null == this.methodName) {
            String msg = Log.msg(1, "msg.comprovider.error.nullmname", this.targetObjectURI);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, msg);
        }
        Object ret = null;
        try {
            ret = this.invoke(this.threadingModel, this.progid, this.methodName, this.vp);
        }
        catch (Exception e) {
            String msg = Log.msg(1, "msg.comprovider.error.nativeError", e.toString());
            throw new SOAPException(Constants.FAULT_CODE_SERVER, msg);
        }
        try {
            Parameter pret = null;
            if (ret != null) {
                pret = new Parameter(RPCConstants.ELEM_RETURN, ret.getClass(), ret, null);
            }
            this.vp = null;
            Response resp = new Response(this.targetObjectURI, this.call.getMethodName(), pret, null, null, this.call.getEncodingStyleURI(), resContext);
            Envelope env = resp.buildEnvelope();
            StringWriter sw = new StringWriter();
            env.marshall(sw, this.call.getSOAPMappingRegistry(), resContext);
            resContext.setRootPart(sw.toString(), "text/xml;charset=utf-8");
        }
        catch (Exception e) {
            String msg = Log.msg(1, "msg.comprovider.error.exp", e.toString());
            if (e instanceof SOAPException) {
                throw (SOAPException)e;
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, msg);
        }
        Log.msg(256, "msg.comprovider.ok", ret == null ? "*null*" : ret.toString());
    }

    protected void logit(int level, String msg) {
        Log.msg(level, msg);
    }

    private static SOAPException getSOAPException(String msg) {
        return new SOAPException(Constants.FAULT_CODE_SERVER, msg);
    }

    private native Object invoke(String var1, String var2, String var3, byte[] var4) throws SOAPException;

    private static native void initlog(short var0);

    private static native byte[] nativeConvertToBString(String var0);

    private final byte[] objectToVariant(Object o) throws SOAPException {
        return this.objectToVariant(o, null, 0);
    }

    private final byte[] objectsToVariants(Object[] o) throws SOAPException {
        byte[] bo = new byte[o.length * 16];
        for (int i = 0; i < o.length; ++i) {
            this.objectToVariant(o[i], bo, i * 16);
        }
        return bo;
    }

    private final byte[] objectToVariant(Object o, byte[] bo, int os2) throws SOAPException {
        byte[] v = bo;
        if (null == v) {
            v = new byte[16];
            os2 = 0;
        }
        if (null == o) {
            v[os2 + 0] = 1;
            v[os2 + 1] = 0;
        } else if (o instanceof Boolean) {
            byte x;
            v[os2 + 0] = 11;
            v[os2 + 1] = 0;
            v[os2 + 8] = x = (byte)((Boolean)o != false ? 255 : 0);
            v[os2 + 9] = x;
            v[os2 + 10] = x;
            v[os2 + 11] = x;
        } else if (o instanceof Integer) {
            v[os2 + 0] = 3;
            v[os2 + 1] = 0;
            int x = (Integer)o;
            v[os2 + 8] = (byte)x;
            v[os2 + 9] = (byte)(x >>> 8 & 0xFF);
            v[os2 + 10] = (byte)(x >>> 16 & 0xFF);
            v[os2 + 11] = (byte)(x >>> 24 & 0xFF);
        } else if (o instanceof String) {
            v[os2 + 0] = 8;
            v[os2 + 1] = 0;
            byte[] pbs = RPCProvider.nativeConvertToBString((String)o);
            v[os2 + 8] = pbs[0];
            v[os2 + 9] = pbs[1];
            v[os2 + 10] = pbs[2];
            v[os2 + 11] = pbs[3];
        } else if (o instanceof Long) {
            v[os2 + 0] = 5;
            v[os2 + 1] = 0;
            long x = Double.doubleToLongBits(((Long)o).longValue());
            v[os2 + 8] = (byte)x;
            v[os2 + 9] = (byte)(x >>> 8 & 0xFFL);
            v[os2 + 10] = (byte)(x >>> 16 & 0xFFL);
            v[os2 + 11] = (byte)(x >>> 24 & 0xFFL);
            v[os2 + 12] = (byte)(x >>> 32 & 0xFFL);
            v[os2 + 13] = (byte)(x >>> 40 & 0xFFL);
            v[os2 + 14] = (byte)(x >>> 48 & 0xFFL);
            v[os2 + 15] = (byte)(x >>> 56 & 0xFFL);
        } else if (o instanceof Short) {
            v[os2 + 0] = 2;
            v[os2 + 1] = 0;
            int x = ((Short)o).intValue();
            v[os2 + 8] = (byte)x;
            v[os2 + 9] = (byte)(x >>> 8 & 0xFF);
            v[os2 + 10] = (byte)(x >>> 16 & 0xFF);
            v[os2 + 11] = (byte)(x >>> 24 & 0xFF);
        } else if (o instanceof Float) {
            v[os2 + 0] = 4;
            v[os2 + 1] = 0;
            int x = Float.floatToIntBits(((Float)o).floatValue());
            v[os2 + 8] = (byte)x;
            v[os2 + 9] = (byte)(x >>> 8 & 0xFF);
            v[os2 + 10] = (byte)(x >>> 16 & 0xFF);
            v[os2 + 11] = (byte)(x >>> 24 & 0xFF);
        } else if (o instanceof Double) {
            v[os2 + 0] = 5;
            v[os2 + 1] = 0;
            long x = Double.doubleToLongBits((Double)o);
            v[os2 + 8] = (byte)x;
            v[os2 + 9] = (byte)(x >>> 8 & 0xFFL);
            v[os2 + 10] = (byte)(x >>> 16 & 0xFFL);
            v[os2 + 11] = (byte)(x >>> 24 & 0xFFL);
            v[os2 + 12] = (byte)(x >>> 32 & 0xFFL);
            v[os2 + 13] = (byte)(x >>> 40 & 0xFFL);
            v[os2 + 14] = (byte)(x >>> 48 & 0xFFL);
            v[os2 + 15] = (byte)(x >>> 56 & 0xFFL);
        } else if (o instanceof Byte) {
            byte x;
            v[os2 + 0] = 17;
            v[os2 + 1] = 0;
            v[os2 + 8] = x = ((Byte)o).byteValue();
        } else if (o instanceof Character) {
            byte x;
            v[os2 + 0] = 17;
            v[os2 + 1] = 0;
            v[os2 + 8] = x = (byte)((Character)o).charValue();
        } else if (o instanceof Void) {
            v[os2 + 0] = 1;
            v[os2 + 1] = 0;
        } else {
            if (o.getClass().isArray()) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Currently arrays are unsupported,  type received:" + o.getClass().getName());
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Currently unsupported data type received:" + o.getClass().getName());
        }
        return v;
    }

    static {
        try {
            System.loadLibrary(libName);
        }
        catch (SecurityException e) {
            dllLoadException = new SOAPException(Constants.FAULT_CODE_SERVER, "SecurityException from org.apache.soap.providers.com.RPCProvider loading library:COMProvider " + e.getMessage(), e);
        }
        catch (UnsatisfiedLinkError e) {
            dllLoadException = new SOAPException(Constants.FAULT_CODE_SERVER, "UnsatisfiedLinkError from org.apache.soap.providers.com.RPCProvider loading library:COMProvider " + e.getMessage(), e);
        }
    }
}

