/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.Provider;

public class StatelessEJBProvider
implements Provider {
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String methodName;
    private String targetObjectURI;
    private HttpServlet servlet;
    private HttpSession session;
    private Context contxt = null;
    private EJBObject remoteObjRef = null;
    public static String CNTXT_PROVIDER_URL = "iiop://localhost:900";
    public static String CNTXT_FACTORY_NAME = "com.ibm.ejs.ns.jndi.CNInitialContextFactory";
    private Vector methodParameters = null;
    private String respEncStyle = null;

    private void initialize() throws SOAPException {
        if (this.contxt == null) {
            Properties properties = new Properties();
            properties.put("java.naming.provider.url", CNTXT_PROVIDER_URL);
            properties.put("java.naming.factory.initial", CNTXT_FACTORY_NAME);
            try {
                this.contxt = new InitialContext(properties);
            }
            catch (NamingException ne) {
                System.out.println("Naming Exception caught during InitialContext creation @ " + CNTXT_PROVIDER_URL);
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to initialize context");
            }
        }
    }

    private void initialize(String url, String factory) throws SOAPException {
        if (this.contxt == null) {
            Properties properties = new Properties();
            if (url != null && !url.trim().equals("")) {
                properties.put("java.naming.provider.url", url);
            }
            if (factory != null && !factory.trim().equals("")) {
                properties.put("java.naming.factory.initial", factory);
            }
            try {
                this.contxt = new InitialContext(properties);
            }
            catch (NamingException ne) {
                System.out.println("Naming Exception caught during InitialContext creation @ " + url);
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to initialize context");
            }
        }
    }

    public void invoke(SOAPContext reqContext, SOAPContext resContext) throws SOAPException {
        System.err.println("=============================================");
        System.err.println("In TemplateProvider.invoke()");
        Parameter ret = null;
        Object[] args = null;
        Class[] argTypes = null;
        this.respEncStyle = this.call.getEncodingStyleURI();
        if (this.methodParameters != null) {
            int parametersCount = this.methodParameters.size();
            args = new Object[parametersCount];
            argTypes = new Class[parametersCount];
            for (int i = 0; i < parametersCount; ++i) {
                Parameter param = (Parameter)this.methodParameters.elementAt(i);
                args[i] = param.getValue();
                argTypes[i] = param.getType();
                if (this.respEncStyle != null) continue;
                this.respEncStyle = param.getEncodingStyleURI();
            }
        }
        if (this.respEncStyle == null) {
            this.respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        try {
            Method m = MethodUtils.getMethod(this.remoteObjRef, this.methodName, argTypes);
            Bean result = new Bean(m.getReturnType(), m.invoke((Object)this.remoteObjRef, args));
            if (result.type != Void.TYPE) {
                ret = new Parameter(RPCConstants.ELEM_RETURN, result.type, result.value, null);
            }
        }
        catch (InvocationTargetException e) {
            System.err.println("Exception Caught upon method invocation attempt: " + e.getMessage());
            Throwable t = e.getTargetException();
            throw new SOAPException(Constants.FAULT_CODE_SERVER, t.getMessage(), t);
        }
        catch (Throwable t) {
            System.err.println("Exception Caught upon method invocation attempt: " + t.toString());
            throw new SOAPException(Constants.FAULT_CODE_SERVER, t.getMessage(), t);
        }
        try {
            Response resp = new Response(this.targetObjectURI, this.call.getMethodName(), ret, null, null, this.respEncStyle, resContext);
            Envelope env = resp.buildEnvelope();
            StringWriter sw = new StringWriter();
            env.marshall(sw, this.call.getSOAPMappingRegistry(), resContext);
            resContext.setRootPart(sw.toString(), "text/xml;charset=utf-8");
        }
        catch (Exception e) {
            if (e instanceof SOAPException) {
                throw (SOAPException)e;
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, e.toString());
        }
    }

    public void locate(DeploymentDescriptor dd, Envelope env, Call call, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        HttpServlet servlet = (HttpServlet)reqContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession session = (HttpSession)reqContext.getProperty(Constants.BAG_HTTPSESSION);
        System.err.println("=============================================");
        System.err.println("In TemplateProvider.locate()");
        System.err.println("URI: " + targetObjectURI);
        System.err.println("DD.ServiceClass: " + dd.getServiceClass());
        System.err.println("DD.ProviderClass: " + dd.getProviderClass());
        System.err.println("Call.MethodName: " + call.getMethodName());
        this.dd = dd;
        this.envelope = env;
        this.call = call;
        this.methodName = methodName;
        this.targetObjectURI = targetObjectURI;
        this.servlet = servlet;
        this.session = session;
        Hashtable props = dd.getProps();
        String ContxtProviderURL = (String)props.get("ContextProviderURL");
        String ContxtFactoryName = (String)props.get("FullContextFactoryName");
        if (ContxtProviderURL != null || ContxtFactoryName != null) {
            this.initialize(ContxtProviderURL, ContxtFactoryName);
        } else {
            this.initialize();
        }
        String homeInterfaceName = (String)props.get("FullHomeInterfaceName");
        if (homeInterfaceName == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in Deployment Descriptor Property Settings");
        }
        String jndiName = (String)props.get("JNDIName");
        if (jndiName == null) {
            jndiName = dd.getProviderClass();
        }
        if (jndiName != null && this.contxt != null) {
            try {
                EJBHome home = (EJBHome)PortableRemoteObject.narrow((Object)this.contxt.lookup(jndiName), Class.forName(homeInterfaceName));
                Method createMethod = home.getClass().getMethod("create", new Class[0]);
                this.remoteObjRef = (EJBObject)createMethod.invoke((Object)home, new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Exception caught: " + e.toString());
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in connecting to EJB", e);
            }
        }
        methodName = call.getMethodName();
        this.methodParameters = call.getParams();
    }
}

