/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VectorSerializer
implements Serializer,
Deserializer {
    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        String lengthStr;
        Enumeration enum1;
        nsStack.pushScope();
        if (src != null && !(src instanceof Vector) && !(src instanceof Enumeration)) {
            throw new IllegalArgumentException("Tried to pass a '" + src.getClass().toString() + "' to VectorSerializer");
        }
        if (src instanceof Enumeration) {
            enum1 = (Enumeration)src;
            lengthStr = "";
        } else {
            Vector v = (Vector)src;
            enum1 = v.elements();
            String string = lengthStr = src != null ? v.size() + "" : "";
        }
        if (src == null) {
            SoapEncUtils.generateNullStructure(inScopeEncStyle, javaType, context, sink, nsStack, xjmr);
        } else {
            SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr);
            sink.write(StringUtils.lineSeparator);
            Enumeration e = enum1;
            while (e.hasMoreElements()) {
                nsStack.pushScope();
                Object value = e.nextElement();
                if (value == null) {
                    SoapEncUtils.generateNullStructure("http://schemas.xmlsoap.org/soap/encoding/", Object.class, "item", sink, nsStack, xjmr);
                } else {
                    Class<?> actualComponentType = value.getClass();
                    xjmr.marshall("http://schemas.xmlsoap.org/soap/encoding/", actualComponentType, value, "item", sink, nsStack, ctx);
                }
                sink.write(StringUtils.lineSeparator);
                nsStack.popScope();
            }
            sink.write("</" + context + '>');
        }
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        if (SoapEncUtils.isNull(root)) {
            return new Bean(Vector.class, null);
        }
        Vector<Object> v = new Vector<Object>();
        Element tempEl = DOMUtils.getFirstChildElement(root);
        while (tempEl != null) {
            QName declItemType;
            String declEncStyle = DOMUtils.getAttributeNS(tempEl, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
            String actualEncStyle = declEncStyle != null ? declEncStyle : inScopeEncStyle;
            String href = tempEl.getAttribute("href");
            Element actualEl = tempEl;
            if (href != null && !href.equals("") && href.charAt(0) == '#') {
                href = href.substring(1);
                actualEl = DOMUtils.getElementByID(src.getOwnerDocument().getDocumentElement(), href);
                if (actualEl == null) {
                    throw new IllegalArgumentException("No such ID '" + href + "'");
                }
            }
            QName actualItemType = declItemType = SoapEncUtils.getTypeQName(actualEl);
            Bean itemBean = xjmr.unmarshall(actualEncStyle, actualItemType, actualEl, ctx);
            v.addElement(itemBean.value);
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return new Bean(Vector.class, v);
    }
}

