/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.encoding.soapenc.MimePartSerializer;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.PrefixedName;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterSerializer
implements Serializer,
Deserializer {
    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        nsStack.pushScope();
        Parameter param = (Parameter)src;
        Class type = param.getType();
        String name = param.getName();
        Object value = param.getValue();
        if (!(context instanceof PrefixedName)) {
            context = name;
        }
        if (value == null && !type.isArray()) {
            SoapEncUtils.generateNullStructure(inScopeEncStyle, type, context, sink, nsStack, xjmr);
        } else {
            String declEncStyle = param.getEncodingStyleURI();
            String actualEncStyle = declEncStyle != null ? declEncStyle : inScopeEncStyle;
            Serializer s = xjmr.querySerializer(type, actualEncStyle);
            s.marshall(inScopeEncStyle, type, value, context, sink, nsStack, xjmr, ctx);
        }
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element paramEl = (Element)src;
        String name = paramEl.getTagName();
        Bean bean = null;
        String href = DOMUtils.getAttribute(paramEl, "href");
        if (href != null) {
            if (href.length() > 0 && href.charAt(0) == '#') {
                href = href.substring(1);
                Element el = DOMUtils.getElementByID(src.getOwnerDocument().getDocumentElement(), href);
                if (el == null) {
                    throw new IllegalArgumentException("No such ID '" + href + "'.");
                }
                QName soapType = SoapEncUtils.getTypeQName(el);
                if (soapType == null) {
                    String paramNamespaceURI = paramEl.getNamespaceURI();
                    soapType = paramNamespaceURI != null ? new QName(paramNamespaceURI, name) : new QName("", name);
                }
                bean = xjmr.unmarshall(inScopeEncStyle, soapType, el, ctx);
            } else {
                bean = new MimePartSerializer().unmarshall(inScopeEncStyle, elementType, src, xjmr, ctx);
            }
        } else {
            QName soapType = SoapEncUtils.getTypeQName(paramEl);
            if (soapType == null) {
                String paramNamespaceURI = paramEl.getNamespaceURI();
                soapType = paramNamespaceURI != null ? new QName(paramNamespaceURI, name) : new QName("", name);
            }
            bean = SoapEncUtils.isNull(paramEl) && !new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array").equals(soapType) ? new Bean(xjmr.queryJavaType(soapType, inScopeEncStyle), null) : xjmr.unmarshall(inScopeEncStyle, soapType, paramEl, ctx);
        }
        Parameter parameter = new Parameter(name, bean.type, bean.value, null);
        return new Bean(Parameter.class, parameter);
    }
}

