/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.literalxml;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Utils;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLParameterSerializer
implements Serializer,
Deserializer {
    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        Element el;
        nsStack.pushScope();
        Parameter param = (Parameter)src;
        Class type = param.getType();
        String name = param.getName();
        if (type == Element.class) {
            el = (Element)param.getValue();
            sink.write('<' + name);
            if (inScopeEncStyle == null || !inScopeEncStyle.equals("http://xml.apache.org/xml-soap/literalxml")) {
                String soapEnvNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", sink);
                sink.write(' ' + soapEnvNSPrefix + ':' + "encodingStyle" + "=\"" + "http://xml.apache.org/xml-soap/literalxml" + '\"');
            }
        } else {
            throw new IllegalArgumentException("I only know how to serialize an 'org.w3c.dom.Element'.");
        }
        sink.write('>' + StringUtils.lineSeparator);
        Utils.marshallNode(el, sink);
        sink.write(StringUtils.lineSeparator + "</" + name + '>');
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element paramEl = (Element)src;
        String name = paramEl.getTagName();
        Element el = DOMUtils.getFirstChildElement(paramEl);
        Parameter parameter = new Parameter(name, Element.class, el, null);
        return new Bean(Parameter.class, parameter);
    }
}

