/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Utils {
    public static String cleanString(String s) {
        char[] out2;
        if (s == null) {
            return "";
        }
        char[] amp = new char[]{'&', 'a', 'm', 'p', ';'};
        char[] quot = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        char[] apos = new char[]{'&', 'a', 'p', 'o', 's', ';'};
        char[] lt = new char[]{'&', 'l', 't', ';'};
        char[] gt = new char[]{'&', 'g', 't', ';'};
        char[] ac = s.toCharArray();
        int aclen = ac.length;
        int maxlen = aclen * 2;
        int delta = 0;
        int lastoffset = 0;
        int i = 0;
        int o = 0;
        int outtest = 0;
        char[] out = new char[maxlen];
        block7: for (i = 0; i < aclen; ++i) {
            switch (ac[i]) {
                case '&': {
                    delta = i - lastoffset;
                    outtest = o + delta + 5;
                    while (outtest > maxlen) {
                        out2 = new char[maxlen *= 2];
                        System.arraycopy(out, 0, out2, 0, o);
                        out = out2;
                    }
                    if (delta > 0) {
                        System.arraycopy(ac, lastoffset, out, o, delta);
                    }
                    lastoffset = i + 1;
                    System.arraycopy(amp, 0, out, o + delta, 5);
                    o = outtest;
                    continue block7;
                }
                case '\"': {
                    delta = i - lastoffset;
                    outtest = o + delta + 6;
                    while (outtest > maxlen) {
                        maxlen = maxlen * 2 + 1;
                        out2 = new char[maxlen];
                        System.arraycopy(out, 0, out2, 0, o);
                        out = out2;
                    }
                    if (delta > 0) {
                        System.arraycopy(ac, lastoffset, out, o, delta);
                    }
                    lastoffset = i + 1;
                    System.arraycopy(quot, 0, out, o + delta, 6);
                    o = outtest;
                    continue block7;
                }
                case '\'': {
                    delta = i - lastoffset;
                    outtest = o + delta + 6;
                    while (outtest > maxlen) {
                        out2 = new char[maxlen *= 2];
                        System.arraycopy(out, 0, out2, 0, o);
                        out = out2;
                    }
                    if (delta > 0) {
                        System.arraycopy(ac, lastoffset, out, o, delta);
                    }
                    lastoffset = i + 1;
                    System.arraycopy(apos, 0, out, o + delta, 6);
                    o = outtest;
                    continue block7;
                }
                case '<': {
                    delta = i - lastoffset;
                    outtest = o + delta + 4;
                    while (outtest > maxlen) {
                        out2 = new char[maxlen *= 2];
                        System.arraycopy(out, 0, out2, 0, o);
                        out = out2;
                    }
                    if (delta > 0) {
                        System.arraycopy(ac, lastoffset, out, o, delta);
                    }
                    lastoffset = i + 1;
                    System.arraycopy(lt, 0, out, o + delta, 4);
                    o = outtest;
                    continue block7;
                }
                case '>': {
                    delta = i - lastoffset;
                    outtest = o + delta + 4;
                    while (outtest > maxlen) {
                        out2 = new char[maxlen *= 2];
                        System.arraycopy(out, 0, out2, 0, o);
                        out = out2;
                    }
                    if (delta > 0) {
                        System.arraycopy(ac, lastoffset, out, o, delta);
                    }
                    lastoffset = i + 1;
                    System.arraycopy(gt, 0, out, o + delta, 4);
                    o = outtest;
                }
            }
        }
        delta = i - lastoffset;
        if (delta > 0) {
            outtest = o + delta;
            while (outtest > maxlen) {
                out2 = new char[maxlen *= 2];
                System.arraycopy(out, 0, out2, 0, o);
                out = out2;
            }
            System.arraycopy(ac, lastoffset, out, o, delta);
            o = outtest;
        }
        return new String(out, 0, o);
    }

    public static void marshallNode(Node node, Writer sink) {
        DOM2Writer.serializeAsXML(node, sink);
    }

    public static Vector buildFaultDetailsFromThrowable(Throwable t) {
        Vector<Element> details = new Vector<Element>();
        DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
        Document doc = xdb.newDocument();
        Element elem = doc.createElement("stackTrace");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        Text tn = doc.createTextNode(Utils.cleanString(sw.toString()));
        elem.appendChild(tn);
        details.addElement(elem);
        return details;
    }

    public static void checkMustUnderstands(Header header) throws SOAPException {
        Vector entries = header.getHeaderEntries();
        for (int i = 0; i < entries.size(); ++i) {
            Element el = (Element)entries.elementAt(i);
            String val = el.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
            if (val == null || !val.equals("1")) continue;
            throw new SOAPException("mustUnderstand", "Didn't understand header '" + el.getLocalName() + "'");
        }
    }
}

