/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.AttributeHandler;
import org.apache.soap.Utils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Header {
    private Vector headerEntries = null;
    private AttributeHandler attrHandler = new AttributeHandler();

    public void setAttribute(QName attrQName, String value) {
        this.attrHandler.setAttribute(attrQName, value);
    }

    public String getAttribute(QName attrQName) {
        return this.attrHandler.getAttribute(attrQName);
    }

    public void removeAttribute(QName attrQName) {
        this.attrHandler.removeAttribute(attrQName);
    }

    public void declareNamespace(String nsPrefix, String namespaceURI) {
        this.attrHandler.declareNamespace(nsPrefix, namespaceURI);
    }

    public void setHeaderEntries(Vector headerEntries) {
        this.headerEntries = headerEntries;
    }

    public Vector getHeaderEntries() {
        return this.headerEntries;
    }

    public void marshall(Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        this.attrHandler.populateNSStack(nsStack);
        String soapEnvNSPrefix = this.attrHandler.getUniquePrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV", nsStack);
        if (this.headerEntries != null) {
            sink.write('<' + soapEnvNSPrefix + ':' + "Header");
            this.attrHandler.marshall(sink, ctx);
            sink.write('>' + StringUtils.lineSeparator);
            Enumeration e = this.headerEntries.elements();
            while (e.hasMoreElements()) {
                Element headerEntryEl = (Element)e.nextElement();
                Utils.marshallNode(headerEntryEl, sink);
                sink.write(StringUtils.lineSeparator);
            }
            sink.write("</" + soapEnvNSPrefix + ':' + "Header" + '>' + StringUtils.lineSeparator);
        }
        nsStack.popScope();
    }

    public static Header unmarshall(Node src, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        Header header = new Header();
        Vector<Element> headerEntries = new Vector<Element>();
        header.attrHandler = AttributeHandler.unmarshall(root, ctx);
        Element el = DOMUtils.getFirstChildElement(root);
        while (el != null) {
            headerEntries.addElement(el);
            el = DOMUtils.getNextSiblingElement(el);
        }
        header.setHeaderEntries(headerEntries);
        return header;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[Attributes=" + this.attrHandler + "] " + "[HeaderEntries={");
        if (this.headerEntries != null) {
            for (int i = 0; i < this.headerEntries.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print("[" + this.headerEntries.elementAt(i) + "]");
            }
        }
        pw.print("}]");
        return sw.toString();
    }
}

