/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.AttributeHandler;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.Utils;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Fault {
    private String faultCode = null;
    private String faultString = null;
    private String faultActorURI = null;
    private Vector detailEntries = null;
    private Vector faultEntries = null;
    private AttributeHandler attrHandler = new AttributeHandler();

    public Fault() {
    }

    public Fault(SOAPException _soapException) {
        this.faultCode = _soapException.getFaultCode();
        this.faultString = _soapException.getMessage();
    }

    public void setAttribute(QName attrQName, String value) {
        this.attrHandler.setAttribute(attrQName, value);
    }

    public String getAttribute(QName attrQName) {
        return this.attrHandler.getAttribute(attrQName);
    }

    public void removeAttribute(QName attrQName) {
        this.attrHandler.removeAttribute(attrQName);
    }

    public void declareNamespace(String nsPrefix, String namespaceURI) {
        this.attrHandler.declareNamespace(nsPrefix, namespaceURI);
    }

    public void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setFaultString(String faultString) {
        this.faultString = faultString;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setFaultActorURI(String faultActorURI) {
        this.faultActorURI = faultActorURI;
    }

    public String getFaultActorURI() {
        return this.faultActorURI;
    }

    public void setDetailEntries(Vector detailEntries) {
        this.detailEntries = detailEntries;
    }

    public Vector getDetailEntries() {
        return this.detailEntries;
    }

    public void setFaultEntries(Vector faultEntries) {
        this.faultEntries = faultEntries;
    }

    public Vector getFaultEntries() {
        return this.faultEntries;
    }

    public void marshall(String inScopeEncStyle, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        Enumeration e;
        this.attrHandler.populateNSStack(nsStack);
        String faultCode = this.getFaultCode();
        String faultString = this.getFaultString();
        String faultActorURI = this.getFaultActorURI();
        Vector detailEntries = this.getDetailEntries();
        Vector faultEntries = this.getFaultEntries();
        String soapEnvNSPrefix = this.attrHandler.getUniquePrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV", nsStack);
        sink.write('<' + soapEnvNSPrefix + ':' + "Fault");
        this.attrHandler.marshall(sink, ctx);
        sink.write('>' + StringUtils.lineSeparator + '<' + "faultcode" + '>' + faultCode + "</" + "faultcode" + '>' + StringUtils.lineSeparator + '<' + "faultstring" + '>' + faultString + "</" + "faultstring" + '>' + StringUtils.lineSeparator);
        if (faultActorURI != null) {
            sink.write("<faultactor>" + faultActorURI + "</" + "faultactor" + '>' + StringUtils.lineSeparator);
        }
        if (detailEntries != null) {
            sink.write("<detail>" + StringUtils.lineSeparator);
            e = detailEntries.elements();
            while (e.hasMoreElements()) {
                Object detailEntry = e.nextElement();
                if (detailEntry instanceof Element) {
                    Element detailEntryEl = (Element)detailEntry;
                    Utils.marshallNode(detailEntryEl, sink);
                    sink.write(StringUtils.lineSeparator);
                    continue;
                }
                if (!(detailEntry instanceof Parameter)) continue;
                try {
                    Parameter detailEntryParameter = (Parameter)detailEntry;
                    Serializer s = xjmr.querySerializer(Parameter.class, inScopeEncStyle);
                    if (s != null) {
                        s.marshall(null, Parameter.class, detailEntryParameter, "detailEntry", sink, nsStack, xjmr, ctx);
                        sink.write(StringUtils.lineSeparator);
                        continue;
                    }
                    throw new IllegalArgumentException("Could not find Parameter serializer.");
                }
                catch (IllegalArgumentException iae) {
                }
            }
            sink.write("</detail>" + StringUtils.lineSeparator);
        }
        if (faultEntries != null) {
            e = faultEntries.elements();
            while (e.hasMoreElements()) {
                Element faultEntryEl = (Element)e.nextElement();
                Utils.marshallNode(faultEntryEl, sink);
                sink.write(StringUtils.lineSeparator);
            }
        }
        sink.write("</" + soapEnvNSPrefix + ':' + "Fault" + '>' + StringUtils.lineSeparator);
        nsStack.popScope();
    }

    public static Fault unmarshall(String inScopeEncStyle, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        Fault fault = new Fault();
        if (Constants.Q_ELEM_FAULT.matches(root)) {
            Element faultCodeEl = null;
            Element faultStringEl = null;
            Element faultActorEl = null;
            Element detailEl = null;
            Vector<Element> faultEntries = new Vector<Element>();
            Element tempEl = DOMUtils.getFirstChildElement(root);
            fault.attrHandler = AttributeHandler.unmarshall(root, ctx);
            while (tempEl != null) {
                String namespaceURI = tempEl.getNamespaceURI();
                String localPart = tempEl.getLocalName();
                if (localPart == null) {
                    localPart = tempEl.getTagName();
                }
                if (namespaceURI == null || namespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    if (localPart.equals("faultcode")) {
                        faultCodeEl = tempEl;
                    } else if (localPart.equals("faultstring")) {
                        faultStringEl = tempEl;
                    } else if (localPart.equals("faultactor")) {
                        faultActorEl = tempEl;
                    } else if (localPart.equals("detail")) {
                        detailEl = tempEl;
                    } else {
                        faultEntries.addElement(tempEl);
                    }
                } else {
                    faultEntries.addElement(tempEl);
                }
                tempEl = DOMUtils.getNextSiblingElement(tempEl);
            }
            if (faultCodeEl == null) {
                throw new IllegalArgumentException("A '" + Constants.Q_ELEM_FAULT + "' element must contain a: '" + "faultcode" + "' element.");
            }
            String faultCode = DOMUtils.getChildCharacterData(faultCodeEl);
            fault.setFaultCode(faultCode);
            if (faultStringEl == null) {
                throw new IllegalArgumentException("A '" + Constants.Q_ELEM_FAULT + "' element must contain a: '" + "faultstring" + "' element.");
            }
            String faultString = DOMUtils.getChildCharacterData(faultStringEl);
            fault.setFaultString(faultString);
            if (faultActorEl != null) {
                String faultActorURI = DOMUtils.getChildCharacterData(faultActorEl);
                fault.setFaultActorURI(faultActorURI);
            }
            if (detailEl != null) {
                Vector<Object> detailEntries = new Vector<Object>();
                Element el = DOMUtils.getFirstChildElement(detailEl);
                while (el != null) {
                    try {
                        String declEncStyle = DOMUtils.getAttributeNS(el, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
                        String actualEncStyle = declEncStyle != null ? declEncStyle : inScopeEncStyle;
                        Bean paramBean = xjmr.unmarshall(declEncStyle, RPCConstants.Q_ELEM_PARAMETER, el, ctx);
                        Parameter param = (Parameter)paramBean.value;
                        detailEntries.addElement(param);
                    }
                    catch (Exception e) {
                        detailEntries.addElement(el);
                    }
                    el = DOMUtils.getNextSiblingElement(el);
                }
                fault.setDetailEntries(detailEntries);
            }
            if (faultEntries.size() > 0) {
                fault.setFaultEntries(faultEntries);
            }
        } else {
            throw new IllegalArgumentException("Root element of a SOAP Fault must be: '" + Constants.Q_ELEM_FAULT + "'.");
        }
        return fault;
    }

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[Attributes=" + this.attrHandler + "] " + "[faultCode=" + this.faultCode + "] " + "[faultString=" + this.faultString + "] " + "[faultActorURI=" + this.faultActorURI + "] " + "[DetailEntries=");
        if (this.detailEntries != null) {
            pw.println();
            for (i = 0; i < this.detailEntries.size(); ++i) {
                Object detailEl = this.detailEntries.elementAt(i);
                if (detailEl instanceof Parameter) {
                    Parameter param = (Parameter)detailEl;
                    pw.println("[(" + i + ")=" + param + "]");
                    continue;
                }
                pw.println("[(" + i + ")=" + DOM2Writer.nodeToString((Element)detailEl) + "]");
            }
        }
        pw.print("] [FaultEntries=");
        if (this.faultEntries != null) {
            pw.println();
            for (i = 0; i < this.faultEntries.size(); ++i) {
                pw.println("[(" + i + ")=" + DOM2Writer.nodeToString((Element)this.faultEntries.elementAt(i)) + "]");
            }
        }
        pw.print("]");
        return sw.toString();
    }
}

