/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class AttributeHandler {
    private Hashtable attributes = new Hashtable();
    private Hashtable namespaceURIs2Prefixes = new Hashtable();
    private int nsPrefixIndex = 0;

    public AttributeHandler() {
        this.namespaceURIs2Prefixes.put("http://www.w3.org/2000/xmlns/", "xmlns");
    }

    public void setAttribute(QName attrQName, String value) {
        this.attributes.put(attrQName, value);
        if (attrQName.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
            this.namespaceURIs2Prefixes.put(value, attrQName.getLocalPart());
        }
    }

    public String getAttribute(QName attrQName) {
        return (String)this.attributes.get(attrQName);
    }

    public void removeAttribute(QName attrQName) {
        this.attributes.remove(attrQName);
    }

    private Enumeration getAttributeQNames() {
        this.generateNSDeclarations();
        return this.attributes.keys();
    }

    public void declareNamespace(String nsPrefix, String namespaceURI) {
        this.setAttribute(new QName("http://www.w3.org/2000/xmlns/", nsPrefix), namespaceURI);
    }

    private void generateNSDeclarations() {
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            QName qname = (QName)keys.nextElement();
            this.getPrefixFromURI(qname.getNamespaceURI());
        }
    }

    private String getPrefixFromURI(String namespaceURI) {
        if ("".equals(namespaceURI)) {
            return null;
        }
        String nsPrefix = (String)this.namespaceURIs2Prefixes.get(namespaceURI);
        if (nsPrefix == null) {
            nsPrefix = "ns" + this.nsPrefixIndex++;
            this.setAttribute(new QName("http://www.w3.org/2000/xmlns/", nsPrefix), namespaceURI);
        }
        return nsPrefix;
    }

    public void populateNSStack(NSStack nsStack) {
        this.generateNSDeclarations();
        nsStack.pushScope();
        Enumeration e = this.namespaceURIs2Prefixes.keys();
        while (e.hasMoreElements()) {
            String namespaceURI = (String)e.nextElement();
            String namespacePrefix = this.getPrefixFromURI(namespaceURI);
            if (namespacePrefix == null) continue;
            nsStack.addNSDeclaration(namespacePrefix, namespaceURI);
        }
    }

    public String getUniquePrefixFromURI(String namespaceURI, String preferredPrefix, NSStack nsStack) {
        String retPrefix = nsStack.getPrefixFromURI(namespaceURI);
        if (retPrefix == null) {
            int prefixCount = 0;
            if (preferredPrefix == null) {
                preferredPrefix = "ns";
                ++prefixCount;
            }
            while (retPrefix == null) {
                String newPrefix = preferredPrefix + (prefixCount > 0 ? prefixCount + "" : "");
                if (nsStack.getURIFromPrefix(newPrefix) == null) {
                    nsStack.popScope();
                    this.declareNamespace(newPrefix, namespaceURI);
                    this.populateNSStack(nsStack);
                    retPrefix = nsStack.getPrefixFromURI(namespaceURI);
                    continue;
                }
                ++prefixCount;
            }
        }
        return retPrefix;
    }

    public void marshall(Writer sink, SOAPContext ctx) throws IllegalArgumentException, IOException {
        Enumeration attrQNames = this.getAttributeQNames();
        while (attrQNames.hasMoreElements()) {
            QName attrQName = (QName)attrQNames.nextElement();
            sink.write(32);
            String nsPrefix = this.getPrefixFromURI(attrQName.getNamespaceURI());
            if (nsPrefix != null) {
                sink.write(nsPrefix + ':');
            }
            sink.write(attrQName.getLocalPart() + "=\"" + this.getAttribute(attrQName) + '\"');
        }
    }

    public static AttributeHandler unmarshall(Node src, SOAPContext ctx) throws IllegalArgumentException {
        NamedNodeMap attrs = src.getAttributes();
        AttributeHandler attrHandler = new AttributeHandler();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String namespaceURI = attr.getNamespaceURI();
            String localName = attr.getLocalName();
            String value = attr.getValue();
            attrHandler.setAttribute(new QName(namespaceURI, localName), value);
        }
        return attrHandler;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            sw.write("{");
            this.marshall(sw, new SOAPContext());
            sw.write("}");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sw.toString();
    }
}

