/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soap.SOAPHeaderEntry;
import com.ibm.trl.soapimpl.SOAPDocumentImpl;
import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.xml.soap.security.dsig.AlgorithmChecker;
import com.ibm.xml.soap.security.dsig.AuthenticatedPartsChecker;
import com.ibm.xml.soap.security.dsig.PKIXChecker;
import com.ibm.xml.soap.security.dsig.SOAPDSigLogger;
import com.ibm.xml.soap.security.dsig.SOAPSignatureHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SOAPVerifier
extends SOAPSignatureHandler {
    private static final String XPATH_CONFIG = "/" + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPVerifierConfig");
    private static final String XPATH_ACTOR = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPActor");
    private static final String XPATH_ALLOWEDALGORITHMS = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "AllowedAlgorithms");
    private static final String XPATH_ALGORITHM = XPATH_ALLOWEDALGORITHMS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Algorithm");
    private static final String XPATH_DEFAULTVERIFICATIONKEYS = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "DefaultVerificationKeys");
    private static final String XPATH_DEFAULTPUBLICKEY = XPATH_DEFAULTVERIFICATIONKEYS + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    private static final String XPATH_REQUIREDAUTHENTICATEDPARTS = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "RequiredAuthenticatedParts");
    private static final String XPATH_REFERENCE = XPATH_REQUIREDAUTHENTICATEDPARTS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Reference");
    private static final String XPATH_PART = XPATH_REFERENCE + "/@part";
    private static final String XPATH_PKIXPARAMETERS = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "PKIXParameters");
    private static final String XPATH_TRUSTANCHORLIST = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TrustAnchorList");
    private static final String XPATH_TRUSTANCHOR = XPATH_TRUSTANCHORLIST + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TrustAnchor");
    private static final String XPATH_TRUSTANCHOR_KEYINFO = XPATH_TRUSTANCHOR + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    private static final String XPATH_TRUSTANCHOR_KEYSTORE = XPATH_TRUSTANCHOR + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "KeyStore");
    private static final String XPATH_TRUSTEDROOTLIST = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TrustedRootList");
    private static final String XPATH_TRUSTEDROOT = XPATH_TRUSTEDROOTLIST + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TrustedRoot");
    private static final String XPATH_TRUSTEDROOT_KEYINFO = XPATH_TRUSTEDROOT + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    private static final String XPATH_TRUSTEDROOT_KEYSTORE = XPATH_TRUSTEDROOT + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "KeyStore");
    private static final String XPATH_INITIALPOLICIES = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "InitialPolicies");
    private static final String XPATH_CERTIFICATEPOLICY = XPATH_INITIALPOLICIES + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "CertificatePolicy");
    private static final String XPATH_POLICYMAPPINGINHIBITED = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "PolicyMappingInhibited");
    private static final String XPATH_EXPLICITPOLICYREQUIRED = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "ExplicitPolicyRequired");
    private static final String XPATH_REVOCATIONENABLED = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "RevocationEnabled");
    private static final String XPATH_TARGETKEYUSAGE = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TargetKeyUsage");
    private static final String XPATH_KEYUSAGE = XPATH_TARGETKEYUSAGE + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "KeyUsage");
    private static final String XPATH_TARGETEXTENDEDKEYUSAGE = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TargetExtendedKeyUsage");
    private static final String XPATH_EXTENDEDKEYUSAGE = XPATH_TARGETEXTENDEDKEYUSAGE + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "ExtendedKeyUsage");
    private static final String XPATH_CERTSTORELIST = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "CertStoreList");
    private static final String XPATH_LDAPCERTSTORE = XPATH_CERTSTORELIST + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "LDAPCertStore");
    private static final String XPATH_LDAPSERVER = XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "LDAPServer");
    private static final String XPATH_COLLECTIONCERTSTORE = XPATH_CERTSTORELIST + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "CollectionCertStore");
    private static final String XPATH_X509CERTIFICATE = XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "X509Certificate");
    private static final String XPATH_CANONICALIZATIONMETHOD = ".//" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
    private static final String XPATH_SIGNATUREMETHOD = ".//" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
    private static final String XPATH_DIGESTMETHOD = ".//" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
    private static final String XPATH_TRANSFORM = ".//" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Transform");
    private static final String XPATH_ENCODING = ".//*/@Encoding";
    private static final String XPATH_LOG = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Log");
    private static final String XPATH_SOAPDSIGLOGGER = XPATH_LOG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPDSigLogger");
    private String verifierActorURI;
    private AlgorithmChecker algorithmChecker;
    private AuthenticatedPartsChecker authenticatedPartsChecker;
    private List defaultPublicKeys;
    private List soapDSigLoggers;
    private PKIXChecker pkixChecker;
    private static final String ALGORITHM = "LDAP";
    private static final Map KEY_USAGE_TABLE = new HashMap();

    public void initialize(InputSource config) throws SOAPException {
        Document doc = this.loadDocument(config, false);
        this.verifierActorURI = this.getActorURI(doc);
        Logger.normal("Verifier actor URI: " + this.verifierActorURI, 3);
        this.algorithmChecker = this.getAlgorithmChecker(doc);
        this.authenticatedPartsChecker = this.getAuthenticatedPartsChecker(doc);
        this.defaultPublicKeys = this.getDefaultPublicKeys(doc);
        this.soapDSigLoggers = this.getSOAPDSigLoggers(doc);
        this.pkixChecker = this.getPKIXChecker(doc);
    }

    private String getActorURI(Document config) throws SOAPException {
        NodeList actors = SOAPVerifier.processXPath(config, XPATH_ACTOR);
        if (actors == null || actors.getLength() < 1) {
            return "";
        }
        Element elem = (Element)actors.item(0);
        if (elem == null) {
            return "";
        }
        return elem.getAttribute("URI");
    }

    private List getSOAPDSigLoggers(Document config) throws SOAPException {
        String name = null;
        try {
            LinkedList<SOAPDSigLogger> loggers = new LinkedList<SOAPDSigLogger>();
            NodeList list = SOAPVerifier.processXPath(config, XPATH_SOAPDSIGLOGGER);
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elem = (Element)list.item(i);
                name = elem.getAttribute("class");
                Class<?> cls = Class.forName(name);
                SOAPDSigLogger logger = (SOAPDSigLogger)cls.newInstance();
                logger.init(elem, this.home);
                loggers.add(logger);
                Logger.normal("SOAPDSigLogger: class='" + cls.getName() + "' params='" + new String(XPathCanonicalizer.serializeSubset((Node)elem, (boolean)true)) + "' instance='" + logger + "'", 3);
            }
            return loggers;
        }
        catch (ClassNotFoundException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't load class: '" + name + "', please check your CLASSPATH and the class name.", e);
        }
        catch (IllegalAccessException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't access to the constructor of " + name, e);
        }
        catch (InstantiationException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't instantiate '" + name + "'", e);
        }
    }

    private AlgorithmChecker getAlgorithmChecker(Document config) throws SOAPException {
        AlgorithmChecker checker = new AlgorithmChecker();
        NodeList list = SOAPVerifier.processXPath(config, XPATH_ALGORITHM);
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element elem = (Element)list.item(i);
            checker.add(new AlgorithmChecker.Algorithm(elem.getAttribute("type"), elem.getAttribute("URI")));
        }
        Logger.normal("Allowed Algorithms: " + checker, 3);
        return checker;
    }

    private AuthenticatedPartsChecker getAuthenticatedPartsChecker(Document config) throws SOAPException {
        AuthenticatedPartsChecker checker = new AuthenticatedPartsChecker();
        NodeList list = SOAPVerifier.processXPath(config, XPATH_PART);
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            checker.setFlag(list.item(i).getNodeValue());
        }
        Logger.normal("Required Authenticated Parts: " + checker, 3);
        return checker;
    }

    private List getDefaultPublicKeys(Document config) throws SOAPException {
        LinkedList<KeyInfo> keys = new LinkedList<KeyInfo>();
        NodeList list = SOAPVerifier.processXPath(config, XPATH_DEFAULTPUBLICKEY);
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            keys.add(this.createKeyInfo((Element)list.item(i)));
        }
        return keys;
    }

    private static boolean checkOID(String val) {
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if (".0123456789".indexOf(ch) >= 0) continue;
            return false;
        }
        return true;
    }

    private PKIXChecker getPKIXChecker(Document config) throws SOAPException {
        int i;
        int length;
        NodeList list;
        PKIXChecker checker = null;
        NodeList alist = SOAPVerifier.processXPath(config, XPATH_TRUSTANCHOR_KEYSTORE);
        NodeList rlist = SOAPVerifier.processXPath(config, XPATH_TRUSTEDROOT_KEYSTORE);
        if (alist.getLength() != 0) {
            checker = new PKIXChecker(this.getKeyStore((Element)alist.item(0)));
        } else if (rlist.getLength() != 0) {
            checker = new PKIXChecker(this.getKeyStore((Element)rlist.item(0)));
        } else {
            int k;
            X509Certificate[] certs;
            int j;
            KeyInfo.X509Data[] data;
            KeyInfo keyInfo;
            int i2;
            HashSet<X509Certificate> set = new HashSet<X509Certificate>();
            list = SOAPVerifier.processXPath(config, XPATH_TRUSTANCHOR_KEYINFO);
            length = list.getLength();
            for (i2 = 0; i2 < length; ++i2) {
                keyInfo = this.createKeyInfo((Element)list.item(i2));
                data = keyInfo.getX509Data();
                for (j = 0; j < data.length; ++j) {
                    certs = data[j].getCertificates();
                    for (k = 0; k < certs.length; ++k) {
                        set.add(certs[k]);
                    }
                }
            }
            list = SOAPVerifier.processXPath(config, XPATH_TRUSTEDROOT_KEYINFO);
            length = list.getLength();
            for (i2 = 0; i2 < length; ++i2) {
                keyInfo = this.createKeyInfo((Element)list.item(i2));
                data = keyInfo.getX509Data();
                for (j = 0; j < data.length; ++j) {
                    certs = data[j].getCertificates();
                    for (k = 0; k < certs.length; ++k) {
                        set.add(certs[k]);
                    }
                }
            }
            checker = new PKIXChecker(set);
        }
        PKIXBuilderParameters template = checker.getTemplate();
        list = SOAPVerifier.processXPath(config, XPATH_CERTIFICATEPOLICY + "/text()");
        length = list.getLength();
        if (length != 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i3 = 0; i3 < length; ++i3) {
                set.add(list.item(i3).getNodeValue().trim());
            }
            template.setInitialPolicies(set);
        }
        boolean flag = SOAPVerifier.evalFlag(config, XPATH_POLICYMAPPINGINHIBITED);
        template.setPolicyMappingInhibited(flag);
        flag = SOAPVerifier.evalFlag(config, XPATH_EXPLICITPOLICYREQUIRED);
        template.setExplicitPolicyRequired(flag);
        flag = SOAPVerifier.evalFlag(config, XPATH_REVOCATIONENABLED);
        template.setRevocationEnabled(flag);
        X509CertSelector selector = (X509CertSelector)template.getTargetCertConstraints();
        boolean[] keyUsage = new boolean[]{false, false, false, false, false, false, false, false, false};
        list = SOAPVerifier.processXPath(config, XPATH_KEYUSAGE + "/text()");
        length = list.getLength();
        for (int i4 = 0; i4 < length; ++i4) {
            this.enableKeyUsage(list.item(i4).getNodeValue().trim(), keyUsage);
        }
        if (Logger.getLevel() == 3) {
            HashSet<String> ku = new HashSet<String>(keyUsage.length);
            for (int i5 = 0; i5 < keyUsage.length; ++i5) {
                ku.add(keyUsage[i5] ? "1" : "0");
            }
            Logger.normal("Key Usage: " + ku, 3);
        }
        selector.setKeyUsage(keyUsage);
        HashSet<String> extendedKeyUsage = new HashSet<String>();
        list = SOAPVerifier.processXPath(config, XPATH_EXTENDEDKEYUSAGE + "/text()");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            String value = list.item(i).getNodeValue().trim();
            if (!SOAPVerifier.checkOID(value)) {
                Logger.normal("OID is needed in an ExtendedKeyUsage element: " + value, 3);
                continue;
            }
            extendedKeyUsage.add(value);
        }
        try {
            Logger.normal("Extended Key Usage: " + extendedKeyUsage, 3);
            selector.setExtendedKeyUsage(extendedKeyUsage);
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid Extended Key Usage: " + extendedKeyUsage, e);
        }
        list = SOAPVerifier.processXPath(config, XPATH_LDAPCERTSTORE);
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            int port;
            Element elem = (Element)list.item(i);
            String provider = elem.getAttribute("provider");
            String host = SOAPVerifier.processXPath(elem, XPATH_LDAPSERVER + "/@host").item(0).getNodeValue();
            CertStore store = this.createLDAPCertStore(host, port = Integer.parseInt(SOAPVerifier.processXPath(elem, XPATH_LDAPSERVER + "/@port").item(0).getNodeValue()), provider);
            if (store == null) continue;
            template.addCertStore(store);
        }
        list = SOAPVerifier.processXPath(config, XPATH_COLLECTIONCERTSTORE);
        length = list.getLength();
        HashMap<String, CertificateFactory> map = new HashMap<String, CertificateFactory>();
        for (int i6 = 0; i6 < length; ++i6) {
            Element elem = (Element)list.item(i6);
            String provider = elem.getAttribute("provider");
            CertificateFactory certificateFactory = (CertificateFactory)map.get(provider);
            if (certificateFactory == null) {
                certificateFactory = this.createCertificateFactory(provider);
                map.put(provider, certificateFactory);
            }
            NodeList certs = SOAPVerifier.processXPath(elem, XPATH_X509CERTIFICATE + "/@href");
            CertStore certStore = this.createCollectionCertStore(certs, certificateFactory, provider);
            template.addCertStore(certStore);
        }
        return checker;
    }

    private void verify(SOAPHeaderEntry entry) throws SOAPException {
        Element sig = this.soapSignature.getSignatureElement(entry);
        this.checkAlgorithm(sig, XPATH_CANONICALIZATIONMETHOD);
        this.checkAlgorithm(sig, XPATH_SIGNATUREMETHOD);
        this.checkAlgorithm(sig, XPATH_DIGESTMETHOD);
        this.checkAlgorithm(sig, XPATH_TRANSFORM);
        this.checkEncoding(sig);
        this.authenticatedPartsChecker.check(this.soapSignature.getIDResolver(), sig);
        Object key = null;
        NodeList list = sig.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (list.getLength() == 0) {
            Element prev = null;
            Iterator iterator = this.defaultPublicKeys.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Element elem;
                KeyInfo keyInfo = (KeyInfo)iterator.next();
                String prefix = (elem = (Element)sig.getOwnerDocument().importNode(keyInfo.getKeyInfo(), true)).getPrefix();
                String xmlns = prefix == null ? "xmlns" : "xmlns:" + prefix;
                if ("".equals(elem.getAttribute(xmlns))) {
                    elem.setAttribute(xmlns, "http://www.w3.org/2000/09/xmldsig#");
                }
                if (prev == null) {
                    sig.appendChild(elem);
                } else {
                    sig.replaceChild(elem, prev);
                }
                Logger.normal("Trying validation by using the default key #" + i++, 0);
                Logger.normal("Target SOAP-SEC header: " + new String(XPathCanonicalizer.serializeSubset((Node)entry.getDOMEntity(), (boolean)true)), 0);
                this.checkValidity(entry);
                prev = elem;
            }
        } else {
            this.checkValidity(entry);
        }
    }

    public void edit(Reader in, Writer out) throws SOAPException {
        try {
            SOAPDocumentImpl doc = new SOAPDocumentImpl(this.loadDocument(new InputSource(in), false));
            boolean succeded = false;
            SOAPHeaderEntry[] entries = this.soapSignature.getSignatureEntries(doc);
            for (int i = 0; i < entries.length; ++i) {
                Logger.normal("Found a <SOAP-SEC:Signature>, verifying...", 0);
                try {
                    this.verify(entries[i]);
                    succeded = true;
                    break;
                }
                catch (Exception e) {
                    Logger.normal("Verification failed due to " + e.getClass().getName() + ": " + e.getMessage(), 0);
                    Logger.normal("Verification done", 0);
                    continue;
                }
            }
            Iterator iterator = this.soapDSigLoggers.iterator();
            if (succeded) {
                while (iterator.hasNext()) {
                    SOAPDSigLogger logger = (SOAPDSigLogger)iterator.next();
                    logger.verificationSucceeded(doc);
                }
            } else {
                while (iterator.hasNext()) {
                    SOAPDSigLogger logger = (SOAPDSigLogger)iterator.next();
                    logger.verificationFailed(doc);
                }
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid signature");
            }
            XPathCanonicalizer.serializeAll((Document)doc.getDocument(), (boolean)true, (Writer)out);
            out.flush();
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "IO error", e);
        }
    }

    private void checkValidity(SOAPHeaderEntry entry) throws SOAPException {
        try {
            Element sig = this.soapSignature.getSignatureElement(entry);
            Key key = this.pkixChecker.check(sig);
            if (!this.soapSignature.verify(entry, key)) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid signature");
            }
        }
        catch (SignatureStructureException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid signature element", e);
        }
        catch (InvalidKeySpecException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid key spec", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unknown algorithm", e);
        }
        catch (CertificateException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid certificate", e);
        }
    }

    private void checkAlgorithm(Element sig, String xpath) throws SOAPException {
        Logger.normal("Checking algorithms...", 0);
        NodeList list = SOAPVerifier.processXPath(sig, xpath);
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element elem = (Element)list.item(i);
            AlgorithmChecker.Algorithm algo = new AlgorithmChecker.Algorithm(elem.getLocalName(), elem.getAttribute("Algorithm"));
            if (this.algorithmChecker.check(algo)) continue;
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "" + algo + " is not allowed");
        }
        Logger.normal("Checking algorithms, done.", 0);
    }

    private void checkEncoding(Element sig) throws SOAPException {
        Logger.normal("Checking encoding...", 0);
        NodeList list = SOAPVerifier.processXPath(sig, XPATH_ENCODING);
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            AlgorithmChecker.Algorithm algo = new AlgorithmChecker.Algorithm(list.item(i).getLocalName(), list.item(i).getNodeValue());
            if (this.algorithmChecker.check(algo)) continue;
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "" + algo + " is not allowed");
        }
        Logger.normal("Checking encoding, done.", 0);
    }

    KeyInfo createKeyInfo(Element elem) throws SOAPException {
        try {
            return new KeyInfo(elem);
        }
        catch (XSignatureException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Invalid key spec: " + new String(XPathCanonicalizer.serializeSubset((Node)elem, (boolean)true)), e);
        }
    }

    CertStore createLDAPCertStore(String host, int port, String provider) throws SOAPException {
        try {
            LDAPCertStoreParameters params = new LDAPCertStoreParameters(host, port);
            CertStore certStore = null;
            if ("".equals(provider)) {
                CertStore.getInstance(ALGORITHM, params);
            } else {
                CertStore.getInstance(ALGORITHM, (CertStoreParameters)params, provider);
            }
            return certStore;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unknown algorithm: LDAP", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            Logger.normal("LDAPCertStore: " + e.getMessage() + " host=" + host + " port=" + port, 4);
            return null;
        }
        catch (NoSuchProviderException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "No such provider: " + provider, e);
        }
        catch (Exception e) {
            Logger.normal("Ignore an error: LDAPCertStore: " + e.getMessage() + " host=" + host + " port=" + port, 3);
            return null;
        }
    }

    CertStore createCollectionCertStore(NodeList list, CertificateFactory certificateFactory, String provider) throws SOAPException {
        HashSet<X509Certificate> set = new HashSet<X509Certificate>();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            String certFile = list.item(i).getNodeValue();
            set.add(this.loadX509Certificate(certFile, certificateFactory));
        }
        try {
            CollectionCertStoreParameters params = new CollectionCertStoreParameters(set);
            if ("".equals(provider)) {
                return CertStore.getInstance("Collection", params);
            }
            return CertStore.getInstance("Collection", (CertStoreParameters)params, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Can't create a CollectionCertStore", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Can't create a CollectionCertStore", e);
        }
        catch (NoSuchProviderException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "No such provider: " + provider, e);
        }
    }

    private X509Certificate loadX509Certificate(String path, CertificateFactory certificateFactory) throws SOAPException {
        try {
            File file = new File(this.home, path);
            path = file.getCanonicalPath();
            Logger.normal("Loading an X509Certificate: " + path, 3);
            return (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Can't open an X509Certificate file: " + path, e);
        }
        catch (CertificateException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid X509Certificate: " + path, e);
        }
    }

    public static void main(String[] args) throws Exception {
        SOAPVerifier verifier = new SOAPVerifier();
        verifier.initialize(new InputSource(args[0]));
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        verifier.edit(new FileReader(args[1]), out);
        ((Writer)out).flush();
        System.out.flush();
    }

    private CertificateFactory createCertificateFactory(String provider) throws SOAPException {
        try {
            if (provider == null || "".equals(provider)) {
                return CertificateFactory.getInstance("X.509");
            }
            return CertificateFactory.getInstance("X.509", provider);
        }
        catch (CertificateException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Can't create an X.509 CertificateFactory", e);
        }
        catch (NoSuchProviderException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "No such provider: " + provider, e);
        }
    }

    private void enableKeyUsage(String oid, boolean[] keyUsage) throws SOAPException {
        Integer oidCode = (Integer)KEY_USAGE_TABLE.get(oid);
        if (oidCode == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unknown OID: '" + oid + "'");
        }
        int index = oidCode;
        keyUsage[index] = true;
    }

    static {
        int i = 0;
        KEY_USAGE_TABLE.put("DIGITAL_SIGNATURE", new Integer(i++));
        KEY_USAGE_TABLE.put("NON_REPUDIATION", new Integer(i++));
        KEY_USAGE_TABLE.put("KEY_ENCIPHERMENT", new Integer(i++));
        KEY_USAGE_TABLE.put("DATA_ENCHIPERMENT", new Integer(i++));
        KEY_USAGE_TABLE.put("KEY_AGREEMENT", new Integer(i++));
        KEY_USAGE_TABLE.put("KEY_CERT_SIGN", new Integer(i++));
        KEY_USAGE_TABLE.put("CRL_SIGN", new Integer(i++));
        KEY_USAGE_TABLE.put("ENCIPHER_ONLY", new Integer(i++));
        KEY_USAGE_TABLE.put("DECIPHER_ONLY", new Integer(i++));
    }
}

