/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soap.SOAPDocument;
import com.ibm.trl.soap.SOAPHeaderEntry;
import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.QName;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.xml.soap.security.SOAPSecurity;
import com.ibm.xml.soap.security.dsig.SOAPIDResolver;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SOAPSignature
extends SOAPSecurity {
    public static final String ELEM_SIGNATURE = "Signature";
    public static final String ATTR_ID = "id";
    private static final QName[] ID_TYPE_ATTRS = new QName[]{new QName("http://schemas.xmlsoap.org/soap/security/2000-12", "id")};
    private IDResolver idResolver = new SOAPIDResolver(ID_TYPE_ATTRS);
    private static final int MAX_DEPTH = 1;

    public void setIDResolver(IDResolver idResolver) {
        this.idResolver = idResolver;
    }

    public IDResolver getIDResolver() {
        return this.idResolver;
    }

    public void sign(SOAPDocument env, Element template, Key privateKey, KeyInfo keyInfo, String verifierURI) throws XSignatureException, SignatureStructureException {
        template = template.getOwnerDocument() == env.getDocument() ? template : (Element)env.getDocument().importNode(template, true);
        Logger.normal("Template:\n" + new String(XPathCanonicalizer.serializeSubset((Node)template, (boolean)true)), 3);
        SOAPHeaderEntry entry = this.createHeaderEntry(env, verifierURI);
        entry.getDOMEntity().appendChild(template);
        this.normalizeForApacheSOAP(env.getDocument().getDocumentElement(), 0);
        SignatureContext con = new SignatureContext();
        con.setIDResolver(this.idResolver);
        if (keyInfo != null) {
            keyInfo.insertTo(template);
        }
        Logger.normal("Signing start", 0);
        con.sign(template, privateKey);
        Logger.normal("Signing done", 0);
    }

    private void normalizeForApacheSOAP(Element elem, int depth) {
        int i;
        if (depth > 1) {
            return;
        }
        NodeList list = elem.getChildNodes();
        Node[] nodes = new Node[list.getLength()];
        for (i = 0; i < nodes.length; ++i) {
            nodes[i] = list.item(i);
        }
        for (i = 0; i < nodes.length; ++i) {
            elem.removeChild(nodes[i]);
        }
        Document fac = elem.getOwnerDocument();
        elem.appendChild(fac.createTextNode("\n"));
        block6: for (int i2 = 0; i2 < nodes.length; ++i2) {
            switch (nodes[i2].getNodeType()) {
                case 1: {
                    this.normalizeForApacheSOAP((Element)nodes[i2], depth + 1);
                    elem.appendChild(nodes[i2]);
                    elem.appendChild(fac.createTextNode("\n"));
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
                default: {
                    elem.appendChild(nodes[i2]);
                }
            }
        }
    }

    public SOAPHeaderEntry[] getSignatureEntries(SOAPDocument doc) {
        NodeList list = doc.getEnvelope().getHeader().getDOMEntity().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/security/2000-12", ELEM_SIGNATURE);
        SOAPHeaderEntry[] entries = new SOAPHeaderEntry[list.getLength()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = doc.createHeaderEntry((Element)list.item(i));
        }
        return entries;
    }

    public Element getSignatureElement(SOAPHeaderEntry entry) {
        return (Element)entry.getDOMEntity().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", ELEM_SIGNATURE).item(0);
    }

    public boolean verify(SOAPHeaderEntry entry) throws CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureStructureException {
        return this.verify(entry, null);
    }

    public boolean verify(SOAPHeaderEntry entry, Key key) throws CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureStructureException {
        SignatureContext context = new SignatureContext();
        if (this.idResolver != null) {
            context.setIDResolver(this.idResolver);
        }
        Logger.normal("Verifying start", 0);
        Validity validity = context.verify(this.getSignatureElement(entry), key);
        Logger.normal("Verifying done", 0);
        Logger.normal("Core validity=" + validity.getCoreValidity(), 4);
        Logger.normal("Signed info validity=" + validity.getSignedInfoValidity(), 4);
        Logger.normal("Signed info message=" + validity.getSignedInfoMessage(), 4);
        int count = validity.getNumberOfReferences();
        for (int i = 0; i < count; ++i) {
            Logger.normal("Ref[" + i + "](validity=" + validity.getReferenceValidity(i) + ", message=" + validity.getReferenceMessage(i) + ", uri=" + validity.getReferenceURI(i) + ", type=" + validity.getReferenceType(i) + ")", 4);
        }
        return validity.getCoreValidity();
    }

    private SOAPHeaderEntry createHeaderEntry(SOAPDocument env, String verifierURI) {
        Element elem = env.getDocument().createElementNS("http://schemas.xmlsoap.org/soap/security/2000-12", "SOAP-SEC:Signature");
        SOAPHeaderEntry entry = env.createHeaderEntry(elem);
        entry.declareNamespace("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV");
        entry.declareNamespace("http://schemas.xmlsoap.org/soap/security/2000-12", "SOAP-SEC");
        entry.setMustUnderstand(true);
        entry.setActor(verifierURI);
        env.getEnvelope().getHeader().addHeaderEntry(entry);
        return entry;
    }
}

