/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soap.SOAPDocument;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.xml.soap.security.dsig.SOAPDSigLogger;
import com.ibm.xml.soap.transport.AbstractSOAPHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class SOAPDSigLoggerImpl
implements SOAPDSigLogger {
    private static final String TARGET_ALL = "all";
    private static final String TARGET_SUCCESS = "success";
    private static final String TARGET_FAIL = "fail";
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_ALL = 1;
    private static final int TYPE_SUCCESS = 2;
    private static final int TYPE_FAIL = 3;
    private static final Hashtable typeTable = new Hashtable();
    private static final String XPATH_LOGFILE;
    private final List logFiles = new LinkedList();

    private static int getType(String target) {
        Integer integer = (Integer)typeTable.get(target);
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public void init(Element config, String home) throws SOAPException {
        try {
            NodeList list = XPathProcessor.process(config, XPATH_LOGFILE);
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                LogFile logFile = new LogFile();
                logFile.init((Element)list.item(i), home);
                this.logFiles.add(logFile);
            }
        }
        catch (SAXException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Invalid XPath expression: " + XPATH_LOGFILE, e);
        }
    }

    public void verificationSucceeded(SOAPDocument doc) throws SOAPException {
        for (LogFile logFile : this.logFiles) {
            logFile.verificationSucceeded(doc);
        }
    }

    public void verificationFailed(SOAPDocument doc) throws SOAPException {
        for (LogFile logFile : this.logFiles) {
            logFile.verificationFailed(doc);
        }
    }

    public String toString() {
        return "SOAPDSigLoggerImpl(logFiles=" + this.logFiles + ")";
    }

    private static String getTime() {
        return DateFormat.getDateTimeInstance(0, 0).format(new Date());
    }

    static {
        typeTable.put(TARGET_ALL, new Integer(1));
        typeTable.put(TARGET_SUCCESS, new Integer(2));
        typeTable.put(TARGET_FAIL, new Integer(3));
        XPATH_LOGFILE = "//" + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "LogFile");
    }

    class LogFile
    implements SOAPDSigLogger {
        private String path = null;
        private boolean append = false;
        private Writer out = null;
        private boolean success = false;
        private boolean fail = false;

        LogFile() {
        }

        public void init(Element logFile, String home) throws SOAPException {
            this.path = logFile.getAttribute("path");
            this.append = AbstractSOAPHandler.isTrue(logFile.getAttribute("append"));
            try {
                this.out = new FileWriter(new File(home, this.path).getAbsolutePath(), this.append);
            }
            catch (IOException e) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't open the log file: " + this.path, e);
            }
            switch (SOAPDSigLoggerImpl.getType(logFile.getAttribute("target"))) {
                case 1: {
                    this.success = true;
                    this.fail = true;
                    break;
                }
                case 2: {
                    this.success = true;
                    break;
                }
                case 3: {
                    this.fail = true;
                    break;
                }
            }
        }

        public void verificationSucceeded(SOAPDocument doc) throws SOAPException {
            try {
                if (this.out != null && this.success) {
                    this.out.write(SOAPDSigLoggerImpl.getTime() + " \"SUCCESS\" ");
                    XPathCanonicalizer.serializeAll((Document)doc.getDocument(), (boolean)true, (Writer)this.out);
                    this.out.write("\n");
                    this.out.flush();
                }
            }
            catch (IOException e) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't write to the log file", e);
            }
        }

        public void verificationFailed(SOAPDocument doc) throws SOAPException {
            try {
                if (this.out != null && this.fail) {
                    this.out.write(SOAPDSigLoggerImpl.getTime() + " \"FAIL\" ");
                    XPathCanonicalizer.serializeAll((Document)doc.getDocument(), (boolean)true, (Writer)this.out);
                    this.out.write("\n");
                    this.out.flush();
                }
            }
            catch (IOException e) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't write to the log file", e);
            }
        }

        public String toString() {
            return "LogFile(path='" + this.path + "' append=" + this.append + " logSuccess=" + this.success + " logFail=" + this.fail + ")";
        }
    }
}

