/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameTokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(UsernameTokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UsernameTokenConsumer.class.getName();
    private boolean _initialized = false;
    public static final String _DISABLE_REGISTRY_CHECK = "com.ibm.wsspi.wssecurity.auth.module.UsernameLoginModule.disableUserRegistryCheck";

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "], " + "Map context)"));
        }
        TokenConsumerConfig config = (TokenConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + config + "]."));
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[1][wssVersion];
        NonceManager nmanager = (NonceManager)context.remove(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The NonceManager is " + (nmanager == null ? "null." : "not null,")));
        }
        if (target.getNodeType() == 1) {
            UsernameToken retToken;
            UsernameToken token;
            Element targetElem = (Element)target;
            String tokenId = null;
            String idattr = IdUtil.getInstance().getIdAttributeName(targetElem);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + idattr + "]."));
            }
            if (idattr != null) {
                tokenId = targetElem.getAttribute(idattr);
            }
            Boolean decouple = (Boolean)config.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
            boolean decoupleToken = true;
            if (decouple != null) {
                decoupleToken = decouple;
            }
            Element n = null;
            n = !decoupleToken ? targetElem : DOMUtil.clone(targetElem);
            final UsernameToken tokenPrivSetUsedTokenConsumer = token = new UsernameToken(tokenId, null, null, n);
            final TokenConsumerConfig configPriv = config;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(configPriv);
                    return null;
                }
            });
            UsernameTokenConsumer.setTokenToSubject(context, token);
            QName vtype = config.getType();
            if (!com.ibm.ws.webservices.wssecurity.Constants.UNTOKEN.equals(vtype)) {
                throw new SoapSecurityException("Unsupported value type: " + vtype);
            }
            Element elem = DOMUtil.getOneElement((Element)targetElem, (String)nsWsse, (String)"Username");
            String username = null;
            if (elem != null) {
                username = DOMUtil.getStringValue((Node)elem);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Username [" + username + "]."));
            }
            String passwordStr = null;
            elem = DOMUtil.getOneElement((Element)targetElem, (String)nsWsse, (String)"Password");
            char[] password = null;
            if (elem != null) {
                QName passwordType;
                String passwordTypeStr = elem.getAttribute("Type");
                if (passwordTypeStr != null && passwordTypeStr.length() > 0 && NamespaceUtil.equals(passwordType = DOMUtil.getQName(elem, passwordTypeStr, wssVersion), com.ibm.ws.webservices.wssecurity.Constants.PASSWORD_DIGEST)) {
                    throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.UNSUPPORTED_SECURITY_TOKEN, "security.wssecurity.UsernameTokenConsumer.s01");
                }
                passwordStr = DOMUtil.getStringValue((Node)elem);
                if (passwordStr != null) {
                    password = passwordStr.toCharArray();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(password == null ? "Password is null." : "Password is not null."));
            }
            Date created = UsernameTokenConsumer.checkNonce(targetElem, config, nsWsse, nsWsu, nmanager);
            token.setDate(created);
            boolean trusted = false;
            boolean delayLogin = false;
            if (config.getTrustedIDEvaluator() != null) {
                final boolean trustedPriv = trusted = config.getTrustedIDEvaluator().evaluate(username);
                final UsernameToken tokenPriv = token;
                if (!trusted) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{username});
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tokenPriv.setTrusted(trustedPriv);
                        return null;
                    }
                });
            }
            if (!trusted && ConfigUtil.hasValue((String)passwordStr)) {
                WSSConsumerConfig cconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                Set callers = cconfig.getCallers();
                QName UNT_TYPE = com.ibm.ws.webservices.wssecurity.Constants.UNTOKEN;
                if (callers != null) {
                    for (WSSConsumerConfig.CallerConfig cconf : callers) {
                        QName type = cconf.getTokenType();
                        WSSConsumerConfig.CallerConfig cx = cconf.getTrustMethod();
                        if (!type.equals(UNT_TYPE) || cx != null) continue;
                        delayLogin = true;
                        break;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("delayLogin=" + delayLogin));
            }
            if ((retToken = UsernameTokenConsumer.invokeLoginModule(config, username, password, messageContext, context, delayLogin)) != null) {
                username = retToken.getUsername();
                final UsernameToken retTokenPriv = retToken;
                password = (char[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return retTokenPriv.getPassword();
                    }
                });
            }
            final UsernameToken tokenSetUsernamePriv = token;
            final String usernamePriv = username;
            final char[] passwordPriv = password;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tokenSetUsernamePriv.setUsername(usernamePriv);
                    tokenSetUsernamePriv.setPassword(passwordPriv);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is [" + token + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + target.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target, Map context)");
        }
    }

    protected static UsernameToken invokeLoginModule(TokenConsumerConfig config, String username, char[] password, SOAPMessageContext messageContext, Map context, boolean delayLogin) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invokeLoginModule(TokenConsumerConfig config,String username[" + username + "]," + "char[] password[" + (password == null ? "null" : "not null") + "]," + "SOAPMessageContext messageContext," + "Map context," + "boolean delayLogin[" + delayLogin + "])"));
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (messageContext != null) {
            properties.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
        }
        if (delayLogin) {
            properties.put(_DISABLE_REGISTRY_CHECK, "true");
        }
        if (config.getJAASConfigProperties() != null) {
            properties.putAll(config.getJAASConfigProperties());
        }
        final String jconfig = config.getJAASConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JAAS config name is " + jconfig + "."));
        }
        if (jconfig == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurityJAAS Config entry is missing. Check your configuration.");
        }
        final WSCallbackHandlerFactoryImpl factory = new WSCallbackHandlerFactoryImpl();
        final String usernamePriv = username;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                factory.setUsername(usernamePriv);
                return null;
            }
        });
        if (password != null) {
            final char[] passwordPriv = password;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    factory.setPassword(passwordPriv);
                    return null;
                }
            });
        }
        factory.setProperties(properties);
        final CallbackHandler handler = factory.newCallbackHandler();
        if (tc.isDebugEnabled()) {
            if (handler != null) {
                Tr.debug((TraceComponent)tc, (String)("Callback handler (" + handler.getClass().getName() + ") is [" + handler + "]."));
            } else {
                Tr.debug((TraceComponent)tc, (String)"Callback handler is null");
            }
        }
        LoginContext lcontext = null;
        final Map _context = context;
        try {
            lcontext = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    Subject subject = (Subject)_context.get("com.ibm.wsspi.wssecurity.core.subject");
                    return new LoginContext(jconfig, subject, handler);
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Succeed to construct the login context.");
            }
            lcontext.login();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Succeed to login.");
            }
        }
        catch (PrivilegedActionException pae) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.ERROR)) {
                Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.AUTHN_PRIVILEDGE_ACTION_EXCEPTION, pae.toString());
                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jconfig, "FAILURE");
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
            }
            LoginException le = (LoginException)pae.getCause();
            throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s01", (Throwable)le);
        }
        catch (LoginException e) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, e.toString());
                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jconfig, "SUCCESS");
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
            }
            throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s02", (Throwable)e);
        }
        UsernameToken token = (UsernameToken)properties.get(Constants.WSSECURITY_TOKEN_LOGININFO);
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "TokenId", token.getId());
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "Username", username);
            WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jconfig, "SUCCESS");
            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Auditing SECURITY_AUTHN event not enabled.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("invokeLoginModule(TokenConsumerConfig config,UsernameToken token,SOAPMessageContext messageContext,Map context,boolean delayLogin) returns UsernameToken [" + token + "]"));
        }
        return token;
    }

    private static void setTokenToSubject(Map context, UsernameToken token) {
        TokenManager.setToken(context, token);
    }

    protected static Date checkNonce(Element target, TokenConsumerConfig config, String nsWsse, String nsWsu, NonceManager nmanager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkNonce(Element target[" + DOMUtil.getDisplayName((Node)target) + "], " + "TokenConsumerConfig config," + "String nsWsse," + "String nsWsu," + "NonceManager nmanager)"));
        }
        Map p = config.getProperties();
        boolean isTimestampRequired = false;
        Object obj = p.get(Constants.WSSECURITY_VERIFY_TIMESTAMP);
        if (obj != null) {
            isTimestampRequired = ConfigUtil.isTrue((String)obj.toString());
        }
        boolean isNonceRequired = false;
        obj = p.get(Constants.WSSECURITY_VERIFY_NONCE);
        if (obj != null) {
            isNonceRequired = ConfigUtil.isTrue((String)obj.toString());
        }
        int nonceMaxAge = -1;
        obj = p.get(Constants.WSSECURITY_NONCE_MAX_AGE);
        if (obj != null && obj instanceof Integer) {
            nonceMaxAge = (Integer)obj;
        }
        int nonceClockSkew = -1;
        obj = p.get(Constants.WSSECURITY_NONCE_CLOCK_SKEW);
        if (obj != null && obj instanceof Long) {
            nonceClockSkew = (Integer)obj;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isTimestampRequired is [" + isTimestampRequired + "]."));
            Tr.debug((TraceComponent)tc, (String)("isNonceRequired is [" + isNonceRequired + "]."));
            Tr.debug((TraceComponent)tc, (String)("nonceMaxAge is [" + nonceMaxAge + "]."));
            Tr.debug((TraceComponent)tc, (String)("nonceClockSkew is [" + nonceClockSkew + "]."));
        }
        Date created = null;
        if (isTimestampRequired) {
            Element createdElem = DOMUtil.getChildElement((Element)target, (String)nsWsu, (String)"Created");
            created = NonceUtil.checkNonceTimestamp(createdElem, nsWsu, nonceMaxAge, nonceClockSkew);
        }
        if (isNonceRequired) {
            Element nonce = DOMUtil.getChildElement((Element)target, (String)nsWsse, (String)"Nonce");
            NonceUtil.checkNonce(nonce, nsWsse, nmanager);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkNonce(Element target, TokenConsumerConfig config,String nsWsse,String nsWsu,NonceManager nmanager) returns Date[" + created + "]"));
        }
        return created;
    }
}

