/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.TokenId;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.lang.reflect.Constructor;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPATokenGenerator
implements TokenGeneratorComponent {
    private static final TraceComponent tc = Tr.register(LTPATokenGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPATokenGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document doc, Element parent, Map context) throws SoapSecurityException {
        boolean alreadyExist;
        QName tokenType;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        TokenGeneratorConfig config = (TokenGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenGeneratorConfig [" + config + "]."));
        }
        if ((tokenType = config.getType()) == null) {
            tokenType = com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No token value type defined in the Token Generator configuration, defualt [" + com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN.toString() + "] is used."));
            }
        } else if (!tokenType.equals(com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN) && !tokenType.equals(com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN_PROPAGATION)) {
            String tmp = com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN.toString() + ", " + com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN_PROPAGATION.toString();
            throw SoapSecurityException.format("security.wssecurity.WSEC0160E", new String[]{tokenType.toString(), clsName, tmp});
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int wssVersion = 0;
        Object obj2 = null;
        obj2 = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj2 != null && obj2 instanceof Integer) {
            wssVersion = (Integer)obj2;
        }
        boolean isStandAlone = config.isStandAlone();
        CallbackHandlerConfig cbhconf = config.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandlerConfig [" + config + "]."));
        }
        byte[] credToken = null;
        if (cbhconf != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invoking callback handler...");
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String cbhname = cbhconf.getClassName();
            CallbackHandler handler = cbhconf.getInstance();
            if (handler == null) {
                block29: {
                    try {
                        String unStr = cbhconf.getUserId();
                        char[] pwChr = cbhconf.getUserPassword();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Default username is [" + unStr + "]."));
                            Tr.debug((TraceComponent)tc, (String)"password is [XXXXXXXX].");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Instantiating the callback handler [" + cbhname + "]..."));
                        }
                        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Class<?> cls = null;
                        cls = loader != null ? loader.loadClass(cbhname) : Class.forName(cbhname);
                        if (CallbackHandler.class.isAssignableFrom(cls)) {
                            properties.put("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey", cbhconf);
                            Constructor<?> con = cls.getConstructor(String.class, char[].class, Map.class);
                            handler = (CallbackHandler)con.newInstance(unStr, pwChr, properties);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Succeeded to Instantiate the callback handler [" + cbhname + "]."));
                            }
                            break block29;
                        }
                        throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", cbhname, CallbackHandler.class.getName());
                    }
                    catch (SoapSecurityException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"238");
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s01", (Object)new Object[]{cbhname, e});
                        throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", cbhname, (Throwable)e);
                    }
                }
                cbhconf.setInstance(handler);
            }
            properties = new HashMap();
            if (messageContext != null) {
                properties.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
                properties.put("com.ibm.ws.webservices.wssecurity.constants.wssecurityContext", context);
                properties.put("com.ibm.ws.webservices.wssecurity.constants.tokenType", tokenType);
            }
            final Callback[] callbacks = new Callback[]{new BinaryTokenCallback("BinaryTokenCallback: "), new PropertyCallback(properties)};
            try {
                final CallbackHandler _handler = handler;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws PrivilegedActionException {
                        try {
                            _handler.handle(callbacks);
                        }
                        catch (Exception e) {
                            throw new PrivilegedActionException(e);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable th = e;
                if (th.getCause() != null && (th = th.getCause()).getCause() != null) {
                    th = th.getCause();
                }
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"290");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s02", (Object)new Object[]{cbhname, th});
                SoapSecurityException sse = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", cbhname, th);
                sse.initCause(e);
                throw sse;
            }
            credToken = ((BinaryTokenCallback)callbacks[0]).getCredToken();
        }
        if (credToken == null || credToken.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.WSEC0161E");
        }
        context.remove(Constants.WSSECURITY_KEY_EMBID);
        context.remove(Constants.WSSECURITY_KEY_REFERENCE);
        context.remove(Constants.WSSECURITY_KEY_ID);
        context.remove(Constants.WSSECURITY_KEY_NAME);
        context.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        context.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        String tokenId = null;
        if (isStandAlone && messageContext != null && (obj2 = messageContext.getProperty(Constants.WSSECURITY_TOKEN_PROPERGATION)) != null && obj2 instanceof Set) {
            for (Object obj2 : (Set)obj2) {
                TokenId tid;
                if (!(obj2 instanceof TokenId) || !tokenType.equals((tid = (TokenId)obj2).getType())) continue;
                if (tokenId == null) {
                    tokenId = tid.getId();
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("More than one TokenId objects are found. Since the runtime tentatively uses the first identifier + \"" + tokenId + "\"," + " it neglects the identifier \"" + tid.getId() + "\"."));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenIdentifier [" + tokenId + "]."));
        }
        if (!(alreadyExist = LTPATokenGenerator.checkToken(context, config, credToken))) {
            Element elem = LTPATokenGenerator.createTokenElement(doc, parent, config, credToken, tokenId, wssVersion);
            elem = (Element)parent.insertBefore(elem, parent.getFirstChild());
            LTPATokenGenerator.setTokenToSubject(context, config, credToken, tokenId, elem);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    private static boolean checkToken(Map context, TokenGeneratorConfig config, byte[] credToken) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkToken(Map context,TokenGeneratorConfig config,byte[] credToken)");
        }
        boolean ret = false;
        Set tokens = TokenManager.getTokens(context);
        if (tokens != null && tokens.size() > 0) {
            int h = 0;
            int len = credToken.length;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + credToken[i];
            }
            String uniqueId = String.valueOf(h);
            for (Object o : tokens) {
                LTPAToken t;
                if (!(o instanceof LTPAToken) || !(t = (LTPAToken)o).getUsedTokenGenerator().equals(config) || !t.getUniqueID().equals(uniqueId)) continue;
                ret = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkToken(Map context,TokenGeneratorConfig config,byte[] credToken) returns boolean[" + ret + "]"));
        }
        return ret;
    }

    private static Element createTokenElement(Document doc, Element parent, TokenGeneratorConfig config, byte[] credToken, String id, int wssVersion) {
        QName tokenType;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTokenElement(Document doc[" + doc + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "TokenGeneratorConfig config," + "byte[] credToken," + "String id[" + id + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        String nsWsse = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse:";
        } else if (pWsse.length() > 0) {
            pWsse = pWsse + ":";
        }
        Element tokenElem = doc.createElementNS(nsWsse, pWsse + "BinarySecurityToken");
        if (isDecl) {
            tokenElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", nsWsse);
        }
        if (id != null) {
            isDecl = false;
            String pWsu = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsu);
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu:";
            } else if (pWsse.length() > 0) {
                pWsu = pWsu + ":";
            }
            if (isDecl) {
                tokenElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", nsWsu);
            }
            tokenElem.setAttributeNS(com.ibm.ws.webservices.wssecurity.Constants.NS_WSU, pWsu + "Id", id);
        }
        if ((tokenType = config.getType()) == null) {
            tokenType = com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN;
        }
        tokenElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsst", tokenType.getNamespaceURI());
        DOMUtil.setQNameAttr(tokenElem, null, "EncodingType", com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY, wssVersion);
        DOMUtil.setQNameAttr(tokenElem, null, "ValueType", tokenType, wssVersion);
        String data = Base64.encode((byte[])credToken);
        tokenElem.appendChild(doc.createTextNode(data));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTokenElement(Document doc,Element parent,TokenGeneratorConfig config,byte[] credToken,String id,int wssVersion) returns Element[" + tokenElem + "]"));
        }
        return tokenElem;
    }

    private static void setTokenToSubject(Map context, TokenGeneratorConfig config, byte[] credToken, String id, Element elem) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokenToSubject(Map context,TokenGeneratorConfig config,byte[] credToken[" + credToken + "]," + "String id[" + id + "]," + "Element elem[" + DOMUtil.getDisplayName((Node)elem) + "])"));
        }
        LTPAToken token = new LTPAToken(id, credToken);
        token.setElement(elem);
        token.setReferenced(!config.isStandAlone());
        token.setUsedTokenGenerator(config);
        TokenManager.setToken(context, token);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokenToSubject(Map context,TokenGeneratorConfig config,byte[] credToken,String id,Element elem)");
        }
    }
}

