/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.wsspi.wssecurity.token.UsernameTokenConsumer;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IDAssertionUsernameTokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(IDAssertionUsernameTokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IDAssertionUsernameTokenConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "], " + "Map context)"));
        }
        TokenConsumerConfig config = (TokenConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + config + "]."));
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        NonceManager nmanager = (NonceManager)context.remove(NonceManager.class);
        if (target.getNodeType() == 1) {
            UsernameToken retToken;
            UsernameToken token;
            Element targetElem = (Element)target;
            String tokenId = null;
            String idattr = IdUtil.getInstance().getIdAttributeName(targetElem);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + idattr + "]."));
            }
            if (idattr != null) {
                tokenId = targetElem.getAttribute(idattr);
            }
            Boolean decouple = (Boolean)config.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
            boolean decoupleToken = true;
            if (decouple != null) {
                decoupleToken = decouple;
            }
            Element n = null;
            n = !decoupleToken ? targetElem : DOMUtil.clone(targetElem);
            final UsernameToken tokenPrivSetUsedTokenConsumer = token = new UsernameToken(tokenId, null, null, n);
            final TokenConsumerConfig configPriv = config;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(configPriv);
                    return null;
                }
            });
            IDAssertionUsernameTokenConsumer.setTokenToSubject(context, token);
            Element elem = DOMUtil.getOneElement((Element)targetElem, (String)nsWsse, (String)"Username");
            String username = null;
            if (elem != null) {
                username = DOMUtil.getStringValue((Node)elem);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Username [" + username + "]."));
                Tr.debug((TraceComponent)tc, (String)("isCallerRequired [" + config.isCallerRequired() + "]."));
            }
            if (!config.isCallerRequired()) {
                throw SoapSecurityException.format("security.wssecurity.IDAssertionUsernameTokenConsumer.s01", "isCalerRequired()=false");
            }
            elem = DOMUtil.getZeroOrOneElement((Element)targetElem, (String)nsWsse, (String)"Password");
            if (elem != null) {
                throw SoapSecurityException.format("security.wssecurity.IDAssertionUsernameTokenConsumer.s02", "<wsse:Password> != null.");
            }
            Date created = UsernameTokenConsumer.checkNonce(targetElem, config, nsWsse, nsWsu, nmanager);
            token.setDate(created);
            boolean delayLogin = false;
            if (config.getTrustedIDEvaluator() == null) {
                WSSConsumerConfig cconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                Set callers = cconfig.getCallers();
                QName UNT_TYPE = Constants.UNTOKEN;
                if (callers != null) {
                    for (WSSConsumerConfig.CallerConfig cconf : callers) {
                        QName type = cconf.getTokenType();
                        WSSConsumerConfig.CallerConfig cx = cconf.getTrustMethod();
                        if (!type.equals(UNT_TYPE) || cx == null) continue;
                        delayLogin = true;
                        break;
                    }
                }
            }
            if ((retToken = UsernameTokenConsumer.invokeLoginModule(config, username, null, messageContext, context, delayLogin)) != null) {
                username = retToken.getUsername();
            }
            final UsernameToken tokenPriv = token;
            final String usernamePriv = username;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tokenPriv.setUsername(usernamePriv);
                    return null;
                }
            });
            if (config.getTrustedIDEvaluator() != null) {
                final boolean trusted = config.getTrustedIDEvaluator().evaluate(username);
                final UsernameToken tokenPrivSetTrusted = token;
                if (!trusted) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{username});
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tokenPrivSetTrusted.setTrusted(trusted);
                        return null;
                    }
                });
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is [" + token + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + target.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target, Map context)");
        }
    }

    private static void setTokenToSubject(Map context, UsernameToken token) {
        TokenManager.setToken(context, token);
    }
}

