/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.keyinfo;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.keyinfo.KeyStoreKeyLocator;
import com.ibm.wsspi.wssecurity.keyinfo.X509TokenKeyLocator;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.namespace.QName;

public class SignerCertKeyLocator
implements KeyLocator {
    private static final TraceComponent tc = Tr.register(SignerCertKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509TokenKeyLocator.class.getName();
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_KEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Map type, Map context) throws SoapSecurityException {
        boolean isKeyName;
        boolean isKeyId;
        boolean isStrref;
        boolean isEmb;
        boolean isX509;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey(Map type,Map context)");
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String keyInfoType = (String)type.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (keyInfoType == null) {
            isX509 = false;
            isEmb = false;
            isStrref = false;
            isKeyId = false;
            isKeyName = false;
        } else {
            isKeyName = ConfigUtil.isKeyInfoKeyname((String)keyInfoType);
            isKeyId = ConfigUtil.isKeyInfoKeyid((String)keyInfoType);
            isStrref = ConfigUtil.isKeyInfoStrref((String)keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb((String)keyInfoType);
            isX509 = ConfigUtil.isKeyInfoX509issuer((String)keyInfoType);
        }
        String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        boolean isEncrypting = "EncryptingKey".equals(keyType);
        Key key = null;
        if (!isEncrypting) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey02", keyType);
        }
        key = this.getPublicKey(isKeyName, isKeyId, isStrref, isEmb, isX509, messageContext, type, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Map type, Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getPublicKey(boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, SOAPMessageContext messageContext, Map type, Map context) throws SoapSecurityException {
        Token token;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPublicKey(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "SOAPMessageContext messageContext," + "Map type," + "Map context)"));
        }
        PublicKey key = null;
        X509Certificate cert = this.getCertInRequest(messageContext);
        if (cert != null) {
            key = cert.getPublicKey();
            context.put(key, cert);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(key, certificate) from request put in context");
            }
        }
        if ((token = KeyStoreKeyLocator.getToken(isKeyName, isKeyId, isStrref, isEmb, isX509, type, context)) == null) {
            SignerCertKeyLocator.setInfo(isKeyName, isKeyId, isStrref, isEmb, isX509, cert, context);
        } else if (token instanceof X509BSToken && cert == null && (cert = ((X509BSToken)token).getCert()) != null && (key = cert.getPublicKey()) != null) {
            context.put(key, cert);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(key, certificate) from token put in context");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPublicKey(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,SOAPMessageContext messageContext,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private X509Certificate getCertInRequest(SOAPMessageContext messageContext) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCertInRequest(SOAPMessageContext messageContext)");
        }
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        X509Certificate cert = null;
        Object obj = messageContext.getProperty("com.ibm.xml.soapsec.RequestCert");
        if (!(obj instanceof X509Certificate)) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01");
        }
        cert = (X509Certificate)obj;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertInRequest(SOAPMessageContext messageContext) returns X509Certificate[" + cert + "]"));
        }
        return cert;
    }

    private static void setInfo(boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, X509Certificate cert, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setInfo(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "X509Certificate cert," + "Map context)"));
        }
        String subjectDN = null;
        String keyId = null;
        String issuerDN = null;
        String issuerSerial = null;
        if (isKeyName) {
            subjectDN = KeyInfo.X509Data.encodeDName((String)cert.getSubjectDN().getName());
        } else if (isKeyId) {
            try {
                QName encodingType = (QName)context.remove(Constants.WSSECURITY_KEY_ENCODING);
                QName idCalcMethod = (QName)context.remove(Constants.WSSECURITY_KEY_IDTYPE);
                if (com.ibm.ws.webservices.wssecurity.Constants.HEX_BINARY.equals(encodingType)) {
                    if (com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1.equals(idCalcMethod)) {
                        keyId = Hex.encode((byte[])SignerCertKeyLocator.makeIdentifier(cert, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1));
                    }
                    keyId = Hex.encode((byte[])SignerCertKeyLocator.makeIdentifier(cert, null));
                }
                if (com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1.equals(idCalcMethod)) {
                    keyId = Base64.encode((byte[])SignerCertKeyLocator.makeIdentifier(cert, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1));
                }
                keyId = Base64.encode((byte[])SignerCertKeyLocator.makeIdentifier(cert, null));
            }
            catch (NoSuchAlgorithmException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"284");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{e});
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", e);
            }
            catch (InvalidAlgorithmParameterException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"288");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{e});
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", e);
            }
        } else if (isStrref) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: TokenGenerator is responsible to set a X509 token to the Subject in case of STRREF.");
            }
        } else if (isEmb) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: TokenGenerator is responsible to set a X509 token to the Subject in case of EMB.");
            }
        } else if (isX509) {
            issuerDN = KeyInfo.X509Data.encodeDName((String)cert.getIssuerDN().getName());
            issuerSerial = cert.getSerialNumber().toString();
        }
        if (subjectDN != null) {
            context.put(Constants.WSSECURITY_KEY_NAME, subjectDN);
        } else {
            context.remove(Constants.WSSECURITY_KEY_NAME);
        }
        if (keyId != null) {
            context.put(Constants.WSSECURITY_KEY_ID, keyId);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ID);
        }
        if (issuerDN != null) {
            context.put(Constants.WSSECURITY_KEY_ISSUERNAME, issuerDN);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        }
        if (issuerSerial != null) {
            context.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, issuerSerial);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        context.remove(Constants.WSSECURITY_KEY_EMBID);
        context.remove(Constants.WSSECURITY_KEY_REFERENCE);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInfo(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,X509Certificate cert,Map context)");
        }
    }

    private static byte[] makeIdentifier(Certificate cert, QName idty) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("makeIdentifier(Certificate cert,QName idty[" + idty + "])"));
        }
        byte[] bits = null;
        if (cert != null && ((bits = SignerCertKeyLocator.certToIdentifier(cert)) == null || idty != null)) {
            if (idty == null || NamespaceUtil.equals((QName)idty, (QName)com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                if (bits == null || bits.length != 20) {
                    bits = SignerCertKeyLocator.pubkeyToIdentifier(cert, idty);
                }
            } else if (NamespaceUtil.equals((QName)idty, (QName)com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                if (bits == null || bits.length != 8) {
                    bits = SignerCertKeyLocator.pubkeyToIdentifier(cert, idty);
                }
            } else {
                throw new IllegalArgumentException("Internal Error: " + idty);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"makeIdentifier(Certificate cert,QName idty)");
        }
        return bits;
    }

    private static byte[] certToIdentifier(Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("certToIdentifier(Certificate cert[" + cert + "])"));
        }
        if (!(cert instanceof X509Certificate)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
            }
            return null;
        }
        byte[] der = ((X509Certificate)cert).getExtensionValue(OID_KEYIDENTIFIER);
        if (der == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
            }
            return null;
        }
        byte[] ki = new byte[der.length - 4];
        System.arraycopy(der, 4, ki, 0, der.length - 4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
        }
        return ki;
    }

    private static byte[] pubkeyToIdentifier(Certificate cert, QName idty) throws NoSuchAlgorithmException {
        byte[] bits;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("pubkeyToIdentifier(Certificate cert[" + cert + "]," + "QName idty[" + idty + "])"));
        }
        byte[] key = cert.getPublicKey().getEncoded();
        MessageDigest digester = MessageDigest.getInstance("SHA");
        if (key[0] != 48) {
            throw new RuntimeException("Unknown encoded key: " + Hex.encode((byte[])key));
        }
        int len = key[1] & 0xFF;
        int offset = (len & 0x80) == 0 ? 2 : 2 + (len & 0x7F);
        len = key[offset + 1] & 0xFF;
        if ((len & 0x80) == 0) {
            offset += 2;
        } else {
            int lenoff = offset + 2;
            offset += 2 + (len & 0x7F);
            switch (len & 0x7F) {
                case 1: {
                    len = key[lenoff] & 0xFF;
                    break;
                }
                case 2: {
                    len = ((key[lenoff] & 0xFF) << 8) + (key[lenoff + 1] & 0xFF);
                    break;
                }
                case 3: {
                    len = ((key[lenoff] & 0xFF) << 16) + ((key[lenoff + 1] & 0xFF) << 8) + (key[lenoff + 2] & 0xFF);
                    break;
                }
                case 4: {
                    len = ((key[lenoff] & 0xFF) << 24) + ((key[lenoff + 1] & 0xFF) << 16) + ((key[lenoff + 2] & 0xFF) << 8) + (key[lenoff + 3] & 0xFF);
                    break;
                }
                default: {
                    throw new RuntimeException("Integer overflow: " + Hex.encode((byte[])key));
                }
            }
        }
        if (key[offset += len] != 3) {
            throw new RuntimeException("Non BIT STRING: 0x" + Integer.toString(key[offset] & 0xFF, 16));
        }
        offset += ((len = key[offset + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (len & 0x7F);
        if (NamespaceUtil.equals((QName)idty, (QName)com.ibm.ws.webservices.wssecurity.Constants.ITSHA1) || idty == null) {
            digester.update(key, offset, key.length - offset);
            bits = digester.digest();
        } else if (NamespaceUtil.equals((QName)idty, (QName)com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
            digester.update(key, offset, key.length - offset);
            byte[] digest = digester.digest();
            bits = new byte[8];
            bits[0] = (byte)(64 + (digest[digest.length - 8] & 0xF));
            System.arraycopy(digest, digest.length - 8 + 1, bits, 1, bits.length - 1);
        } else {
            throw new IllegalArgumentException("Internal Error: " + idty);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pubkeyToIdentifier(Certificate cert,QName idty)");
        }
        return bits;
    }
}

