/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.ValidationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.ValidationResultImpl;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.ValidationResult;

public class WSSecurityPropagationHelper {
    private static WSSecurityPropagationHelper wsSecurityPropagationHelper = null;
    public static boolean rmiInboundPropagationEnabled = false;
    public static boolean rmiOutboundPropagationEnabled = false;
    public static boolean webInboundPropagationEnabled = false;
    private static final WebSphereRuntimePermission UPDATE_PROP = new WebSphereRuntimePermission("setPropagationToken");
    private static final WebSphereRuntimePermission VALIDATE_TOKEN = new WebSphereRuntimePermission("validateLTPAToken");
    private static final TraceComponent tc = Tr.register(WSSecurityPropagationHelper.class, null, "com.ibm.ejs.resources.security");

    public static WSSecurityPropagationHelper getInstance() {
        if (wsSecurityPropagationHelper == null) {
            wsSecurityPropagationHelper = new WSSecurityPropagationHelper();
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            rmiInboundPropagationEnabled = Boolean.valueOf(ctxMgr.getProperty("com.ibm.CSI.rmiInboundPropagationEnabled"));
            rmiOutboundPropagationEnabled = Boolean.valueOf(ctxMgr.getProperty("com.ibm.CSI.rmiOutboundPropagationEnabled"));
            webInboundPropagationEnabled = Boolean.valueOf(ctxMgr.getProperty("com.ibm.ws.security.webInboundPropagationEnabled"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RMI inbound propagation enabled: " + rmiInboundPropagationEnabled);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RMI outbound propagation enabled: " + rmiOutboundPropagationEnabled);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WEB inbound propagation enabled: " + webInboundPropagationEnabled);
            }
        }
        return wsSecurityPropagationHelper;
    }

    private WSSecurityPropagationHelper() {
    }

    public boolean isRMIInboundPropagationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRMIInboundPropagationEnabled()");
        }
        boolean rmiInboundPropagationEnabled = false;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        rmiInboundPropagationEnabled = Boolean.valueOf(ctxMgr.getProperty("com.ibm.CSI.rmiInboundPropagationEnabled"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRMIInboundPropagationEnabled()", rmiInboundPropagationEnabled);
        }
        return rmiInboundPropagationEnabled;
    }

    public boolean isRMIOutboundPropagationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRMIOutboundPropagationEnabled()");
        }
        boolean rmiOutboundPropagationEnabled = false;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        rmiOutboundPropagationEnabled = Boolean.valueOf(ctxMgr.getProperty("com.ibm.CSI.rmiOutboundPropagationEnabled"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRMIOutboundPropagationEnabled()", rmiOutboundPropagationEnabled);
        }
        return rmiOutboundPropagationEnabled;
    }

    public boolean isWebInboundPropagationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWebInboundPropagationEnabled()");
        }
        boolean webInboundPropagationEnabled = false;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        webInboundPropagationEnabled = Boolean.valueOf(ctxMgr.getProperty("com.ibm.ws.security.webInboundPropagationEnabled"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "webInboundPropagationEnabled()", webInboundPropagationEnabled);
        }
        return webInboundPropagationEnabled;
    }

    public static PropagationToken getPropagationToken(String name, int version) throws WSSecurityException {
        String key = name + ":" + version;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking up propagation token with key " + key);
        }
        return ContextManagerFactory.getInstance().getPropagationToken(key);
    }

    public static PropagationToken addPropagationToken(PropagationToken token) throws WSSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + UPDATE_PROP.toString());
            }
            sm.checkPermission(UPDATE_PROP);
        }
        String key = token.getName() + ":" + token.getVersion();
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        PropagationToken existing_token = ctxMgr.getPropagationToken(key);
        if (existing_token != null) {
            Tr.warning(tc, "security.sap.warning.propagation.token.exists", new Object[]{token.getName(), new Short(token.getVersion())});
            return existing_token;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting propagation token with key " + key);
        }
        return ctxMgr.setPropagationToken(key, token);
    }

    public static String validateLTPAToken(byte[] token) throws WSLoginFailedException {
        block11: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + VALIDATE_TOKEN.toString());
                }
                sm.checkPermission(VALIDATE_TOKEN);
            }
            try {
                Token ltpa_token_object = ContextManagerFactory.getInstance().getWSCredTokenMapper().validateLTPAToken(token);
                if (ltpa_token_object != null) {
                    String[] accessID = ltpa_token_object.getAttributes("u");
                    String securityName = null;
                    if (accessID != null && accessID[0] != null) {
                        int index = accessID[0].indexOf(":");
                        securityName = accessID[0].startsWith("user:") ? accessID[0].substring(index + 1) : accessID[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Returning securityName: " + securityName);
                        }
                        return securityName;
                    }
                    break block11;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Throwing WSLoginFailedException, token was null.");
                }
                throw new WSLoginFailedException("Invalid token, token returned from validation is null.");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received exception during validation.", new Object[]{e});
                }
                Manager.Ffdc.log(e, WSSecurityPropagationHelper.class, "com.ibm.ws.security.token.WSSecurityPropagationHelper.validateLTPAToken", "289");
                if (e instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)e;
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning null.");
        }
        return null;
    }

    public static ValidationResult validateToken(byte[] token) throws ValidationFailedException {
        ValidationResultImpl result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[])", "token=" + token);
        }
        try {
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            String accessId = WSSecurityPropagationHelper.validateLTPAToken(token);
            result = new ValidationResultImpl(ctxMgr, accessId);
        }
        catch (WSLoginFailedException e) {
            Manager.Ffdc.log(e, WSSecurityPropagationHelper.class, "com.ibm.ws.security.token.WSSecurityPropagationHelper.validateToken", "311");
            throw new ValidationFailedException("An exception was thrown while validating received token.", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken(byte[])", "ValidationResult=" + result);
        }
        return result;
    }

    public static ValidationResult validateToken(byte[] token, boolean validateRealm) throws ValidationFailedException {
        ValidationResultImpl result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[], boolean)", "token=" + token + " boolean = " + validateRealm);
        }
        try {
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            String accessId = WSSecurityPropagationHelper.validateLTPAToken(token);
            if (validateRealm) {
                WSSecurityPropagationHelper.validateTokenRealm(token);
            }
            result = new ValidationResultImpl(ctxMgr, accessId);
        }
        catch (WSLoginFailedException e) {
            Manager.Ffdc.log(e, WSSecurityPropagationHelper.class, "com.ibm.ws.security.token.WSSecurityPropagationHelper.validateToken", "311");
            throw new ValidationFailedException("An exception was thrown while validating received token.", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken(byte[], boolean)", "ValidationResult=" + result);
        }
        return result;
    }

    public static void validateTokenRealm(byte[] token) throws ValidationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTokenRealm(byte[])", "token=" + token);
        }
        try {
            Token ltpa_token_object = ContextManagerFactory.getInstance().getWSCredTokenMapper().validateLTPAToken(token);
            ContextManagerFactory.getInstance().getWSCredTokenMapper().validateTokenRealm(ltpa_token_object);
        }
        catch (Exception e) {
            throw new ValidationFailedException("An exception was thrown while validating realm in received token.", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTokenRealm(byte[])");
        }
    }

    public static String getUserFromUniqueID(String uniqueID) {
        return RealmSecurityName.getSecurityName(uniqueID);
    }

    public static String getRealmFromUniqueID(String uniqueID) {
        int index = uniqueID.indexOf(":");
        if (uniqueID.startsWith("user:")) {
            uniqueID = uniqueID.substring(index + 1);
        }
        return RealmSecurityName.getRealm(uniqueID);
    }
}

