/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSSMarkerObject;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.Token;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class WSOpaqueTokenHelper {
    private static WSOpaqueTokenHelper wsOpaqueTokenHelper = null;
    public static final String tokenHeader = "WSOPAQUE";
    private final byte[] tokenHeaderBytes = StringBytesConversion.getConvertedBytes("WSOPAQUE");
    private final int tokenHeaderSize = this.tokenHeaderBytes.length;
    private final int tokenVersion = 1;
    private final String tokenHeaderLookup = "WSOPAQUE:1";
    public static final String wsCredHashHeader = "WSCREDHASH";
    private final byte[] wsCredHashHeaderBytes = StringBytesConversion.getConvertedBytes("WSCREDHASH");
    private final int wsCredHashHeaderSize = this.wsCredHashHeaderBytes.length;
    public static final String wsTokensHeader = "WSTOKEN";
    private final byte[] wsTokensHeaderBytes = StringBytesConversion.getConvertedBytes("WSTOKEN");
    private final int wsTokensHeaderSize = this.wsTokensHeaderBytes.length;
    public static final String customTokensHeader = "CUSTOM";
    private final byte[] customTokensHeaderBytes = StringBytesConversion.getConvertedBytes("CUSTOM");
    private final int customTokensHeaderSize = this.customTokensHeaderBytes.length;
    public static final String customPublicTokensHeader = "CUSTOM_PUBLIC";
    public static final String customPublicTokensHeaderEnding = " (1)";
    public static final String customPrivateTokensHeader = "CUSTOM_PRIVATE";
    public static final String customPrivateTokensHeaderEnding = " (2)";
    public static final String customPrincipalTokensHeader = "CUSTOM_PRINCIPAL";
    public static final String customPrincipalTokensHeaderEnding = " (3)";
    private static ArrayList excludeList = null;
    private static boolean throwExceptionForAllPropagationSerializationProblems = false;
    private static final TraceComponent tc = Tr.register(WSOpaqueTokenHelper.class, "SASRas", "com.ibm.ejs.resources.security");

    public static WSOpaqueTokenHelper getInstance() {
        if (wsOpaqueTokenHelper == null) {
            wsOpaqueTokenHelper = new WSOpaqueTokenHelper();
        }
        return wsOpaqueTokenHelper;
    }

    private WSOpaqueTokenHelper() {
        ContextManager contextManager = ContextManagerFactory.getInstance();
        try {
            SecurityConfigObject security2 = null;
            String throwExceptionForAllPropagationSerializationProblemsProperty = null;
            SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
            if (scm != null) {
                security2 = scm.getObject("security");
            }
            if (security2 != null) {
                throwExceptionForAllPropagationSerializationProblemsProperty = security2.getProperties().getProperty("com.ibm.CSI.throwExceptionForAllPropagationSerializationProblems");
                throwExceptionForAllPropagationSerializationProblems = throwExceptionForAllPropagationSerializationProblemsProperty != null && (throwExceptionForAllPropagationSerializationProblemsProperty.equalsIgnoreCase("true") || throwExceptionForAllPropagationSerializationProblemsProperty.equalsIgnoreCase("yes"));
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.wsspi.security.token.WSOpaqueTokenHelper.init", "155", this);
            Tr.debug(tc, "Exception getting ContextManager.", new Object[]{e});
            contextManager.setRootException(e);
        }
    }

    public String getOpaqueTokenName() {
        return tokenHeader;
    }

    public String getOpaqueTokenLookup() {
        return "WSOPAQUE:1";
    }

    public int getOpaqueTokenVersion() {
        return 1;
    }

    public byte[] createOpaqueTokenFromSubject(final Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOpaqueTokenFromSubject");
        }
        if (subject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            return null;
        }
        try {
            int i;
            ArrayList subjectTokenHolderList = null;
            ArrayList propagationTokenHolderList = null;
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                try {
                    subjectTokenHolderList = (ArrayList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws WSLoginFailedException {
                            return WSOpaqueTokenHelper.this.getForwardableTokensFromSubject(subject);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Manager.Ffdc.log(e.getException(), this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromSubject", "267", this);
                    Tr.debug(tc, "Exception getting private/public tokens from Subject.", new Object[]{e.getException()});
                    return null;
                }
                if (subjectTokenHolderList == null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token list is null.");
                }
                if ((propagationTokenHolderList = ContextManagerFactory.getInstance().getWSCredTokenMapper().getForwardablePropagationTokensFromContext()) == null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "propagation token list is null.");
                }
            }
            if (propagationTokenHolderList == null && subjectTokenHolderList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Propagation and subject token lists are null.");
            }
            ArrayList<Object> tokenHolderList = new ArrayList<Object>();
            if (propagationTokenHolderList != null) {
                Object[] propagationTokenHolderArray = propagationTokenHolderList.toArray();
                for (i = 0; i < propagationTokenHolderArray.length; ++i) {
                    tokenHolderList.add(propagationTokenHolderArray[i]);
                }
            }
            if (subjectTokenHolderList != null) {
                Object[] subjectTokenHolderArray = subjectTokenHolderList.toArray();
                for (i = 0; i < subjectTokenHolderArray.length; ++i) {
                    tokenHolderList.add(subjectTokenHolderArray[i]);
                }
            }
            if (tokenHolderList.size() > 0 && SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
                String cacheKey = ContextManagerFactory.getInstance().getWSCredTokenMapper().createUniqueIDFromAllTokens(subject);
                if (cacheKey == null) {
                    WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                    cacheKey = wsCred.getRealmName() + ":" + wsCred.getUniqueSecurityName();
                }
                TokenHolder th = new TokenHolder(StringBytesConversion.getConvertedBytes(cacheKey), "com.ibm.wsspi.security.cred.cacheKey", 1);
                tokenHolderList.add(th);
            } else if (tokenHolderList.size() > 0) {
                WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                String cacheKey = wsCred.getRealmName() + ":" + wsCred.getUniqueSecurityName();
                TokenHolder th = new TokenHolder(StringBytesConversion.getConvertedBytes(cacheKey), "com.ibm.wsspi.security.cred.cacheKey", 1);
                tokenHolderList.add(th);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            return this.createOpaqueTokenFromTokenHolderList(subject, tokenHolderList);
        }
        catch (WSLoginFailedException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSLoginFailedException occurred creating opaque token.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.updatePropagationTokenWithSubjectChange", "345", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            throw e;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.updatePropagationTokenWithSubjectChange", "352", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public synchronized byte[] createOpaqueTokenFromTokenHolderList(Subject subject, ArrayList tokenHolders) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOpaqueTokenFromTokenHolderList");
        }
        if ((tokenHolders == null || tokenHolders.size() == 0) && tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning null token.", new Object[]{tokenHolders});
        }
        try {
            DataOutputStream dos;
            ByteArrayOutputStream baos;
            block35: {
                baos = new ByteArrayOutputStream(500);
                dos = new DataOutputStream(baos);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token header size: " + this.tokenHeaderSize);
                }
                dos.write(this.tokenHeaderBytes, 0, this.tokenHeaderSize);
                dos.write(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing opaque token header/version: WSOPAQUE/V1");
                }
                WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
                Hashtable table = null;
                if (cred != null) {
                    table = ((WSCredentialImpl)cred).getTable();
                }
                byte[] table_bytes = null;
                int table_bytes_len = 0;
                if (table != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to write wsCred hashtable.");
                    }
                    try {
                        table_bytes = this.serialize_internal(table, ObjectOutputStream.class);
                        if (table_bytes != null) {
                            table_bytes_len = table_bytes.length;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Offset size: " + baos.size());
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "wsCredHashHeaderSize: " + this.wsCredHashHeaderSize);
                            }
                            dos.write(this.wsCredHashHeaderBytes, 0, this.wsCredHashHeaderSize);
                            dos.writeInt(table_bytes_len);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Writing wsCred hashtable, length: " + table_bytes_len);
                            }
                            dos.write(table_bytes, 0, table_bytes_len);
                        }
                    }
                    catch (Exception e) {
                        table_bytes = null;
                        table_bytes_len = 0;
                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{table});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred writing wsCred hashtable.", new Object[]{e});
                        }
                        if (!throwExceptionForAllPropagationSerializationProblems) break block35;
                        throw e;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total tokens to write: " + tokenHolders.size());
            }
            dos.write(this.wsTokensHeaderBytes, 0, this.wsTokensHeaderSize);
            dos.write(tokenHolders.size());
            for (int i = 0; i < tokenHolders.size(); ++i) {
                String token_name = null;
                int token_name_len = 0;
                byte[] token_name_bytes = null;
                int token_version = 0;
                byte[] token_bytes = null;
                int token_bytes_len = 0;
                TokenHolder th = (TokenHolder)tokenHolders.get(i);
                if (th == null) continue;
                token_name = th.getName();
                token_version = th.getVersion();
                token_bytes = th.getBytes();
                if (token_name == null || token_version == 0 || token_bytes == null) continue;
                token_name_bytes = StringBytesConversion.getConvertedBytes(token_name);
                token_name_len = token_name_bytes.length;
                token_bytes_len = token_bytes.length;
                dos.writeInt(token_name_len);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token name: " + token_name);
                }
                dos.write(token_name_bytes, 0, token_name_len);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token version: " + token_version);
                }
                dos.write(token_version);
                dos.writeInt(token_bytes_len);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token bytes, length: " + token_bytes_len);
                }
                dos.write(token_bytes, 0, token_bytes_len);
            }
            ArrayList customObjectsList = null;
            try {
                if (subject != null) {
                    final Subject subjectPriv = subject;
                    customObjectsList = (ArrayList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws Exception {
                            Subject subject = subjectPriv;
                            synchronized (subject) {
                                ArrayList<TokenHolder> customObjects = new ArrayList<TokenHolder>();
                                Object var3_3 = null;
                                byte[] objectBytes = null;
                                for (Object object : subjectPriv.getPublicCredentials()) {
                                    if (object instanceof Token || object instanceof KRBAuthnToken || object instanceof WSCredential || WSOpaqueTokenHelper.this.isExcluded(object)) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom public object: ", new Object[]{object});
                                        }
                                        objectBytes = WSOpaqueTokenHelper.this.serialize_internal(object, ObjectOutputStream.class);
                                        String tokenName = null;
                                        try {
                                            String object_class_name = object.getClass().getName();
                                            tokenName = object_class_name + WSOpaqueTokenHelper.customPublicTokensHeaderEnding;
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        if (tokenName == null) {
                                            tokenName = WSOpaqueTokenHelper.customPublicTokensHeader;
                                        }
                                        if (objectBytes == null) continue;
                                        customObjects.add(new TokenHolder(objectBytes, tokenName, 1));
                                    }
                                    catch (Exception e) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{object});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{e});
                                        }
                                        Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "536", this);
                                        if (!throwExceptionForAllPropagationSerializationProblems) continue;
                                        throw e;
                                    }
                                }
                                for (Object object : subjectPriv.getPrivateCredentials()) {
                                    if (object instanceof Token || object instanceof KRBAuthnToken || object instanceof WSCredential || WSOpaqueTokenHelper.this.isExcluded(object)) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom private object: ", new Object[]{object});
                                        }
                                        objectBytes = WSOpaqueTokenHelper.this.serialize_internal(object, ObjectOutputStream.class);
                                        String tokenName = null;
                                        try {
                                            String object_class_name = object.getClass().getName();
                                            tokenName = object_class_name + WSOpaqueTokenHelper.customPrivateTokensHeaderEnding;
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        if (tokenName == null) {
                                            tokenName = WSOpaqueTokenHelper.customPrivateTokensHeader;
                                        }
                                        if (objectBytes == null) continue;
                                        customObjects.add(new TokenHolder(objectBytes, tokenName, 1));
                                    }
                                    catch (Exception e) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{object});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{e});
                                        }
                                        Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "578", this);
                                        if (!throwExceptionForAllPropagationSerializationProblems) continue;
                                        throw e;
                                    }
                                }
                                for (Principal principal : subjectPriv.getPrincipals()) {
                                    if (principal instanceof WSPrincipal || WSOpaqueTokenHelper.this.isExcluded(principal)) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom principal object: ", new Object[]{principal});
                                        }
                                        objectBytes = WSOpaqueTokenHelper.this.serialize_internal(principal, ObjectOutputStream.class);
                                        String tokenName = null;
                                        try {
                                            String object_class_name = principal.getClass().getName();
                                            tokenName = object_class_name + WSOpaqueTokenHelper.customPrincipalTokensHeaderEnding;
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        if (tokenName == null) {
                                            tokenName = WSOpaqueTokenHelper.customPrincipalTokensHeader;
                                        }
                                        if (objectBytes == null) continue;
                                        customObjects.add(new TokenHolder(objectBytes, tokenName, 1));
                                    }
                                    catch (Exception e) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{principal});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{e});
                                        }
                                        Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "619", this);
                                        if (!throwExceptionForAllPropagationSerializationProblems) continue;
                                        throw e;
                                    }
                                }
                                return customObjects;
                            }
                        }
                    });
                }
            }
            catch (PrivilegedActionException e) {
                Manager.Ffdc.log(e.getException(), this, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.commit", "636", this);
                ContextManager contextManager = ContextManagerFactory.getInstance();
                contextManager.setRootException(e.getException());
                throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
            }
            if (customObjectsList != null && customObjectsList.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Total custom tokens to write: " + customObjectsList.size());
                }
                dos.write(this.customTokensHeaderBytes, 0, this.customTokensHeaderSize);
                dos.write(customObjectsList.size());
                for (int i = 0; i < customObjectsList.size(); ++i) {
                    String token_name = null;
                    int token_name_len = 0;
                    byte[] token_name_bytes = null;
                    int token_version = 0;
                    byte[] token_bytes = null;
                    int token_bytes_len = 0;
                    TokenHolder th = (TokenHolder)customObjectsList.get(i);
                    if (th == null) continue;
                    token_name = th.getName();
                    token_version = th.getVersion();
                    token_bytes = th.getBytes();
                    if (token_name == null || token_version == 0 || token_bytes == null) continue;
                    token_name_bytes = StringBytesConversion.getConvertedBytes(token_name);
                    token_name_len = token_name_bytes.length;
                    token_bytes_len = token_bytes.length;
                    dos.writeInt(token_name_len);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token name: " + token_name);
                    }
                    dos.write(token_name_bytes, 0, token_name_len);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token version: " + token_version);
                    }
                    dos.write(token_version);
                    dos.writeInt(token_bytes_len);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token bytes, length: " + token_bytes_len);
                    }
                    dos.write(token_bytes, 0, token_bytes_len);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total opaque token length: " + baos.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromTokenHolderList");
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "704", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromTokenHolderList");
            }
            if (throwExceptionForAllPropagationSerializationProblems) {
                throw e;
            }
            return null;
        }
    }

    public ArrayList createTokenHolderListFromOpaqueToken(byte[] opaque_token) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTokenHolderListFromOpaqueToken");
        }
        if (opaque_token == null || opaque_token.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning null token holder ArrayList.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTokenHolderListFromOpaqueToken");
            }
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(opaque_token);
            DataInputStream dis = new DataInputStream(bais);
            boolean isWASAuthzToken = this.checkOpaqueTokenHeader(dis);
            if (isWASAuthzToken) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Successfully read the opaque token header, beginning to process token.");
                }
                ArrayList<TokenHolder> tokenHolderList = new ArrayList<TokenHolder>();
                boolean isWASCredHashHeader = this.checkCredHashHeader(dis);
                if (isWASCredHashHeader) {
                    byte[] table_bytes = null;
                    table_bytes = this.readCredHashTableBytes(dis);
                    if (table_bytes != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully retrieved wsCredHash bytes.");
                        }
                        tokenHolderList.add(new TokenHolder(table_bytes, wsCredHashHeader, 1));
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "wsCredHash bytes could not be read from InputStream.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The wsCred hashtable not present in opaque byte array.");
                }
                boolean isWASTokensHeader = this.checkTokensHeader(dis);
                if (isWASTokensHeader) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reading standard tokens from opaque token.");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There are no tokens present in opaque byte array.");
                    }
                    throw new WSSecurityException("There are no tokens present in opaque byte array.");
                }
                this.readTokens(dis, tokenHolderList);
                isWASTokensHeader = this.checkCustomTokensHeader(dis);
                if (isWASTokensHeader) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reading custom tokens from opaque token.");
                    }
                    this.readTokens(dis, tokenHolderList);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There are no custom tokens present in opaque byte array.");
                }
                return tokenHolderList;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not a WAS opaque authorization token, returning null.");
            }
            return null;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "817", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTokenHolderListFromOpaqueToken");
            }
            if (throwExceptionForAllPropagationSerializationProblems) {
                if (e instanceof WSSecurityException) {
                    throw (WSSecurityException)e;
                }
                throw new WSSecurityException(e.getMessage(), e);
            }
            return null;
        }
    }

    private void readTokens(DataInputStream dis, ArrayList tokenHolderList) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readTokens");
        }
        try {
            int num_tokens = dis.readByte();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of tokens to be handled: " + num_tokens);
            }
            for (int i = 0; i < num_tokens; ++i) {
                String token_name = null;
                byte[] token_name_bytes = null;
                int token_name_len = 0;
                byte token_version = 0;
                byte[] token_bytes = null;
                int token_bytes_len = 0;
                token_name_len = dis.readInt();
                token_name_bytes = new byte[token_name_len];
                dis.read(token_name_bytes, 0, token_name_len);
                token_name = StringBytesConversion.getConvertedString(token_name_bytes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found token name: " + token_name);
                }
                token_version = dis.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token version: " + token_version);
                }
                token_bytes_len = dis.readInt();
                token_bytes = new byte[token_bytes_len];
                dis.read(token_bytes, 0, token_bytes_len);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token bytes length: " + token_bytes_len);
                }
                if (token_bytes == null || token_name == null) {
                    throw new WSSecurityException("malformed token, cannot retrieve token bytes.");
                }
                tokenHolderList.add(new TokenHolder(token_bytes, token_name, token_version));
            }
        }
        catch (WSSecurityException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readTokens", "885", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readTokens exception", new Object[]{e});
            }
            throw e;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readTokens", "891", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readTokens exception", new Object[]{e});
            }
            throw new WSSecurityException(e.getMessage(), e);
        }
    }

    private byte[] readCredHashTableBytes(DataInputStream dis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readCredHashTableBytes");
        }
        try {
            dis.mark(dis.available());
            int hash_bytes_len = 0;
            byte[] hash_bytes = null;
            hash_bytes_len = dis.readInt();
            if (hash_bytes_len > 0) {
                hash_bytes = new byte[hash_bytes_len];
                dis.read(hash_bytes, 0, hash_bytes_len);
                return hash_bytes;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readCredHashTableBytes, invalid size = " + hash_bytes_len);
            }
            return null;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readCredHashTableBytes", "932", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readCredHashTableBytes exception", new Object[]{e});
            }
            return null;
        }
    }

    private boolean checkOpaqueTokenHeader(DataInputStream dis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkOpaqueTokenHeader");
        }
        try {
            byte[] header = null;
            String headerString = null;
            header = new byte[this.tokenHeaderSize];
            dis.read(header, 0, this.tokenHeaderSize);
            if (header != null) {
                headerString = StringBytesConversion.getConvertedString(header);
                if (headerString.equals(tokenHeader)) {
                    byte version = dis.readByte();
                    if (version == 1) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "checkOpaqueTokenHeader, true");
                        }
                        return true;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkOpaqueTokenHeader, version mismatch, version = " + version);
                    }
                    return false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkOpaqueTokenHeader, invalid header, false");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkOpaqueTokenHeader, no header, false");
            }
            return false;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkOpaqueTokenHeader", "987", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkOpaqueTokenHeader exception", new Object[]{e});
            }
            return false;
        }
    }

    private boolean checkCredHashHeader(DataInputStream dis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCredHashHeader");
        }
        try {
            dis.mark(dis.available());
            byte[] header = null;
            String headerString = null;
            header = new byte[this.wsCredHashHeaderSize];
            dis.read(header, 0, this.wsCredHashHeaderSize);
            if (header != null) {
                headerString = StringBytesConversion.getConvertedString(header);
                if (headerString.equals(wsCredHashHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkCredHashHeader, true");
                    }
                    return true;
                }
                dis.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCredHashHeader, false");
                }
                return false;
            }
            dis.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCredHashHeader, no header, false");
            }
            return false;
        }
        catch (Exception e) {
            try {
                dis.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkCredHashHeader", "1041", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCredHashHeader exception", new Object[]{e});
            }
            return false;
        }
    }

    private boolean checkTokensHeader(DataInputStream dis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTokensHeader");
        }
        try {
            dis.mark(dis.available());
            byte[] header = null;
            String headerString = null;
            header = new byte[this.wsTokensHeaderSize];
            dis.read(header, 0, this.wsTokensHeaderSize);
            if (header != null) {
                headerString = StringBytesConversion.getConvertedString(header);
                if (headerString.equals(wsTokensHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkTokensHeader, true");
                    }
                    return true;
                }
                dis.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTokensHeader, false");
                }
                return false;
            }
            dis.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkTokensHeader, no header, false");
            }
            return false;
        }
        catch (Exception e) {
            try {
                dis.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkTokensHeader", "1095", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkTokensHeader exception", new Object[]{e});
            }
            return false;
        }
    }

    private boolean checkCustomTokensHeader(DataInputStream dis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCustomTokensHeader");
        }
        try {
            dis.mark(dis.available());
            byte[] header = null;
            String headerString = null;
            header = new byte[this.customTokensHeaderSize];
            dis.read(header, 0, this.customTokensHeaderSize);
            if (header != null) {
                headerString = StringBytesConversion.getConvertedString(header);
                if (headerString.equals(customTokensHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkCustomTokensHeader, true");
                    }
                    return true;
                }
                dis.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCustomTokensHeader, false");
                }
                return false;
            }
            dis.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCustomTokensHeader, no header, false");
            }
            return false;
        }
        catch (Exception e) {
            try {
                dis.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkCustomTokensHeader", "1149", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCustomTokensHeader exception", new Object[]{e});
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize_internal(Object src, Class oosClass) throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bs);
        byte[] ret = null;
        try {
            try {
                oos.writeObject(src);
                ret = bs.toByteArray();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) throw e;
                Tr.debug(tc, "Exception serializing object. ", new Object[]{e});
                throw e;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                oos.close();
                bs.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        oos.close();
        bs.close();
        return ret;
    }

    public static byte[] serialize(Object src) throws Exception {
        return WSOpaqueTokenHelper.serialize(src, ObjectOutputStream.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] serialize(Object src, Class oosClass) throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bs);
        byte[] ret = null;
        try {
            try {
                oos.writeObject(src);
                ret = bs.toByteArray();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) throw e;
                Tr.debug(tc, "Exception serializing object. ", new Object[]{e});
                throw e;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                oos.close();
                bs.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        oos.close();
        bs.close();
        return ret;
    }

    public static Object deserialize(byte[] buf) throws Exception {
        return WSOpaqueTokenHelper.deserialize(buf, WsObjectInputStream.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserialize(byte[] data, Class oisClass) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        WsObjectInputStream ois = new WsObjectInputStream(bais);
        Object ret = null;
        try {
            try {
                ret = ois.readObject();
            }
            catch (Exception e) {
                Tr.warning(tc, "security.sap.warning.deserializing.custom.objects.from.subject");
                if (!tc.isDebugEnabled()) throw e;
                Tr.debug(tc, "Exception deserializing object. ", new Object[]{e});
                throw e;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                ois.close();
                bais.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        ois.close();
        bais.close();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getForwardableTokensFromSubject(Subject subject) throws WSLoginFailedException {
        if (subject == null) {
            Tr.debug(tc, "Null Subject passed in.");
            return null;
        }
        try {
            Subject subject2 = subject;
            synchronized (subject2) {
                ArrayList<TokenHolder> tokens = new ArrayList<TokenHolder>();
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                Set<Object> publicCredentials = subject.getPublicCredentials();
                for (Object token : privateCredentials) {
                    Token tokenObject;
                    if (token instanceof KRBAuthnToken) {
                        tokenObject = (AuthenticationToken)token;
                        if (((KRBAuthnToken)token).isTokenForwardable()) {
                            if (!((KRBAuthnToken)token).isTokenValid()) {
                                Tr.debug(tc, "Token with name " + tokenObject.getName() + " is expired.");
                                throw new WSLoginFailedException("Token with name " + tokenObject.getName() + " is expired.");
                            }
                            if (tokenObject.getBytes() != null && tokenObject.getName() != null && tokenObject.getVersion() != 0) {
                                tokens.add(new TokenHolder(tokenObject.getBytes(), tokenObject.getName(), tokenObject.getVersion()));
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Did not add token " + tokenObject.getName() + ":" + tokenObject.getVersion() + " to opaque token, bytes null? " + tokenObject.getBytes());
                            continue;
                        }
                        Tr.debug(tc, "Token with name " + tokenObject.getName() + " is not forwardable.");
                        continue;
                    }
                    if (!(token instanceof Token)) continue;
                    tokenObject = (Token)token;
                    if (tokenObject.isForwardable()) {
                        if (!tokenObject.isValid()) {
                            Tr.debug(tc, "Token with name " + tokenObject.getName() + " is expired.");
                            throw new WSLoginFailedException("Token with name " + tokenObject.getName() + " is expired.");
                        }
                        if (tokenObject.getBytes() != null && tokenObject.getName() != null && tokenObject.getVersion() != 0) {
                            tokens.add(new TokenHolder(tokenObject.getBytes(), tokenObject.getName(), tokenObject.getVersion()));
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Did not add token " + tokenObject.getName() + ":" + tokenObject.getVersion() + " to opaque token, bytes null? " + tokenObject.getBytes());
                        continue;
                    }
                    Tr.debug(tc, "Token with name " + tokenObject.getName() + " is not forwardable.");
                }
                for (Object token : publicCredentials) {
                    Token tokenObject;
                    if (!(token instanceof Token) || !(tokenObject = (Token)token).isForwardable() || !tokenObject.isValid()) continue;
                    if (tokenObject.getBytes() != null && tokenObject.getName() != null && tokenObject.getVersion() != 0) {
                        tokens.add(new TokenHolder(tokenObject.getBytes(), tokenObject.getName(), tokenObject.getVersion()));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Did not add token " + tokenObject.getName() + ":" + tokenObject.getVersion() + " to opaque token, bytes null? " + tokenObject.getBytes());
                }
                if (tokens != null && tokens.size() > 0) {
                    return tokens;
                }
                return null;
            }
        }
        catch (WSLoginFailedException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.getForwardableAuthzTokensFromSubject", "1359", this);
            Tr.debug(tc, "WSLoginFailedException getting forwardable tokens from Subject.", new Object[]{e});
            throw e;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.getForwardableAuthzTokensFromSubject", "1365", this);
            Tr.debug(tc, "Exception getting forwardable tokens from Subject.", new Object[]{e});
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    private boolean isExcluded(Object custom_object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExcluded");
        }
        try {
            if (excludeList == null) {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                String list = contextManager.getProperty("com.ibm.ws.security.propagationExcludeList");
                excludeList = new ArrayList();
                StringTokenizer st = new StringTokenizer(list, ":");
                while (st.hasMoreTokens()) {
                    String next = st.nextToken();
                    if (next.endsWith("*")) {
                        next = next.substring(0, next.length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding entry to exclude list: " + next);
                    }
                    excludeList.add(next);
                }
                String name = WSSMarkerObject.class.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding entry to exclude list: " + name);
                }
                excludeList.add(name);
            }
            String object_name = custom_object.getClass().getName();
            for (int i = 0; i < excludeList.size(); ++i) {
                if (object_name.equals((String)excludeList.get(i))) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, object_name + " isExcluded (true), list rule -> " + excludeList.get(i));
                    }
                    return true;
                }
                if (object_name.startsWith((String)excludeList.get(i))) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, object_name + " isExcluded (true), list rule -> " + excludeList.get(i));
                    }
                    return true;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, object_name + " isExcluded (false)");
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.isExcluded", "1418", this);
            Tr.debug(tc, "Exception checking if class is excluded from propagation.", new Object[]{e});
        }
        return false;
    }
}

