/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.factory.StatsGroupImpl;
import com.ibm.ws.pmi.factory.StatsInstanceImpl;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import javax.management.ObjectName;

public class StatsFactory {
    private static final TraceComponent tc = Tr.register(StatsFactory.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");

    public static boolean isPMIEnabled() {
        return !PmiRegistry.isDisabled();
    }

    public static StatsGroup createStatsGroup(String groupName, String statsTemplate, ObjectName mBean) throws StatsFactoryException {
        StatsGroup group;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsGroup:name=").append(groupName).append(";template=").append(statsTemplate).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsFactory.checkPMIService(groupName);
        try {
            group = StatsGroupImpl.createGroup(groupName, statsTemplate, mBean, false);
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                e.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return group;
    }

    public static StatsGroup createStatsGroup(String groupName, String statsTemplate, StatsGroup parentGroup, ObjectName mBean) throws StatsFactoryException {
        StatsGroup group;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsGroup:name=").append(groupName).append(";parent group=").append(parentGroup.getName()).append(";template=").append(statsTemplate).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsFactory.checkPMIService(groupName);
        try {
            group = StatsGroupImpl.createGroup(groupName, parentGroup, statsTemplate, mBean, false);
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                e.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return group;
    }

    public static StatsGroup createStatsGroup(String groupName, String statsTemplate, StatsInstance parentInstance, ObjectName mBean) throws StatsFactoryException {
        StatsGroup group;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsGroup:name=").append(groupName).append(";parent instance=").append(parentInstance.getName()).append(";template=").append(statsTemplate).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsFactory.checkPMIService(groupName);
        try {
            group = StatsGroupImpl.createGroup(groupName, parentInstance, statsTemplate, mBean, false);
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                e.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return group;
    }

    public static StatsInstance createStatsInstance(String instanceName, String statsTemplate, ObjectName mBean, StatisticActionListener listener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(instanceName).append(";template=").append(statsTemplate).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsInstance rv = StatsFactory.createStatsInstance(instanceName, statsTemplate, mBean, new StatisticActions(listener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return rv;
    }

    public static StatsInstance createStatsInstance(String instanceName, String statsTemplate, ObjectName mBean, StatisticActions listener) throws StatsFactoryException {
        StatsInstanceImpl instance;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(instanceName).append(";template=").append(statsTemplate).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsFactory.checkPMIService(instanceName);
        try {
            instance = StatsInstanceImpl.createInstance(instanceName, statsTemplate, mBean, false, listener);
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                e.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return instance;
    }

    public static StatsInstance createStatsInstance(String instanceName, StatsGroup parentGroup, ObjectName mBean, StatisticActionListener listener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(instanceName).append(";parent name=").append(parentGroup.getName()).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsInstance rv = StatsFactory.createStatsInstance(instanceName, parentGroup, mBean, new StatisticActions(listener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return rv;
    }

    public static StatsInstance createStatsInstance(String instanceName, StatsGroup parentGroup, ObjectName mBean, StatisticActions listener) throws StatsFactoryException {
        StatsInstanceImpl instance;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(instanceName).append(";parent name=").append(parentGroup.getName()).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsFactory.checkPMIService(instanceName);
        try {
            instance = StatsInstanceImpl.createGroupInstance(instanceName, parentGroup, mBean, false, listener);
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                e.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return instance;
    }

    public static StatsInstance createStatsInstance(String instanceName, String statsTemplate, StatsGroup parentGroup, ObjectName mBean, StatisticActionListener listener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(instanceName).append(";template=").append(statsTemplate).append(";parent name=").append(parentGroup.getName()).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsInstance instance = StatsFactory.createStatsInstance(instanceName, statsTemplate, parentGroup, mBean, new StatisticActions(listener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return instance;
    }

    public static StatsInstance createStatsInstance(String instanceName, String statsTemplate, StatsGroup parentGroup, ObjectName mBean, StatisticActions listener) throws StatsFactoryException {
        StatsInstanceImpl instance;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(instanceName).append(";template=").append(statsTemplate).append(";parent name=").append(parentGroup.getName()).append(";mBean=").append(mBean == null ? null : mBean.toString()).toString());
        }
        StatsFactory.checkPMIService(instanceName);
        try {
            instance = StatsInstanceImpl.createGroupInstance(instanceName, parentGroup, statsTemplate, mBean, false, listener);
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                e.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return instance;
    }

    public static void removeStatsInstance(StatsInstance instance) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("removeStatsInstance:name=").append(instance.getName()).toString());
        }
        StatsFactoryUtil.unRegisterStats((PmiModule)((Object)instance), instance.getMBean());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeStatsInstance");
        }
    }

    public static void removeStatsGroup(StatsGroup group) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("removeStatsGroup:name=").append(group.getName()).toString());
        }
        StatsFactoryUtil.unRegisterStats((PmiModule)((Object)group), group.getMBean());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeStatsGroup");
        }
    }

    public static void registerStatsTemplateLookup(StatsTemplateLookup lookupClass) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("registerStatsTemplateLookup: ").append(lookupClass.getClass().getName()).toString());
        }
        PerfModules.registerTemplateLookupClass(lookupClass);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerStatsTemplateLookup");
        }
    }

    public static StatsGroup getStatsGroup(String[] path) {
        StatsGroup group = null;
        if (path != null) {
            PmiModule o;
            ModuleItem parent;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatsGroup: " + StatsFactory._arrayToString(path));
            }
            if ((parent = PmiRegistry.findModuleItem(path)) != null && (o = parent.getInstance()) instanceof StatsGroupImpl) {
                group = (StatsGroup)((Object)o);
            }
        } else if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsGroup: path is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsGroup");
        }
        return group;
    }

    public static StatsInstance getStatsInstance(String[] path) {
        StatsInstance instance = null;
        if (path != null) {
            PmiModule o;
            ModuleItem parent;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatsInstance: " + StatsFactory._arrayToString(path));
            }
            if ((parent = PmiRegistry.findModuleItem(path)) != null && (o = parent.getInstance()) instanceof StatsInstanceImpl) {
                instance = (StatsInstance)((Object)o);
            }
        } else if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsInstance: path is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsInstance");
        }
        return instance;
    }

    private static String _arrayToString(String[] path) {
        StringBuffer b = new StringBuffer(path[0]);
        for (int i = 1; i < path.length; ++i) {
            b.append("/").append(path[i]);
        }
        return b.toString();
    }

    private static void checkPMIService(String name) throws StatsFactoryException {
        if (!StatsFactory.isPMIEnabled()) {
            Tr.warning(tc, "PMI0107W", name);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0107W", new Object[]{name}, "PMI0107W: Unable to register custom PMI module since the PMI service is not enabled: {0}"));
        }
    }
}

