/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncResourceCache {
    private static TraceComponent _tc = Tr.register(SyncResourceCache.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String CLASS_NAME = "com.ibm.wsspi.management.bla.sync.SyncResourceCache";
    private static TraceComponent _tc_srce = Tr.register(SyncResourceCacheEntry.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private long _cacheID;
    protected Hashtable<String, SyncResourceCacheEntry> _cache = null;
    protected String _cellName = null;
    protected String _nodeName = null;
    protected VariableMap _oldVarMap = null;
    protected VariableMap _newVarMap = null;
    protected boolean _isLocal;
    protected boolean _isInNodeSync;
    protected boolean _isBase;
    protected ConfigRepository _repository;
    protected boolean _eventsDone = false;
    protected boolean _varXMLChanged = false;

    public SyncResourceCache(long cacheID, boolean isLocal, boolean isInNodeSync, ConfigRepository repo) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SyncResourceCache", new Object[]{"cacheID=" + cacheID, "isLocal=" + isLocal, "isInNodeSync=" + isInNodeSync, "repo=" + repo});
        }
        this._cacheID = cacheID;
        this._cache = new Hashtable();
        this._isLocal = isLocal;
        this._isInNodeSync = isInNodeSync;
        this._repository = repo;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SyncResourceCache");
        }
    }

    public SyncResourceCacheEntry getCacheForURI(String uri) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCacheForURI", new Object[]{"cacheID=" + this._cacheID, "uri=" + uri});
        }
        SyncResourceCacheEntry srcEntry = null;
        if (uri != null) {
            srcEntry = this._cache.get(uri);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCacheForURI", new Object[]{"cacheID=" + this._cacheID, "srcEntry=" + srcEntry});
        }
        return srcEntry;
    }

    public boolean isLocal() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isLocal", new Object[]{"cacheID=" + this._cacheID, "isLocal=" + this._isLocal});
        }
        return this._isLocal;
    }

    public long getID() {
        return this._cacheID;
    }

    public boolean isInNodeSync() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isInNodeSync", new Object[]{"cacheID=" + this._cacheID, "isInNodeSync=" + this._isInNodeSync});
        }
        return this._isInNodeSync;
    }

    public ConfigRepository getRepository() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getRepository", new Object[]{"cacheID=" + this._cacheID, "repository=" + this._repository});
        }
        return this._repository;
    }

    protected void clear() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "clear", new Object[]{"cacheID=" + this._cacheID});
        }
        this._cache.clear();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "clear", new Object[]{"cacheID=" + this._cacheID});
        }
    }

    public String getCellName() throws OpExecutionException {
        if (this._cellName == null) {
            this.getCellNode();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCellName", new Object[]{"cacheID=" + this._cacheID, "cellName=" + this._cellName});
        }
        return this._cellName;
    }

    public String getNodeName() throws OpExecutionException {
        if (this._cellName == null) {
            this.getCellNode();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNodeName", new Object[]{"cacheID=" + this._cacheID, "nodeName=" + this._nodeName});
        }
        return this._nodeName;
    }

    public boolean isBase() throws OpExecutionException {
        if (this._cellName == null) {
            this.getCellNode();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isBase", new Object[]{"cacheID=" + this._cacheID, "isBase=" + this._isBase});
        }
        return this._isBase;
    }

    private void getCellNode() throws OpExecutionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCellNode", new Object[]{"cacheID=" + this._cacheID});
        }
        try {
            Class<?> blaSyncUtilsClass = Class.forName("com.ibm.ws.management.bla.sync.BLASyncUtils");
            Class[] paramTypes = new Class[]{Boolean.TYPE, Boolean.TYPE};
            Method blaSyncUtilsMethod = blaSyncUtilsClass.getMethod("getCellNode", paramTypes);
            Object[] paramArray = new Object[]{this._isInNodeSync, this._isLocal};
            String[] ret = (String[])blaSyncUtilsMethod.invoke(null, paramArray);
            this._cellName = ret[0];
            this._nodeName = ret[1];
            this._isBase = "true".equals(ret[2]);
        }
        catch (Throwable th) {
            OpExecutionException oee;
            if (th instanceof OpExecutionException) {
                oee = (OpExecutionException)th;
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getCellNode", new Object[]{"cacheID=" + this._cacheID, "Rethrowing exception: " + oee});
                }
            } else {
                FFDCFilter.processException(th, "com.ibm.wsspi.management.bla.sync.SyncResourceCache.getCellNode", "172");
                oee = new OpExecutionException(th);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getCellNode", oee);
                }
            }
            throw oee;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCellNode", new Object[]{"cacheID=" + this._cacheID});
        }
    }

    public VariableMap getOldVarMap() throws Exception {
        if (this._oldVarMap == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getOldVarMap", new Object[]{"cacheID=" + this._cacheID, "Creating oldVarMap."});
            }
            this._oldVarMap = UtilHelper.createVarMap(this._repository, this.getCellName(), this.getNodeName());
            if (this._eventsDone && this._newVarMap == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getOldVarMap", new Object[]{"cacheID=" + this._cacheID, "Setting newVarMap to oldVarMap."});
                }
                this._newVarMap = this._oldVarMap;
            }
        }
        return this._oldVarMap;
    }

    public void setEventsDone(boolean eventsDone) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setEventsDone", new Object[]{"cacheID=" + this._cacheID, "eventsDone=" + eventsDone});
        }
        this._eventsDone = eventsDone;
    }

    public VariableMap getNewVarMap() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNewVarMap", new Object[]{"cacheID=" + this._cacheID});
        }
        if (!this._eventsDone) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getNewVarMap", new Object[]{"cacheID=" + this._cacheID, "false: change processing not yet complete."});
            }
            return null;
        }
        if (this._newVarMap == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getNewVarMap", "Creating newVarMap.");
            }
            this._newVarMap = UtilHelper.createVarMap(this._repository, this.getCellName(), this.getNodeName());
            if (this._oldVarMap == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getNewVarMap", new Object[]{"cacheID=" + this._cacheID, "Setting oldVarMap to newVarMap."});
                }
                this._oldVarMap = this._newVarMap;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNewVarMap", new Object[]{"cacheID=" + this._cacheID});
        }
        return this._newVarMap;
    }

    public Hashtable<String, SyncResourceCacheEntry> getTable() {
        return this._cache;
    }

    public SyncResourceCacheEntry createEntry(String uri, int configChangeType) {
        String srcChangeType;
        switch (configChangeType) {
            case 0: {
                srcChangeType = "CREATED";
                break;
            }
            case 1: {
                srcChangeType = "DELETED";
                break;
            }
            case 2: {
                srcChangeType = "UPDATED";
                break;
            }
            default: {
                IllegalArgumentException iae = new IllegalArgumentException("\"Change type\" parameter value of " + configChangeType + " is not valid.");
                FFDCFilter.processException(iae, "com.ibm.wsspi.management.bla.sync.SyncResourceCache.createEntry", "282");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createEntry(String, int)", iae);
                }
                throw iae;
            }
        }
        SyncResourceCacheEntry srcEntry = this.createEntry(uri, srcChangeType);
        return srcEntry;
    }

    public SyncResourceCacheEntry createEntry(String uri, String srcChangeType) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createEntry", new Object[]{"uri=" + uri, "srcChangeType=" + srcChangeType});
        }
        SyncResourceCacheEntry srcEntry = new SyncResourceCacheEntry(uri, srcChangeType);
        this._cache.put(uri, srcEntry);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createEntry", new Object[]{"cacheID=" + this._cacheID, "srcEntry=" + srcEntry});
        }
        return srcEntry;
    }

    public void removeEntry(String uri) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeEntry", new Object[]{"cacheID=" + this._cacheID, "uri=" + uri});
        }
        if (uri == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "removeEntry", new Object[]{"cacheID=" + this._cacheID, "No entry removed (null URI)"});
            }
            return;
        }
        this._cache.remove(uri);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeEntry", new Object[]{"cacheID=" + this._cacheID});
        }
    }

    public void printCache(String context) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "printCache", new Object[]{"cacheID=" + this._cacheID, "context=" + context});
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "xxxx SRC DUMP BEGIN: cacheID=" + this._cacheID + ", " + context);
            if (this._cache == null) {
                Tr.debug(_tc, "NULL CACHE");
            } else {
                Enumeration<String> ee = this._cache.keys();
                while (ee.hasMoreElements()) {
                    String uri = ee.nextElement();
                    Tr.debug(_tc, "ENTRY BEGIN: " + uri);
                    Tr.debug(_tc, "    " + this._cache.get(uri));
                    Tr.debug(_tc, "ENTRY END");
                }
            }
            Tr.debug(_tc, "xxxx SRC DUMP END: cacheID=" + this._cacheID + ", " + context);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "printCache", new Object[]{"cacheID=" + this._cacheID});
        }
    }

    public boolean getVarXMLChanged() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getVarXMLChanged", new Object[]{"cacheID=" + this._cacheID, "varXMLChanged=" + this._varXMLChanged});
        }
        return this._varXMLChanged;
    }

    public void setVarXMLChanged(boolean changed) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setVarXMLChanged", new Object[]{"cacheID=" + this._cacheID, "changed=" + changed});
        }
        this._varXMLChanged = changed;
    }

    public class SyncResourceCacheEntry {
        String _changeType = null;
        Object _beforeResource = null;
        Object _afterResource = null;
        Hashtable<String, Object> _props = null;
        String _recycle = "SYNC_NO_RECYCLE";
        boolean _stopped = false;
        String _destinationTableKey = null;

        public SyncResourceCacheEntry(String uri, String changeType) {
            if (_tc_srce.isEntryEnabled()) {
                Tr.entry(_tc, "SyncResourceCacheEntry", new Object[]{"uri=" + uri, "changeType=" + changeType});
            }
            this._changeType = changeType;
            this._beforeResource = null;
            this._afterResource = null;
            this._props = new Hashtable();
            if (_tc_srce.isEntryEnabled()) {
                Tr.exit(_tc, "SyncResourceCache");
            }
        }

        public String getChangeType() {
            return this._changeType;
        }

        public Object getBeforeResource() {
            return this._beforeResource;
        }

        public Object getAfterResource() {
            return this._afterResource;
        }

        public String getRecycle() {
            return this._recycle;
        }

        public boolean isStopped() {
            return this._stopped;
        }

        public String getDestinationTableEntry() {
            return this._destinationTableKey;
        }

        @Deprecated
        public Object getProps(String key) {
            return this.getProp(key);
        }

        public Object getProp(String key) {
            Object obj = this._props.get(key);
            if (_tc_srce.isDebugEnabled()) {
                Tr.debug(_tc, "getProp", new Object[]{"key=" + key, "obj=" + obj});
            }
            return obj;
        }

        public void setRecycle(String recycle) {
            if (_tc_srce.isEntryEnabled()) {
                Tr.entry(_tc, "setRecycle", "recycle=" + recycle);
            }
            if (_tc_srce.isDebugEnabled()) {
                Tr.debug(_tc, "setRecycle", "currRecycle=" + this._recycle);
            }
            if (!this._recycle.equals("SYNC_STOP")) {
                if (this._recycle.equals("SYNC_RESTART")) {
                    if (recycle.equals("SYNC_STOP")) {
                        this._recycle = recycle;
                    }
                } else {
                    this._recycle = recycle;
                }
            }
            if (_tc_srce.isEntryEnabled()) {
                Tr.exit(_tc, "setRecycle", "newRecycle=" + this._recycle);
            }
        }

        public void setStopped(boolean stopped) {
            if (_tc_srce.isDebugEnabled()) {
                Tr.debug(_tc, "setStopped", "stopped=" + stopped);
            }
            this._stopped = stopped;
        }

        public void setChangeType(String changeType) {
            if (_tc_srce.isDebugEnabled()) {
                Tr.debug(_tc, "setChangeType", "changeType=" + changeType);
            }
            this._changeType = changeType;
        }

        @Deprecated
        public void setAfterResouce(Object afterResource) {
            this.setAfterResource(afterResource);
        }

        public void setAfterResource(Object afterResource) {
            if (_tc_srce.isDebugEnabled()) {
                Tr.debug(_tc, "setAfterResource", "afterResource=" + afterResource);
            }
            this._afterResource = afterResource;
        }

        @Deprecated
        public void setBeforeResouce(Object beforeResource) {
            this.setBeforeResource(beforeResource);
        }

        public void setBeforeResource(Object beforeResource) {
            if (_tc_srce.isDebugEnabled()) {
                Tr.debug(_tc, "setBeforeResource", "beforeResource=" + beforeResource);
            }
            this._beforeResource = beforeResource;
        }

        public void setDestinationTableEntry(String key) {
            if (_tc_srce.isDebugEnabled()) {
                Tr.debug(_tc, "setDestinationTableEntry", "key=" + key);
            }
            this._destinationTableKey = key;
        }

        @Deprecated
        public void putProps(String key, Object obj) {
            this.putProp(key, obj);
        }

        public void putProp(String key, Object obj) {
            if (_tc_srce.isDebugEnabled()) {
                Tr.debug(_tc, "putProp", new Object[]{"key=" + key, "obj=" + obj});
            }
            this._props.put(key, obj);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SyncResourceCacheEntry:{");
            sb.append("changeType=");
            sb.append(this._changeType);
            sb.append(", destinationTableKey=");
            sb.append(this._destinationTableKey);
            sb.append(", props=");
            sb.append(this._props);
            sb.append(", recycle=");
            sb.append(this._recycle);
            sb.append(", stopped=");
            sb.append(this._stopped);
            sb.append(", beforeResource=");
            sb.append(this._beforeResource);
            sb.append(", afterResource=");
            sb.append(this._afterResource);
            sb.append('}');
            return sb.toString();
        }
    }
}

