/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.management.bla.model.CompositionUnit;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import com.ibm.wsspi.management.bla.sync.SyncResourceCache;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncExecutionTableEntry {
    private static TraceComponent tc = Tr.register(SyncExecutionTableEntry.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    String _assetXMLUri = null;
    List<String> _assetUris = new ArrayList<String>();
    Hashtable<String, List<String>> _cuUris = new Hashtable();

    public SyncExecutionTableEntry(String assetXML) {
        this._assetXMLUri = assetXML;
    }

    public String getAssetXMLUri() {
        return this._assetXMLUri;
    }

    public List<String> getAssetUris() {
        return this._assetUris;
    }

    public List<String> getCUUrisForCU(String s) {
        return this._cuUris.get(s);
    }

    public void addCUXMLUri(String s) {
        this._cuUris.put(s, new ArrayList());
    }

    public Hashtable<String, List<String>> getCUUris() {
        return this._cuUris;
    }

    public List<String> getCUXMLUris() {
        Enumeration<String> en = this._cuUris.keys();
        ArrayList<String> retVal = new ArrayList<String>();
        while (en.hasMoreElements()) {
            retVal.add(en.nextElement());
        }
        return retVal;
    }

    public boolean isAssetForDmgrNode(SyncResourceCache src) throws OpExecutionException {
        if (src.getNodeName() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TSNH - node can not be null");
            }
            return false;
        }
        String compareStr = "node=" + src.getNodeName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "compaare str: " + compareStr);
        }
        Enumeration<String> keys = this._cuUris.keys();
        while (keys.hasMoreElements()) {
            String uri = keys.nextElement();
            SyncResourceCache.SyncResourceCacheEntry entry = src.getCacheForURI(uri);
            if (entry == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "TSNH - entry can not be null");
                continue;
            }
            if (entry.getChangeType().equals("DELETED")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ignore deletetion " + uri);
                continue;
            }
            if (entry.getAfterResource() == null || !(entry.getAfterResource() instanceof CompositionUnit)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "TSNH - entry must be cu");
                continue;
            }
            CompositionUnit cu = (CompositionUnit)entry.getAfterResource();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "for uri: " + uri + ", targets = " + cu.listTargetsForCU());
            }
            for (String t : cu.listTargetsForCU()) {
                if (t.indexOf(compareStr) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean wasAssetForDmgrNode(SyncResourceCache src) throws OpExecutionException {
        if (src.getNodeName() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TSNH - node can not be null");
            }
            return false;
        }
        String compareStr = "node=" + src.getNodeName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "compaare str: " + compareStr);
        }
        Enumeration<String> keys = this._cuUris.keys();
        while (keys.hasMoreElements()) {
            String uri = keys.nextElement();
            SyncResourceCache.SyncResourceCacheEntry entry = src.getCacheForURI(uri);
            if (entry == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "TSNH - entry can not be null");
                continue;
            }
            if (entry.getChangeType().equals("CREATED")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ignore creation for wasAssetForNode " + uri);
                continue;
            }
            if (entry.getBeforeResource() == null || !(entry.getBeforeResource() instanceof CompositionUnit)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "TSNH - entry must be cu");
                continue;
            }
            CompositionUnit cu = (CompositionUnit)entry.getBeforeResource();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "for uri: " + uri + ", targets = " + cu.listTargetsForCU());
            }
            for (String t : cu.listTargetsForCU()) {
                if (t.indexOf(compareStr) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "<SETE>\n" + this._assetXMLUri + ", \n assetUris = " + this._assetUris + ", \n cuUris = " + this._cuUris + "\n</SETE>";
    }
}

