/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.management.bla.model.CompositionUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlOpUtil {
    private static TraceComponent _tc = Tr.register(ControlOpUtil.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String CLASS_NAME = "com.ibm.wsspi.management.bla.runtime.ControlOpUtil";

    public static List<CompositionUnit> sortCompUnitsAccordingToStartOrder(Iterator<CompositionUnit> compUnitIter, boolean reverseSort) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sortCompUnitsAccordingToStartOrder", "reverseSort=" + reverseSort);
        }
        ArrayList<CompositionUnit> compUnitList = new ArrayList<CompositionUnit>();
        while (compUnitIter.hasNext()) {
            int insertionIndex;
            CompositionUnit newCU = compUnitIter.next();
            int newStartingWeight = newCU.getStartingWeight();
            for (insertionIndex = 0; insertionIndex < compUnitList.size(); ++insertionIndex) {
                CompositionUnit currCU = (CompositionUnit)compUnitList.get(insertionIndex);
                int currWeight = currCU.getStartingWeight();
                if (!reverseSort && currWeight > newStartingWeight || reverseSort && currWeight <= newStartingWeight) break;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Inserting CU into list.", new Object[]{"insertionIndex=" + insertionIndex, "cu=" + newCU});
            }
            compUnitList.add(insertionIndex, newCU);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sortCompUnitsAccordingToStartOrder", compUnitList);
        }
        return compUnitList;
    }
}

